/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.jsdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.JavaPreview;

public class SnippetPreview
extends JavaPreview {
    private ArrayList fSnippets = new ArrayList();

    public SnippetPreview(Map map, Composite composite) {
        super(map, composite);
    }

    protected void doFormatPreview() {
        if (this.fSnippets.isEmpty()) {
            this.fPreviewDocument.set("");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.fSnippets.iterator();
        while (iterator.hasNext()) {
            String string;
            PreviewSnippet previewSnippet = (PreviewSnippet)iterator.next();
            try {
                string = CodeFormatterUtil.format(previewSnippet.kind, previewSnippet.source, 0, null, "\n", this.fWorkingValues);
            }
            catch (Exception exception) {
                Status status = new Status(4, JavaPlugin.getPluginId(), 10001, FormatterMessages.JavaPreview_formatter_exception, (Throwable)exception);
                JavaPlugin.log((IStatus)status);
                continue;
            }
            stringBuffer.append("\n");
            stringBuffer.append(string);
            stringBuffer.append("\n");
            stringBuffer.append("\n");
        }
        this.fPreviewDocument.set(stringBuffer.toString());
    }

    public void add(PreviewSnippet previewSnippet) {
        this.fSnippets.add(previewSnippet);
    }

    public void remove(PreviewSnippet previewSnippet) {
        this.fSnippets.remove(previewSnippet);
    }

    public void addAll(Collection collection) {
        this.fSnippets.addAll(collection);
    }

    public void clear() {
        this.fSnippets.clear();
    }

    public static final class PreviewSnippet {
        public String header;
        public final String source;
        public final int kind;

        public PreviewSnippet(int n, String string) {
            this.kind = n;
            this.source = string;
        }
    }
}

