/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.propertiesfileeditor;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.spelling.SpellingReconcileStrategy;
import org.eclipse.wst.jsdt.internal.ui.propertiesfileeditor.IPropertiesFilePartitions;
import org.eclipse.wst.jsdt.internal.ui.propertiesfileeditor.PropertyValueScanner;
import org.eclipse.wst.jsdt.internal.ui.text.AbstractJavaScanner;
import org.eclipse.wst.jsdt.internal.ui.text.HTMLAnnotationHover;
import org.eclipse.wst.jsdt.internal.ui.text.JavaPresentationReconciler;
import org.eclipse.wst.jsdt.internal.ui.text.SingleTokenJavaScanner;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaStringDoubleClickSelector;
import org.eclipse.wst.jsdt.ui.text.IColorManager;

public class PropertiesFileSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    private static final IContentType PROPERTIES_CONTENT_TYPE = Platform.getContentTypeManager().getContentType("org.eclipse.wst.jsdt.core.javaProperties");
    private ITextEditor fTextEditor;
    private String fDocumentPartitioning;
    private AbstractJavaScanner fPropertyKeyScanner;
    private AbstractJavaScanner fCommentScanner;
    private AbstractJavaScanner fPropertyValueScanner;
    private IColorManager fColorManager;

    public PropertiesFileSourceViewerConfiguration(IColorManager iColorManager, IPreferenceStore iPreferenceStore, ITextEditor iTextEditor, String string) {
        super(iPreferenceStore);
        this.fColorManager = iColorManager;
        this.fTextEditor = iTextEditor;
        this.fDocumentPartitioning = string;
        this.initializeScanners();
    }

    protected RuleBasedScanner getPropertyKeyScanner() {
        return this.fPropertyKeyScanner;
    }

    protected RuleBasedScanner getCommentScanner() {
        return this.fCommentScanner;
    }

    protected RuleBasedScanner getPropertyValueScanner() {
        return this.fPropertyValueScanner;
    }

    protected IColorManager getColorManager() {
        return this.fColorManager;
    }

    protected ITextEditor getEditor() {
        return this.fTextEditor;
    }

    private void initializeScanners() {
        this.fPropertyKeyScanner = new SingleTokenJavaScanner(this.getColorManager(), this.fPreferenceStore, "pf_coloring_key");
        this.fPropertyValueScanner = new PropertyValueScanner(this.getColorManager(), this.fPreferenceStore);
        this.fCommentScanner = new SingleTokenJavaScanner(this.getColorManager(), this.fPreferenceStore, "pf_coloring_comment");
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer iSourceViewer) {
        JavaPresentationReconciler javaPresentationReconciler = new JavaPresentationReconciler();
        javaPresentationReconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(iSourceViewer));
        DefaultDamagerRepairer defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.getPropertyKeyScanner());
        javaPresentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__dftl_partition_content_type");
        javaPresentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__dftl_partition_content_type");
        defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.getCommentScanner());
        javaPresentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__pf_comment");
        javaPresentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__pf_comment");
        defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.getPropertyValueScanner());
        javaPresentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__pf_roperty_value");
        javaPresentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__pf_roperty_value");
        return javaPresentationReconciler;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer iSourceViewer, String string) {
        if ("__dftl_partition_content_type".equals(string)) {
            return new JavaStringDoubleClickSelector(this.getConfiguredDocumentPartitioning(iSourceViewer));
        }
        return super.getDoubleClickStrategy(iSourceViewer, string);
    }

    public String[] getConfiguredContentTypes(ISourceViewer iSourceViewer) {
        int n = IPropertiesFilePartitions.PARTITIONS.length;
        String[] stringArray = new String[n + 1];
        stringArray[0] = "__dftl_partition_content_type";
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2 + 1] = IPropertiesFilePartitions.PARTITIONS[n2];
            ++n2;
        }
        return stringArray;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer iSourceViewer) {
        if (this.fDocumentPartitioning != null) {
            return this.fDocumentPartitioning;
        }
        return super.getConfiguredDocumentPartitioning(iSourceViewer);
    }

    public boolean affectsTextPresentation(PropertyChangeEvent propertyChangeEvent) {
        return this.fPropertyKeyScanner.affectsBehavior(propertyChangeEvent) || this.fCommentScanner.affectsBehavior(propertyChangeEvent) || this.fPropertyValueScanner.affectsBehavior(propertyChangeEvent);
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent propertyChangeEvent) {
        if (this.fPropertyKeyScanner.affectsBehavior(propertyChangeEvent)) {
            this.fPropertyKeyScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
        if (this.fCommentScanner.affectsBehavior(propertyChangeEvent)) {
            this.fCommentScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
        if (this.fPropertyValueScanner.affectsBehavior(propertyChangeEvent)) {
            this.fPropertyValueScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
    }

    protected Map getHyperlinkDetectorTargets(ISourceViewer iSourceViewer) {
        Map map = super.getHyperlinkDetectorTargets(iSourceViewer);
        map.put("org.eclipse.wst.jsdt.ui.PropertiesFileEditor", this.fTextEditor);
        return map;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer iSourceViewer) {
        return new HTMLAnnotationHover(){

            protected boolean isIncluded(Annotation annotation) {
                return PropertiesFileSourceViewerConfiguration.this.isShowInVerticalRuler(annotation);
            }
        };
    }

    public IAnnotationHover getOverviewRulerAnnotationHover(ISourceViewer iSourceViewer) {
        return new HTMLAnnotationHover(){

            protected boolean isIncluded(Annotation annotation) {
                return PropertiesFileSourceViewerConfiguration.this.isShowInOverviewRuler(annotation);
            }
        };
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer iSourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                return new DefaultInformationControl(shell, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
            }
        };
    }

    public IReconciler getReconciler(ISourceViewer iSourceViewer) {
        if (!EditorsUI.getPreferenceStore().getBoolean("spellingEnabled")) {
            return null;
        }
        SpellingReconcileStrategy spellingReconcileStrategy = new SpellingReconcileStrategy(iSourceViewer, EditorsUI.getSpellingService()){

            protected IContentType getContentType() {
                return PROPERTIES_CONTENT_TYPE;
            }
        };
        MonoReconciler monoReconciler = new MonoReconciler((IReconcilingStrategy)spellingReconcileStrategy, false);
        monoReconciler.setIsIncrementalReconciler(false);
        monoReconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
        monoReconciler.setDelay(500);
        return monoReconciler;
    }
}

