/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.contentassist.SubjectControlContentAssistant;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.contentassist.ContentAssistHandler;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.StubTypeContext;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TableTextCellEditor;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.wst.jsdt.internal.ui.refactoring.IParameterListChangeListener;
import org.eclipse.wst.jsdt.internal.ui.refactoring.ParameterEditDialog;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.wst.jsdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.wst.jsdt.internal.ui.refactoring.contentassist.VariableNamesProcessor;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;
import org.eclipse.wst.jsdt.internal.ui.util.TableLayoutComposite;

public class ChangeParametersControl
extends Composite {
    static final boolean SHOW_TYPES = false;
    private static final String[] PROPERTIES = new String[]{"type", "new", "default"};
    private static final int TYPE_PROP = 0;
    private static final int NEWNAME_PROP = 1;
    private static final int DEFAULT_PROP = 2;
    private static final int ROW_COUNT = 7;
    private final Mode fMode;
    private final IParameterListChangeListener fListener;
    private List fParameterInfos;
    private final StubTypeContext fTypeContext;
    private final String[] fParamNameProposals;
    private ContentAssistHandler fNameContentAssistHandler;
    private TableViewer fTableViewer;
    private Button fUpButton;
    private Button fDownButton;
    private Button fEditButton;
    private Button fAddButton;
    private Button fRemoveButton;

    public ChangeParametersControl(Composite composite, int n, String string, IParameterListChangeListener iParameterListChangeListener, Mode mode, StubTypeContext stubTypeContext) {
        this(composite, n, string, iParameterListChangeListener, mode, stubTypeContext, new String[0]);
    }

    public ChangeParametersControl(Composite composite, int n, String string, IParameterListChangeListener iParameterListChangeListener, Mode mode) {
        this(composite, n, string, iParameterListChangeListener, mode, null, new String[0]);
    }

    public ChangeParametersControl(Composite composite, int n, String string, IParameterListChangeListener iParameterListChangeListener, Mode mode, String[] stringArray) {
        this(composite, n, string, iParameterListChangeListener, mode, null, stringArray);
    }

    private ChangeParametersControl(Composite composite, int n, String string, IParameterListChangeListener iParameterListChangeListener, Mode mode, StubTypeContext stubTypeContext, String[] stringArray) {
        super(composite, n);
        Assert.isNotNull((Object)iParameterListChangeListener);
        this.fListener = iParameterListChangeListener;
        this.fMode = mode;
        this.fTypeContext = stubTypeContext;
        this.fParamNameProposals = stringArray;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        if (string != null) {
            Label label = new Label((Composite)this, 0);
            GridData gridData = new GridData();
            gridData.horizontalSpan = 2;
            label.setLayoutData((Object)gridData);
            label.setText(string);
        }
        this.createParameterList(this);
        this.createButtonComposite(this);
    }

    public void setInput(List list) {
        Assert.isNotNull((Object)list);
        this.fParameterInfos = list;
        this.fTableViewer.setInput((Object)this.fParameterInfos);
        if (this.fParameterInfos.size() > 0) {
            this.fTableViewer.setSelection((ISelection)new StructuredSelection(this.fParameterInfos.get(0)));
        }
    }

    public void editParameter(ParameterInfo parameterInfo) {
        this.fTableViewer.getControl().setFocus();
        if (!parameterInfo.isDeleted()) {
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)parameterInfo), true);
            this.updateButtonsEnabledState();
            this.editColumnOrNextPossible(1);
            return;
        }
    }

    private void createParameterList(Composite composite) {
        TableLayoutComposite tableLayoutComposite = new TableLayoutComposite(composite, 0);
        this.addColumnLayoutData(tableLayoutComposite);
        Table table = new Table((Composite)tableLayoutComposite, 67586);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn tableColumn = new TableColumn(table, 0, 0);
        tableColumn.setResizable(true);
        tableColumn.setText("");
        int n = 1;
        tableColumn = new TableColumn(table, 0, n);
        tableColumn.setResizable(true);
        tableColumn.setText(RefactoringMessages.ChangeParametersControl_table_name);
        if (this.fMode.canChangeDefault()) {
            n = 2;
            tableColumn = new TableColumn(table, 0, n);
            tableColumn.setResizable(true);
            tableColumn.setText(RefactoringMessages.ChangeParametersControl_table_defaultValue);
        }
        GridData gridData = new GridData(1808);
        gridData.heightHint = SWTUtil.getTableHeightHint(table, 7);
        gridData.widthHint = 40;
        tableLayoutComposite.setLayoutData(gridData);
        this.fTableViewer = new TableViewer(table);
        this.fTableViewer.setUseHashlookup(true);
        this.fTableViewer.setContentProvider((IContentProvider)new ParameterInfoContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new ParameterInfoLabelProvider());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ChangeParametersControl.this.updateButtonsEnabledState();
            }
        });
        table.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 4 && traverseEvent.stateMask == 0) {
                    ChangeParametersControl.this.editColumnOrNextPossible(0);
                    traverseEvent.detail = 0;
                }
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 0x100000B && keyEvent.stateMask == 0) {
                    ChangeParametersControl.this.editColumnOrNextPossible(0);
                    keyEvent.doit = false;
                }
            }
        });
        this.addCellEditors();
    }

    private void editColumnOrNextPossible(int n) {
        ParameterInfo[] parameterInfoArray = this.getSelectedElements();
        if (parameterInfoArray.length != 1) {
            return;
        }
        int n2 = n;
        do {
            this.fTableViewer.editElement((Object)parameterInfoArray[0], n2);
            if (!this.fTableViewer.isCellEditorActive()) continue;
            return;
        } while ((n2 = this.nextColumn(n2)) != n);
    }

    private void editColumnOrPrevPossible(int n) {
        ParameterInfo[] parameterInfoArray = this.getSelectedElements();
        if (parameterInfoArray.length != 1) {
            return;
        }
        int n2 = n;
        do {
            this.fTableViewer.editElement((Object)parameterInfoArray[0], n2);
            if (!this.fTableViewer.isCellEditorActive()) continue;
            return;
        } while ((n2 = this.prevColumn(n2)) != n);
    }

    private int nextColumn(int n) {
        return n >= this.getTable().getColumnCount() - 1 ? 0 : n + 1;
    }

    private int prevColumn(int n) {
        return n <= 0 ? this.getTable().getColumnCount() - 1 : n - 1;
    }

    private void addColumnLayoutData(TableLayoutComposite tableLayoutComposite) {
        if (this.fMode.canChangeDefault()) {
            tableLayoutComposite.addColumnData((ColumnLayoutData)new ColumnWeightData(33, true));
            tableLayoutComposite.addColumnData((ColumnLayoutData)new ColumnWeightData(33, true));
            tableLayoutComposite.addColumnData((ColumnLayoutData)new ColumnWeightData(34, true));
        } else {
            tableLayoutComposite.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
            tableLayoutComposite.addColumnData((ColumnLayoutData)new ColumnWeightData(99, true));
        }
    }

    private ParameterInfo[] getSelectedElements() {
        ISelection iSelection = this.fTableViewer.getSelection();
        if (iSelection == null) {
            return new ParameterInfo[0];
        }
        if (!(iSelection instanceof IStructuredSelection)) {
            return new ParameterInfo[0];
        }
        List list = ((IStructuredSelection)iSelection).toList();
        return list.toArray(new ParameterInfo[list.size()]);
    }

    private void createButtonComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1040));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        if (this.fMode.canAddParameters()) {
            this.fAddButton = this.createAddButton(composite2);
        }
        this.fEditButton = this.createEditButton(composite2);
        if (this.fMode.canAddParameters()) {
            this.fRemoveButton = this.createRemoveButton(composite2);
        }
        if (composite2.getChildren().length != 0) {
            this.addSpacer(composite2);
        }
        this.fUpButton = this.createButton(composite2, RefactoringMessages.ChangeParametersControl_buttons_move_up, true);
        this.fDownButton = this.createButton(composite2, RefactoringMessages.ChangeParametersControl_buttons_move_down, false);
        this.updateButtonsEnabledState();
    }

    private void addSpacer(Composite composite) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData(768);
        gridData.heightHint = 5;
        label.setLayoutData((Object)gridData);
    }

    private void updateButtonsEnabledState() {
        this.fUpButton.setEnabled(this.canMove(true));
        this.fDownButton.setEnabled(this.canMove(false));
        if (this.fEditButton != null) {
            this.fEditButton.setEnabled(this.getTableSelectionCount() == 1);
        }
        if (this.fAddButton != null) {
            this.fAddButton.setEnabled(true);
        }
        if (this.fRemoveButton != null) {
            this.fRemoveButton.setEnabled(this.getTableSelectionCount() != 0);
        }
    }

    private int getTableSelectionCount() {
        return this.getTable().getSelectionCount();
    }

    private int getTableItemCount() {
        return this.getTable().getItemCount();
    }

    private Table getTable() {
        return this.fTableViewer.getTable();
    }

    private Button createEditButton(Composite composite) {
        Button button = new Button(composite, 8);
        button.setText(RefactoringMessages.ChangeParametersControl_buttons_edit);
        button.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    ParameterInfo[] parameterInfoArray = ChangeParametersControl.this.getSelectedElements();
                    Assert.isTrue((parameterInfoArray.length == 1 ? 1 : 0) != 0);
                    ParameterInfo parameterInfo = parameterInfoArray[0];
                    ParameterEditDialog parameterEditDialog = new ParameterEditDialog(ChangeParametersControl.this.getShell(), parameterInfo, ChangeParametersControl.this.fMode.canChangeTypes(), ChangeParametersControl.this.fMode.canChangeDefault(), ChangeParametersControl.this.fTypeContext);
                    parameterEditDialog.open();
                    ChangeParametersControl.this.fListener.parameterChanged(parameterInfo);
                    ChangeParametersControl.this.fTableViewer.update((Object)parameterInfo, PROPERTIES);
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    ChangeParametersControl.this.fTableViewer.getControl().setFocus();
                    throw throwable;
                }
                {
                    Object var5_7 = null;
                }
                ChangeParametersControl.this.fTableViewer.getControl().setFocus();
            }
        });
        return button;
    }

    private Button createAddButton(Composite composite) {
        Button button = new Button(composite, 8);
        button.setText(RefactoringMessages.ChangeParametersControl_buttons_add);
        button.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object object;
                String[] stringArray = new String[ChangeParametersControl.this.fParameterInfos.size()];
                int n = 0;
                while (n < ChangeParametersControl.this.fParameterInfos.size()) {
                    object = (ParameterInfo)ChangeParametersControl.this.fParameterInfos.get(n);
                    stringArray[n] = ((ParameterInfo)object).getNewName();
                    ++n;
                }
                IJavaProject iJavaProject = ChangeParametersControl.this.fTypeContext.getCuHandle().getJavaProject();
                object = StubUtility.suggestArgumentName(iJavaProject, RefactoringMessages.ChangeParametersControl_new_parameter_default_name, stringArray);
                ParameterInfo parameterInfo = ParameterInfo.createInfoForAddedParameter("Object", (String)object, "null");
                int n2 = ChangeParametersControl.this.fParameterInfos.size();
                int n3 = ChangeParametersControl.this.fParameterInfos.size() - 1;
                while (n3 >= 0) {
                    ParameterInfo parameterInfo2 = (ParameterInfo)ChangeParametersControl.this.fParameterInfos.get(n3);
                    if (parameterInfo2.isNewVarargs()) {
                        n2 = n3;
                        break;
                    }
                    --n3;
                }
                ChangeParametersControl.this.fParameterInfos.add(n2, parameterInfo);
                ChangeParametersControl.this.fListener.parameterAdded(parameterInfo);
                ChangeParametersControl.this.fTableViewer.refresh();
                ChangeParametersControl.this.fTableViewer.getControl().setFocus();
                ChangeParametersControl.this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)parameterInfo), true);
                ChangeParametersControl.this.updateButtonsEnabledState();
                ChangeParametersControl.this.editColumnOrNextPossible(0);
            }
        });
        return button;
    }

    private Button createRemoveButton(Composite composite) {
        Button button = new Button(composite, 8);
        button.setText(RefactoringMessages.ChangeParametersControl_buttons_remove);
        button.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = ChangeParametersControl.this.getTable().getSelectionIndices()[0];
                ParameterInfo[] parameterInfoArray = ChangeParametersControl.this.getSelectedElements();
                int n2 = 0;
                while (n2 < parameterInfoArray.length) {
                    if (parameterInfoArray[n2].isAdded()) {
                        ChangeParametersControl.this.fParameterInfos.remove(parameterInfoArray[n2]);
                    } else {
                        parameterInfoArray[n2].markAsDeleted();
                    }
                    ++n2;
                }
                this.restoreSelection(n);
            }

            private void restoreSelection(int n) {
                ChangeParametersControl.this.fTableViewer.refresh();
                ChangeParametersControl.this.fTableViewer.getControl().setFocus();
                int n2 = ChangeParametersControl.this.getTableItemCount();
                if (n2 != 0 && n >= n2) {
                    n = n2 - 1;
                    ChangeParametersControl.this.getTable().setSelection(n);
                }
                ChangeParametersControl.this.fListener.parameterListChanged();
                ChangeParametersControl.this.updateButtonsEnabledState();
            }
        });
        return button;
    }

    private Button createButton(Composite composite, String string, final boolean bl) {
        Button button = new Button(composite, 8);
        button.setText(string);
        button.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ISelection iSelection = ChangeParametersControl.this.fTableViewer.getSelection();
                if (iSelection == null) {
                    return;
                }
                ParameterInfo[] parameterInfoArray = ChangeParametersControl.this.getSelectedElements();
                if (parameterInfoArray.length == 0) {
                    return;
                }
                if (bl) {
                    ChangeParametersControl.this.moveUp(parameterInfoArray);
                } else {
                    ChangeParametersControl.this.moveDown(parameterInfoArray);
                }
                ChangeParametersControl.this.fTableViewer.refresh();
                ChangeParametersControl.this.fTableViewer.setSelection(iSelection);
                ChangeParametersControl.this.fListener.parameterListChanged();
                ChangeParametersControl.this.fTableViewer.getControl().setFocus();
            }
        });
        return button;
    }

    private void addCellEditors() {
        SubjectControlContentAssistant subjectControlContentAssistant;
        this.fTableViewer.setColumnProperties(PROPERTIES);
        CellEditor[] cellEditorArray = new TableTextCellEditor[PROPERTIES.length];
        cellEditorArray[0] = new TableTextCellEditor(this.fTableViewer, 0);
        cellEditorArray[1] = new TableTextCellEditor(this.fTableViewer, 1);
        cellEditorArray[2] = new TableTextCellEditor(this.fTableViewer, 2);
        if (this.fMode.canChangeTypes()) {
            subjectControlContentAssistant = this.installParameterTypeContentAssist(cellEditorArray[0].getText());
            cellEditorArray[0].setContentAssistant(subjectControlContentAssistant);
        }
        if (this.fParamNameProposals.length > 0) {
            subjectControlContentAssistant = this.installParameterNameContentAssist(cellEditorArray[1].getText());
            cellEditorArray[1].setContentAssistant(subjectControlContentAssistant);
        }
        int n = 0;
        while (n < cellEditorArray.length) {
            final int n2 = n;
            TableTextCellEditor tableTextCellEditor = cellEditorArray[n];
            tableTextCellEditor.getText().addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent traverseEvent) {
                    switch (traverseEvent.detail) {
                        case 16: {
                            ChangeParametersControl.this.editColumnOrNextPossible(ChangeParametersControl.this.nextColumn(n2));
                            traverseEvent.detail = 0;
                            break;
                        }
                        case 8: {
                            ChangeParametersControl.this.editColumnOrPrevPossible(ChangeParametersControl.this.prevColumn(n2));
                            traverseEvent.detail = 0;
                            break;
                        }
                    }
                }
            });
            TextFieldNavigationHandler.install(tableTextCellEditor.getText());
            ++n;
        }
        cellEditorArray[1].setActivationListener(new TableTextCellEditor.IActivationListener(){

            public void activate() {
                ParameterInfo[] parameterInfoArray = ChangeParametersControl.this.getSelectedElements();
                if (parameterInfoArray.length == 1 && ChangeParametersControl.this.fNameContentAssistHandler != null) {
                    ChangeParametersControl.this.fNameContentAssistHandler.setEnabled(parameterInfoArray[0].isAdded());
                }
            }
        });
        this.fTableViewer.setCellEditors(cellEditorArray);
        this.fTableViewer.setCellModifier((ICellModifier)new ParametersCellModifier());
    }

    private SubjectControlContentAssistant installParameterTypeContentAssist(Text text) {
        JavaTypeCompletionProcessor javaTypeCompletionProcessor = new JavaTypeCompletionProcessor(true, false);
        if (this.fTypeContext == null) {
            javaTypeCompletionProcessor.setCompletionContext(null, null, null);
        } else {
            javaTypeCompletionProcessor.setCompletionContext(this.fTypeContext.getCuHandle(), this.fTypeContext.getBeforeString(), this.fTypeContext.getAfterString());
        }
        SubjectControlContentAssistant subjectControlContentAssistant = ControlContentAssistHelper.createJavaContentAssistant(javaTypeCompletionProcessor);
        ContentAssistHandler.createHandlerForText((Text)text, (SubjectControlContentAssistant)subjectControlContentAssistant);
        return subjectControlContentAssistant;
    }

    private SubjectControlContentAssistant installParameterNameContentAssist(Text text) {
        VariableNamesProcessor variableNamesProcessor = new VariableNamesProcessor(this.fParamNameProposals);
        SubjectControlContentAssistant subjectControlContentAssistant = ControlContentAssistHelper.createJavaContentAssistant(variableNamesProcessor);
        this.fNameContentAssistHandler = ContentAssistHandler.createHandlerForText((Text)text, (SubjectControlContentAssistant)subjectControlContentAssistant);
        return subjectControlContentAssistant;
    }

    private void moveUp(ParameterInfo[] parameterInfoArray) {
        ChangeParametersControl.moveUp(this.fParameterInfos, Arrays.asList(parameterInfoArray));
    }

    private void moveDown(ParameterInfo[] parameterInfoArray) {
        Collections.reverse(this.fParameterInfos);
        ChangeParametersControl.moveUp(this.fParameterInfos, Arrays.asList(parameterInfoArray));
        Collections.reverse(this.fParameterInfos);
    }

    private static void moveUp(List list, List list2) {
        ArrayList arrayList = new ArrayList(list.size());
        ArrayList arrayList2 = new ArrayList();
        Object e = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (list2.contains(e2)) {
                arrayList.add(e2);
                continue;
            }
            if (((ParameterInfo)e2).isDeleted()) {
                arrayList2.add(e2);
                continue;
            }
            if (e != null) {
                arrayList.add(e);
            }
            e = e2;
        }
        if (e != null) {
            arrayList.add(e);
        }
        arrayList.addAll(arrayList2);
        list.clear();
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
    }

    private boolean canMove(boolean bl) {
        int n = this.getNotDeletedInfosCount();
        if (n == 0) {
            return false;
        }
        int[] nArray = this.getTable().getSelectionIndices();
        if (nArray.length == 0) {
            return false;
        }
        int n2 = bl ? 0 : n - 1;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] == n2) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private int getNotDeletedInfosCount() {
        if (this.fParameterInfos == null) {
            return 0;
        }
        int n = 0;
        Iterator iterator = this.fParameterInfos.iterator();
        while (iterator.hasNext()) {
            ParameterInfo parameterInfo = (ParameterInfo)iterator.next();
            if (parameterInfo.isDeleted()) continue;
            ++n;
        }
        return n;
    }

    public static class Mode {
        private final String fName;
        public static final Mode EXTRACT_METHOD = new Mode("EXTRACT_METHOD");
        public static final Mode CHANGE_METHOD_SIGNATURE = new Mode("CHANGE_METHOD_SIGNATURE");
        public static final Mode INTRODUCE_PARAMETER = new Mode("INTRODUCE_PARAMETER");

        private Mode(String string) {
            this.fName = string;
        }

        public String toString() {
            return this.fName;
        }

        public boolean canChangeTypes() {
            return this == CHANGE_METHOD_SIGNATURE;
        }

        public boolean canAddParameters() {
            return this == CHANGE_METHOD_SIGNATURE;
        }

        public boolean canChangeDefault() {
            return this == CHANGE_METHOD_SIGNATURE;
        }
    }

    private static class ParameterInfoContentProvider
    implements IStructuredContentProvider {
        private ParameterInfoContentProvider() {
        }

        public Object[] getElements(Object object) {
            return this.removeMarkedAsDeleted((List)object);
        }

        private ParameterInfo[] removeMarkedAsDeleted(List list) {
            ArrayList<ParameterInfo> arrayList = new ArrayList<ParameterInfo>(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ParameterInfo parameterInfo = (ParameterInfo)iterator.next();
                if (parameterInfo.isDeleted()) continue;
                arrayList.add(parameterInfo);
            }
            return arrayList.toArray(new ParameterInfo[arrayList.size()]);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private static class ParameterInfoLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableFontProvider {
        private ParameterInfoLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            ParameterInfo parameterInfo = (ParameterInfo)object;
            switch (n) {
                case 0: {
                    return parameterInfo.getNewTypeName();
                }
                case 1: {
                    return parameterInfo.getNewName();
                }
                case 2: {
                    if (parameterInfo.isAdded()) {
                        return parameterInfo.getDefaultValue();
                    }
                    return "-";
                }
            }
            throw new IllegalArgumentException(String.valueOf(n) + ": " + object);
        }

        public Font getFont(Object object, int n) {
            ParameterInfo parameterInfo = (ParameterInfo)object;
            if (parameterInfo.isAdded()) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
            return null;
        }
    }

    private class ParametersCellModifier
    implements ICellModifier {
        private ParametersCellModifier() {
        }

        public boolean canModify(Object object, String string) {
            Assert.isTrue((boolean)(object instanceof ParameterInfo));
            if (string.equals(PROPERTIES[0])) {
                return ChangeParametersControl.this.fMode.canChangeTypes();
            }
            if (string.equals(PROPERTIES[1])) {
                return true;
            }
            if (string.equals(PROPERTIES[2])) {
                return ((ParameterInfo)object).isAdded();
            }
            Assert.isTrue((boolean)false);
            return false;
        }

        public Object getValue(Object object, String string) {
            Assert.isTrue((boolean)(object instanceof ParameterInfo));
            if (string.equals(PROPERTIES[0])) {
                return ((ParameterInfo)object).getNewTypeName();
            }
            if (string.equals(PROPERTIES[1])) {
                return ((ParameterInfo)object).getNewName();
            }
            if (string.equals(PROPERTIES[2])) {
                return ((ParameterInfo)object).getDefaultValue();
            }
            Assert.isTrue((boolean)false);
            return null;
        }

        public void modify(Object object, String string, Object object2) {
            boolean bl;
            if (object instanceof TableItem) {
                object = ((TableItem)object).getData();
            }
            if (!(object instanceof ParameterInfo)) {
                return;
            }
            ParameterInfo parameterInfo = (ParameterInfo)object;
            if (string.equals(PROPERTIES[1])) {
                bl = parameterInfo.getNewName().equals(object2);
                parameterInfo.setNewName((String)object2);
            } else if (string.equals(PROPERTIES[2])) {
                bl = parameterInfo.getDefaultValue().equals(object2);
                parameterInfo.setDefaultValue((String)object2);
            } else if (string.equals(PROPERTIES[0])) {
                bl = parameterInfo.getNewTypeName().equals(object2);
                parameterInfo.setNewTypeName((String)object2);
            } else {
                throw new IllegalStateException();
            }
            if (!bl) {
                ChangeParametersControl.this.fListener.parameterChanged(parameterInfo);
                ChangeParametersControl.this.fTableViewer.update((Object)parameterInfo, new String[]{string});
            }
        }
    }
}

