/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

class ComboSelectionDialog
extends Dialog {
    private String fSelection = null;
    private final String fShellTitle;
    private final String fLabelText;
    private final String[] fAllowedStrings;
    private final int fInitialSelectionIndex;

    public ComboSelectionDialog(Shell shell, String string, String string2, String[] stringArray, int n) {
        super(shell);
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)string2);
        Assert.isTrue((stringArray.length > 0 ? 1 : 0) != 0);
        Assert.isTrue((n >= 0 && n < stringArray.length ? 1 : 0) != 0);
        this.fShellTitle = string;
        this.fLabelText = string2;
        this.fAllowedStrings = stringArray;
        this.fInitialSelectionIndex = n;
    }

    String getSelectedString() {
        return this.fSelection;
    }

    protected Control createDialogArea(Composite composite) {
        this.getShell().setText(this.fShellTitle);
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        Label label = new Label(composite3, 0);
        label.setText(this.fLabelText);
        label.setLayoutData((Object)new GridData());
        final Combo combo = new Combo(composite3, 8);
        int n = 0;
        while (n < this.fAllowedStrings.length) {
            combo.add(this.fAllowedStrings[n]);
            ++n;
        }
        combo.select(this.fInitialSelectionIndex);
        this.fSelection = combo.getItem(combo.getSelectionIndex());
        GridData gridData = new GridData();
        gridData.widthHint = this.convertWidthInCharsToPixels(this.getMaxStringLength());
        combo.setLayoutData((Object)gridData);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ComboSelectionDialog.this.fSelection = combo.getItem(combo.getSelectionIndex());
            }
        });
        ComboSelectionDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private int getMaxStringLength() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.fAllowedStrings.length) {
            n = Math.max(n, this.fAllowedStrings[n2].length());
            ++n2;
        }
        return n;
    }
}

