/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.ui.refactoring.LanguageElementNode;
import org.eclipse.ltk.ui.refactoring.TextEditChangeNode;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class CompilationUnitChangeNode
extends TextEditChangeNode {
    static final TextEditChangeNode.ChildNode[] EMPTY_CHILDREN = new TextEditChangeNode.ChildNode[0];
    static /* synthetic */ Class class$0;

    public CompilationUnitChangeNode(TextEditBasedChange textEditBasedChange) {
        super(textEditBasedChange);
    }

    protected TextEditChangeNode.ChildNode[] createChildNodes() {
        ICompilationUnit iCompilationUnit;
        TextEditBasedChange textEditBasedChange = this.getTextEditBasedChange();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.ICompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iCompilationUnit = (ICompilationUnit)textEditBasedChange.getAdapter((Class)clazz)) != null) {
            ArrayList<TextEditChangeNode.ChildNode> arrayList = new ArrayList<TextEditChangeNode.ChildNode>(5);
            HashMap hashMap = new HashMap(20);
            TextEditBasedChangeGroup[] textEditBasedChangeGroupArray = this.getSortedChangeGroups(textEditBasedChange);
            int n = 0;
            while (n < textEditBasedChangeGroupArray.length) {
                TextEditBasedChangeGroup textEditBasedChangeGroup = textEditBasedChangeGroupArray[n];
                try {
                    IJavaElement iJavaElement = this.getModifiedJavaElement(textEditBasedChangeGroup, iCompilationUnit);
                    if (iJavaElement.equals(iCompilationUnit)) {
                        arrayList.add(CompilationUnitChangeNode.createTextEditGroupNode((TextEditChangeNode)this, (TextEditBasedChangeGroup)textEditBasedChangeGroup));
                    } else {
                        JavaLanguageNode javaLanguageNode = this.getChangeElement(hashMap, iJavaElement, arrayList, this);
                        javaLanguageNode.addChild(CompilationUnitChangeNode.createTextEditGroupNode((TextEditChangeNode.ChildNode)javaLanguageNode, (TextEditBasedChangeGroup)textEditBasedChangeGroup));
                    }
                }
                catch (JavaModelException javaModelException) {
                    arrayList.add(CompilationUnitChangeNode.createTextEditGroupNode((TextEditChangeNode)this, (TextEditBasedChangeGroup)textEditBasedChangeGroup));
                }
                ++n;
            }
            return arrayList.toArray(new TextEditChangeNode.ChildNode[arrayList.size()]);
        }
        return EMPTY_CHILDREN;
    }

    private TextEditBasedChangeGroup[] getSortedChangeGroups(TextEditBasedChange textEditBasedChange) {
        TextEditBasedChangeGroup[] textEditBasedChangeGroupArray = textEditBasedChange.getChangeGroups();
        ArrayList<TextEditBasedChangeGroup> arrayList = new ArrayList<TextEditBasedChangeGroup>(textEditBasedChangeGroupArray.length);
        int n = 0;
        while (n < textEditBasedChangeGroupArray.length) {
            if (!textEditBasedChangeGroupArray[n].getTextEditGroup().isEmpty()) {
                arrayList.add(textEditBasedChangeGroupArray[n]);
            }
            ++n;
        }
        OffsetComparator offsetComparator = new OffsetComparator();
        Collections.sort(arrayList, offsetComparator);
        return arrayList.toArray(new TextEditBasedChangeGroup[arrayList.size()]);
    }

    private IJavaElement getModifiedJavaElement(TextEditBasedChangeGroup textEditBasedChangeGroup, ICompilationUnit iCompilationUnit) throws JavaModelException {
        IRegion iRegion = textEditBasedChangeGroup.getRegion();
        if (iRegion.getOffset() == 0 && iRegion.getLength() == 0) {
            return iCompilationUnit;
        }
        IJavaElement iJavaElement = iCompilationUnit.getElementAt(iRegion.getOffset());
        if (iJavaElement == null) {
            return iCompilationUnit;
        }
        try {
            while (true) {
                ISourceReference iSourceReference = (ISourceReference)iJavaElement;
                Region region = new Region(iSourceReference.getSourceRange().getOffset(), iSourceReference.getSourceRange().getLength());
                if (iJavaElement.getElementType() != 5 && iJavaElement.getParent() != null && !this.coveredBy(textEditBasedChangeGroup, (IRegion)region)) {
                    iJavaElement = iJavaElement.getParent();
                    continue;
                }
                break;
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (ClassCastException classCastException) {}
        return iJavaElement;
    }

    private JavaLanguageNode getChangeElement(Map map, IJavaElement iJavaElement, List list, TextEditChangeNode textEditChangeNode) {
        JavaLanguageNode javaLanguageNode = (JavaLanguageNode)((Object)map.get(iJavaElement));
        if (javaLanguageNode != null) {
            return javaLanguageNode;
        }
        IJavaElement iJavaElement2 = iJavaElement.getParent();
        if (iJavaElement2 instanceof ICompilationUnit) {
            javaLanguageNode = new JavaLanguageNode(textEditChangeNode, iJavaElement);
            list.add(javaLanguageNode);
            map.put(iJavaElement, javaLanguageNode);
        } else {
            JavaLanguageNode javaLanguageNode2 = this.getChangeElement(map, iJavaElement2, list, textEditChangeNode);
            javaLanguageNode = new JavaLanguageNode((TextEditChangeNode.ChildNode)javaLanguageNode2, iJavaElement);
            javaLanguageNode2.addChild((TextEditChangeNode.ChildNode)javaLanguageNode);
            map.put(iJavaElement, javaLanguageNode);
        }
        return javaLanguageNode;
    }

    private boolean coveredBy(TextEditBasedChangeGroup textEditBasedChangeGroup, IRegion iRegion) {
        int n = iRegion.getLength();
        if (n == 0) {
            return false;
        }
        int n2 = iRegion.getOffset();
        int n3 = n2 + n - 1;
        TextEdit[] textEditArray = textEditBasedChangeGroup.getTextEdits();
        int n4 = 0;
        while (n4 < textEditArray.length) {
            TextEdit textEdit = textEditArray[n4];
            if (textEdit.isDeleted()) {
                return false;
            }
            int n5 = textEdit.getOffset();
            int n6 = textEdit.getLength();
            int n7 = n5 + n6 - 1;
            if (n6 == 0 ? n2 >= n5 || n5 > n3 : n2 > n5 || n7 > n3) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    private static class JavaLanguageNode
    extends LanguageElementNode {
        private IJavaElement fJavaElement;
        private static JavaElementImageProvider fgImageProvider = new JavaElementImageProvider();

        public JavaLanguageNode(TextEditChangeNode textEditChangeNode, IJavaElement iJavaElement) {
            super(textEditChangeNode);
            this.fJavaElement = iJavaElement;
            Assert.isNotNull((Object)this.fJavaElement);
        }

        public JavaLanguageNode(TextEditChangeNode.ChildNode childNode, IJavaElement iJavaElement) {
            super(childNode);
            this.fJavaElement = iJavaElement;
            Assert.isNotNull((Object)this.fJavaElement);
        }

        public String getText() {
            return JavaElementLabels.getElementLabel(this.fJavaElement, JavaElementLabels.ALL_DEFAULT);
        }

        public ImageDescriptor getImageDescriptor() {
            return fgImageProvider.getJavaImageDescriptor(this.fJavaElement, 3);
        }

        public IRegion getTextRange() throws CoreException {
            ISourceRange iSourceRange = ((ISourceReference)this.fJavaElement).getSourceRange();
            return new Region(iSourceRange.getOffset(), iSourceRange.getLength());
        }
    }

    private static class OffsetComparator
    implements Comparator {
        private OffsetComparator() {
        }

        public int compare(Object object, Object object2) {
            int n;
            TextEditBasedChangeGroup textEditBasedChangeGroup = (TextEditBasedChangeGroup)object;
            TextEditBasedChangeGroup textEditBasedChangeGroup2 = (TextEditBasedChangeGroup)object2;
            int n2 = this.getOffset(textEditBasedChangeGroup);
            if (n2 < (n = this.getOffset(textEditBasedChangeGroup2))) {
                return -1;
            }
            if (n2 > n) {
                return 1;
            }
            return 0;
        }

        private int getOffset(TextEditBasedChangeGroup textEditBasedChangeGroup) {
            return textEditBasedChangeGroup.getRegion().getOffset();
        }
    }
}

