/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.IMemberActionInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.PullUpRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.PullUpRefactoringProcessor;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.refactoring.ComboSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.refactoring.PullPushCheckboxTableViewer;
import org.eclipse.wst.jsdt.internal.ui.refactoring.PullUpMethodPage;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;
import org.eclipse.wst.jsdt.internal.ui.util.TableLayoutComposite;
import org.eclipse.wst.jsdt.ui.JavaElementLabelProvider;

public class PullUpMemberPage
extends UserInputWizardPage {
    private static final int ACTION_COLUMN = 1;
    private static final String ACTION_PROPERTY = "action";
    protected static final int DECLARE_ABSTRACT_ACTION = 1;
    private static final int MEMBER_COLUMN = 0;
    private static final String MEMBER_PROPERTY = "member";
    protected static final int PULL_UP_ACTION = 0;
    private static final String SETTING_INSTANCEOF = "InstanceOf";
    private static final String SETTING_REPLACE = "Replace";
    private Button fAddButton;
    protected IType[] fCandidateTypes = new IType[0];
    private Button fCreateStubsButton;
    private Button fDeselectAllButton;
    private Button fEditButton;
    private Button fInstanceofButton;
    private Label fLabel;
    private Button fReplaceButton;
    private Button fSelectAllButton;
    private Label fStatusLine;
    protected final PullUpMethodPage fSuccessorPage;
    private Combo fSuperTypesCombo;
    private CheckboxTableViewer fTableViewer;
    protected final String[] METHOD_LABELS;
    protected final String[] TYPE_LABELS;

    private static int getEditableCount(MemberActionInfo[] memberActionInfoArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < memberActionInfoArray.length) {
            MemberActionInfo memberActionInfo = memberActionInfoArray[n2];
            if (memberActionInfo.isEditable()) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private static void putToStringMapping(Map map, String[] stringArray, int n) {
        map.put(stringArray[n], new Integer(n));
    }

    private static void setActionForInfos(MemberActionInfo[] memberActionInfoArray, int n) {
        int n2 = 0;
        while (n2 < memberActionInfoArray.length) {
            memberActionInfoArray[n2].setAction(n);
            ++n2;
        }
    }

    public PullUpMemberPage(String string, PullUpMethodPage pullUpMethodPage) {
        super(string);
        this.fSuccessorPage = pullUpMethodPage;
        this.setDescription(RefactoringMessages.PullUpInputPage1_page_message);
        this.METHOD_LABELS = new String[2];
        this.METHOD_LABELS[0] = RefactoringMessages.PullUpInputPage1_pull_up;
        this.METHOD_LABELS[1] = RefactoringMessages.PullUpInputPage1_declare_abstract;
        this.TYPE_LABELS = new String[1];
        this.TYPE_LABELS[0] = RefactoringMessages.PullUpInputPage1_pull_up;
    }

    private boolean areAllMembersMarkedAsPullUp() {
        return this.getMembersForAction(0).length == this.getTableInput().length;
    }

    protected boolean areAllMembersMarkedAsWithNoAction() {
        return this.getMembersForAction(2).length == this.getTableInput().length;
    }

    private MemberActionInfo[] asMemberActionInfos() {
        PullUpRefactoringProcessor pullUpRefactoringProcessor = this.getPullUpRefactoring().getPullUpProcessor();
        List<IMember> list = Arrays.asList(pullUpRefactoringProcessor.getMembersToMove());
        IMember[] iMemberArray = pullUpRefactoringProcessor.getPullableMembersOfDeclaringType();
        MemberActionInfo[] memberActionInfoArray = new MemberActionInfo[iMemberArray.length];
        int n = 0;
        while (n < iMemberArray.length) {
            IMember iMember = iMemberArray[n];
            memberActionInfoArray[n] = list.contains(iMember) ? new MemberActionInfo(iMember, 0) : new MemberActionInfo(iMember, 2);
            ++n;
        }
        return memberActionInfoArray;
    }

    public boolean canFlipToNextPage() {
        if (this.getMethodsForAction(0).length == 0) {
            return this.isPageComplete();
        }
        return super.canFlipToNextPage();
    }

    private void checkAdditionalRequired() {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(false, false, new IRunnableWithProgress(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                    try {
                        try {
                            PullUpMemberPage.this.checkPullUp(PullUpMemberPage.this.getPullUpRefactoring().getPullUpProcessor().getAdditionalRequiredMembersToPullUp(iProgressMonitor), true);
                        }
                        catch (JavaModelException javaModelException) {
                            throw new InvocationTargetException(javaModelException);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        iProgressMonitor.done();
                        throw throwable;
                    }
                    {
                        Object var3_5 = null;
                    }
                    iProgressMonitor.done();
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionHandler.handle(invocationTargetException, this.getShell(), RefactoringMessages.PullUpInputPage_pull_Up, RefactoringMessages.PullUpInputPage_exception);
        }
        catch (InterruptedException interruptedException) {
            Assert.isTrue((boolean)false);
        }
    }

    protected void checkPageCompletionStatus(boolean bl) {
        if (this.areAllMembersMarkedAsWithNoAction()) {
            if (bl) {
                this.setErrorMessage(this.getNoMembersMessage());
            }
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
        this.fSuccessorPage.fireSettingsChanged();
    }

    private void checkPullUp(IMember[] iMemberArray, boolean bl) {
        this.setActionForMembers(iMemberArray, 0);
        this.updateWizardPage(null, bl);
    }

    private void createButtonComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1040));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        this.fSelectAllButton = new Button(composite2, 8);
        this.fSelectAllButton.setText(RefactoringMessages.PullUpWizard_select_all_label);
        this.fSelectAllButton.setLayoutData((Object)new GridData(768));
        this.fSelectAllButton.setEnabled(true);
        SWTUtil.setButtonDimensionHint(this.fSelectAllButton);
        this.fSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IMember[] iMemberArray = PullUpMemberPage.this.getMembers();
                PullUpMemberPage.this.setActionForMembers(iMemberArray, 0);
                PullUpMemberPage.this.updateWizardPage(null, true);
            }
        });
        this.fDeselectAllButton = new Button(composite2, 8);
        this.fDeselectAllButton.setText(RefactoringMessages.PullUpWizard_deselect_all_label);
        this.fDeselectAllButton.setLayoutData((Object)new GridData(768));
        this.fDeselectAllButton.setEnabled(false);
        SWTUtil.setButtonDimensionHint(this.fDeselectAllButton);
        this.fDeselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IMember[] iMemberArray = PullUpMemberPage.this.getMembers();
                PullUpMemberPage.this.setActionForMembers(iMemberArray, 2);
                PullUpMemberPage.this.updateWizardPage(null, true);
            }
        });
        this.fEditButton = new Button(composite2, 8);
        this.fEditButton.setText(RefactoringMessages.PullUpInputPage1_Edit);
        GridData gridData = new GridData(768);
        gridData.verticalIndent = new PixelConverter((Control)composite).convertVerticalDLUsToPixels(7);
        this.fEditButton.setLayoutData((Object)gridData);
        this.fEditButton.setEnabled(false);
        SWTUtil.setButtonDimensionHint(this.fEditButton);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PullUpMemberPage.this.editSelectedMembers();
            }
        });
        this.fAddButton = new Button(composite2, 8);
        this.fAddButton.setText(RefactoringMessages.PullUpInputPage1_Add_Required);
        this.fAddButton.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(this.fAddButton);
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PullUpMemberPage.this.checkAdditionalRequired();
            }
        });
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        this.createSuperTypeControl(composite2);
        this.createSpacer(composite2);
        this.createSuperTypeCheckbox(composite2);
        this.createInstanceOfCheckbox(composite2, gridLayout.marginWidth);
        this.createStubCheckbox(composite2);
        this.createSpacer(composite2);
        this.createMemberTableLabel(composite2);
        this.createMemberTableComposite(composite2);
        this.createStatusLine(composite2);
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
        this.initializeEnablement();
        this.initializeCheckboxes();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.jsdt.ui.pull_up_wizard_page_context");
    }

    protected void createInstanceOfCheckbox(Composite composite, int n) {
        final PullUpRefactoringProcessor pullUpRefactoringProcessor = this.getPullUpRefactoring().getPullUpProcessor();
        this.fInstanceofButton = new Button(composite, 32);
        this.fInstanceofButton.setSelection(false);
        GridData gridData = new GridData();
        gridData.horizontalIndent = n + this.fInstanceofButton.computeSize((int)-1, (int)-1).x;
        gridData.horizontalSpan = 2;
        this.fInstanceofButton.setLayoutData((Object)gridData);
        this.fInstanceofButton.setText(this.getInstanceofButtonLabel());
        pullUpRefactoringProcessor.setInstanceOf(this.fInstanceofButton.getSelection());
        this.fInstanceofButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                pullUpRefactoringProcessor.setInstanceOf(PullUpMemberPage.this.fInstanceofButton.getSelection());
            }
        });
        this.fReplaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PullUpMemberPage.this.fInstanceofButton.setEnabled(PullUpMemberPage.this.fReplaceButton.getSelection());
            }
        });
    }

    private void createMemberTable(Composite composite) {
        TableLayoutComposite tableLayoutComposite = new TableLayoutComposite(composite, 0);
        tableLayoutComposite.addColumnData((ColumnLayoutData)new ColumnWeightData(60, true));
        tableLayoutComposite.addColumnData((ColumnLayoutData)new ColumnWeightData(40, true));
        Table table = new Table((Composite)tableLayoutComposite, 68386);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData(1808);
        gridData.heightHint = SWTUtil.getTableHeightHint(table, this.getTableRowCount());
        gridData.widthHint = this.convertWidthInCharsToPixels(30);
        tableLayoutComposite.setLayoutData(gridData);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setText(RefactoringMessages.PullUpInputPage1_Member);
        TableColumn tableColumn2 = new TableColumn(table, 0);
        tableColumn2.setText(RefactoringMessages.PullUpInputPage1_Action);
        this.fTableViewer = new PullPushCheckboxTableViewer(table);
        this.fTableViewer.setUseHashlookup(true);
        this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new MemberActionInfoLabelProvider());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                PullUpMemberPage.this.updateButtonEnablement(selectionChangedEvent.getSelection());
            }
        });
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                boolean bl = checkStateChangedEvent.getChecked();
                MemberActionInfo memberActionInfo = (MemberActionInfo)checkStateChangedEvent.getElement();
                if (bl) {
                    memberActionInfo.setAction(0);
                } else {
                    memberActionInfo.setAction(2);
                }
                PullUpMemberPage.this.updateWizardPage(null, true);
            }
        });
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                PullUpMemberPage.this.editSelectedMembers();
            }
        });
        this.setTableInput();
        this.checkPullUp(this.getPullUpRefactoring().getPullUpProcessor().getMembersToMove(), false);
        this.setupCellEditors(table);
    }

    protected void createMemberTableComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        composite2.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        this.createMemberTable(composite2);
        this.createButtonComposite(composite2);
    }

    protected void createMemberTableLabel(Composite composite) {
        this.fLabel = new Label(composite, 0);
        this.fLabel.setText(RefactoringMessages.PullUpInputPage1_Specify_actions);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.fLabel.setLayoutData((Object)gridData);
    }

    protected void createSpacer(Composite composite) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.heightHint = this.convertHeightInCharsToPixels(1) / 2;
        label.setLayoutData((Object)gridData);
    }

    protected void createStatusLine(Composite composite) {
        this.fStatusLine = new Label(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.updateStatusLine();
        this.fStatusLine.setLayoutData((Object)gridData);
    }

    private Map createStringMappingForSelectedMembers() {
        HashMap hashMap = new HashMap();
        PullUpMemberPage.putToStringMapping(hashMap, this.METHOD_LABELS, 0);
        PullUpMemberPage.putToStringMapping(hashMap, this.METHOD_LABELS, 1);
        return hashMap;
    }

    protected void createStubCheckbox(Composite composite) {
        this.fCreateStubsButton = new Button(composite, 32);
        this.fCreateStubsButton.setText(this.getCreateStubsButtonLabel());
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.fCreateStubsButton.setLayoutData((Object)gridData);
        this.fCreateStubsButton.setEnabled(false);
        this.fCreateStubsButton.setSelection(this.getPullUpRefactoring().getPullUpProcessor().getCreateMethodStubs());
    }

    protected void createSuperTypeCheckbox(Composite composite) {
        this.fReplaceButton = new Button(composite, 32);
        this.fReplaceButton.setText(this.getReplaceButtonLabel());
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.fReplaceButton.setLayoutData((Object)gridData);
        this.fReplaceButton.setEnabled(true);
        this.fReplaceButton.setSelection(this.getPullUpRefactoring().getPullUpProcessor().isReplace());
    }

    private void createSuperTypeCombo(IProgressMonitor iProgressMonitor, Composite composite) throws JavaModelException {
        Label label = new Label(composite, 0);
        label.setText(RefactoringMessages.PullUpInputPage1_Select_destination);
        label.setLayoutData((Object)new GridData());
        this.fSuperTypesCombo = new Combo(composite, 8);
        this.fCandidateTypes = this.getPullUpRefactoring().getPullUpProcessor().getCandidateTypes(new RefactoringStatus(), iProgressMonitor);
        if (this.fCandidateTypes.length > 0) {
            int n = 0;
            while (n < this.fCandidateTypes.length) {
                String string = JavaModelUtil.getFullyQualifiedName(this.fCandidateTypes[n]);
                this.fSuperTypesCombo.add(string);
                ++n;
            }
            this.fSuperTypesCombo.select(this.fCandidateTypes.length - 1);
            this.fSuperTypesCombo.setLayoutData((Object)new GridData(768));
        }
    }

    protected void createSuperTypeControl(final Composite composite) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(false, false, new IRunnableWithProgress(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                    try {
                        try {
                            PullUpMemberPage.this.createSuperTypeCombo(iProgressMonitor, composite);
                        }
                        catch (JavaModelException javaModelException) {
                            throw new InvocationTargetException(javaModelException);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        iProgressMonitor.done();
                        throw throwable;
                    }
                    {
                        Object var3_5 = null;
                    }
                    iProgressMonitor.done();
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionHandler.handle(invocationTargetException, this.getShell(), RefactoringMessages.PullUpInputPage_pull_Up, RefactoringMessages.PullUpInputPage_exception);
        }
        catch (InterruptedException interruptedException) {
            Assert.isTrue((boolean)false);
        }
    }

    public void dispose() {
        this.fInstanceofButton = null;
        this.fReplaceButton = null;
        this.fTableViewer = null;
        super.dispose();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void editSelectedMembers() {
        if (!this.fEditButton.isEnabled()) {
            return;
        }
        ISelection iSelection = this.fTableViewer.getSelection();
        try {
            String string = RefactoringMessages.PullUpInputPage1_Edit_members;
            String string2 = RefactoringMessages.PullUpInputPage1_Mark_selected_members;
            Map map = this.createStringMappingForSelectedMembers();
            Object[] objectArray = map.keySet().toArray(new String[map.keySet().size()]);
            Arrays.sort(objectArray);
            int n = this.getInitialSelectionIndexForEditDialog(map, (String[])objectArray);
            ComboSelectionDialog comboSelectionDialog = new ComboSelectionDialog(this.getShell(), string, string2, (String[])objectArray, n);
            comboSelectionDialog.setBlockOnOpen(true);
            if (comboSelectionDialog.open() == 1) {
                Object var9_8 = null;
                this.updateWizardPage(iSelection, true);
                return;
            }
            int n2 = (Integer)map.get(comboSelectionDialog.getSelectedString());
            PullUpMemberPage.setActionForInfos(this.getSelectedMembers(), n2);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.updateWizardPage(iSelection, true);
            throw throwable;
        }
        {
            Object var9_10 = null;
            this.updateWizardPage(iSelection, true);
            return;
        }
    }

    private boolean enableEditButton(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.isEmpty() || iStructuredSelection.size() == 0) {
            return false;
        }
        return iStructuredSelection.size() == PullUpMemberPage.getEditableCount(this.getSelectedMembers());
    }

    private MemberActionInfo[] getActiveInfos() {
        MemberActionInfo[] memberActionInfoArray = this.getTableInput();
        ArrayList<MemberActionInfo> arrayList = new ArrayList<MemberActionInfo>(memberActionInfoArray.length);
        int n = 0;
        while (n < memberActionInfoArray.length) {
            MemberActionInfo memberActionInfo = memberActionInfoArray[n];
            if (memberActionInfo.isActive()) {
                arrayList.add(memberActionInfo);
            }
            ++n;
        }
        return arrayList.toArray(new MemberActionInfo[arrayList.size()]);
    }

    private int getCommonActionCodeForSelectedInfos() {
        MemberActionInfo[] memberActionInfoArray = this.getSelectedMembers();
        if (memberActionInfoArray.length == 0) {
            return -1;
        }
        int n = memberActionInfoArray[0].getAction();
        int n2 = 0;
        while (n2 < memberActionInfoArray.length) {
            if (n != memberActionInfoArray[n2].getAction()) {
                return -1;
            }
            ++n2;
        }
        return n;
    }

    protected String getCreateStubsButtonLabel() {
        return RefactoringMessages.PullUpInputPage1_Create_stubs;
    }

    protected String getDeclareAbstractActionLabel() {
        return RefactoringMessages.PullUpInputPage1_declare_abstract;
    }

    public IType getDestinationType() {
        int n = this.fSuperTypesCombo.getSelectionIndex();
        if (n >= 0) {
            return this.fCandidateTypes[n];
        }
        return null;
    }

    private int getInitialSelectionIndexForEditDialog(Map map, String[] stringArray) {
        int n = this.getCommonActionCodeForSelectedInfos();
        if (n == -1) {
            return 0;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n2 = (Integer)map.get(string);
            if (n != n2) continue;
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (string.equals(stringArray[n3])) {
                    return n3;
                }
                ++n3;
            }
            Assert.isTrue((boolean)false);
        }
        return 0;
    }

    protected String getInstanceofButtonLabel() {
        return RefactoringMessages.PullUpInputPage1_label_use_in_instanceof;
    }

    private IMember[] getMembers() {
        MemberActionInfo[] memberActionInfoArray = this.getTableInput();
        ArrayList<IMember> arrayList = new ArrayList<IMember>(memberActionInfoArray.length);
        int n = 0;
        while (n < memberActionInfoArray.length) {
            arrayList.add(memberActionInfoArray[n].getMember());
            ++n;
        }
        return arrayList.toArray(new IMember[arrayList.size()]);
    }

    private IMember[] getMembersForAction(int n) {
        MemberActionInfo[] memberActionInfoArray = this.getTableInput();
        ArrayList<IMember> arrayList = new ArrayList<IMember>(memberActionInfoArray.length);
        int n2 = 0;
        while (n2 < memberActionInfoArray.length) {
            if (memberActionInfoArray[n2].getAction() == n) {
                arrayList.add(memberActionInfoArray[n2].getMember());
            }
            ++n2;
        }
        return arrayList.toArray(new IMember[arrayList.size()]);
    }

    private IMethod[] getMethodsForAction(int n) {
        MemberActionInfo[] memberActionInfoArray = this.getTableInput();
        ArrayList<IMember> arrayList = new ArrayList<IMember>(memberActionInfoArray.length);
        int n2 = 0;
        while (n2 < memberActionInfoArray.length) {
            if (memberActionInfoArray[n2].isMethodInfo() && memberActionInfoArray[n2].getAction() == n) {
                arrayList.add(memberActionInfoArray[n2].getMember());
            }
            ++n2;
        }
        return arrayList.toArray(new IMethod[arrayList.size()]);
    }

    public IWizardPage getNextPage() {
        this.initializeRefactoring();
        this.storeDialogSettings();
        if (this.getMethodsForAction(0).length == 0) {
            return this.computeSuccessorPage();
        }
        try {
            IType iType = this.getDestinationType();
            if (iType != null && iType.isInterface()) {
                return this.computeSuccessorPage();
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
        return super.getNextPage();
    }

    protected String getNoMembersMessage() {
        return RefactoringMessages.PullUpInputPage1_Select_members_to_pull_up;
    }

    protected String getPullUpActionLabel() {
        return RefactoringMessages.PullUpInputPage1_pull_up;
    }

    private PullUpRefactoring getPullUpRefactoring() {
        return (PullUpRefactoring)this.getRefactoring();
    }

    protected String getReplaceButtonLabel() {
        return RefactoringMessages.PullUpInputPage1_label_use_destination;
    }

    private MemberActionInfo[] getSelectedMembers() {
        Assert.isTrue((boolean)(this.fTableViewer.getSelection() instanceof IStructuredSelection));
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fTableViewer.getSelection();
        List list = iStructuredSelection.toList();
        return list.toArray(new MemberActionInfo[list.size()]);
    }

    private MemberActionInfo[] getTableInput() {
        return (MemberActionInfo[])this.fTableViewer.getInput();
    }

    protected int getTableRowCount() {
        return 10;
    }

    private void initializeCheckBox(Button button, String string, boolean bl) {
        String string2 = JavaPlugin.getDefault().getDialogSettings().get(string);
        if (string2 != null) {
            button.setSelection(new Boolean(string2).booleanValue());
        } else {
            button.setSelection(bl);
        }
    }

    protected void initializeCheckboxes() {
        this.initializeCheckBox(this.fReplaceButton, SETTING_REPLACE, true);
        this.initializeCheckBox(this.fInstanceofButton, SETTING_INSTANCEOF, false);
    }

    protected void initializeEnablement() {
        MemberActionInfo[] memberActionInfoArray = this.asMemberActionInfos();
        boolean bl = memberActionInfoArray.length > 0;
        this.fTableViewer.getTable().setEnabled(bl);
        this.fStatusLine.setEnabled(bl);
        this.fAddButton.setEnabled(bl);
        this.fLabel.setEnabled(bl);
    }

    private void initializeRefactoring() {
        PullUpRefactoringProcessor pullUpRefactoringProcessor = this.getPullUpRefactoring().getPullUpProcessor();
        pullUpRefactoringProcessor.setMembersToMove(this.getMembersForAction(0));
        pullUpRefactoringProcessor.setAbstractMethods(this.getMethodsForAction(1));
        IType iType = this.getDestinationType();
        if (iType != null) {
            pullUpRefactoringProcessor.setDestinationType(iType);
        }
        pullUpRefactoringProcessor.setCreateMethodStubs(this.fCreateStubsButton.getSelection());
        pullUpRefactoringProcessor.setReplace(this.fReplaceButton.getSelection());
        pullUpRefactoringProcessor.setInstanceOf(this.fInstanceofButton.getSelection());
        pullUpRefactoringProcessor.setDeletedMethods(this.getMethodsForAction(0));
    }

    protected boolean performFinish() {
        this.initializeRefactoring();
        this.storeDialogSettings();
        return super.performFinish();
    }

    private void setActionForMembers(IMember[] iMemberArray, int n) {
        MemberActionInfo[] memberActionInfoArray = this.getTableInput();
        int n2 = 0;
        while (n2 < iMemberArray.length) {
            int n3 = 0;
            while (n3 < memberActionInfoArray.length) {
                if (memberActionInfoArray[n3].getMember().equals(iMemberArray[n2])) {
                    memberActionInfoArray[n3].setAction(n);
                }
                ++n3;
            }
            ++n2;
        }
    }

    private void setTableInput() {
        this.fTableViewer.setInput((Object)this.asMemberActionInfos());
    }

    private void setupCellEditors(final Table table) {
        final ComboBoxCellEditor comboBoxCellEditor = new ComboBoxCellEditor();
        comboBoxCellEditor.setStyle(8);
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = comboBoxCellEditor;
        this.fTableViewer.setCellEditors(cellEditorArray);
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ISelection iSelection;
                if (comboBoxCellEditor.getControl() == null & !table.isDisposed()) {
                    comboBoxCellEditor.create((Composite)table);
                }
                if (!((iSelection = selectionChangedEvent.getSelection()) instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
                if (iStructuredSelection.size() != 1) {
                    return;
                }
                MemberActionInfo memberActionInfo = (MemberActionInfo)iStructuredSelection.getFirstElement();
                comboBoxCellEditor.setItems(memberActionInfo.getAllowedLabels());
                comboBoxCellEditor.setValue((Object)new Integer(memberActionInfo.getAction()));
            }
        });
        MemberActionCellModifier memberActionCellModifier = new MemberActionCellModifier();
        this.fTableViewer.setCellModifier((ICellModifier)memberActionCellModifier);
        this.fTableViewer.setColumnProperties(new String[]{MEMBER_PROPERTY, ACTION_PROPERTY});
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl) return;
        try {
            this.getPullUpRefactoring().getPullUpProcessor().resetEnvironment();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object[])this.getActiveInfos()), true);
            this.fTableViewer.getControl().setFocus();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object[])this.getActiveInfos()), true);
        this.fTableViewer.getControl().setFocus();
    }

    private void storeDialogSettings() {
        IDialogSettings iDialogSettings = JavaPlugin.getDefault().getDialogSettings();
        iDialogSettings.put(SETTING_REPLACE, this.fReplaceButton.getSelection());
        iDialogSettings.put(SETTING_INSTANCEOF, this.fInstanceofButton.getSelection());
    }

    private void updateButtonEnablement(ISelection iSelection) {
        if (this.fEditButton != null) {
            this.fEditButton.setEnabled(this.enableEditButton((IStructuredSelection)iSelection));
        }
        this.fCreateStubsButton.setEnabled(this.getMethodsForAction(1).length != 0);
        this.fInstanceofButton.setEnabled(this.fReplaceButton.getSelection());
        if (this.fSelectAllButton != null) {
            this.fSelectAllButton.setEnabled(!this.areAllMembersMarkedAsPullUp());
        }
        if (this.fDeselectAllButton != null) {
            this.fDeselectAllButton.setEnabled(!this.areAllMembersMarkedAsWithNoAction());
        }
    }

    private void updateStatusLine() {
        if (this.fStatusLine == null) {
            return;
        }
        int n = this.fTableViewer.getCheckedElements().length;
        Object[] objectArray = new String[]{String.valueOf(n)};
        String string = Messages.format(RefactoringMessages.PullUpInputPage1_status_line, objectArray);
        this.fStatusLine.setText(string);
    }

    private void updateWizardPage(ISelection iSelection, boolean bl) {
        this.fTableViewer.refresh();
        if (iSelection != null) {
            this.fTableViewer.getControl().setFocus();
            this.fTableViewer.setSelection(iSelection);
        }
        this.checkPageCompletionStatus(bl);
        this.updateButtonEnablement(this.fTableViewer.getSelection());
        this.updateStatusLine();
    }

    private class MemberActionCellModifier
    implements ICellModifier {
        private MemberActionCellModifier() {
        }

        public boolean canModify(Object object, String string) {
            if (!PullUpMemberPage.ACTION_PROPERTY.equals(string)) {
                return false;
            }
            return ((MemberActionInfo)object).isEditable();
        }

        public Object getValue(Object object, String string) {
            if (!PullUpMemberPage.ACTION_PROPERTY.equals(string)) {
                return null;
            }
            MemberActionInfo memberActionInfo = (MemberActionInfo)object;
            return new Integer(memberActionInfo.getAction());
        }

        public void modify(Object object, String string, Object object2) {
            if (!PullUpMemberPage.ACTION_PROPERTY.equals(string)) {
                return;
            }
            int n = (Integer)object2;
            MemberActionInfo memberActionInfo = object instanceof Item ? (MemberActionInfo)((Item)object).getData() : (MemberActionInfo)object;
            if (!this.canModify(memberActionInfo, string)) {
                return;
            }
            Assert.isTrue((boolean)memberActionInfo.isMethodInfo());
            memberActionInfo.setAction(n);
            PullUpMemberPage.this.updateWizardPage(null, true);
        }
    }

    private class MemberActionInfo
    implements IMemberActionInfo {
        private static final int NO_ACTION = 2;
        private int fAction;
        private final IMember fMember;

        public MemberActionInfo(IMember iMember, int n) {
            Assert.isTrue((iMember instanceof IMethod || iMember instanceof IField || iMember instanceof IType ? 1 : 0) != 0);
            this.assertAction(iMember, n);
            this.fMember = iMember;
            this.fAction = n;
        }

        private void assertAction(IMember iMember, int n) {
            if (iMember instanceof IMethod) {
                try {
                    Assert.isTrue((n != 1 || !JdtFlags.isStatic(iMember) ? 1 : 0) != 0);
                }
                catch (JavaModelException javaModelException) {
                    JavaPlugin.log(javaModelException);
                }
                Assert.isTrue((n == 2 || n == 1 || n == 0 ? 1 : 0) != 0);
            } else {
                Assert.isTrue((n == 2 || n == 0 ? 1 : 0) != 0);
            }
        }

        public int getAction() {
            return this.fAction;
        }

        public String getActionLabel() {
            switch (this.fAction) {
                case 0: {
                    return PullUpMemberPage.this.getPullUpActionLabel();
                }
                case 1: {
                    return PullUpMemberPage.this.getDeclareAbstractActionLabel();
                }
                case 2: {
                    return "";
                }
            }
            Assert.isTrue((boolean)false);
            return null;
        }

        public String[] getAllowedLabels() {
            if (this.isFieldInfo()) {
                return new String[]{""};
            }
            if (this.isMethodInfo()) {
                return PullUpMemberPage.this.METHOD_LABELS;
            }
            if (this.isTypeInfo()) {
                return PullUpMemberPage.this.TYPE_LABELS;
            }
            Assert.isTrue((boolean)false);
            return null;
        }

        public IMember getMember() {
            return this.fMember;
        }

        public boolean isActive() {
            return this.getAction() != 2;
        }

        public boolean isEditable() {
            if (this.fAction == 2) {
                return false;
            }
            if (!this.isMethodInfo()) {
                return false;
            }
            IMethod iMethod = (IMethod)this.fMember;
            try {
                return !JdtFlags.isStatic((IMember)iMethod);
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
                return false;
            }
        }

        public boolean isFieldInfo() {
            return this.getMember() instanceof IField;
        }

        public boolean isMethodInfo() {
            return this.getMember() instanceof IMethod;
        }

        public boolean isTypeInfo() {
            return this.getMember() instanceof IType;
        }

        public void setAction(int n) {
            this.assertAction(this.fMember, n);
            this.fAction = n;
        }
    }

    private static class MemberActionInfoLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private final ILabelProvider fLabelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT | 0x100);

        private MemberActionInfoLabelProvider() {
        }

        public void dispose() {
            super.dispose();
            this.fLabelProvider.dispose();
        }

        public Image getColumnImage(Object object, int n) {
            MemberActionInfo memberActionInfo = (MemberActionInfo)object;
            switch (n) {
                case 0: {
                    return this.fLabelProvider.getImage((Object)memberActionInfo.getMember());
                }
                case 1: {
                    return null;
                }
            }
            Assert.isTrue((boolean)false);
            return null;
        }

        public String getColumnText(Object object, int n) {
            MemberActionInfo memberActionInfo = (MemberActionInfo)object;
            switch (n) {
                case 0: {
                    return this.fLabelProvider.getText((Object)memberActionInfo.getMember());
                }
                case 1: {
                    return memberActionInfo.getActionLabel();
                }
            }
            Assert.isTrue((boolean)false);
            return null;
        }
    }
}

