/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class RenameResourceAction
extends SelectionDispatchAction {
    public RenameResourceAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        IResource iResource = RenameResourceAction.getResource(iStructuredSelection);
        if (iResource == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(RefactoringAvailabilityTester.isRenameAvailable(iResource));
        }
    }

    public void run(IStructuredSelection iStructuredSelection) {
        IResource iResource = RenameResourceAction.getResource(iStructuredSelection);
        if (!RefactoringAvailabilityTester.isRenameAvailable(iResource)) {
            return;
        }
        try {
            RefactoringExecutionStarter.startRenameResourceRefactoring(iResource, this.getShell());
        }
        catch (CoreException coreException) {
            ExceptionHandler.handle(coreException, RefactoringMessages.RenameJavaElementAction_name, RefactoringMessages.RenameJavaElementAction_exception);
        }
    }

    private static IResource getResource(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() != 1) {
            return null;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (!(object instanceof IResource)) {
            return null;
        }
        return (IResource)object;
    }
}

