/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.contentassist.ISubjectControlContentAssistProcessor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.CompletionRequestor;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.internal.corext.refactoring.StubTypeContext;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.contentassist.CompletionContextRequestor;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaTypeCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.wst.jsdt.ui.text.java.CompletionProposalComparator;

public class CUPositionCompletionProcessor
implements IContentAssistProcessor,
ISubjectControlContentAssistProcessor {
    private static final ImageDescriptorRegistry IMAGE_DESC_REGISTRY = JavaPlugin.getImageDescriptorRegistry();
    private String fErrorMessage;
    private char[] fProposalAutoActivationSet;
    private CompletionProposalComparator fComparator;
    private CompletionContextRequestor fCompletionContextRequestor;
    private CUPositionCompletionRequestor fCompletionRequestor;

    public CUPositionCompletionProcessor(CUPositionCompletionRequestor cUPositionCompletionRequestor) {
        this.fCompletionRequestor = cUPositionCompletionRequestor;
        this.fComparator = new CompletionProposalComparator();
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString("content_assist_autoactivation_triggers_java");
        this.fProposalAutoActivationSet = string.toCharArray();
    }

    public void setCompletionContext(ICompilationUnit iCompilationUnit, String string, String string2) {
        this.fCompletionContextRequestor = new CompletionContextRequestor(iCompilationUnit, string, string2){
            final StubTypeContext fStubTypeContext;
            {
                this.fStubTypeContext = new StubTypeContext(iCompilationUnit, string, string2);
            }

            public StubTypeContext getStubTypeContext() {
                return this.fStubTypeContext;
            }
        };
        if (iCompilationUnit != null) {
            this.fCompletionRequestor.setJavaProject(iCompilationUnit.getJavaProject());
        }
    }

    public void setCompletionContextRequestor(CompletionContextRequestor completionContextRequestor) {
        this.fCompletionContextRequestor = completionContextRequestor;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer iTextViewer, int n) {
        Assert.isTrue((boolean)false, (String)"ITextViewer not supported");
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer iTextViewer, int n) {
        Assert.isTrue((boolean)false, (String)"ITextViewer not supported");
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public IContextInformation[] computeContextInformation(IContentAssistSubjectControl iContentAssistSubjectControl, int n) {
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(IContentAssistSubjectControl iContentAssistSubjectControl, int n) {
        if (this.fCompletionContextRequestor.getOriginalCu() == null) {
            return null;
        }
        String string = iContentAssistSubjectControl.getDocument().get();
        if (n == 0) {
            return null;
        }
        ICompletionProposal[] iCompletionProposalArray = this.internalComputeCompletionProposals(n, string);
        Arrays.sort(iCompletionProposalArray, this.fComparator);
        return iCompletionProposalArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ICompletionProposal[] internalComputeCompletionProposals(int n, String string) {
        ICompletionProposal[] iCompletionProposalArray2;
        String string2 = String.valueOf(this.fCompletionContextRequestor.getBeforeString()) + string + this.fCompletionContextRequestor.getAfterString();
        ICompilationUnit iCompilationUnit = null;
        try {
            try {
                iCompilationUnit = this.fCompletionContextRequestor.getOriginalCu().getWorkingCopy(new WorkingCopyOwner(){}, null, (IProgressMonitor)new NullProgressMonitor());
                iCompilationUnit.getBuffer().setContents(string2);
                int n2 = this.fCompletionContextRequestor.getBeforeString().length();
                this.fCompletionRequestor.setOffsetReduction(n2);
                iCompilationUnit.codeComplete(n2 + n, (CompletionRequestor)this.fCompletionRequestor);
                ICompletionProposal[] iCompletionProposalArray = this.fCompletionRequestor.getResults();
                if (iCompletionProposalArray.length == 0) {
                    String string3 = this.fCompletionRequestor.getErrorMessage();
                    if (string3 == null || string3.trim().length() == 0) {
                        string3 = RefactoringMessages.JavaTypeCompletionProcessor_no_completion;
                    }
                    this.fErrorMessage = string3;
                } else {
                    this.fErrorMessage = this.fCompletionRequestor.getErrorMessage();
                }
                iCompletionProposalArray2 = iCompletionProposalArray;
                Object var8_10 = null;
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
                Object var8_11 = null;
                try {
                    if (iCompilationUnit == null) return null;
                    iCompilationUnit.discardWorkingCopy();
                    return null;
                }
                catch (JavaModelException javaModelException3) {
                    JavaPlugin.log(javaModelException3);
                }
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            try {}
            catch (JavaModelException javaModelException2) {
                JavaPlugin.log(javaModelException2);
                throw throwable;
            }
            if (iCompilationUnit == null) throw throwable;
            iCompilationUnit.discardWorkingCopy();
            throw throwable;
        }
        try {}
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
            return iCompletionProposalArray2;
        }
        if (iCompilationUnit == null) return iCompletionProposalArray2;
        iCompilationUnit.discardWorkingCopy();
        return iCompletionProposalArray2;
    }

    protected static abstract class CUPositionCompletionRequestor
    extends CompletionRequestor {
        public static final char[] TRIGGER_CHARACTERS = new char[]{'.'};
        private int fOffsetReduction;
        private IJavaProject fJavaProject;
        private List fProposals;
        private String fErrorMessage2;

        protected CUPositionCompletionRequestor() {
        }

        public IJavaProject getJavaProject() {
            return this.fJavaProject;
        }

        private void setJavaProject(IJavaProject iJavaProject) {
            this.fJavaProject = iJavaProject;
        }

        private void setOffsetReduction(int n) {
            this.fOffsetReduction = n;
            this.fProposals = new ArrayList();
        }

        public final void completionFailure(IProblem iProblem) {
            this.fErrorMessage2 = iProblem.getMessage();
        }

        public final JavaCompletionProposal[] getResults() {
            return this.fProposals.toArray(new JavaCompletionProposal[this.fProposals.size()]);
        }

        public final String getErrorMessage() {
            return this.fErrorMessage2;
        }

        protected final void addAdjustedCompletion(String string, String string2, int n, int n2, int n3, ImageDescriptor imageDescriptor) {
            JavaCompletionProposal javaCompletionProposal = new JavaCompletionProposal(string2, n - this.fOffsetReduction, n2 - n, CUPositionCompletionRequestor.getImage(imageDescriptor), string, n3);
            javaCompletionProposal.setTriggerCharacters(TRIGGER_CHARACTERS);
            this.fProposals.add(javaCompletionProposal);
        }

        protected final void addAdjustedTypeCompletion(String string, String string2, int n, int n2, int n3, ImageDescriptor imageDescriptor, String string3) {
            JavaTypeCompletionProposal javaTypeCompletionProposal = new JavaTypeCompletionProposal(string3 == null ? string2 : string3, null, string3 == null ? n - this.fOffsetReduction : 0, n2 - n, CUPositionCompletionRequestor.getImage(imageDescriptor), string, n3, string2);
            javaTypeCompletionProposal.setTriggerCharacters(TRIGGER_CHARACTERS);
            this.fProposals.add(javaTypeCompletionProposal);
        }

        private static Image getImage(ImageDescriptor imageDescriptor) {
            return imageDescriptor == null ? null : IMAGE_DESC_REGISTRY.get(imageDescriptor);
        }
    }
}

