/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.contentassist;

import java.util.Arrays;
import java.util.List;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.corext.util.TypeFilter;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.contentassist.CUPositionCompletionProcessor;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;

public class JavaTypeCompletionProcessor
extends CUPositionCompletionProcessor {
    public static final String DUMMY_CLASS_NAME = "$$__$$";
    public static final String DUMMY_CU_NAME = "$$__$$.js";

    public JavaTypeCompletionProcessor(boolean bl, boolean bl2) {
        this(bl, bl2, false);
    }

    public JavaTypeCompletionProcessor(boolean bl, boolean bl2, boolean bl3) {
        super(new TypeCompletionRequestor(bl, bl2, bl3));
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public void setPackageFragment(IPackageFragment iPackageFragment) {
        if (iPackageFragment == null) {
            this.setCompletionContext(null, null, null);
        } else {
            String string = "public class $$__$$ { ";
            String string2 = " }";
            this.setCompletionContext(iPackageFragment.getCompilationUnit(DUMMY_CU_NAME), string, string2);
        }
    }

    public void setExtendsCompletionContext(IJavaElement iJavaElement) {
        if (iJavaElement instanceof IPackageFragment) {
            IPackageFragment iPackageFragment = (IPackageFragment)iJavaElement;
            ICompilationUnit iCompilationUnit = iPackageFragment.getCompilationUnit(DUMMY_CU_NAME);
            this.setCompletionContext(iCompilationUnit, "public class $$__$$ extends ", " {}");
        } else if (iJavaElement instanceof IType) {
            IType iType = (IType)iJavaElement;
            String string = "public class " + iType.getElementName() + " extends ";
            String string2 = " {}";
            IJavaElement iJavaElement2 = iType.getParent();
            while (iJavaElement2 instanceof IType) {
                iType = (IType)iJavaElement2;
                string = String.valueOf(string) + "public class " + iType.getElementName() + " {";
                string2 = String.valueOf(string2) + "}";
                iJavaElement2 = iType.getParent();
            }
            ICompilationUnit iCompilationUnit = iType.getCompilationUnit();
            this.setCompletionContext(iCompilationUnit, string, string2);
        } else {
            this.setCompletionContext(null, null, null);
        }
    }

    protected static class TypeCompletionRequestor
    extends CUPositionCompletionProcessor.CUPositionCompletionRequestor {
        private static final String VOID = "void";
        private static final List BASE_TYPES = Arrays.asList("boolean", "byte", "char", "double", "float", "int", "long", "short");
        private boolean fEnableBaseTypes;
        private boolean fEnableVoid;
        private final boolean fFullyQualify;

        public TypeCompletionRequestor(boolean bl, boolean bl2, boolean bl3) {
            this.fFullyQualify = bl3;
            this.fEnableBaseTypes = bl;
            this.fEnableVoid = bl2;
            this.setIgnored(1, true);
            this.setIgnored(2, true);
            this.setIgnored(4, true);
            this.setIgnored(5, true);
            this.setIgnored(7, true);
            this.setIgnored(6, true);
            this.setIgnored(10, true);
            this.setIgnored(11, true);
            this.setIgnored(12, true);
        }

        public void accept(CompletionProposal completionProposal) {
            switch (completionProposal.getKind()) {
                case 8: {
                    char[] cArray = completionProposal.getDeclarationSignature();
                    if (TypeFilter.isFiltered(cArray)) {
                        return;
                    }
                    this.addAdjustedCompletion(new String(cArray), new String(completionProposal.getCompletion()), completionProposal.getReplaceStart(), completionProposal.getReplaceEnd(), completionProposal.getRelevance(), JavaPluginImages.DESC_OBJS_PACKAGE);
                    return;
                }
                case 9: {
                    char[] cArray = Signature.toCharArray((char[])completionProposal.getSignature());
                    if (TypeFilter.isFiltered(cArray)) {
                        return;
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(Signature.getSimpleName((char[])cArray));
                    if (stringBuffer.length() == 0) {
                        return;
                    }
                    char[] cArray2 = Signature.getQualifier((char[])cArray);
                    if (cArray2.length > 0) {
                        stringBuffer.append(" - ");
                        stringBuffer.append(cArray2);
                    }
                    String string = stringBuffer.toString();
                    this.addAdjustedTypeCompletion(string, new String(completionProposal.getCompletion()), completionProposal.getReplaceStart(), completionProposal.getReplaceEnd(), completionProposal.getRelevance(), JavaElementImageProvider.getTypeImageDescriptor(false, false, completionProposal.getFlags(), false), this.fFullyQualify ? new String(cArray) : null);
                    return;
                }
                case 3: {
                    if (!this.fEnableBaseTypes) {
                        return;
                    }
                    String string = new String(completionProposal.getName());
                    if (this.fEnableVoid && VOID.equals(string) || this.fEnableBaseTypes && BASE_TYPES.contains(string)) {
                        this.addAdjustedCompletion(string, new String(completionProposal.getCompletion()), completionProposal.getReplaceStart(), completionProposal.getReplaceEnd(), completionProposal.getRelevance(), null);
                    }
                    return;
                }
            }
        }
    }
}

