/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.nls;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSRefactoring;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.NLSUIMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.PackageBrowseAdapter;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.SourceFirstPackageSelectionDialogField;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.Separator;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.wst.jsdt.ui.JavaElementLabelProvider;

public class NLSAccessorConfigurationDialog
extends StatusDialog {
    private SourceFirstPackageSelectionDialogField fResourceBundlePackage;
    private StringButtonDialogField fResourceBundleFile;
    private SourceFirstPackageSelectionDialogField fAccessorPackage;
    private StringDialogField fAccessorClassName;
    private StringDialogField fSubstitutionPattern;
    private NLSRefactoring fRefactoring;
    private IStatus[] fStati;
    private static final int IDX_ACCESSOR_CLASS = 0;
    private static final int IDX_ACCESSOR_PACKAGE = 1;
    private static final int IDX_SUBST_PATTERN = 2;
    private static final int IDX_BUNDLE_NAME = 3;
    private static final int IDX_BUNDLE_PACKAGE = 4;

    public NLSAccessorConfigurationDialog(Shell shell, NLSRefactoring nLSRefactoring) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fRefactoring = nLSRefactoring;
        this.fStati = new IStatus[]{StatusInfo.OK_STATUS, StatusInfo.OK_STATUS, StatusInfo.OK_STATUS, StatusInfo.OK_STATUS, StatusInfo.OK_STATUS};
        this.setTitle(NLSUIMessages.NLSAccessorConfigurationDialog_title);
        AccessorAdapter accessorAdapter = new AccessorAdapter();
        ICompilationUnit iCompilationUnit = nLSRefactoring.getCu();
        this.fAccessorPackage = new SourceFirstPackageSelectionDialogField(NLSUIMessages.NLSAccessorConfigurationDialog_accessor_path, NLSUIMessages.NLSAccessorConfigurationDialog_accessor_package, NLSUIMessages.NLSAccessorConfigurationDialog_browse1, NLSUIMessages.NLSAccessorConfigurationDialog_browse2, NLSUIMessages.NLSAccessorConfigurationDialog_default_package, NLSUIMessages.NLSAccessorConfigurationDialog_accessor_dialog_title, NLSUIMessages.NLSAccessorConfigurationDialog_accessor_dialog_message, NLSUIMessages.NLSAccessorConfigurationDialog_accessor_dialog_emtpyMessage, iCompilationUnit, accessorAdapter, nLSRefactoring.getAccessorClassPackage());
        this.fAccessorClassName = this.createStringButtonField(NLSUIMessages.NLSAccessorConfigurationDialog_className, NLSUIMessages.NLSAccessorConfigurationDialog_browse6, accessorAdapter);
        this.fSubstitutionPattern = this.createStringField(NLSUIMessages.NLSAccessorConfigurationDialog_substitutionPattern, accessorAdapter);
        this.fResourceBundlePackage = new SourceFirstPackageSelectionDialogField(NLSUIMessages.NLSAccessorConfigurationDialog_property_path, NLSUIMessages.NLSAccessorConfigurationDialog_property_package, NLSUIMessages.NLSAccessorConfigurationDialog_browse3, NLSUIMessages.NLSAccessorConfigurationDialog_browse4, NLSUIMessages.NLSAccessorConfigurationDialog_default_package, NLSUIMessages.NLSAccessorConfigurationDialog_property_dialog_title, NLSUIMessages.NLSAccessorConfigurationDialog_property_dialog_message, NLSUIMessages.NLSAccessorConfigurationDialog_property_dialog_emptyMessage, iCompilationUnit, accessorAdapter, this.fRefactoring.getResourceBundlePackage());
        this.fResourceBundleFile = this.createStringButtonField(NLSUIMessages.NLSAccessorConfigurationDialog_property_file_name, NLSUIMessages.NLSAccessorConfigurationDialog_browse5, accessorAdapter);
        this.initFields();
    }

    private void initFields() {
        this.initAccessorClassFields();
        String string = this.fRefactoring.getResourceBundleName();
        this.fResourceBundleFile.setText(string != null ? string : "messages.properties");
    }

    private void initAccessorClassFields() {
        String string = this.fRefactoring.getAccessorClassName();
        if (string == null) {
            string = "Messages";
        }
        this.fAccessorClassName.setText(string);
        this.fSubstitutionPattern.setText(this.fRefactoring.getSubstitutionPattern());
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.initializeDialogUnits((Control)composite);
        GridLayout gridLayout = (GridLayout)composite2.getLayout();
        gridLayout.numColumns = 4;
        composite2.setLayout((Layout)gridLayout);
        this.createAccessorPart(composite2, 4, this.convertWidthInCharsToPixels(40));
        Separator separator = new Separator(258);
        separator.doFillIntoGrid(composite2, 4);
        this.createPropertyPart(composite2, 4, this.convertWidthInCharsToPixels(40));
        Dialog.applyDialogFont((Control)composite2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.wst.jsdt.ui.externalize_wizard_properties_file_page_context");
        this.validateAll();
        return composite2;
    }

    private void createAccessorPart(Composite composite, int n, int n2) {
        this.createLabel(composite, NLSUIMessages.NLSAccessorConfigurationDialog_resourceBundle_title, n);
        this.fAccessorPackage.createControl(composite, n, n2);
        this.fAccessorClassName.doFillIntoGrid(composite, n);
        Text text = this.fAccessorClassName.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, this.convertWidthInCharsToPixels(60));
        TextFieldNavigationHandler.install(text);
        this.fSubstitutionPattern.doFillIntoGrid(composite, n);
        Text text2 = this.fSubstitutionPattern.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text2, this.convertWidthInCharsToPixels(60));
        TextFieldNavigationHandler.install(text2);
        this.fSubstitutionPattern.setEnabled(!this.fRefactoring.isEclipseNLS());
    }

    private void createPropertyPart(Composite composite, int n, int n2) {
        this.createLabel(composite, NLSUIMessages.NLSAccessorConfigurationDialog_property_location, n);
        this.fResourceBundlePackage.createControl(composite, n, n2);
        this.fResourceBundleFile.doFillIntoGrid(composite, n);
        LayoutUtil.setWidthHint((Control)this.fResourceBundleFile.getTextControl(null), this.convertWidthInCharsToPixels(60));
    }

    private void createLabel(Composite composite, String string, int n) {
        Separator separator = new Separator(0);
        ((Label)separator.getSeparator(composite)).setText(string);
        GC gC = new GC((Drawable)composite);
        int n2 = gC.stringExtent((String)string).y;
        gC.dispose();
        separator.doFillIntoGrid(composite, n, n2);
    }

    private void browseForPropertyFile() {
        IFile iFile;
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider());
        elementListSelectionDialog.setIgnoreCase(false);
        elementListSelectionDialog.setTitle(NLSUIMessages.NLSAccessorConfigurationDialog_Property_File_Selection);
        elementListSelectionDialog.setMessage(NLSUIMessages.NLSAccessorConfigurationDialog_Choose_the_property_file);
        elementListSelectionDialog.setElements(this.createFileListInput());
        elementListSelectionDialog.setFilter("*.properties");
        if (elementListSelectionDialog.open() == 0 && (iFile = (IFile)elementListSelectionDialog.getFirstResult()) != null) {
            this.fResourceBundleFile.setText(iFile.getName());
        }
    }

    protected void browseForAccessorClass() {
        IType iType;
        IProgressService iProgressService = PlatformUI.getWorkbench().getProgressService();
        IPackageFragmentRoot iPackageFragmentRoot = this.fAccessorPackage.getSelectedFragmentRoot();
        IJavaSearchScope iJavaSearchScope = iPackageFragmentRoot != null ? SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{iPackageFragmentRoot}) : SearchEngine.createWorkspaceScope();
        FilteredTypesSelectionDialog filteredTypesSelectionDialog = new FilteredTypesSelectionDialog(this.getShell(), false, (IRunnableContext)iProgressService, iJavaSearchScope, 5);
        filteredTypesSelectionDialog.setTitle(NLSUIMessages.NLSAccessorConfigurationDialog_Accessor_Selection);
        filteredTypesSelectionDialog.setMessage(NLSUIMessages.NLSAccessorConfigurationDialog_Choose_the_accessor_file);
        filteredTypesSelectionDialog.setInitialPattern("*Messages");
        if (filteredTypesSelectionDialog.open() == 0 && (iType = (IType)filteredTypesSelectionDialog.getFirstResult()) != null) {
            this.fAccessorClassName.setText(iType.getElementName());
            this.fAccessorPackage.setSelected(iType.getPackageFragment());
        }
    }

    private Object[] createFileListInput() {
        try {
            IPackageFragment iPackageFragment = this.fResourceBundlePackage.getSelected();
            if (iPackageFragment == null) {
                return new Object[0];
            }
            ArrayList<Object> arrayList = new ArrayList<Object>(1);
            Object[] objectArray = iPackageFragment.getNonJavaResources();
            int n = 0;
            while (n < objectArray.length) {
                if (NLSAccessorConfigurationDialog.isPropertyFile(objectArray[n])) {
                    arrayList.add(objectArray[n]);
                }
                ++n;
            }
            return arrayList.toArray();
        }
        catch (JavaModelException javaModelException) {
            ExceptionHandler.handle((CoreException)((Object)javaModelException), NLSUIMessages.NLSAccessorConfigurationDialog_externalizing, NLSUIMessages.NLSAccessorConfigurationDialog_exception);
            return new Object[0];
        }
    }

    private static boolean isPropertyFile(Object object) {
        if (!(object instanceof IFile)) {
            return false;
        }
        IFile iFile = (IFile)object;
        return ".properties".equals(String.valueOf('.') + iFile.getFileExtension());
    }

    private void validateAll() {
        this.validateSubstitutionPattern();
        this.validateAccessorClassName();
        this.checkPackageFragment();
        this.validatePropertyFilename();
        this.validatePropertyPackage();
        this.updateStatus(StatusUtil.getMostSevere(this.fStati));
    }

    private void validateAccessorClassName() {
        String string = this.fAccessorClassName.getText();
        IStatus iStatus = JavaConventions.validateJavaTypeName((String)string);
        if (iStatus.getSeverity() == 4) {
            this.setInvalid(0, iStatus.getMessage());
            return;
        }
        if (string.indexOf(46) != -1) {
            this.setInvalid(0, NLSUIMessages.NLSAccessorConfigurationDialog_no_dot);
            return;
        }
        this.setValid(0);
    }

    private void validatePropertyFilename() {
        String string = this.fResourceBundleFile.getText();
        if (string == null || string.length() == 0) {
            this.setInvalid(3, NLSUIMessages.NLSAccessorConfigurationDialog_enter_name);
            return;
        }
        if (!string.endsWith(".properties")) {
            this.setInvalid(3, Messages.format(NLSUIMessages.NLSAccessorConfigurationDialog_file_name_must_end, ".properties"));
            return;
        }
        this.setValid(3);
    }

    private void validatePropertyPackage() {
        IPackageFragmentRoot iPackageFragmentRoot = this.fResourceBundlePackage.getSelectedFragmentRoot();
        if (iPackageFragmentRoot == null || !iPackageFragmentRoot.exists()) {
            this.setInvalid(4, NLSUIMessages.NLSAccessorConfigurationDialog_property_package_root_invalid);
            return;
        }
        IPackageFragment iPackageFragment = this.fResourceBundlePackage.getSelected();
        if (iPackageFragment == null || !iPackageFragment.exists()) {
            this.setInvalid(4, NLSUIMessages.NLSAccessorConfigurationDialog_property_package_invalid);
            return;
        }
        String string = iPackageFragment.getElementName();
        IStatus iStatus = JavaConventions.validatePackageName((String)string);
        if (string.length() > 0 && iStatus.getSeverity() == 4) {
            this.setInvalid(4, iStatus.getMessage());
            return;
        }
        IPath iPath = new Path(string.replace('.', '/')).makeRelative();
        IJavaProject iJavaProject = this.fRefactoring.getCu().getJavaProject();
        try {
            IJavaElement iJavaElement = iJavaProject.findElement(iPath);
            if (iJavaElement == null || !iJavaElement.exists()) {
                this.setInvalid(4, NLSUIMessages.NLSAccessorConfigurationDialog_must_exist);
                return;
            }
            IPackageFragment iPackageFragment2 = (IPackageFragment)iJavaElement;
            if (!PackageBrowseAdapter.canAddPackage(iPackageFragment2)) {
                this.setInvalid(4, NLSUIMessages.NLSAccessorConfigurationDialog_incorrect_package);
                return;
            }
            if (!PackageBrowseAdapter.canAddPackageRoot((IPackageFragmentRoot)iPackageFragment2.getParent())) {
                this.setInvalid(4, NLSUIMessages.NLSAccessorConfigurationDialog_incorrect_package);
                return;
            }
        }
        catch (JavaModelException javaModelException) {
            this.setInvalid(4, javaModelException.getStatus().getMessage());
            return;
        }
        this.setValid(4);
    }

    private void checkPackageFragment() {
        IPackageFragmentRoot iPackageFragmentRoot = this.fAccessorPackage.getSelectedFragmentRoot();
        if (iPackageFragmentRoot == null || !iPackageFragmentRoot.exists()) {
            this.setInvalid(1, NLSUIMessages.NLSAccessorConfigurationDialog_accessor_package_root_invalid);
            return;
        }
        IPackageFragment iPackageFragment = this.fAccessorPackage.getSelected();
        if (iPackageFragment == null || !iPackageFragment.exists()) {
            this.setInvalid(1, NLSUIMessages.NLSAccessorConfigurationDialog_accessor_package_invalid);
            return;
        }
        this.setValid(1);
    }

    private void validateSubstitutionPattern() {
        if (this.fSubstitutionPattern.getText() == null || this.fSubstitutionPattern.getText().length() == 0) {
            this.setInvalid(2, NLSUIMessages.NLSAccessorConfigurationDialog_substitution_pattern_missing);
        } else {
            this.setValid(2);
        }
    }

    private void setInvalid(int n, String string) {
        this.fStati[n] = new StatusInfo(4, string);
    }

    private void setValid(int n) {
        this.fStati[n] = StatusInfo.OK_STATUS;
    }

    protected void okPressed() {
        this.updateRefactoring();
        super.okPressed();
    }

    void updateRefactoring() {
        this.fRefactoring.setAccessorClassPackage(this.fAccessorPackage.getSelected());
        this.fRefactoring.setAccessorClassName(this.fAccessorClassName.getText());
        this.fRefactoring.setResourceBundleName(this.fResourceBundleFile.getText());
        this.fRefactoring.setResourceBundlePackage(this.fResourceBundlePackage.getSelected());
        if (!this.fRefactoring.isEclipseNLS()) {
            this.fRefactoring.setSubstitutionPattern(this.fSubstitutionPattern.getText());
        }
        this.fRefactoring.setIsEclipseNLS(this.fRefactoring.detectIsEclipseNLS());
    }

    private StringDialogField createStringField(String string, AccessorAdapter accessorAdapter) {
        StringDialogField stringDialogField = new StringDialogField();
        stringDialogField.setDialogFieldListener(accessorAdapter);
        stringDialogField.setLabelText(string);
        return stringDialogField;
    }

    private StringButtonDialogField createStringButtonField(String string, String string2, AccessorAdapter accessorAdapter) {
        StringButtonDialogField stringButtonDialogField = new StringButtonDialogField(accessorAdapter);
        stringButtonDialogField.setDialogFieldListener(accessorAdapter);
        stringButtonDialogField.setLabelText(string);
        stringButtonDialogField.setButtonLabel(string2);
        return stringButtonDialogField;
    }

    private class AccessorAdapter
    implements IDialogFieldListener,
    IStringButtonAdapter {
        private AccessorAdapter() {
        }

        public void dialogFieldChanged(DialogField dialogField) {
            NLSAccessorConfigurationDialog.this.validateAll();
        }

        public void changeControlPressed(DialogField dialogField) {
            if (dialogField == NLSAccessorConfigurationDialog.this.fResourceBundleFile) {
                NLSAccessorConfigurationDialog.this.browseForPropertyFile();
            } else if (dialogField == NLSAccessorConfigurationDialog.this.fAccessorClassName) {
                NLSAccessorConfigurationDialog.this.browseForAccessorClass();
            }
        }
    }
}

