/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.nls;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.NLSUIMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.PackageSelectionDialogButtonField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.wst.jsdt.ui.JavaElementLabelProvider;

public class PackageBrowseAdapter
implements IStringButtonAdapter {
    PackageSelectionDialogButtonField fReceiver;
    private ICompilationUnit fCu;

    public PackageBrowseAdapter(ICompilationUnit iCompilationUnit) {
        this.fCu = iCompilationUnit;
    }

    public void setReceiver(PackageSelectionDialogButtonField packageSelectionDialogButtonField) {
        this.fReceiver = packageSelectionDialogButtonField;
    }

    public void changeControlPressed(DialogField dialogField) {
        IPackageFragment iPackageFragment;
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)new JavaElementLabelProvider());
        elementListSelectionDialog.setIgnoreCase(false);
        elementListSelectionDialog.setTitle(NLSUIMessages.PackageBrowseAdapter_package_selection);
        elementListSelectionDialog.setMessage(NLSUIMessages.PackageBrowseAdapter_choose_package);
        elementListSelectionDialog.setElements(PackageBrowseAdapter.createPackageListInput(this.fCu, null));
        if (elementListSelectionDialog.open() == 0 && (iPackageFragment = (IPackageFragment)elementListSelectionDialog.getFirstResult()) != null) {
            this.fReceiver.setPackage(iPackageFragment);
        }
    }

    public static Object[] createPackageListInput(ICompilationUnit iCompilationUnit, String string) {
        try {
            IJavaProject iJavaProject = iCompilationUnit.getJavaProject();
            IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.getPackageFragmentRoots();
            ArrayList arrayList = new ArrayList();
            HashMap hashMap = new HashMap();
            int n = 0;
            while (n < iPackageFragmentRootArray.length) {
                if (PackageBrowseAdapter.canAddPackageRoot(iPackageFragmentRootArray[n])) {
                    PackageBrowseAdapter.getValidPackages(iPackageFragmentRootArray[n], arrayList, hashMap, string);
                }
                ++n;
            }
            return arrayList.toArray();
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
            return new Object[0];
        }
    }

    static boolean canAddPackageRoot(IPackageFragmentRoot iPackageFragmentRoot) throws JavaModelException {
        if (!iPackageFragmentRoot.exists()) {
            return false;
        }
        if (iPackageFragmentRoot.isArchive()) {
            return false;
        }
        if (iPackageFragmentRoot.isExternal()) {
            return false;
        }
        if (iPackageFragmentRoot.isReadOnly()) {
            return false;
        }
        return iPackageFragmentRoot.isStructureKnown();
    }

    static void getValidPackages(IPackageFragmentRoot iPackageFragmentRoot, List list, HashMap hashMap, String string) throws JavaModelException {
        IJavaElement[] iJavaElementArray = null;
        try {
            iJavaElementArray = iPackageFragmentRoot.getChildren();
        }
        catch (JavaModelException javaModelException) {
            return;
        }
        int n = 0;
        while (n < iJavaElementArray.length) {
            if (iJavaElementArray[n] instanceof IPackageFragment) {
                IPackageFragment iPackageFragment = (IPackageFragment)iJavaElementArray[n];
                String string2 = iPackageFragment.getElementName();
                if (!(hashMap != null && hashMap.containsKey(string2) || !PackageBrowseAdapter.canAddPackage(iPackageFragment) || string != null && !string.equals(string2))) {
                    list.add(iPackageFragment);
                    if (hashMap != null) {
                        hashMap.put(string2, null);
                    }
                }
            }
            ++n;
        }
    }

    static boolean canAddPackage(IPackageFragment iPackageFragment) throws JavaModelException {
        if (!iPackageFragment.exists()) {
            return false;
        }
        if (iPackageFragment.isReadOnly()) {
            return false;
        }
        return iPackageFragment.isStructureKnown();
    }

    public static List searchAllPackages(IJavaProject iJavaProject, String string) {
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.getPackageFragmentRoots();
            ArrayList arrayList = new ArrayList();
            int n = 0;
            while (n < iPackageFragmentRootArray.length) {
                if (PackageBrowseAdapter.canAddPackageRoot(iPackageFragmentRootArray[n])) {
                    PackageBrowseAdapter.getValidPackages(iPackageFragmentRootArray[n], arrayList, null, string);
                }
                ++n;
            }
            return arrayList;
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
            return new ArrayList(0);
        }
    }
}

