/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.search.ui.text.Match;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTMatcher;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.CastExpression;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.ui.search.ExceptionOccurrencesGroupKey;
import org.eclipse.wst.jsdt.internal.ui.search.IOccurrencesFinder;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;

public class ExceptionOccurrencesFinder
extends ASTVisitor
implements IOccurrencesFinder {
    public static final String IS_EXCEPTION = "isException";
    private AST fAST;
    private Name fSelectedName;
    private ITypeBinding fException;
    private ASTNode fStart;
    private List fResult = new ArrayList();

    public String initialize(CompilationUnit compilationUnit, int n, int n2) {
        return this.initialize(compilationUnit, NodeFinder.perform((ASTNode)compilationUnit, n, n2));
    }

    public String initialize(CompilationUnit compilationUnit, ASTNode aSTNode) {
        IVariableBinding iVariableBinding;
        CatchClause catchClause;
        TryStatement tryStatement;
        this.fAST = compilationUnit.getAST();
        if (!(aSTNode instanceof Name)) {
            return SearchMessages.ExceptionOccurrencesFinder_no_exception;
        }
        this.fSelectedName = ASTNodes.getTopMostName((Name)aSTNode);
        ASTNode aSTNode2 = this.fSelectedName.getParent();
        MethodDeclaration methodDeclaration = this.resolveMethodDeclaration(aSTNode2);
        if (methodDeclaration != null && this.methodThrowsException(methodDeclaration, this.fSelectedName)) {
            this.fException = this.fSelectedName.resolveTypeBinding();
            this.fStart = methodDeclaration.getBody();
        } else if (aSTNode2 instanceof Type && (aSTNode2 = aSTNode2.getParent()) instanceof SingleVariableDeclaration && aSTNode2.getParent() instanceof CatchClause && (tryStatement = (TryStatement)(catchClause = (CatchClause)aSTNode2.getParent()).getParent()) != null && (iVariableBinding = catchClause.getException().resolveBinding()) != null && iVariableBinding.getType() != null) {
            this.fException = iVariableBinding.getType();
            this.fStart = tryStatement.getBody();
        }
        if (this.fException == null || this.fStart == null) {
            return SearchMessages.ExceptionOccurrencesFinder_no_exception;
        }
        return null;
    }

    private MethodDeclaration resolveMethodDeclaration(ASTNode aSTNode) {
        if (aSTNode instanceof MethodDeclaration) {
            return (MethodDeclaration)aSTNode;
        }
        Javadoc javadoc = (Javadoc)ASTNodes.getParent(aSTNode, 29);
        if (javadoc == null) {
            return null;
        }
        if (javadoc.getParent() instanceof MethodDeclaration) {
            return (MethodDeclaration)javadoc.getParent();
        }
        return null;
    }

    private boolean methodThrowsException(MethodDeclaration methodDeclaration, Name name) {
        ASTMatcher aSTMatcher = new ASTMatcher();
        Iterator iterator = methodDeclaration.thrownExceptions().iterator();
        while (iterator.hasNext()) {
            Name name2 = (Name)iterator.next();
            if (!name.subtreeMatch(aSTMatcher, (Object)name2)) continue;
            return true;
        }
        return false;
    }

    public List perform() {
        this.fStart.accept((ASTVisitor)this);
        if (this.fSelectedName != null) {
            this.fResult.add(this.fSelectedName);
        }
        return this.fResult;
    }

    public void collectOccurrenceMatches(IJavaElement iJavaElement, IDocument iDocument, Collection collection) {
        HashMap<Integer, ExceptionOccurrencesGroupKey> hashMap = new HashMap<Integer, ExceptionOccurrencesGroupKey>();
        Iterator iterator = this.fResult.iterator();
        while (iterator.hasNext()) {
            ASTNode aSTNode = (ASTNode)iterator.next();
            int n = aSTNode.getStartPosition();
            int n2 = aSTNode.getLength();
            try {
                IRegion iRegion;
                boolean bl = aSTNode == this.fSelectedName;
                int n3 = iDocument.getLineOfOffset(n);
                Integer n4 = new Integer(n3);
                ExceptionOccurrencesGroupKey exceptionOccurrencesGroupKey = (ExceptionOccurrencesGroupKey)hashMap.get(n4);
                if (exceptionOccurrencesGroupKey == null) {
                    iRegion = iDocument.getLineInformation(n3);
                    String string = iDocument.get(iRegion.getOffset(), iRegion.getLength()).trim();
                    exceptionOccurrencesGroupKey = new ExceptionOccurrencesGroupKey(iJavaElement, n3, string, bl);
                    hashMap.put(n4, exceptionOccurrencesGroupKey);
                } else if (bl) {
                    exceptionOccurrencesGroupKey.setException(true);
                }
                iRegion = new Match((Object)exceptionOccurrencesGroupKey, n, n2);
                collection.add(iRegion);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public String getJobLabel() {
        return SearchMessages.ExceptionOccurrencesFinder_searchfor;
    }

    public String getElementName() {
        if (this.fSelectedName != null) {
            return ASTNodes.asString((ASTNode)this.fSelectedName);
        }
        return null;
    }

    public String getUnformattedPluralLabel() {
        return SearchMessages.ExceptionOccurrencesFinder_label_plural;
    }

    public String getUnformattedSingularLabel() {
        return SearchMessages.ExceptionOccurrencesFinder_label_singular;
    }

    public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
        return false;
    }

    public boolean visit(CastExpression castExpression) {
        if ("java.lang.ClassCastException".equals(this.fException.getQualifiedName())) {
            this.fResult.add(castExpression.getType());
        }
        return super.visit(castExpression);
    }

    public boolean visit(ClassInstanceCreation classInstanceCreation) {
        if (this.matches(classInstanceCreation.resolveConstructorBinding())) {
            this.fResult.add(classInstanceCreation.getType());
        }
        return super.visit(classInstanceCreation);
    }

    public boolean visit(ConstructorInvocation constructorInvocation) {
        if (this.matches(constructorInvocation.resolveConstructorBinding())) {
            SimpleName simpleName = this.fAST.newSimpleName("xxxx");
            simpleName.setSourceRange(constructorInvocation.getStartPosition(), 4);
            this.fResult.add(simpleName);
        }
        return super.visit(constructorInvocation);
    }

    public boolean visit(MethodInvocation methodInvocation) {
        if (this.matches(methodInvocation.resolveMethodBinding())) {
            this.fResult.add(methodInvocation.getName());
        }
        return super.visit(methodInvocation);
    }

    public boolean visit(SuperConstructorInvocation superConstructorInvocation) {
        if (this.matches(superConstructorInvocation.resolveConstructorBinding())) {
            SimpleName simpleName = this.fAST.newSimpleName("xxxxx");
            simpleName.setSourceRange(superConstructorInvocation.getStartPosition(), 5);
            this.fResult.add(simpleName);
        }
        return super.visit(superConstructorInvocation);
    }

    public boolean visit(SuperMethodInvocation superMethodInvocation) {
        if (this.matches(superMethodInvocation.resolveMethodBinding())) {
            this.fResult.add(superMethodInvocation.getName());
        }
        return super.visit(superMethodInvocation);
    }

    public boolean visit(ThrowStatement throwStatement) {
        if (this.matches(throwStatement.getExpression().resolveTypeBinding())) {
            SimpleName simpleName = this.fAST.newSimpleName("xxxxx");
            simpleName.setSourceRange(throwStatement.getStartPosition(), 5);
            this.fResult.add(simpleName);
        }
        return super.visit(throwStatement);
    }

    public boolean visit(TypeDeclarationStatement typeDeclarationStatement) {
        return false;
    }

    private boolean matches(IMethodBinding iMethodBinding) {
        if (iMethodBinding == null) {
            return false;
        }
        ITypeBinding[] iTypeBindingArray = iMethodBinding.getExceptionTypes();
        int n = 0;
        while (n < iTypeBindingArray.length) {
            ITypeBinding iTypeBinding = iTypeBindingArray[n];
            if (this.matches(iTypeBinding)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean matches(ITypeBinding var1_1) {
        if (var1_1 != null) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (Bindings.equals((IBinding)this.fException, (IBinding)var1_1)) {
                return true;
            }
            var1_1 = var1_1.getSuperclass();
lbl6:
            // 2 sources

            ** while (var1_1 != null)
        }
lbl7:
        // 1 sources

        return false;
    }
}

