/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.search.ui.text.Match;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.ui.search.IOccurrencesFinder;
import org.eclipse.wst.jsdt.internal.ui.search.JavaElementLine;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;

public class ImplementOccurrencesFinder
implements IOccurrencesFinder {
    private ASTNode fStart;
    private List fResult = new ArrayList();
    private ASTNode fSelectedNode;
    private ITypeBinding fSelectedType;

    public String initialize(CompilationUnit compilationUnit, int n, int n2) {
        return this.initialize(compilationUnit, NodeFinder.perform((ASTNode)compilationUnit, n, n2));
    }

    public String initialize(CompilationUnit compilationUnit, ASTNode aSTNode) {
        if (!(aSTNode instanceof Name)) {
            return SearchMessages.ImplementOccurrencesFinder_invalidTarget;
        }
        this.fSelectedNode = ASTNodes.getNormalizedNode(aSTNode);
        if (!(this.fSelectedNode instanceof Type)) {
            return SearchMessages.ImplementOccurrencesFinder_invalidTarget;
        }
        ASTNode aSTNode2 = this.fSelectedNode.getParent();
        if (!(aSTNode2 instanceof AbstractTypeDeclaration)) {
            return SearchMessages.ImplementOccurrencesFinder_invalidTarget;
        }
        this.fSelectedType = ((Type)this.fSelectedNode).resolveBinding();
        if (this.fSelectedType == null) {
            return SearchMessages.ImplementOccurrencesFinder_invalidTarget;
        }
        this.fStart = aSTNode2;
        return null;
    }

    public List perform() {
        this.fStart.accept((ASTVisitor)new MethodVisitor());
        if (this.fSelectedNode != null) {
            this.fResult.add(this.fSelectedNode);
        }
        return this.fResult;
    }

    public void collectOccurrenceMatches(IJavaElement iJavaElement, IDocument iDocument, Collection collection) {
        Iterator iterator = this.fResult.iterator();
        while (iterator.hasNext()) {
            ASTNode aSTNode = (ASTNode)iterator.next();
            int n = aSTNode.getStartPosition();
            int n2 = aSTNode.getLength();
            try {
                int n3 = iDocument.getLineOfOffset(n);
                IRegion iRegion = iDocument.getLineInformation(n3);
                String string = iDocument.get(iRegion.getOffset(), iRegion.getLength()).trim();
                JavaElementLine javaElementLine = new JavaElementLine(iJavaElement, n3, string);
                collection.add(new Match((Object)javaElementLine, n, n2));
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public String getJobLabel() {
        return SearchMessages.ImplementOccurrencesFinder_searchfor;
    }

    public String getElementName() {
        if (this.fSelectedNode != null) {
            return ASTNodes.asString(this.fSelectedNode);
        }
        return null;
    }

    public String getUnformattedPluralLabel() {
        return SearchMessages.ImplementOccurrencesFinder_label_plural;
    }

    public String getUnformattedSingularLabel() {
        return SearchMessages.ImplementOccurrencesFinder_label_singular;
    }

    public void releaseAST() {
        this.fStart = null;
        this.fSelectedType = null;
    }

    private class MethodVisitor
    extends ASTVisitor {
        private MethodVisitor() {
        }

        public boolean visit(MethodDeclaration methodDeclaration) {
            IMethodBinding iMethodBinding;
            IMethodBinding iMethodBinding2 = methodDeclaration.resolveBinding();
            if (iMethodBinding2 != null && (iMethodBinding = Bindings.findOverriddenMethodInHierarchy(ImplementOccurrencesFinder.this.fSelectedType, iMethodBinding2)) != null) {
                ImplementOccurrencesFinder.this.fResult.add(methodDeclaration.getName());
            }
            return super.visit(methodDeclaration);
        }

        public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
            return false;
        }

        public boolean visit(TypeDeclarationStatement typeDeclarationStatement) {
            return false;
        }
    }
}

