/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.internal.ui.search.WorkingSetsComparator;

public class LRUWorkingSetsList {
    private final ArrayList fLRUList;
    private final int fSize;
    private final WorkingSetsComparator fComparator = new WorkingSetsComparator();

    public LRUWorkingSetsList(int n) {
        this.fSize = n;
        this.fLRUList = new ArrayList(n);
    }

    public void add(IWorkingSet[] iWorkingSetArray) {
        this.removeDeletedWorkingSets();
        IWorkingSet[] iWorkingSetArray2 = this.find(this.fLRUList, iWorkingSetArray);
        if (iWorkingSetArray2 != null) {
            this.fLRUList.remove(iWorkingSetArray2);
        } else if (this.fLRUList.size() == this.fSize) {
            this.fLRUList.remove(this.fSize - 1);
        }
        this.fLRUList.add(0, iWorkingSetArray);
    }

    public Iterator iterator() {
        this.removeDeletedWorkingSets();
        return this.fLRUList.iterator();
    }

    public Iterator sortedIterator() {
        this.removeDeletedWorkingSets();
        ArrayList arrayList = new ArrayList(this.fLRUList);
        Collections.sort(arrayList, this.fComparator);
        return arrayList.iterator();
    }

    private void removeDeletedWorkingSets() {
        Iterator iterator = new ArrayList(this.fLRUList).iterator();
        block0: while (iterator.hasNext()) {
            IWorkingSet[] iWorkingSetArray = (IWorkingSet[])iterator.next();
            int n = 0;
            while (n < iWorkingSetArray.length) {
                if (PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(iWorkingSetArray[n].getName()) == null) {
                    this.fLRUList.remove(iWorkingSetArray);
                    continue block0;
                }
                ++n;
            }
        }
    }

    private IWorkingSet[] find(ArrayList arrayList, IWorkingSet[] iWorkingSetArray) {
        HashSet<IWorkingSet> hashSet = new HashSet<IWorkingSet>(Arrays.asList(iWorkingSetArray));
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            IWorkingSet[] iWorkingSetArray2 = (IWorkingSet[])iterator.next();
            HashSet<IWorkingSet> hashSet2 = new HashSet<IWorkingSet>(Arrays.asList(iWorkingSetArray2));
            if (!hashSet2.equals(hashSet)) continue;
            return iWorkingSetArray2;
        }
        return null;
    }
}

