/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.LocalVariableIndex;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.InOutFlowAnalyzer;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;

public class MethodExitsFinder
extends ASTVisitor {
    private AST fAST;
    private MethodDeclaration fMethodDeclaration;
    private List fResult;
    private List fCatchedExceptions;

    public String initialize(CompilationUnit compilationUnit, int n, int n2) {
        return this.initialize(compilationUnit, NodeFinder.perform((ASTNode)compilationUnit, n, n2));
    }

    public String initialize(CompilationUnit compilationUnit, ASTNode aSTNode) {
        Name name;
        this.fAST = compilationUnit.getAST();
        if (aSTNode instanceof ReturnStatement) {
            this.fMethodDeclaration = (MethodDeclaration)ASTNodes.getParent(aSTNode, 31);
            if (this.fMethodDeclaration == null) {
                return SearchMessages.MethodExitsFinder_no_return_type_selected;
            }
            return null;
        }
        Type type = null;
        if (aSTNode instanceof Type) {
            type = (Type)aSTNode;
        } else if (aSTNode instanceof Name && (name = ASTNodes.getTopMostName((Name)aSTNode)).getParent() instanceof Type) {
            type = (Type)name.getParent();
        }
        if (type == null) {
            return SearchMessages.MethodExitsFinder_no_return_type_selected;
        }
        if (!((type = ASTNodes.getTopMostType(type)).getParent() instanceof MethodDeclaration)) {
            return SearchMessages.MethodExitsFinder_no_return_type_selected;
        }
        this.fMethodDeclaration = (MethodDeclaration)type.getParent();
        return null;
    }

    public List perform() {
        Type type;
        this.fResult = new ArrayList();
        this.markReferences();
        if (this.fResult.size() > 0 && (type = this.fMethodDeclaration.getReturnType2()) != null) {
            this.fResult.add(this.fMethodDeclaration.getReturnType2());
        }
        return this.fResult;
    }

    private void markReferences() {
        ITypeBinding iTypeBinding;
        this.fCatchedExceptions = new ArrayList();
        boolean bl = true;
        Type type = this.fMethodDeclaration.getReturnType2();
        if (type != null) {
            iTypeBinding = type.resolveBinding();
            bl = iTypeBinding != null && Bindings.isVoidType(iTypeBinding);
        }
        this.fMethodDeclaration.accept((ASTVisitor)this);
        iTypeBinding = this.fMethodDeclaration.getBody();
        if (iTypeBinding != null) {
            SimpleName simpleName;
            List list = iTypeBinding.statements();
            if (list.size() > 0) {
                simpleName = (Statement)list.get(list.size() - 1);
                int n = LocalVariableIndex.perform((BodyDeclaration)this.fMethodDeclaration);
                FlowContext flowContext = new FlowContext(0, n + 1);
                flowContext.setConsiderAccessMode(false);
                flowContext.setComputeMode(FlowContext.ARGUMENTS);
                InOutFlowAnalyzer inOutFlowAnalyzer = new InOutFlowAnalyzer(flowContext);
                FlowInfo flowInfo = inOutFlowAnalyzer.perform(new ASTNode[]{simpleName});
                if (!(flowInfo.isNoReturn() || bl || flowInfo.isPartialReturn())) {
                    return;
                }
            }
            simpleName = this.fAST.newSimpleName("x");
            simpleName.setSourceRange(this.fMethodDeclaration.getStartPosition() + this.fMethodDeclaration.getLength() - 1, 1);
            this.fResult.add(simpleName);
        }
    }

    public boolean visit(TypeDeclaration typeDeclaration) {
        return false;
    }

    public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
        return false;
    }

    public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
        return false;
    }

    public boolean visit(EnumDeclaration enumDeclaration) {
        return false;
    }

    public boolean visit(ReturnStatement returnStatement) {
        this.fResult.add(returnStatement);
        return super.visit(returnStatement);
    }

    public boolean visit(TryStatement tryStatement) {
        int n;
        int n2 = this.fCatchedExceptions.size();
        List list = tryStatement.catchClauses();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IVariableBinding iVariableBinding = ((CatchClause)iterator.next()).getException().resolveBinding();
            if (iVariableBinding == null || iVariableBinding.getType() == null) continue;
            this.fCatchedExceptions.add(iVariableBinding.getType());
        }
        tryStatement.getBody().accept((ASTVisitor)this);
        int n3 = n = this.fCatchedExceptions.size() - n2;
        while (n3 > 0) {
            this.fCatchedExceptions.remove(n2);
            --n3;
        }
        Iterator iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            ((CatchClause)iterator2.next()).accept((ASTVisitor)this);
        }
        if (tryStatement.getFinally() != null) {
            tryStatement.getFinally().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(ThrowStatement throwStatement) {
        ITypeBinding iTypeBinding = throwStatement.getExpression().resolveTypeBinding();
        if (this.isExitPoint(iTypeBinding)) {
            SimpleName simpleName = this.fAST.newSimpleName("xxxxx");
            simpleName.setSourceRange(throwStatement.getStartPosition(), 5);
            this.fResult.add(simpleName);
        }
        return true;
    }

    public boolean visit(MethodInvocation methodInvocation) {
        if (this.isExitPoint(methodInvocation.resolveMethodBinding())) {
            this.fResult.add(methodInvocation.getName());
        }
        return true;
    }

    public boolean visit(SuperMethodInvocation superMethodInvocation) {
        if (this.isExitPoint(superMethodInvocation.resolveMethodBinding())) {
            this.fResult.add(superMethodInvocation.getName());
        }
        return true;
    }

    public boolean visit(ClassInstanceCreation classInstanceCreation) {
        if (this.isExitPoint(classInstanceCreation.resolveConstructorBinding())) {
            this.fResult.add(classInstanceCreation.getType());
        }
        return true;
    }

    public boolean visit(ConstructorInvocation constructorInvocation) {
        if (this.isExitPoint(constructorInvocation.resolveConstructorBinding())) {
            SimpleName simpleName = this.fAST.newSimpleName("xxxx");
            simpleName.setSourceRange(constructorInvocation.getStartPosition(), 4);
            this.fResult.add(simpleName);
        }
        return true;
    }

    public boolean visit(SuperConstructorInvocation superConstructorInvocation) {
        if (this.isExitPoint(superConstructorInvocation.resolveConstructorBinding())) {
            SimpleName simpleName = this.fAST.newSimpleName("xxxxx");
            simpleName.setSourceRange(superConstructorInvocation.getStartPosition(), 5);
            this.fResult.add(simpleName);
        }
        return true;
    }

    private boolean isExitPoint(ITypeBinding iTypeBinding) {
        if (iTypeBinding == null) {
            return false;
        }
        return !this.isCatched(iTypeBinding);
    }

    private boolean isExitPoint(IMethodBinding iMethodBinding) {
        if (iMethodBinding == null) {
            return false;
        }
        ITypeBinding[] iTypeBindingArray = iMethodBinding.getExceptionTypes();
        int n = 0;
        while (n < iTypeBindingArray.length) {
            if (!this.isCatched(iTypeBindingArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isCatched(ITypeBinding iTypeBinding) {
        Iterator iterator = this.fCatchedExceptions.iterator();
        while (iterator.hasNext()) {
            ITypeBinding iTypeBinding2 = (ITypeBinding)iterator.next();
            if (!this.catches(iTypeBinding2, iTypeBinding)) continue;
            return true;
        }
        return false;
    }

    private boolean catches(ITypeBinding iTypeBinding, ITypeBinding iTypeBinding2) {
        while (iTypeBinding2 != null) {
            if (iTypeBinding2 == iTypeBinding) {
                return true;
            }
            iTypeBinding2 = iTypeBinding2.getSuperclass();
        }
        return false;
    }
}

