/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.internal.ui.search.JavaElementMatch;
import org.eclipse.wst.jsdt.internal.ui.search.JavaMatchFilter;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.ui.search.ElementQuerySpecification;
import org.eclipse.wst.jsdt.ui.search.PatternQuerySpecification;
import org.eclipse.wst.jsdt.ui.search.QuerySpecification;

class PolymorphicFilter
extends JavaMatchFilter {
    PolymorphicFilter() {
    }

    public boolean filters(JavaElementMatch javaElementMatch) {
        return javaElementMatch.isSuperInvocation();
    }

    public String getName() {
        return SearchMessages.MatchFilter_PolymorphicFilter_name;
    }

    public String getActionLabel() {
        return SearchMessages.MatchFilter_PolymorphicFilter_actionLabel;
    }

    public String getDescription() {
        return SearchMessages.MatchFilter_PolymorphicFilter_description;
    }

    public boolean isApplicable(JavaSearchQuery javaSearchQuery) {
        QuerySpecification querySpecification = javaSearchQuery.getSpecification();
        switch (querySpecification.getLimitTo()) {
            case 2: 
            case 3: {
                if (querySpecification instanceof ElementQuerySpecification) {
                    ElementQuerySpecification elementQuerySpecification = (ElementQuerySpecification)querySpecification;
                    return elementQuerySpecification.getElement() instanceof IMethod;
                }
                if (!(querySpecification instanceof PatternQuerySpecification)) break;
                PatternQuerySpecification patternQuerySpecification = (PatternQuerySpecification)querySpecification;
                return patternQuerySpecification.getSearchFor() == 1;
            }
        }
        return false;
    }

    public String getID() {
        return "filter_polymorphic";
    }
}

