/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.wst.jsdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.wst.jsdt.internal.ui.text.DocumentCharacterIterator;
import org.eclipse.wst.jsdt.internal.ui.text.JavaHeuristicScanner;

public final class JavaIndenter {
    private final IDocument fDocument;
    private int fIndent;
    private int fAlign;
    private int fPosition;
    private int fPreviousPos;
    private int fToken;
    private int fLine;
    private final JavaHeuristicScanner fScanner;
    private final CorePrefs fPrefs;

    public JavaIndenter(IDocument iDocument, JavaHeuristicScanner javaHeuristicScanner) {
        this(iDocument, javaHeuristicScanner, null);
    }

    public JavaIndenter(IDocument iDocument, JavaHeuristicScanner javaHeuristicScanner, IJavaProject iJavaProject) {
        Assert.isNotNull((Object)iDocument);
        Assert.isNotNull((Object)javaHeuristicScanner);
        this.fDocument = iDocument;
        this.fScanner = javaHeuristicScanner;
        this.fPrefs = new CorePrefs(iJavaProject);
    }

    public StringBuffer getReferenceIndentation(int n) {
        return this.getReferenceIndentation(n, false);
    }

    private StringBuffer getReferenceIndentation(int n, boolean bl) {
        int n2 = bl ? this.findReferencePosition(n, 1) : this.findReferencePosition(n, this.peekChar(n));
        if (n2 == -1) {
            return null;
        }
        return this.getLeadingWhitespace(n2);
    }

    public StringBuffer computeIndentation(int n) {
        return this.computeIndentation(n, false);
    }

    public StringBuffer computeIndentation(int n, boolean bl) {
        StringBuffer stringBuffer = this.getReferenceIndentation(n, bl);
        if (this.fAlign != -1) {
            try {
                IRegion iRegion = this.fDocument.getLineInformationOfOffset(this.fAlign);
                int n2 = iRegion.getOffset();
                return this.createIndent(n2, this.fAlign, false);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        if (stringBuffer == null) {
            return null;
        }
        return this.createReusingIndent(stringBuffer, this.fIndent);
    }

    private int computeVisualLength(CharSequence charSequence) {
        int n = this.fPrefs.prefTabSize;
        int n2 = 0;
        int n3 = 0;
        while (n3 < charSequence.length()) {
            char c = charSequence.charAt(n3);
            switch (c) {
                case '\t': {
                    if (n <= 0) break;
                    int n4 = n2 % n;
                    n2 += n - n4;
                    break;
                }
                case ' ': {
                    ++n2;
                }
            }
            ++n3;
        }
        return n2;
    }

    private StringBuffer stripExceedingChars(StringBuffer stringBuffer, int n) {
        int n2;
        int n3 = this.fPrefs.prefTabSize;
        int n4 = 0;
        int n5 = stringBuffer.length();
        int n6 = 0;
        while (n4 < n && n6 < n5) {
            n2 = stringBuffer.charAt(n6);
            switch (n2) {
                case 9: {
                    if (n3 <= 0) break;
                    int n7 = n4 % n3;
                    n4 += n3 - n7;
                    break;
                }
                case 32: {
                    ++n4;
                }
            }
            ++n6;
        }
        n2 = n4 > n ? n6 - 1 : n6;
        return stringBuffer.delete(n2, n5);
    }

    private StringBuffer getLeadingWhitespace(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            IRegion iRegion = this.fDocument.getLineInformationOfOffset(n);
            int n2 = iRegion.getOffset();
            int n3 = this.fScanner.findNonWhitespaceForwardInAnyPartition(n2, n2 + iRegion.getLength());
            stringBuffer.append(this.fDocument.get(n2, n3 - n2));
            return stringBuffer;
        }
        catch (BadLocationException badLocationException) {
            return stringBuffer;
        }
    }

    private StringBuffer createIndent(int n, int n2, boolean bl) {
        boolean bl2 = this.fPrefs.prefUseTabs && bl;
        int n3 = this.fPrefs.prefTabSize;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n4 = 0;
            while (n < n2) {
                char c = this.fDocument.getChar(n);
                if (c == '\t') {
                    stringBuffer.append('\t');
                    n4 = 0;
                } else if (bl2) {
                    if (++n4 == n3) {
                        stringBuffer.append('\t');
                        n4 = 0;
                    }
                } else {
                    stringBuffer.append(' ');
                }
                ++n;
            }
            while (n4-- > 0) {
                stringBuffer.append(' ');
            }
        }
        catch (BadLocationException badLocationException) {}
        return stringBuffer;
    }

    private StringBuffer createReusingIndent(StringBuffer stringBuffer, int n) {
        int n2;
        int n3;
        int n4 = this.computeVisualLength(stringBuffer);
        int n5 = this.fPrefs.prefIndentationSize * n;
        int n6 = Math.max(0, n4 + n5);
        int n7 = Math.min(n6, n4);
        int n8 = this.fPrefs.prefTabSize;
        int n9 = n8 > 0 ? n7 - n7 % n8 : n7;
        this.stripExceedingChars(stringBuffer, n9);
        int n10 = n6 - n9;
        if ("space".equals(this.fPrefs.prefTabChar)) {
            n3 = 0;
            n2 = n10;
        } else if ("tab".equals(this.fPrefs.prefTabChar)) {
            n3 = n8 > 0 ? n10 / n8 : 0;
            n2 = n8 > 0 ? n10 % n8 : n10;
        } else if ("mixed".equals(this.fPrefs.prefTabChar)) {
            n3 = n8 > 0 ? n10 / n8 : 0;
            n2 = n8 > 0 ? n10 % n8 : n10;
        } else {
            Assert.isTrue((boolean)false);
            return null;
        }
        int n11 = 0;
        while (n11 < n3) {
            stringBuffer.append('\t');
            ++n11;
        }
        n11 = 0;
        while (n11 < n2) {
            stringBuffer.append(' ');
            ++n11;
        }
        return stringBuffer;
    }

    public int findReferencePosition(int n) {
        return this.findReferencePosition(n, this.peekChar(n));
    }

    private int peekChar(int n) {
        if (n < this.fDocument.getLength()) {
            try {
                IRegion iRegion = this.fDocument.getLineInformationOfOffset(n);
                int n2 = iRegion.getOffset();
                int n3 = this.fScanner.nextToken(n, n2 + iRegion.getLength());
                return n3;
            }
            catch (BadLocationException badLocationException) {}
        }
        return -1;
    }

    public int findReferencePosition(int n, int n2) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        if (n < this.fDocument.getLength()) {
            try {
                IRegion iRegion = this.fDocument.getLineInformationOfOffset(n);
                int n3 = iRegion.getOffset();
                int n4 = Math.max(n - 1, 0);
                boolean bl7 = this.fDocument.get(n3, n4 + 1 - n3).trim().length() == 0;
                int n5 = this.fScanner.previousToken(n4, -2);
                boolean bl8 = this.fScanner.isBracelessBlockStart(n4, -2);
                switch (n2) {
                    case 1014: {
                        bl = true;
                        break;
                    }
                    case 1013: 
                    case 1024: {
                        if (bl7) {
                            bl6 = true;
                        }
                        break;
                    }
                    case 1: {
                        if (bl8 && !this.fPrefs.prefIndentBracesForBlocks) {
                            bl2 = true;
                            break;
                        }
                        if (!(n5 != 9 && n5 != 12 && n5 != 4 || this.fPrefs.prefIndentBracesForArrays)) {
                            bl2 = true;
                            break;
                        }
                        if (!bl8 && this.fPrefs.prefIndentBracesForMethods) {
                            bl3 = true;
                        }
                        break;
                    }
                    case 2: {
                        if (bl7) {
                            bl4 = true;
                        }
                        break;
                    }
                    case 6: {
                        if (!bl7) break;
                        bl5 = true;
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (BadLocationException badLocationException) {}
        } else {
            bl = false;
        }
        int n6 = this.findReferencePosition(n, bl, bl4, bl5, bl6);
        if (bl2) {
            --this.fIndent;
        }
        if (bl3) {
            ++this.fIndent;
        }
        return n6;
    }

    public int findReferencePosition(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.fIndent = 0;
        this.fAlign = -1;
        this.fPosition = n;
        if (bl2) {
            if (this.skipScope(1, 2)) {
                int n2;
                try {
                    n2 = this.fDocument.getLineOffset(this.fLine);
                    if (n2 <= this.fPosition && this.fDocument.get(n2, this.fPosition - n2).trim().length() == 0) {
                        return this.fPosition;
                    }
                }
                catch (BadLocationException badLocationException) {}
                n2 = this.skipToStatementStart(true, true);
                this.fIndent = 0;
                return n2;
            }
            int n3 = this.findReferencePosition(n, bl, false, bl3, bl4);
            --this.fIndent;
            return n3;
        }
        if (bl3) {
            if (this.skipScope(5, 6)) {
                return this.fPosition;
            }
            int n4 = this.findReferencePosition(n, bl, bl2, false, bl4);
            --this.fIndent;
            return n4;
        }
        if (bl4) {
            return this.matchCaseAlignment();
        }
        this.nextToken();
        switch (this.fToken) {
            case 2: 
            case 14: {
                int n5 = this.fPosition;
                if (!this.skipScope()) {
                    this.fPosition = n5;
                }
            }
            case 7: {
                return this.skipToStatementStart(bl, false);
            }
            case 1: 
            case 3: 
            case 5: {
                return this.handleScopeIntroduction(n + 1);
            }
            case -1: {
                return -1;
            }
            case 12: {
                this.fIndent = this.fPrefs.prefAssignmentIndent;
                return this.fPosition;
            }
            case 9: {
                this.fIndent = this.fPrefs.prefCaseBlockIndent;
                return this.fPosition;
            }
            case 10: {
                if (this.fPrefs.prefTernaryDeepAlign) {
                    this.setFirstElementAlignment(this.fPosition, n + 1);
                    return this.fPosition;
                }
                this.fIndent = this.fPrefs.prefTernaryIndent;
                return this.fPosition;
            }
            case 1010: 
            case 1014: 
            case 1017: {
                this.fIndent = this.fPrefs.prefSimpleIndent;
                return this.fPosition;
            }
            case 1012: {
                return this.skipToStatementStart(bl, false);
            }
            case 6: {
                int n6 = this.fLine;
                if (this.skipScope(5, 6)) {
                    int n7 = this.fPosition;
                    this.nextToken();
                    if (this.fToken == 109 || this.fToken == 1017 || this.fToken == 1011) {
                        this.fIndent = this.fPrefs.prefSimpleIndent;
                        return this.fPosition;
                    }
                    this.fPosition = n7;
                    if (this.looksLikeMethodDecl()) {
                        return this.skipToStatementStart(bl, false);
                    }
                    if (this.fToken == 1016) {
                        return this.skipToStatementStart(bl, false);
                    }
                    this.fPosition = n7;
                    if (this.looksLikeAnonymousTypeDecl()) {
                        return this.skipToStatementStart(bl, false);
                    }
                }
                this.fPosition = n;
                this.fLine = n6;
            }
        }
        return this.skipToPreviousListItemOrListStart();
    }

    private int skipToStatementStart(boolean bl, boolean bl2) {
        int n = 0;
        boolean bl3 = false;
        while (true) {
            this.nextToken();
            if (bl2) {
                switch (this.fToken) {
                    case 109: 
                    case 1010: 
                    case 1011: 
                    case 1012: 
                    case 1014: 
                    case 1016: 
                    case 1017: 
                    case 1021: {
                        return this.fPosition;
                    }
                    case 1019: {
                        n = 2;
                        break;
                    }
                    case 1022: {
                        if (n == 2) break;
                        return this.fPosition;
                    }
                    case 1026: 
                    case 1027: 
                    case 1028: {
                        bl3 = true;
                        break;
                    }
                    case 1020: {
                        this.fIndent = this.fPrefs.prefCaseIndent;
                        return this.fPosition;
                    }
                }
            }
            switch (this.fToken) {
                case -1: 
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    if (bl2) {
                        this.fIndent = this.getBlockIndent(n == 2, bl3);
                    }
                    return this.fPreviousPos;
                }
                case 9: {
                    int n2 = this.fPreviousPos;
                    if (this.isConditional()) break;
                    return n2;
                }
                case 2: {
                    int n2 = this.fPreviousPos;
                    if (this.skipScope() && this.looksLikeArrayInitializerIntro()) break;
                    if (bl2) {
                        this.fIndent = this.getBlockIndent(n == 2, bl3);
                    }
                    return n2;
                }
                case 6: {
                    if (bl2) {
                        n = 1;
                    }
                }
                case 4: 
                case 14: {
                    int n2 = this.fPreviousPos;
                    if (this.skipScope()) break;
                    return n2;
                }
                case 109: {
                    if (!bl) break;
                    return this.fPosition;
                }
                case 1014: {
                    int n2 = this.fPosition;
                    if (this.skipNextIF()) break;
                    return n2;
                }
                case 1010: {
                    return this.fPosition;
                }
                case 1017: {
                    int n2 = this.fPosition;
                    if (this.hasMatchingDo()) break;
                    this.fPosition = n2;
                    break;
                }
                case 2000: {
                    if (n != 1) break;
                    n = 2;
                }
            }
        }
    }

    private int getBlockIndent(boolean bl, boolean bl2) {
        if (bl2) {
            return this.fPrefs.prefTypeIndent + (this.fPrefs.prefIndentBracesForTypes ? 1 : 0);
        }
        if (bl) {
            return this.fPrefs.prefMethodBodyIndent + (this.fPrefs.prefIndentBracesForMethods ? 1 : 0);
        }
        return this.fIndent;
    }

    private boolean isConditional() {
        block4: while (true) {
            this.nextToken();
            switch (this.fToken) {
                case 8: 
                case 2000: {
                    continue block4;
                }
                case 1013: {
                    return false;
                }
            }
            break;
        }
        return true;
    }

    private int matchCaseAlignment() {
        block6: while (true) {
            this.nextToken();
            switch (this.fToken) {
                case -1: 
                case 3: 
                case 5: {
                    return this.fPosition;
                }
                case 1: {
                    this.fIndent = this.fPrefs.prefCaseIndent;
                    return this.fPosition;
                }
                case 1013: 
                case 1024: {
                    this.fIndent = 0;
                    return this.fPosition;
                }
                case 2: 
                case 4: 
                case 6: 
                case 14: {
                    this.skipScope();
                    continue block6;
                }
            }
        }
    }

    private int skipToPreviousListItemOrListStart() {
        int n = this.fLine;
        int n2 = this.fPosition;
        block9: while (true) {
            this.nextToken();
            if (this.fLine < n) {
                try {
                    int n3 = this.fDocument.getLineOffset(n);
                    int n4 = Math.min(this.fDocument.getLength(), n2 + 1);
                    this.fAlign = this.fScanner.findNonWhitespaceForwardInAnyPartition(n3, n4);
                }
                catch (BadLocationException badLocationException) {}
                return n2;
            }
            switch (this.fToken) {
                case 2: 
                case 4: 
                case 6: 
                case 14: {
                    this.skipScope();
                    continue block9;
                }
                case 1: 
                case 3: 
                case 5: {
                    return this.handleScopeIntroduction(n2 + 1);
                }
                case 7: {
                    return this.fPosition;
                }
                case 10: {
                    if (this.fPrefs.prefTernaryDeepAlign) {
                        this.setFirstElementAlignment(this.fPosition - 1, this.fPosition + 1);
                        return this.fPosition;
                    }
                    this.fIndent = this.fPrefs.prefTernaryIndent;
                    return this.fPosition;
                }
                case -1: {
                    return 0;
                }
            }
        }
    }

    private boolean skipScope() {
        switch (this.fToken) {
            case 6: {
                return this.skipScope(5, 6);
            }
            case 4: {
                return this.skipScope(3, 4);
            }
            case 2: {
                return this.skipScope(1, 2);
            }
            case 14: {
                if (!this.fPrefs.prefHasGenerics) {
                    return false;
                }
                int n = this.fPosition;
                int n2 = this.fToken;
                this.nextToken();
                switch (this.fToken) {
                    case 2000: {
                        if (!JavaHeuristicScanner.isGenericStarter(this.getTokenContent())) break;
                    }
                    case 10: 
                    case 14: {
                        if (!this.skipScope(13, 14)) break;
                        return true;
                    }
                }
                this.fPosition = n;
                this.fToken = n2;
                return false;
            }
        }
        Assert.isTrue((boolean)false);
        return false;
    }

    private CharSequence getTokenContent() {
        return new DocumentCharacterIterator(this.fDocument, this.fPosition, this.fPreviousPos);
    }

    private int handleScopeIntroduction(int n) {
        switch (this.fToken) {
            case 5: {
                int n2 = this.fPosition;
                if (this.looksLikeMethodDecl()) {
                    if (this.fPrefs.prefMethodDeclDeepIndent) {
                        return this.setFirstElementAlignment(n2, n);
                    }
                    this.fIndent = this.fPrefs.prefMethodDeclIndent;
                    return n2;
                }
                this.fPosition = n2;
                if (this.looksLikeMethodCall()) {
                    if (this.fPrefs.prefMethodCallDeepIndent) {
                        return this.setFirstElementAlignment(n2, n);
                    }
                    this.fIndent = this.fPrefs.prefMethodCallIndent;
                    return n2;
                }
                if (this.fPrefs.prefParenthesisDeepIndent) {
                    return this.setFirstElementAlignment(n2, n);
                }
                this.fIndent = this.fPrefs.prefParenthesisIndent;
                return n2;
            }
            case 1: {
                int n3 = this.fPosition;
                if (this.looksLikeArrayInitializerIntro()) {
                    if (this.fPrefs.prefArrayDeepIndent) {
                        return this.setFirstElementAlignment(n3, n);
                    }
                    this.fIndent = this.fPrefs.prefArrayIndent;
                } else {
                    this.fIndent = this.fPrefs.prefBlockIndent;
                }
                if (this.looksLikeArrayInitializerIntro() && !this.fPrefs.prefIndentBracesForArrays || !this.fPrefs.prefIndentBracesForBlocks) {
                    this.fPosition = n3;
                    return this.skipToStatementStart(true, true);
                }
                return n3;
            }
            case 3: {
                int n4 = this.fPosition;
                if (this.fPrefs.prefArrayDimensionsDeepIndent) {
                    return this.setFirstElementAlignment(n4, n);
                }
                this.fIndent = this.fPrefs.prefBracketIndent;
                return n4;
            }
        }
        Assert.isTrue((boolean)false);
        return -1;
    }

    private int setFirstElementAlignment(int n, int n2) {
        int n3 = n + 1;
        this.fAlign = this.fScanner.findNonWhitespaceForwardInAnyPartition(n3, n2);
        if (this.fAlign == -1) {
            this.fAlign = n3;
        }
        return this.fAlign;
    }

    private boolean looksLikeArrayInitializerIntro() {
        this.nextToken();
        return this.fToken == 12 || this.skipBrackets();
    }

    private boolean skipNextIF() {
        Assert.isTrue((this.fToken == 1014 ? 1 : 0) != 0);
        block6: while (true) {
            this.nextToken();
            switch (this.fToken) {
                case 2: 
                case 4: 
                case 6: 
                case 14: {
                    this.skipScope();
                    continue block6;
                }
                case 109: {
                    return true;
                }
                case 1014: {
                    this.skipNextIF();
                    continue block6;
                }
                case -1: 
                case 1: 
                case 3: 
                case 5: {
                    return false;
                }
            }
        }
    }

    private boolean hasMatchingDo() {
        Assert.isTrue((this.fToken == 1017 ? 1 : 0) != 0);
        this.nextToken();
        switch (this.fToken) {
            case 2: {
                this.skipScope();
            }
            case 7: {
                this.skipToStatementStart(false, false);
                return this.fToken == 1010;
            }
        }
        return false;
    }

    private boolean skipBrackets() {
        if (this.fToken == 4) {
            this.nextToken();
            if (this.fToken == 3) {
                return true;
            }
        }
        return false;
    }

    private void nextToken() {
        this.nextToken(this.fPosition);
    }

    private void nextToken(int n) {
        this.fToken = this.fScanner.previousToken(n - 1, -2);
        this.fPreviousPos = n;
        this.fPosition = this.fScanner.getPosition() + 1;
        try {
            this.fLine = this.fDocument.getLineOfOffset(this.fPosition);
        }
        catch (BadLocationException badLocationException) {
            this.fLine = -1;
        }
    }

    private boolean looksLikeMethodDecl() {
        this.nextToken();
        if (this.fToken == 2000) {
            do {
                this.nextToken();
            } while (this.skipBrackets());
            return this.fToken == 2000;
        }
        return false;
    }

    private boolean looksLikeAnonymousTypeDecl() {
        this.nextToken();
        if (this.fToken == 2000) {
            this.nextToken();
            while (this.fToken == 8) {
                this.nextToken();
                if (this.fToken != 2000) {
                    return false;
                }
                this.nextToken();
            }
            return this.fToken == 1025;
        }
        return false;
    }

    private boolean looksLikeMethodCall() {
        this.nextToken();
        return this.fToken == 2000;
    }

    private boolean skipScope(int n, int n2) {
        int n3 = 1;
        while (true) {
            this.nextToken();
            if (this.fToken == n2) {
                ++n3;
                continue;
            }
            if (this.fToken == n) {
                if (--n3 != 0) continue;
                return true;
            }
            if (this.fToken == -1) break;
        }
        return false;
    }

    private final class CorePrefs {
        final boolean prefUseTabs;
        final int prefTabSize;
        final int prefIndentationSize;
        final boolean prefArrayDimensionsDeepIndent;
        final int prefArrayIndent;
        final boolean prefArrayDeepIndent;
        final boolean prefTernaryDeepAlign;
        final int prefTernaryIndent;
        final int prefCaseIndent;
        final int prefAssignmentIndent;
        final int prefCaseBlockIndent;
        final int prefSimpleIndent;
        final int prefBracketIndent;
        final boolean prefMethodDeclDeepIndent;
        final int prefMethodDeclIndent;
        final boolean prefMethodCallDeepIndent;
        final int prefMethodCallIndent;
        final boolean prefParenthesisDeepIndent;
        final int prefParenthesisIndent;
        final int prefBlockIndent;
        final int prefMethodBodyIndent;
        final int prefTypeIndent;
        final boolean prefIndentBracesForBlocks;
        final boolean prefIndentBracesForArrays;
        final boolean prefIndentBracesForMethods;
        final boolean prefIndentBracesForTypes;
        final int prefContinuationIndent;
        final boolean prefHasGenerics;
        final String prefTabChar;
        private final IJavaProject fProject;

        private boolean isStandalone() {
            return JavaCore.getPlugin() == null;
        }

        private String getCoreFormatterOption(String string) {
            if (this.fProject == null) {
                return JavaCore.getOption((String)string);
            }
            return this.fProject.getOption(string, true);
        }

        CorePrefs(IJavaProject iJavaProject) {
            this.fProject = iJavaProject;
            if (this.isStandalone()) {
                this.prefUseTabs = true;
                this.prefTabSize = 4;
                this.prefIndentationSize = 4;
                this.prefArrayDimensionsDeepIndent = true;
                this.prefContinuationIndent = 2;
                this.prefBlockIndent = 1;
                this.prefArrayIndent = this.prefContinuationIndent;
                this.prefArrayDeepIndent = true;
                this.prefTernaryDeepAlign = false;
                this.prefTernaryIndent = this.prefContinuationIndent;
                this.prefCaseIndent = 0;
                this.prefAssignmentIndent = this.prefBlockIndent;
                this.prefCaseBlockIndent = this.prefBlockIndent;
                this.prefIndentBracesForBlocks = false;
                this.prefSimpleIndent = this.prefIndentBracesForBlocks && this.prefBlockIndent == 0 ? 1 : this.prefBlockIndent;
                this.prefBracketIndent = this.prefBlockIndent;
                this.prefMethodDeclDeepIndent = true;
                this.prefMethodDeclIndent = 1;
                this.prefMethodCallDeepIndent = false;
                this.prefMethodCallIndent = 1;
                this.prefParenthesisDeepIndent = false;
                this.prefParenthesisIndent = this.prefContinuationIndent;
                this.prefMethodBodyIndent = 1;
                this.prefTypeIndent = 1;
                this.prefIndentBracesForArrays = false;
                this.prefIndentBracesForMethods = false;
                this.prefIndentBracesForTypes = false;
                this.prefHasGenerics = false;
                this.prefTabChar = "tab";
            } else {
                this.prefUseTabs = this.prefUseTabs();
                this.prefTabSize = this.prefTabSize();
                this.prefIndentationSize = this.prefIndentationSize();
                this.prefArrayDimensionsDeepIndent = this.prefArrayDimensionsDeepIndent();
                this.prefContinuationIndent = this.prefContinuationIndent();
                this.prefBlockIndent = this.prefBlockIndent();
                this.prefArrayIndent = this.prefArrayIndent();
                this.prefArrayDeepIndent = this.prefArrayDeepIndent();
                this.prefTernaryDeepAlign = this.prefTernaryDeepAlign();
                this.prefTernaryIndent = this.prefTernaryIndent();
                this.prefCaseIndent = this.prefCaseIndent();
                this.prefAssignmentIndent = this.prefAssignmentIndent();
                this.prefCaseBlockIndent = this.prefCaseBlockIndent();
                this.prefIndentBracesForBlocks = this.prefIndentBracesForBlocks();
                this.prefSimpleIndent = this.prefSimpleIndent();
                this.prefBracketIndent = this.prefBracketIndent();
                this.prefMethodDeclDeepIndent = this.prefMethodDeclDeepIndent();
                this.prefMethodDeclIndent = this.prefMethodDeclIndent();
                this.prefMethodCallDeepIndent = this.prefMethodCallDeepIndent();
                this.prefMethodCallIndent = this.prefMethodCallIndent();
                this.prefParenthesisDeepIndent = this.prefParenthesisDeepIndent();
                this.prefParenthesisIndent = this.prefParenthesisIndent();
                this.prefMethodBodyIndent = this.prefMethodBodyIndent();
                this.prefTypeIndent = this.prefTypeIndent();
                this.prefIndentBracesForArrays = this.prefIndentBracesForArrays();
                this.prefIndentBracesForMethods = this.prefIndentBracesForMethods();
                this.prefIndentBracesForTypes = this.prefIndentBracesForTypes();
                this.prefHasGenerics = this.hasGenerics();
                this.prefTabChar = this.getCoreFormatterOption("org.eclipse.wst.jsdt.core.formatter.tabulation.char");
            }
        }

        private boolean prefUseTabs() {
            return !"space".equals(this.getCoreFormatterOption("org.eclipse.wst.jsdt.core.formatter.tabulation.char"));
        }

        private int prefTabSize() {
            return CodeFormatterUtil.getTabWidth(this.fProject);
        }

        private int prefIndentationSize() {
            return CodeFormatterUtil.getIndentWidth(this.fProject);
        }

        private boolean prefArrayDimensionsDeepIndent() {
            return true;
        }

        private int prefArrayIndent() {
            String string = this.getCoreFormatterOption("org.eclipse.wst.jsdt.core.formatter.alignment_for_expressions_in_array_initializer");
            try {
                if (DefaultCodeFormatterConstants.getIndentStyle((String)string) == 2) {
                    return 1;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            return this.prefContinuationIndent();
        }

        private boolean prefArrayDeepIndent() {
            String string = this.getCoreFormatterOption("org.eclipse.wst.jsdt.core.formatter.alignment_for_expressions_in_array_initializer");
            try {
                return DefaultCodeFormatterConstants.getIndentStyle((String)string) == 1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return true;
            }
        }

        private boolean prefTernaryDeepAlign() {
            String string = this.getCoreFormatterOption("org.eclipse.wst.jsdt.core.formatter.alignment_for_conditional_expression");
            try {
                return DefaultCodeFormatterConstants.getIndentStyle((String)string) == 1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        private int prefTernaryIndent() {
            block3: {
                String string = this.getCoreFormatterOption("org.eclipse.wst.jsdt.core.formatter.alignment_for_conditional_expression");
                try {
                    if (DefaultCodeFormatterConstants.getIndentStyle((String)string) != 2) break block3;
                    return 1;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return this.prefContinuationIndent();
                }
            }
            return this.prefContinuationIndent();
        }

        private int prefCaseIndent() {
            if ("true".equals(this.getCoreFormatterOption("org.eclipse.wst.jsdt.core.formatter.indent_switchstatements_compare_to_switch"))) {
                return this.prefBlockIndent();
            }
            return 0;
        }

        private int prefAssignmentIndent() {
            return this.prefBlockIndent();
        }

        private int prefCaseBlockIndent() {
            return this.prefBlockIndent();
        }

        private int prefSimpleIndent() {
            if (this.prefIndentBracesForBlocks() && this.prefBlockIndent() == 0) {
                return 1;
            }
            return this.prefBlockIndent();
        }

        private int prefBracketIndent() {
            return this.prefBlockIndent();
        }

        private boolean prefMethodDeclDeepIndent() {
            String string = this.getCoreFormatterOption("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_method_declaration");
            try {
                return DefaultCodeFormatterConstants.getIndentStyle((String)string) == 1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return true;
            }
        }

        private int prefMethodDeclIndent() {
            block3: {
                String string = this.getCoreFormatterOption("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_method_declaration");
                try {
                    if (DefaultCodeFormatterConstants.getIndentStyle((String)string) != 2) break block3;
                    return 1;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return 1;
                }
            }
            return this.prefContinuationIndent();
        }

        private boolean prefMethodCallDeepIndent() {
            String string = this.getCoreFormatterOption("org.eclipse.wst.jsdt.core.formatter.alignment_for_arguments_in_method_invocation");
            try {
                return DefaultCodeFormatterConstants.getIndentStyle((String)string) == 1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        private int prefMethodCallIndent() {
            block3: {
                String string = this.getCoreFormatterOption("org.eclipse.wst.jsdt.core.formatter.alignment_for_arguments_in_method_invocation");
                try {
                    if (DefaultCodeFormatterConstants.getIndentStyle((String)string) != 2) break block3;
                    return 1;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return 1;
                }
            }
            return this.prefContinuationIndent();
        }

        private boolean prefParenthesisDeepIndent() {
            return false;
        }

        private int prefParenthesisIndent() {
            return this.prefContinuationIndent();
        }

        private int prefBlockIndent() {
            String string = this.getCoreFormatterOption("org.eclipse.wst.jsdt.core.formatter.indent_statements_compare_to_block");
            if ("false".equals(string)) {
                return 0;
            }
            return 1;
        }

        private int prefMethodBodyIndent() {
            if ("false".equals(this.getCoreFormatterOption("org.eclipse.wst.jsdt.core.formatter.indent_statements_compare_to_body"))) {
                return 0;
            }
            return 1;
        }

        private int prefTypeIndent() {
            String string = this.getCoreFormatterOption("org.eclipse.wst.jsdt.core.formatter.indent_body_declarations_compare_to_type_header");
            if ("false".equals(string)) {
                return 0;
            }
            return 1;
        }

        private boolean prefIndentBracesForBlocks() {
            return "next_line_shifted".equals(this.getCoreFormatterOption("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block"));
        }

        private boolean prefIndentBracesForArrays() {
            return "next_line_shifted".equals(this.getCoreFormatterOption("org.eclipse.wst.jsdt.core.formatter.brace_position_for_array_initializer"));
        }

        private boolean prefIndentBracesForMethods() {
            return "next_line_shifted".equals(this.getCoreFormatterOption("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration"));
        }

        private boolean prefIndentBracesForTypes() {
            return "next_line_shifted".equals(this.getCoreFormatterOption("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration"));
        }

        private int prefContinuationIndent() {
            try {
                return Integer.parseInt(this.getCoreFormatterOption("org.eclipse.wst.jsdt.core.formatter.continuation_indentation"));
            }
            catch (NumberFormatException numberFormatException) {
                return 2;
            }
        }

        private boolean hasGenerics() {
            return "1.5".compareTo(this.getCoreFormatterOption("org.eclipse.wst.jsdt.core.compiler.source")) <= 0;
        }
    }
}

