/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text;

import com.ibm.icu.text.BreakIterator;
import java.text.CharacterIterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.internal.ui.text.JavaBreakIterator;

public class JavaWordIterator
extends BreakIterator {
    private JavaBreakIterator fIterator = new JavaBreakIterator();
    private int fIndex;

    public JavaWordIterator() {
        this.first();
    }

    public int first() {
        this.fIndex = this.fIterator.first();
        return this.fIndex;
    }

    public int last() {
        this.fIndex = this.fIterator.last();
        return this.fIndex;
    }

    public int next(int n) {
        int n2 = 0;
        while (--n > 0 && n2 != -1) {
            n2 = this.next();
        }
        return n2;
    }

    public int next() {
        this.fIndex = this.following(this.fIndex);
        return this.fIndex;
    }

    public int previous() {
        this.fIndex = this.preceding(this.fIndex);
        return this.fIndex;
    }

    public int preceding(int n) {
        int n2;
        int n3 = this.fIterator.preceding(n);
        if (this.isWhitespace(n3, n) && (n2 = this.fIterator.preceding(n3)) != -1 && !this.isDelimiter(n2, n3)) {
            return n2;
        }
        return n3;
    }

    public int following(int n) {
        int n2;
        int n3 = this.fIterator.following(n);
        if (this.eatFollowingWhitespace(n, n3) && this.isWhitespace(n3, n2 = this.fIterator.following(n3))) {
            return n2;
        }
        return n3;
    }

    private boolean eatFollowingWhitespace(int n, int n2) {
        if (n2 == -1 || n == -1) {
            return false;
        }
        if (this.isWhitespace(n, n2)) {
            return false;
        }
        return !this.isDelimiter(n, n2);
    }

    private boolean isDelimiter(int n, int n2) {
        if (n2 == -1 || n == -1) {
            return false;
        }
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        Assert.isTrue((n2 <= this.getText().getEndIndex() ? 1 : 0) != 0);
        Assert.isTrue((n2 > n ? 1 : 0) != 0);
        CharSequence charSequence = this.fIterator.fText;
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c != '\n' && c != '\r') {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean isWhitespace(int n, int n2) {
        if (n2 == -1 || n == -1) {
            return false;
        }
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        Assert.isTrue((n2 <= this.getText().getEndIndex() ? 1 : 0) != 0);
        Assert.isTrue((n2 > n ? 1 : 0) != 0);
        CharSequence charSequence = this.fIterator.fText;
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (!Character.isWhitespace(c)) {
                return false;
            }
            if (c == '\n' || c == '\r') {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int current() {
        return this.fIndex;
    }

    public CharacterIterator getText() {
        return this.fIterator.getText();
    }

    public void setText(CharSequence charSequence) {
        this.fIterator.setText(charSequence);
        this.first();
    }

    public void setText(CharacterIterator characterIterator) {
        this.fIterator.setText(characterIterator);
        this.first();
    }

    public void setText(String string) {
        this.setText((CharSequence)string);
    }
}

