/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.lang.reflect.Modifier;
import java.util.List;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedCorrectionProposal;

public class AddArgumentCorrectionProposal
extends LinkedCorrectionProposal {
    private int[] fInsertIndexes;
    private ITypeBinding[] fParamTypes;
    private ASTNode fCallerNode;

    public AddArgumentCorrectionProposal(String string, ICompilationUnit iCompilationUnit, ASTNode aSTNode, int[] nArray, ITypeBinding[] iTypeBindingArray, int n) {
        super(string, iCompilationUnit, (ASTRewrite)null, n, JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif"));
        this.fCallerNode = aSTNode;
        this.fInsertIndexes = nArray;
        this.fParamTypes = iTypeBindingArray;
    }

    protected ASTRewrite getRewrite() {
        AST aST = this.fCallerNode.getAST();
        ASTRewrite aSTRewrite = ASTRewrite.create((AST)aST);
        ChildListPropertyDescriptor childListPropertyDescriptor = this.getProperty();
        int n = 0;
        while (n < this.fInsertIndexes.length) {
            int n2 = this.fInsertIndexes[n];
            String string = "newarg_" + n;
            Expression expression = this.evaluateArgumentExpressions(aST, this.fParamTypes[n2], string);
            ListRewrite listRewrite = aSTRewrite.getListRewrite(this.fCallerNode, childListPropertyDescriptor);
            listRewrite.insertAt((ASTNode)expression, n2, null);
            this.addLinkedPosition(aSTRewrite.track((ASTNode)expression), n == 0, string);
            ++n;
        }
        return aSTRewrite;
    }

    private ChildListPropertyDescriptor getProperty() {
        List list = this.fCallerNode.structuralPropertiesForType();
        int n = 0;
        while (n < list.size()) {
            StructuralPropertyDescriptor structuralPropertyDescriptor = (StructuralPropertyDescriptor)list.get(n);
            if (structuralPropertyDescriptor.isChildListProperty() && "arguments".equals(structuralPropertyDescriptor.getId())) {
                return (ChildListPropertyDescriptor)structuralPropertyDescriptor;
            }
            ++n;
        }
        return null;
    }

    private Expression evaluateArgumentExpressions(AST aST, ITypeBinding iTypeBinding, String string) {
        CompilationUnit compilationUnit = (CompilationUnit)this.fCallerNode.getRoot();
        int n = this.fCallerNode.getStartPosition();
        Expression expression = null;
        ITypeBinding iTypeBinding2 = null;
        ScopeAnalyzer scopeAnalyzer = new ScopeAnalyzer(compilationUnit);
        IBinding[] iBindingArray = scopeAnalyzer.getDeclarationsInScope(n, 2);
        int n2 = 0;
        while (n2 < iBindingArray.length) {
            IVariableBinding iVariableBinding = (IVariableBinding)iBindingArray[n2];
            ITypeBinding iTypeBinding3 = iVariableBinding.getType();
            if (iTypeBinding3 != null && this.canAssign(iTypeBinding3, iTypeBinding) && this.testModifier(iVariableBinding)) {
                if (expression == null || this.isMoreSpecific(iTypeBinding2, iTypeBinding3)) {
                    expression = aST.newSimpleName(iVariableBinding.getName());
                    iTypeBinding2 = iTypeBinding3;
                }
                this.addLinkedPositionProposal(string, iVariableBinding.getName(), null);
            }
            ++n2;
        }
        Expression expression2 = ASTNodeFactory.newDefaultExpression(aST, iTypeBinding);
        if (expression == null) {
            expression = expression2;
        }
        this.addLinkedPositionProposal(string, ASTNodes.asString((ASTNode)expression2), null);
        return expression;
    }

    private boolean isMoreSpecific(ITypeBinding iTypeBinding, ITypeBinding iTypeBinding2) {
        return this.canAssign(iTypeBinding, iTypeBinding2) && !this.canAssign(iTypeBinding2, iTypeBinding);
    }

    private boolean canAssign(ITypeBinding iTypeBinding, ITypeBinding iTypeBinding2) {
        return iTypeBinding.isAssignmentCompatible(iTypeBinding2);
    }

    private boolean testModifier(IVariableBinding iVariableBinding) {
        int n;
        int n2 = iVariableBinding.getModifiers();
        if ((n2 & (n = 24)) == n) {
            return false;
        }
        return !Modifier.isStatic(n2) || ASTResolving.isInStaticContext(this.fCallerNode);
    }
}

