/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.core.CompletionRequestor;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.text.java.FillArgumentNamesCompletionProposalCollector;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.wst.jsdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;
import org.eclipse.wst.jsdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.wst.jsdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.wst.jsdt.ui.text.java.JavaContentAssistInvocationContext;

public class JavaCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    private String fErrorMessage;

    protected int guessContextInformationPosition(ContentAssistInvocationContext contentAssistInvocationContext) {
        return contentAssistInvocationContext.getInvocationOffset();
    }

    private List addContextInformations(JavaContentAssistInvocationContext javaContentAssistInvocationContext, int n, IProgressMonitor iProgressMonitor) {
        List list = this.internalComputeCompletionProposals(n, javaContentAssistInvocationContext, iProgressMonitor);
        ArrayList<ContextInformationWrapper> arrayList = new ArrayList<ContextInformationWrapper>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ICompletionProposal iCompletionProposal = (ICompletionProposal)iterator.next();
            IContextInformation iContextInformation = iCompletionProposal.getContextInformation();
            if (iContextInformation == null) continue;
            ContextInformationWrapper contextInformationWrapper = new ContextInformationWrapper(iContextInformation);
            contextInformationWrapper.setContextInformationPosition(n);
            arrayList.add(contextInformationWrapper);
        }
        return arrayList;
    }

    public List computeContextInformation(ContentAssistInvocationContext contentAssistInvocationContext, IProgressMonitor iProgressMonitor) {
        if (contentAssistInvocationContext instanceof JavaContentAssistInvocationContext) {
            JavaContentAssistInvocationContext javaContentAssistInvocationContext = (JavaContentAssistInvocationContext)contentAssistInvocationContext;
            int n = this.guessContextInformationPosition(javaContentAssistInvocationContext);
            List list = this.addContextInformations(javaContentAssistInvocationContext, n, iProgressMonitor);
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public List computeCompletionProposals(ContentAssistInvocationContext contentAssistInvocationContext, IProgressMonitor iProgressMonitor) {
        if (contentAssistInvocationContext instanceof JavaContentAssistInvocationContext) {
            JavaContentAssistInvocationContext javaContentAssistInvocationContext = (JavaContentAssistInvocationContext)contentAssistInvocationContext;
            return this.internalComputeCompletionProposals(contentAssistInvocationContext.getInvocationOffset(), javaContentAssistInvocationContext, iProgressMonitor);
        }
        return Collections.EMPTY_LIST;
    }

    private List internalComputeCompletionProposals(int n, JavaContentAssistInvocationContext javaContentAssistInvocationContext, IProgressMonitor iProgressMonitor) {
        ArrayList<IJavaCompletionProposal> arrayList;
        Object object;
        IJavaCompletionProposal[] iJavaCompletionProposalArray;
        ICompilationUnit iCompilationUnit = javaContentAssistInvocationContext.getCompilationUnit();
        if (iCompilationUnit == null) {
            return Collections.EMPTY_LIST;
        }
        ITextViewer iTextViewer = javaContentAssistInvocationContext.getViewer();
        CompletionProposalCollector completionProposalCollector = this.createCollector(javaContentAssistInvocationContext);
        completionProposalCollector.setInvocationContext(javaContentAssistInvocationContext);
        completionProposalCollector.setAllowsRequiredProposals(2, 9, true);
        completionProposalCollector.setAllowsRequiredProposals(2, 23, true);
        completionProposalCollector.setAllowsRequiredProposals(2, 21, true);
        completionProposalCollector.setAllowsRequiredProposals(6, 9, true);
        completionProposalCollector.setAllowsRequiredProposals(6, 23, true);
        completionProposalCollector.setAllowsRequiredProposals(6, 22, true);
        completionProposalCollector.setFavoriteReferences(this.getFavoriteStaticMembers());
        try {
            iJavaCompletionProposalArray = iTextViewer.getSelectedRange();
            if (iJavaCompletionProposalArray.y > 0) {
                completionProposalCollector.setReplacementLength(iJavaCompletionProposalArray.y);
            }
            iCompilationUnit.codeComplete(n, (CompletionRequestor)completionProposalCollector);
        }
        catch (JavaModelException javaModelException) {
            Shell shell = iTextViewer.getTextWidget().getShell();
            if (javaModelException.isDoesNotExist() && !iCompilationUnit.getJavaProject().isOnClasspath((IJavaElement)iCompilationUnit)) {
                MessageDialog.openInformation((Shell)shell, (String)JavaTextMessages.CompletionProcessor_error_notOnBuildPath_title, (String)JavaTextMessages.CompletionProcessor_error_notOnBuildPath_message);
            }
            ErrorDialog.openError((Shell)shell, (String)JavaTextMessages.CompletionProcessor_error_accessing_title, (String)JavaTextMessages.CompletionProcessor_error_accessing_message, (IStatus)javaModelException.getStatus());
        }
        iJavaCompletionProposalArray = completionProposalCollector.getJavaCompletionProposals();
        int n2 = this.guessContextInformationPosition(javaContentAssistInvocationContext);
        if (n2 != n) {
            int n3 = 0;
            while (n3 < iJavaCompletionProposalArray.length) {
                if (iJavaCompletionProposalArray[n3] instanceof JavaMethodCompletionProposal) {
                    object = (JavaMethodCompletionProposal)iJavaCompletionProposalArray[n3];
                    ((LazyJavaCompletionProposal)object).setContextInformationPosition(n2);
                }
                ++n3;
            }
        }
        if ((arrayList = new ArrayList<IJavaCompletionProposal>(Arrays.asList(iJavaCompletionProposalArray))).size() == 0 && ((String)(object = completionProposalCollector.getErrorMessage())).length() > 0) {
            this.fErrorMessage = object;
        }
        return arrayList;
    }

    private String[] getFavoriteStaticMembers() {
        String string = PreferenceConstants.getPreferenceStore().getString("content_assist_favorite_static_members");
        if (string != null && string.length() > 0) {
            return string.split(";");
        }
        return new String[0];
    }

    protected CompletionProposalCollector createCollector(JavaContentAssistInvocationContext javaContentAssistInvocationContext) {
        if (PreferenceConstants.getPreferenceStore().getBoolean("content_assist_fill_method_arguments")) {
            return new FillArgumentNamesCompletionProposalCollector(javaContentAssistInvocationContext);
        }
        return new CompletionProposalCollector(javaContentAssistInvocationContext.getCompilationUnit());
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public void sessionStarted() {
    }

    public void sessionEnded() {
        this.fErrorMessage = null;
    }

    private static final class ContextInformationWrapper
    implements IContextInformation,
    IContextInformationExtension {
        private final IContextInformation fContextInformation;
        private int fPosition;

        public ContextInformationWrapper(IContextInformation iContextInformation) {
            this.fContextInformation = iContextInformation;
        }

        public String getContextDisplayString() {
            return this.fContextInformation.getContextDisplayString();
        }

        public Image getImage() {
            return this.fContextInformation.getImage();
        }

        public String getInformationDisplayString() {
            return this.fContextInformation.getInformationDisplayString();
        }

        public int getContextInformationPosition() {
            return this.fPosition;
        }

        public void setContextInformationPosition(int n) {
            this.fPosition = n;
        }

        public boolean equals(Object object) {
            if (object instanceof ContextInformationWrapper) {
                return this.fContextInformation.equals((Object)((ContextInformationWrapper)object).fContextInformation);
            }
            return this.fContextInformation.equals(object);
        }
    }
}

