/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.wst.jsdt.internal.ui.text.JavaHeuristicScanner;

public class JavaParameterListValidator
implements IContextInformationValidator,
IContextInformationPresenter {
    private int fPosition;
    private ITextViewer fViewer;
    private IContextInformation fInformation;
    private int fCurrentParameter;

    public void install(IContextInformation iContextInformation, ITextViewer iTextViewer, int n) {
        this.fPosition = n;
        this.fViewer = iTextViewer;
        this.fInformation = iContextInformation;
        this.fCurrentParameter = -1;
    }

    private int getCommentEnd(IDocument iDocument, int n, int n2) throws BadLocationException {
        while (n < n2) {
            char c = iDocument.getChar(n);
            if (c != '*' || ++n >= n2 || iDocument.getChar(n) != '/') continue;
            return n + 1;
        }
        return n2;
    }

    private int getStringEnd(IDocument iDocument, int n, int n2, char c) throws BadLocationException {
        while (n < n2) {
            char c2 = iDocument.getChar(n);
            ++n;
            if (c2 == '\\') {
                ++n;
                continue;
            }
            if (c2 != c) continue;
            return n;
        }
        return n2;
    }

    private int getCharCount(IDocument iDocument, int n, int n2, String string, String string2, boolean bl) throws BadLocationException {
        Assert.isTrue(((string.length() != 0 || string2.length() != 0) && !string.equals(string2) ? 1 : 0) != 0);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = n;
        block13: while (n6 < n2) {
            char c = iDocument.getChar(n6++);
            switch (c) {
                case '/': {
                    if (n6 >= n2) continue block13;
                    char c2 = iDocument.getChar(n6);
                    if (c2 == '*') {
                        n6 = this.getCommentEnd(iDocument, n6 + 1, n2);
                        break;
                    }
                    if (c2 != '/') continue block13;
                    n6 = n2;
                    break;
                }
                case '*': {
                    char c2;
                    if (n6 >= n2 || (c2 = iDocument.getChar(n6)) != '/') continue block13;
                    n5 = 0;
                    ++n6;
                    break;
                }
                case '\"': 
                case '\'': {
                    n6 = this.getStringEnd(iDocument, n6, n2, c);
                    break;
                }
                case '[': {
                    if (bl) {
                        if (n3 != 1 && n3 != 0) continue block13;
                        n3 = 1;
                        ++n4;
                        break;
                    }
                }
                case ']': {
                    if (bl) {
                        if (n3 != true || --n4 != 0) continue block13;
                        n3 = 0;
                        break;
                    }
                }
                case '(': {
                    if (bl) {
                        if (n3 == 4) {
                            n3 = 3;
                            n4 = 1;
                        }
                        if (n3 != 3 && n3 != 0) continue block13;
                        n3 = 3;
                        ++n4;
                        break;
                    }
                }
                case ')': {
                    if (bl) {
                        if (n3 != 3 || --n4 != 0) continue block13;
                        n3 = 0;
                        break;
                    }
                }
                case '{': {
                    if (bl) {
                        if (n3 == 4) {
                            n3 = 2;
                            n4 = 1;
                        }
                        if (n3 != 2 && n3 != 0) continue block13;
                        n3 = 2;
                        ++n4;
                        break;
                    }
                }
                case '}': {
                    if (bl) {
                        if (n3 != 2 || --n4 != 0) continue block13;
                        n3 = 0;
                        break;
                    }
                }
                case '<': {
                    if (bl) {
                        if (n3 != 4 && (n3 != 0 || !this.checkGenericsHeuristic(iDocument, n6 - 1, n - 1))) continue block13;
                        n3 = 4;
                        ++n4;
                        break;
                    }
                }
                case '>': {
                    if (bl) {
                        if (n3 != 4 || --n4 != 0) continue block13;
                        n3 = 0;
                        break;
                    }
                }
                default: {
                    if (n4 != 0) continue block13;
                    if (string.indexOf(c) >= 0) {
                        ++n5;
                    }
                    if (string2.indexOf(c) < 0) continue block13;
                    --n5;
                }
            }
        }
        return n5;
    }

    private boolean checkGenericsHeuristic(IDocument iDocument, int n, int n2) throws BadLocationException {
        JavaHeuristicScanner javaHeuristicScanner = new JavaHeuristicScanner(iDocument);
        return javaHeuristicScanner.looksLikeClassInstanceCreationBackward(n, n2);
    }

    public boolean isContextInformationValid(int n) {
        IDocument iDocument;
        block5: {
            block4: {
                try {
                    if (n >= this.fPosition) break block4;
                    return false;
                }
                catch (BadLocationException badLocationException) {
                    return false;
                }
            }
            iDocument = this.fViewer.getDocument();
            IRegion iRegion = iDocument.getLineInformationOfOffset(this.fPosition);
            if (n >= iRegion.getOffset() && n < iDocument.getLength()) break block5;
            return false;
        }
        return this.getCharCount(iDocument, this.fPosition, n, "(<", ")>", false) >= 0;
    }

    public boolean updatePresentation(int n, TextPresentation textPresentation) {
        int n2 = -1;
        try {
            n2 = this.getCharCount(this.fViewer.getDocument(), this.fPosition, n, ",", "", true);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        if (this.fCurrentParameter != -1 && n2 == this.fCurrentParameter) {
            return false;
        }
        textPresentation.clear();
        this.fCurrentParameter = n2;
        String string = this.fInformation.getInformationDisplayString();
        int[] nArray = this.computeCommaPositions(string);
        if (nArray.length - 2 < this.fCurrentParameter) {
            textPresentation.addStyleRange(new StyleRange(0, string.length(), null, null, 0));
            return true;
        }
        int n3 = nArray[this.fCurrentParameter] + 1;
        int n4 = nArray[this.fCurrentParameter + 1];
        if (n3 > 0) {
            textPresentation.addStyleRange(new StyleRange(0, n3, null, null, 0));
        }
        if (n4 > n3) {
            textPresentation.addStyleRange(new StyleRange(n3, n4 - n3, null, null, 1));
        }
        if (n4 < string.length()) {
            textPresentation.addStyleRange(new StyleRange(n4, string.length() - n4, null, null, 0));
        }
        return true;
    }

    private int[] computeCommaPositions(String string) {
        int n = string.length();
        int n2 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(new Integer(-1));
        while (n2 < n && n2 != -1) {
            char c = string.charAt(n2);
            switch (c) {
                case ',': {
                    arrayList.add(new Integer(n2));
                    break;
                }
                case '<': {
                    n2 = string.indexOf(62, n2);
                    break;
                }
                case '[': {
                    n2 = string.indexOf(93, n2);
                    break;
                }
            }
            if (n2 == -1) continue;
            ++n2;
        }
        arrayList.add(new Integer(n));
        int[] nArray = new int[arrayList.size()];
        int n3 = 0;
        while (n3 < nArray.length) {
            nArray[n3] = (Integer)arrayList.get(n3);
            ++n3;
        }
        return nArray;
    }
}

