/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaCompletionProposal;

public class JavaTypeCompletionProposal
extends JavaCompletionProposal {
    protected final ICompilationUnit fCompilationUnit;
    private final String fUnqualifiedTypeName;
    private final String fFullyQualifiedTypeName;

    public JavaTypeCompletionProposal(String string, ICompilationUnit iCompilationUnit, int n, int n2, Image image, String string2, int n3) {
        this(string, iCompilationUnit, n, n2, image, string2, n3, null);
    }

    public JavaTypeCompletionProposal(String string, ICompilationUnit iCompilationUnit, int n, int n2, Image image, String string2, int n3, String string3) {
        super(string, n, n2, image, string2, n3);
        this.fCompilationUnit = iCompilationUnit;
        this.fFullyQualifiedTypeName = string3;
        this.fUnqualifiedTypeName = string3 != null ? Signature.getSimpleName((String)string3) : null;
    }

    protected boolean updateReplacementString(IDocument iDocument, char c, int n, ImportRewrite importRewrite) throws CoreException, BadLocationException {
        if (importRewrite != null && this.fFullyQualifiedTypeName != null) {
            IType[] iTypeArray;
            String string = this.getReplacementString();
            String string2 = this.fFullyQualifiedTypeName;
            if (string2.indexOf(46) != -1 && string.startsWith(string2) && !string.endsWith(String.valueOf(';')) && (iTypeArray = importRewrite.getCompilationUnit().getTypes()).length > 0 && iTypeArray[0].getSourceRange().getOffset() <= n) {
                this.setReplacementString(importRewrite.addImport(this.getReplacementString()));
                return true;
            }
        }
        return false;
    }

    public void apply(IDocument iDocument, char c, int n) {
        try {
            boolean bl;
            ImportRewrite importRewrite = null;
            if (this.fCompilationUnit != null && this.allowAddingImports()) {
                importRewrite = StubUtility.createImportRewrite(this.fCompilationUnit, true);
            }
            if (bl = this.updateReplacementString(iDocument, c, n, importRewrite)) {
                this.setCursorPosition(this.getReplacementString().length());
            }
            super.apply(iDocument, c, n);
            if (bl && importRewrite != null) {
                int n2 = iDocument.getLength();
                importRewrite.rewriteImports((IProgressMonitor)new NullProgressMonitor()).apply(iDocument, 2);
                this.setReplacementOffset(this.getReplacementOffset() + iDocument.getLength() - n2);
            }
        }
        catch (CoreException coreException) {
            JavaPlugin.log(coreException);
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
        }
    }

    private boolean allowAddingImports() {
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        return iPreferenceStore.getBoolean("content_assist_add_import");
    }

    protected boolean isValidPrefix(String string) {
        return super.isValidPrefix(string) || this.isPrefix(string, this.fUnqualifiedTypeName) || this.isPrefix(string, this.fFullyQualifiedTypeName);
    }

    public CharSequence getPrefixCompletionText(IDocument iDocument, int n) {
        return this.fUnqualifiedTypeName;
    }
}

