/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.wst.jsdt.ui.text.java.JavaContentAssistInvocationContext;

public class LazyJavaCompletionProposal
extends AbstractJavaCompletionProposal {
    protected static final String LPAREN = "(";
    protected static final String RPAREN = ")";
    protected static final String COMMA = ",";
    protected static final String SPACE = " ";
    private boolean fDisplayStringComputed;
    private boolean fReplacementStringComputed;
    private boolean fReplacementOffsetComputed;
    private boolean fReplacementLengthComputed;
    private boolean fCursorPositionComputed;
    private boolean fImageComputed;
    private boolean fContextInformationComputed;
    private boolean fProposalInfoComputed;
    private boolean fTriggerCharactersComputed;
    private boolean fSortStringComputed;
    private boolean fRelevanceComputed;
    private FormatterPrefs fFormatterPrefs;
    protected final CompletionProposal fProposal;
    protected int fContextInformationPosition;

    public LazyJavaCompletionProposal(CompletionProposal completionProposal, JavaContentAssistInvocationContext javaContentAssistInvocationContext) {
        super(javaContentAssistInvocationContext);
        Assert.isNotNull((Object)completionProposal);
        Assert.isNotNull((Object)javaContentAssistInvocationContext);
        Assert.isNotNull((Object)javaContentAssistInvocationContext.getCoreContext());
        this.fProposal = completionProposal;
    }

    public final char[] getTriggerCharacters() {
        if (!this.fTriggerCharactersComputed) {
            this.setTriggerCharacters(this.computeTriggerCharacters());
        }
        return super.getTriggerCharacters();
    }

    protected char[] computeTriggerCharacters() {
        return new char[0];
    }

    public final void setTriggerCharacters(char[] cArray) {
        this.fTriggerCharactersComputed = true;
        super.setTriggerCharacters(cArray);
    }

    public final void setProposalInfo(ProposalInfo proposalInfo) {
        this.fProposalInfoComputed = true;
        super.setProposalInfo(proposalInfo);
    }

    protected final ProposalInfo getProposalInfo() {
        if (!this.fProposalInfoComputed) {
            this.setProposalInfo(this.computeProposalInfo());
        }
        return super.getProposalInfo();
    }

    protected ProposalInfo computeProposalInfo() {
        return null;
    }

    public final void setCursorPosition(int n) {
        this.fCursorPositionComputed = true;
        super.setCursorPosition(n);
    }

    protected final int getCursorPosition() {
        if (!this.fCursorPositionComputed) {
            this.setCursorPosition(this.computeCursorPosition());
        }
        return super.getCursorPosition();
    }

    protected int computeCursorPosition() {
        return this.getReplacementString().length();
    }

    protected final boolean isInJavadoc() {
        return this.fInvocationContext.getCoreContext().isInJavadoc();
    }

    public final IContextInformation getContextInformation() {
        if (!this.fContextInformationComputed) {
            this.setContextInformation(this.computeContextInformation());
        }
        return super.getContextInformation();
    }

    protected IContextInformation computeContextInformation() {
        return null;
    }

    public final void setContextInformation(IContextInformation iContextInformation) {
        this.fContextInformationComputed = true;
        super.setContextInformation(iContextInformation);
    }

    public final String getDisplayString() {
        if (!this.fDisplayStringComputed) {
            this.setDisplayString(this.computeDisplayString());
        }
        return super.getDisplayString();
    }

    protected final void setDisplayString(String string) {
        this.fDisplayStringComputed = true;
        super.setDisplayString(string);
    }

    protected String computeDisplayString() {
        return this.fInvocationContext.getLabelProvider().createLabel(this.fProposal);
    }

    public final String getAdditionalProposalInfo() {
        return super.getAdditionalProposalInfo();
    }

    public final int getContextInformationPosition() {
        if (this.getContextInformation() == null) {
            return this.getReplacementOffset() - 1;
        }
        return this.getReplacementOffset() + this.getCursorPosition();
    }

    public final int getReplacementOffset() {
        if (!this.fReplacementOffsetComputed) {
            this.setReplacementOffset(this.fProposal.getReplaceStart());
        }
        return super.getReplacementOffset();
    }

    public final void setReplacementOffset(int n) {
        this.fReplacementOffsetComputed = true;
        super.setReplacementOffset(n);
    }

    public final int getPrefixCompletionStart(IDocument iDocument, int n) {
        return this.getReplacementOffset();
    }

    public final int getReplacementLength() {
        if (!this.fReplacementLengthComputed) {
            this.setReplacementLength(this.fProposal.getReplaceEnd() - this.fProposal.getReplaceStart());
        }
        return super.getReplacementLength();
    }

    public final void setReplacementLength(int n) {
        this.fReplacementLengthComputed = true;
        super.setReplacementLength(n);
    }

    public final String getReplacementString() {
        if (!this.fReplacementStringComputed) {
            this.setReplacementString(this.computeReplacementString());
        }
        return super.getReplacementString();
    }

    protected String computeReplacementString() {
        return String.valueOf(this.fProposal.getCompletion());
    }

    public final void setReplacementString(String string) {
        this.fReplacementStringComputed = true;
        super.setReplacementString(string);
    }

    public final Image getImage() {
        if (!this.fImageComputed) {
            this.setImage(this.computeImage());
        }
        return super.getImage();
    }

    protected Image computeImage() {
        return JavaPlugin.getImageDescriptorRegistry().get(this.fInvocationContext.getLabelProvider().createImageDescriptor(this.fProposal));
    }

    public final void setImage(Image image) {
        this.fImageComputed = true;
        super.setImage(image);
    }

    protected boolean isValidPrefix(String string) {
        if (super.isValidPrefix(string)) {
            return true;
        }
        if (this.fProposal.getKind() == 12) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Signature.toCharArray((char[])this.fProposal.getDeclarationSignature()));
            stringBuffer.append('.');
            stringBuffer.append(this.getDisplayString());
            return this.isPrefix(string, stringBuffer.toString());
        }
        return false;
    }

    public final int getRelevance() {
        if (!this.fRelevanceComputed) {
            this.setRelevance(this.computeRelevance());
        }
        return super.getRelevance();
    }

    public final void setRelevance(int n) {
        this.fRelevanceComputed = true;
        super.setRelevance(n);
    }

    protected int computeRelevance() {
        int n = this.fProposal.getRelevance() * 16;
        switch (this.fProposal.getKind()) {
            case 8: {
                return n + 0;
            }
            case 4: {
                return n + 1;
            }
            case 3: {
                return n + 2;
            }
            case 1: 
            case 9: {
                return n + 3;
            }
            case 6: 
            case 7: 
            case 12: 
            case 13: {
                return n + 4;
            }
            case 11: {
                return n + 4;
            }
            case 2: {
                return n + 5;
            }
            case 5: 
            case 10: {
                return n + 6;
            }
        }
        return n;
    }

    public final String getSortString() {
        if (!this.fSortStringComputed) {
            this.setSortString(this.computeSortString());
        }
        return super.getSortString();
    }

    protected final void setSortString(String string) {
        this.fSortStringComputed = true;
        super.setSortString(string);
    }

    protected String computeSortString() {
        return this.getDisplayString();
    }

    protected FormatterPrefs getFormatterPrefs() {
        if (this.fFormatterPrefs == null) {
            ICompilationUnit iCompilationUnit = this.fInvocationContext.getCompilationUnit();
            this.fFormatterPrefs = new FormatterPrefs(iCompilationUnit == null ? null : iCompilationUnit.getJavaProject());
        }
        return this.fFormatterPrefs;
    }

    public void setContextInformationPosition(int n) {
        this.fContextInformationPosition = n;
    }

    protected static final class FormatterPrefs {
        public final boolean beforeOpeningParen;
        public final boolean afterOpeningParen;
        public final boolean beforeComma;
        public final boolean afterComma;
        public final boolean beforeClosingParen;
        public final boolean inEmptyList;
        public final boolean beforeOpeningBracket;
        public final boolean afterOpeningBracket;
        public final boolean beforeTypeArgumentComma;
        public final boolean afterTypeArgumentComma;
        public final boolean beforeClosingBracket;

        FormatterPrefs(IJavaProject iJavaProject) {
            this.beforeOpeningParen = this.getCoreOption(iJavaProject, "org.eclipse.wst.jsdt.core.formatter.insert_space_before_opening_paren_in_method_invocation", false);
            this.afterOpeningParen = this.getCoreOption(iJavaProject, "org.eclipse.wst.jsdt.core.formatter.insert_space_after_opening_paren_in_method_invocation", false);
            this.beforeComma = this.getCoreOption(iJavaProject, "org.eclipse.wst.jsdt.core.formatter.insert_space_before_comma_in_method_invocation_arguments", false);
            this.afterComma = this.getCoreOption(iJavaProject, "org.eclipse.wst.jsdt.core.formatter.insert_space_after_comma_in_method_invocation_arguments", true);
            this.beforeClosingParen = this.getCoreOption(iJavaProject, "org.eclipse.wst.jsdt.core.formatter.insert_space_before_closing_paren_in_method_invocation", false);
            this.inEmptyList = this.getCoreOption(iJavaProject, "org.eclipse.wst.jsdt.core.formatter.insert_space_between_empty_parens_in_method_invocation", false);
            this.beforeOpeningBracket = this.getCoreOption(iJavaProject, "org.eclipse.wst.jsdt.core.formatter.insert_space_before_opening_angle_bracket_in_parameterized_type_reference", false);
            this.afterOpeningBracket = this.getCoreOption(iJavaProject, "org.eclipse.wst.jsdt.core.formatter.insert_space_after_opening_angle_bracket_in_parameterized_type_reference", false);
            this.beforeTypeArgumentComma = this.getCoreOption(iJavaProject, "org.eclipse.wst.jsdt.core.formatter.insert_space_before_comma_in_parameterized_type_reference", false);
            this.afterTypeArgumentComma = this.getCoreOption(iJavaProject, "org.eclipse.wst.jsdt.core.formatter.insert_space_after_comma_in_parameterized_type_reference", true);
            this.beforeClosingBracket = this.getCoreOption(iJavaProject, "org.eclipse.wst.jsdt.core.formatter.insert_space_before_closing_angle_bracket_in_parameterized_type_reference", false);
        }

        protected final boolean getCoreOption(IJavaProject iJavaProject, String string, boolean bl) {
            String string2 = this.getCoreOption(iJavaProject, string);
            if ("insert".equals(string2)) {
                return true;
            }
            if ("do not insert".equals(string2)) {
                return false;
            }
            return bl;
        }

        protected final String getCoreOption(IJavaProject iJavaProject, String string) {
            if (iJavaProject == null) {
                return JavaCore.getOption((String)string);
            }
            return iJavaProject.getOption(string, true);
        }
    }
}

