/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.javadoc.JavaDoc2HTMLTextReader;
import org.eclipse.wst.jsdt.ui.JavadocContentAccess;

public class ProposalInfo {
    private boolean fJavadocResolved = false;
    private String fJavadoc = null;
    protected IJavaElement fElement;

    public ProposalInfo(IMember iMember) {
        this.fElement = iMember;
    }

    protected ProposalInfo() {
        this.fElement = null;
    }

    public IJavaElement getJavaElement() throws JavaModelException {
        return this.fElement;
    }

    public final String getInfo(IProgressMonitor iProgressMonitor) {
        if (!this.fJavadocResolved) {
            this.fJavadocResolved = true;
            this.fJavadoc = this.computeInfo(iProgressMonitor);
        }
        return this.fJavadoc;
    }

    private String computeInfo(IProgressMonitor iProgressMonitor) {
        try {
            IJavaElement iJavaElement = this.getJavaElement();
            if (iJavaElement instanceof IMember) {
                IMember iMember = (IMember)iJavaElement;
                return this.extractJavadoc(iMember, iProgressMonitor);
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
        catch (IOException iOException) {
            JavaPlugin.log(iOException);
        }
        return null;
    }

    private String extractJavadoc(IMember iMember, IProgressMonitor iProgressMonitor) throws JavaModelException, IOException {
        Reader reader;
        if (iMember != null && (reader = this.getHTMLContentReader(iMember, iProgressMonitor)) != null) {
            return ProposalInfo.getString(reader);
        }
        return null;
    }

    private Reader getHTMLContentReader(IMember iMember, IProgressMonitor iProgressMonitor) throws JavaModelException {
        String string;
        Reader reader = JavadocContentAccess.getContentReader(iMember, true);
        if (reader != null) {
            return new JavaDoc2HTMLTextReader(reader);
        }
        if (iMember.getOpenable().getBuffer() == null && (string = iMember.getAttachedJavadoc(iProgressMonitor)) != null) {
            return new StringReader(string);
        }
        return null;
    }

    private static String getString(Reader reader) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[1024];
        try {
            int n;
            while ((n = reader.read(cArray)) != -1) {
                stringBuffer.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return stringBuffer.toString();
    }
}

