/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java.hover;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitDocumentProvider;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaMarkerAnnotation;
import org.eclipse.wst.jsdt.internal.ui.text.correction.JavaCorrectionProcessor;
import org.eclipse.wst.jsdt.internal.ui.text.java.hover.AnnotationExpandHover;
import org.eclipse.wst.jsdt.internal.ui.text.java.hover.AnnotationExpansionControl;
import org.eclipse.wst.jsdt.internal.ui.text.java.hover.JavaHoverMessages;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;

public class JavaExpandHover
extends AnnotationExpandHover {
    public static final String NO_BREAKPOINT_ANNOTATION = "org.eclipse.wst.jsdt.internal.ui.NoBreakpointAnnotation";
    private AnnotationPreferenceLookup fLookup = new AnnotationPreferenceLookup();
    private IPreferenceStore fStore = JavaPlugin.getDefault().getCombinedPreferenceStore();

    public JavaExpandHover(CompositeRuler compositeRuler, IAnnotationAccess iAnnotationAccess, IDoubleClickListener iDoubleClickListener) {
        super(compositeRuler, iAnnotationAccess, iDoubleClickListener);
    }

    protected Object getHoverInfoForLine(final ISourceViewer iSourceViewer, final int n) {
        Object object;
        boolean bl = PreferenceConstants.getPreferenceStore().getBoolean("JavaEditor.ShowTemporaryProblem");
        IAnnotationModel iAnnotationModel = iSourceViewer.getAnnotationModel();
        IDocument iDocument = iSourceViewer.getDocument();
        if (iAnnotationModel == null) {
            return null;
        }
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        HashMap hashMap = new HashMap();
        Iterator iterator = iAnnotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            String string;
            AnnotationPreference annotationPreference;
            object = (Annotation)iterator.next();
            if (this.fAnnotationAccess instanceof IAnnotationAccessExtension && !((IAnnotationAccessExtension)this.fAnnotationAccess).isPaintable(object) || object instanceof IJavaAnnotation && !this.isIncluded((IJavaAnnotation)object, bl) || (annotationPreference = this.fLookup.getAnnotationPreference(object)) != null && (string = annotationPreference.getVerticalRulerPreferenceKey()) != null && !this.fStore.getBoolean(string) || (string = iAnnotationModel.getPosition(object)) == null || this.compareRulerLine((Position)string, iDocument, n) != 1 || this.isDuplicateMessage(hashMap, (Position)string, object.getText())) continue;
            arrayList.add((Annotation)object);
        }
        this.sort(arrayList, iAnnotationModel);
        if (arrayList.size() > 0) {
            this.setLastRulerMouseLocation(iSourceViewer, n);
        }
        if (arrayList.size() > 0 && !this.isBreakpointAnnotation((Annotation)(object = (Annotation)arrayList.get(0)))) {
            arrayList.add(0, new NoBreakpointAnnotation());
        }
        if (arrayList.size() <= 1) {
            return null;
        }
        object = new AnnotationExpansionControl.AnnotationHoverInput();
        object.fAnnotations = arrayList.toArray(new Annotation[0]);
        object.fViewer = iSourceViewer;
        object.fRulerInfo = this.fCompositeRuler;
        object.fAnnotationListener = this.fgListener;
        object.fDoubleClickListener = this.fDblClickListener;
        object.redoAction = new AnnotationExpansionControl.ICallback(){

            public void run(IInformationControlExtension2 iInformationControlExtension2) {
                iInformationControlExtension2.setInput(JavaExpandHover.this.getHoverInfoForLine(iSourceViewer, n));
            }
        };
        object.model = iAnnotationModel;
        return object;
    }

    private boolean isIncluded(IJavaAnnotation iJavaAnnotation, boolean bl) {
        if (iJavaAnnotation instanceof CompilationUnitDocumentProvider.ProblemAnnotation && "org.eclipse.ui.workbench.texteditor.task".equals(iJavaAnnotation.getType())) {
            return false;
        }
        if (!iJavaAnnotation.isProblem()) {
            return true;
        }
        if (iJavaAnnotation.isMarkedDeleted() && !iJavaAnnotation.hasOverlay()) {
            return true;
        }
        if (iJavaAnnotation.hasOverlay() && !iJavaAnnotation.isMarkedDeleted()) {
            return true;
        }
        if (iJavaAnnotation.hasOverlay()) {
            return !this.isIncluded(iJavaAnnotation.getOverlay(), bl);
        }
        return bl && JavaCorrectionProcessor.hasCorrections((Annotation)iJavaAnnotation);
    }

    protected int getOrder(Annotation annotation) {
        if (this.isBreakpointAnnotation(annotation)) {
            return 1000;
        }
        return super.getOrder(annotation);
    }

    private boolean isBreakpointAnnotation(Annotation annotation) {
        if (annotation instanceof JavaMarkerAnnotation) {
            JavaMarkerAnnotation javaMarkerAnnotation = (JavaMarkerAnnotation)annotation;
            return javaMarkerAnnotation.getType().equals("org.eclipse.debug.core.breakpoint");
        }
        return false;
    }

    private static class NoBreakpointAnnotation
    extends Annotation
    implements IAnnotationPresentation {
        public NoBreakpointAnnotation() {
            super(JavaExpandHover.NO_BREAKPOINT_ANNOTATION, false, JavaHoverMessages.NoBreakpointAnnotation_addBreakpoint);
        }

        public void paint(GC gC, Canvas canvas, Rectangle rectangle) {
            Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.field_public_obj.gif");
            ImageUtilities.drawImage((Image)image, (GC)gC, (Canvas)canvas, (Rectangle)rectangle, (int)0x1000000);
        }

        public int getLayer() {
            return 0;
        }
    }
}

