/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.spelling;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.text.javadoc.IHtmlTagConstants;
import org.eclipse.wst.jsdt.ui.text.java.IInvocationContext;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposal;

public class WordCorrectionProposal
implements IJavaCompletionProposal {
    private final IInvocationContext fContext;
    private final int fLength;
    private final String fLine;
    private final int fOffset;
    private final int fRelevance;
    private final String fWord;

    public static String getHtmlRepresentation(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = n - 1;
        while (n2 >= 0) {
            int n3 = 0;
            while (n3 < IHtmlTagConstants.HTML_ENTITY_CHARACTERS.length) {
                if (string.charAt(n2) == IHtmlTagConstants.HTML_ENTITY_CHARACTERS[n3]) {
                    stringBuffer.replace(n2, n2 + 1, String.valueOf(IHtmlTagConstants.HTML_ENTITY_CODES[n3]));
                    break;
                }
                ++n3;
            }
            --n2;
        }
        return stringBuffer.toString();
    }

    public WordCorrectionProposal(String string, String[] stringArray, int n, int n2, IInvocationContext iInvocationContext, int n3) {
        this.fWord = Character.isUpperCase(stringArray[0].charAt(0)) ? String.valueOf(Character.toUpperCase(string.charAt(0))) + string.substring(1) : string;
        this.fOffset = n;
        this.fLength = n2;
        this.fContext = iInvocationContext;
        this.fRelevance = n3;
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append("...<br>");
        stringBuffer.append(WordCorrectionProposal.getHtmlRepresentation(stringArray[1]));
        stringBuffer.append("<b>");
        stringBuffer.append(WordCorrectionProposal.getHtmlRepresentation(this.fWord));
        stringBuffer.append("</b>");
        stringBuffer.append(WordCorrectionProposal.getHtmlRepresentation(stringArray[2]));
        stringBuffer.append("<br>...");
        this.fLine = stringBuffer.toString();
    }

    public final void apply(IDocument iDocument) {
        try {
            iDocument.replace(this.fOffset, this.fLength, this.fWord);
        }
        catch (BadLocationException badLocationException) {}
    }

    public String getAdditionalProposalInfo() {
        return this.fLine;
    }

    public final IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return Messages.format(JavaUIMessages.Spelling_correct_label, new String[]{this.fWord});
    }

    public Image getImage() {
        return JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_rename.gif");
    }

    public final int getRelevance() {
        return this.fRelevance;
    }

    public final Point getSelection(IDocument iDocument) {
        int n = this.fContext.getSelectionOffset();
        int n2 = this.fContext.getSelectionLength();
        int n3 = this.fWord.length() - this.fLength;
        if (n <= this.fOffset && n + n2 >= this.fOffset) {
            n2 += n3;
        } else if (n > this.fOffset && n + n2 > this.fOffset + this.fLength) {
            n += n3;
            n2 -= n3;
        } else {
            n2 += n3;
        }
        return new Point(n, n2);
    }
}

