/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.template.contentassist;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.jsdt.internal.ui.text.template.contentassist.MultiVariable;
import org.eclipse.wst.jsdt.internal.ui.text.template.contentassist.VariablePosition;

public class MultiVariableGuess {
    private final Map fDependencies = new HashMap();
    private final Map fBackwardDeps = new HashMap();
    private final Map fPositions = new HashMap();

    public ICompletionProposal[] getProposals(final MultiVariable multiVariable, int n, int n2) {
        MultiVariable multiVariable2 = (MultiVariable)((Object)this.fBackwardDeps.get((Object)multiVariable));
        Object[] objectArray = multiVariable2 == null ? multiVariable.getChoices() : multiVariable.getChoices(multiVariable2.getCurrentChoice());
        if (objectArray == null) {
            return null;
        }
        if (this.fDependencies.containsKey((Object)multiVariable)) {
            ICompletionProposal[] iCompletionProposalArray = new ICompletionProposal[objectArray.length];
            int n3 = 0;
            while (n3 < iCompletionProposalArray.length) {
                final Object object = objectArray[n3];
                iCompletionProposalArray[n3] = new Proposal(multiVariable.toString(object), n, n2, n + n2){

                    public void apply(IDocument iDocument) {
                        super.apply(iDocument);
                        Object object2 = multiVariable.getCurrentChoice();
                        multiVariable.setCurrentChoice(object);
                        MultiVariableGuess.this.updateSlaves(multiVariable, iDocument, object2);
                    }
                };
                ++n3;
            }
            return iCompletionProposalArray;
        }
        if (objectArray.length < 2) {
            return null;
        }
        ICompletionProposal[] iCompletionProposalArray = new ICompletionProposal[objectArray.length];
        int n4 = 0;
        while (n4 < iCompletionProposalArray.length) {
            iCompletionProposalArray[n4] = new Proposal(multiVariable.toString(objectArray[n4]), n, n2, n + n2);
            ++n4;
        }
        return iCompletionProposalArray;
    }

    private void updateSlaves(MultiVariable multiVariable, IDocument iDocument, Object object) {
        Object object2 = multiVariable.getCurrentChoice();
        if (!object.equals(object2)) {
            Set set = (Set)this.fDependencies.get((Object)multiVariable);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                MultiVariable multiVariable2 = (MultiVariable)((Object)iterator.next());
                VariablePosition variablePosition = (VariablePosition)((Object)this.fPositions.get((Object)multiVariable2));
                Object object3 = multiVariable2.getCurrentChoice();
                multiVariable2.setKey(object2);
                try {
                    iDocument.replace(variablePosition.getOffset(), variablePosition.getLength(), multiVariable2.getDefaultValue());
                }
                catch (BadLocationException badLocationException) {}
                if (!this.fDependencies.containsKey((Object)multiVariable2)) continue;
                this.updateSlaves(multiVariable2, iDocument, object3);
            }
        }
    }

    public void addSlave(VariablePosition variablePosition) {
        this.fPositions.put(variablePosition.getVariable(), variablePosition);
    }

    public void addDependency(MultiVariable multiVariable, MultiVariable multiVariable2) {
        if (this.fBackwardDeps.containsKey((Object)multiVariable2)) {
            throw new IllegalArgumentException("slave can only serve one master");
        }
        MultiVariable multiVariable3 = multiVariable;
        while (multiVariable3 != null) {
            if ((multiVariable3 = this.fBackwardDeps.get((Object)multiVariable3)) != multiVariable2) continue;
            throw new IllegalArgumentException("cycle detected");
        }
        HashSet<MultiVariable> hashSet = (HashSet<MultiVariable>)this.fDependencies.get((Object)multiVariable);
        if (hashSet == null) {
            hashSet = new HashSet<MultiVariable>();
            this.fDependencies.put(multiVariable, hashSet);
        }
        this.fBackwardDeps.put(multiVariable2, multiVariable);
        hashSet.add(multiVariable2);
    }

    private static class Proposal
    implements ICompletionProposal,
    ICompletionProposalExtension2 {
        private String fDisplayString;
        String fReplacementString;
        private int fReplacementOffset;
        private int fReplacementLength;
        private int fCursorPosition;
        private Image fImage;
        private IContextInformation fContextInformation;
        private String fAdditionalProposalInfo;

        public Proposal(String string, int n, int n2, int n3) {
            this(string, n, n2, n3, null, null, null, null);
        }

        public Proposal(String string, int n, int n2, int n3, Image image, String string2, IContextInformation iContextInformation, String string3) {
            Assert.isNotNull((Object)string);
            Assert.isTrue((n >= 0 ? 1 : 0) != 0);
            Assert.isTrue((n2 >= 0 ? 1 : 0) != 0);
            Assert.isTrue((n3 >= 0 ? 1 : 0) != 0);
            this.fReplacementString = string;
            this.fReplacementOffset = n;
            this.fReplacementLength = n2;
            this.fCursorPosition = n3;
            this.fImage = image;
            this.fDisplayString = string2;
            this.fContextInformation = iContextInformation;
            this.fAdditionalProposalInfo = string3;
        }

        public void apply(IDocument iDocument) {
            try {
                iDocument.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
            }
            catch (BadLocationException badLocationException) {}
        }

        public Point getSelection(IDocument iDocument) {
            return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
        }

        public IContextInformation getContextInformation() {
            return this.fContextInformation;
        }

        public Image getImage() {
            return this.fImage;
        }

        public String getDisplayString() {
            if (this.fDisplayString != null) {
                return this.fDisplayString;
            }
            return this.fReplacementString;
        }

        public String getAdditionalProposalInfo() {
            return this.fAdditionalProposalInfo;
        }

        public void apply(ITextViewer iTextViewer, char c, int n, int n2) {
            this.apply(iTextViewer.getDocument());
        }

        public void selected(ITextViewer iTextViewer, boolean bl) {
        }

        public void unselected(ITextViewer iTextViewer) {
        }

        public boolean validate(IDocument iDocument, int n, DocumentEvent documentEvent) {
            try {
                String string = iDocument.get(this.fReplacementOffset, this.fReplacementLength);
                if (string.startsWith(this.fReplacementString)) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {}
            return false;
        }
    }
}

