/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.typehierarchy;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.keys.KeySequence;
import org.eclipse.ui.keys.KeyStroke;
import org.eclipse.ui.keys.SWTKeySupport;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.AbstractInformationControl;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.HierarchyLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.HierarchyViewerSorter;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.SuperTypeHierarchyViewer;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TraditionalHierarchyViewer;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyContentProvider;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyMessages;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredViewersManager;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;
import org.eclipse.wst.jsdt.ui.ProblemsLabelDecorator;

public class HierarchyInformationControl
extends AbstractInformationControl {
    private TypeHierarchyLifeCycle fLifeCycle;
    private HierarchyLabelProvider fLabelProvider;
    private KeyAdapter fKeyAdapter;
    private Object[] fOtherExpandedElements = null;
    private TypeHierarchyContentProvider fOtherContentProvider;
    private IMethod fFocus;
    private boolean fDoFilter = true;
    private MethodOverrideTester fMethodOverrideTester = null;

    public HierarchyInformationControl(Shell shell, int n, int n2) {
        super(shell, n, n2, "org.eclipse.wst.jsdt.ui.edit.text.java.open.hierarchy", true);
    }

    private KeyAdapter getKeyAdapter() {
        if (this.fKeyAdapter == null) {
            this.fKeyAdapter = new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    int n = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)keyEvent);
                    KeySequence keySequence = KeySequence.getInstance((KeyStroke)SWTKeySupport.convertAcceleratorToKeyStroke((int)n));
                    KeySequence[] keySequenceArray = HierarchyInformationControl.this.getInvokingCommandKeySequences();
                    if (keySequenceArray == null) {
                        return;
                    }
                    int n2 = 0;
                    while (n2 < keySequenceArray.length) {
                        if (keySequenceArray[n2].equals((Object)keySequence)) {
                            keyEvent.doit = false;
                            HierarchyInformationControl.this.toggleHierarchy();
                            return;
                        }
                        ++n2;
                    }
                }
            };
        }
        return this.fKeyAdapter;
    }

    protected boolean hasHeader() {
        return true;
    }

    protected Text createFilterText(Composite composite) {
        Text text = super.createFilterText(composite);
        text.addKeyListener((KeyListener)this.getKeyAdapter());
        return text;
    }

    protected TreeViewer createTreeViewer(Composite composite, int n) {
        Tree tree = new Tree(composite, 4 | n & 0xFFFFFFFD);
        GridData gridData = new GridData(1808);
        gridData.heightHint = tree.getItemHeight() * 12;
        tree.setLayoutData((Object)gridData);
        TreeViewer treeViewer = new TreeViewer(tree);
        ColoredViewersManager.install((StructuredViewer)treeViewer);
        treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object object, Object object2) {
                return object2 instanceof IType;
            }
        });
        this.fLifeCycle = new TypeHierarchyLifeCycle(false);
        treeViewer.setComparator((ViewerComparator)new HierarchyViewerSorter(this.fLifeCycle));
        treeViewer.setAutoExpandLevel(-1);
        this.fLabelProvider = new HierarchyLabelProvider(this.fLifeCycle);
        this.fLabelProvider.setFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object object, Object object2) {
                return HierarchyInformationControl.this.hasFocusMethod((IType)object2);
            }
        });
        this.fLabelProvider.setTextFlags(JavaElementLabels.ALL_DEFAULT | 0x100000L);
        this.fLabelProvider.addLabelDecorator(new ProblemsLabelDecorator(null));
        treeViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        treeViewer.getTree().addKeyListener((KeyListener)this.getKeyAdapter());
        return treeViewer;
    }

    protected boolean hasFocusMethod(IType iType) {
        if (this.fFocus == null) {
            return true;
        }
        if (iType.equals(this.fFocus.getDeclaringType())) {
            return true;
        }
        try {
            IPackageFragment iPackageFragment;
            IMethod iMethod = this.findMethod(this.fFocus, iType);
            if (iMethod != null && JavaModelUtil.isVisibleInHierarchy((IMember)iMethod, iPackageFragment = (IPackageFragment)this.fFocus.getAncestor(4))) {
                return true;
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
        return false;
    }

    private IMethod findMethod(IMethod iMethod, IType iType) throws JavaModelException {
        IType iType2;
        IType iType3 = iMethod.getDeclaringType();
        ITypeHierarchy iTypeHierarchy = this.fLifeCycle.getHierarchy();
        boolean bl = JavaModelUtil.isSuperType(iTypeHierarchy, iType, iType3);
        IType iType4 = iType2 = bl ? iType3 : iType;
        if (this.fMethodOverrideTester == null || !this.fMethodOverrideTester.getFocusType().equals(iType2)) {
            this.fMethodOverrideTester = new MethodOverrideTester(iType2, iTypeHierarchy);
        }
        if (bl) {
            return this.fMethodOverrideTester.findOverriddenMethodInType(iType, iMethod);
        }
        return this.fMethodOverrideTester.findOverridingMethodInType(iType, iMethod);
    }

    public void setInput(Object object) {
        IMember[] iMemberArray;
        Object[] objectArray;
        Object object2;
        IJavaElement iJavaElement;
        if (!(object instanceof IJavaElement)) {
            this.inputChanged(null, null);
            return;
        }
        IJavaElement iJavaElement2 = null;
        IJavaElement iJavaElement3 = null;
        try {
            iJavaElement = (IJavaElement)object;
            if (iJavaElement.getElementType() == 14) {
                iJavaElement = iJavaElement.getParent();
            }
            switch (iJavaElement.getElementType()) {
                case 2: 
                case 3: 
                case 4: 
                case 7: {
                    iJavaElement2 = iJavaElement;
                    break;
                }
                case 5: {
                    iJavaElement2 = ((ICompilationUnit)iJavaElement).findPrimaryType();
                    break;
                }
                case 6: {
                    iJavaElement2 = ((IClassFile)iJavaElement).getType();
                    break;
                }
                case 9: {
                    object2 = (IMethod)iJavaElement;
                    if (!object2.isConstructor()) {
                        iJavaElement3 = object2;
                    }
                    iJavaElement2 = object2.getDeclaringType();
                    break;
                }
                case 8: 
                case 10: {
                    iJavaElement2 = ((IMember)iJavaElement).getDeclaringType();
                    break;
                }
                case 11: {
                    iJavaElement2 = iJavaElement.getParent().getParent();
                    break;
                }
                case 13: {
                    objectArray = (Object[])iJavaElement;
                    if (objectArray.isOnDemand()) {
                        iJavaElement2 = JavaModelUtil.findTypeContainer(objectArray.getJavaProject(), Signature.getQualifier((String)objectArray.getElementName()));
                        break;
                    }
                    iJavaElement2 = objectArray.getJavaProject().findType(objectArray.getElementName());
                    break;
                }
                default: {
                    JavaPlugin.logErrorMessage("Element unsupported by the hierarchy: " + iJavaElement.getClass());
                    iJavaElement2 = null;
                    break;
                }
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
        super.setTitleText(this.getHeaderLabel(iJavaElement3 == null ? iJavaElement2 : iJavaElement3));
        try {
            this.fLifeCycle.ensureRefreshedTypeHierarchy(iJavaElement2, (IRunnableContext)JavaPlugin.getActiveWorkbenchWindow());
        }
        catch (InvocationTargetException invocationTargetException) {
            iJavaElement2 = null;
        }
        catch (InterruptedException interruptedException) {
            this.dispose();
            return;
        }
        if (iJavaElement3 != null) {
            IMember[] iMemberArray2 = new IMember[1];
            iMemberArray = iMemberArray2;
            iMemberArray2[0] = iJavaElement3;
        } else {
            iMemberArray = null;
        }
        iJavaElement = iMemberArray;
        object2 = new TraditionalHierarchyViewer.TraditionalHierarchyContentProvider(this.fLifeCycle);
        ((TypeHierarchyContentProvider)object2).setMemberFilter((IMember[])iJavaElement);
        this.getTreeViewer().setContentProvider((IContentProvider)object2);
        this.fOtherContentProvider = new SuperTypeHierarchyViewer.SuperTypeHierarchyContentProvider(this.fLifeCycle);
        this.fOtherContentProvider.setMemberFilter((IMember[])iJavaElement);
        this.fFocus = iJavaElement3;
        objectArray = ((TypeHierarchyContentProvider)object2).getElements(this.fLifeCycle);
        if (objectArray.length > 0 && ((TypeHierarchyContentProvider)object2).getChildren(objectArray[0]).length > 40) {
            this.fDoFilter = false;
        } else {
            this.getTreeViewer().addFilter((ViewerFilter)new AbstractInformationControl.NamePatternFilter());
        }
        Object object3 = null;
        if (iJavaElement2 instanceof IMember) {
            object3 = iJavaElement2;
        } else if (objectArray.length > 0) {
            object3 = objectArray[0];
        }
        this.inputChanged(this.fLifeCycle, object3);
    }

    protected void stringMatcherUpdated() {
        if (this.fDoFilter) {
            super.stringMatcherUpdated();
        } else {
            this.selectFirstMatch();
        }
    }

    protected void toggleHierarchy() {
        TreeViewer treeViewer = this.getTreeViewer();
        treeViewer.getTree().setRedraw(false);
        Object[] objectArray = treeViewer.getExpandedElements();
        TypeHierarchyContentProvider typeHierarchyContentProvider = (TypeHierarchyContentProvider)treeViewer.getContentProvider();
        treeViewer.setContentProvider((IContentProvider)this.fOtherContentProvider);
        treeViewer.refresh();
        if (this.fOtherExpandedElements != null) {
            treeViewer.setExpandedElements(this.fOtherExpandedElements);
        } else {
            treeViewer.expandAll();
        }
        treeViewer.getTree().setRedraw(true);
        this.fOtherContentProvider = typeHierarchyContentProvider;
        this.fOtherExpandedElements = objectArray;
        this.updateStatusFieldText();
    }

    private String getHeaderLabel(IJavaElement iJavaElement) {
        if (iJavaElement instanceof IMethod) {
            Object[] objectArray = new String[]{iJavaElement.getParent().getElementName(), JavaElementLabels.getElementLabel(iJavaElement, JavaElementLabels.ALL_DEFAULT)};
            return Messages.format(TypeHierarchyMessages.HierarchyInformationControl_methodhierarchy_label, objectArray);
        }
        if (iJavaElement != null) {
            String string = JavaElementLabels.getElementLabel(iJavaElement, JavaElementLabels.DEFAULT_QUALIFIED);
            return Messages.format(TypeHierarchyMessages.HierarchyInformationControl_hierarchy_label, string);
        }
        return "";
    }

    protected String getStatusFieldText() {
        KeySequence[] keySequenceArray = this.getInvokingCommandKeySequences();
        String string = "";
        if (keySequenceArray != null && keySequenceArray.length > 0) {
            string = keySequenceArray[0].format();
        }
        if (this.fOtherContentProvider instanceof TraditionalHierarchyViewer.TraditionalHierarchyContentProvider) {
            return Messages.format(TypeHierarchyMessages.HierarchyInformationControl_toggle_traditionalhierarchy_label, string);
        }
        return Messages.format(TypeHierarchyMessages.HierarchyInformationControl_toggle_superhierarchy_label, string);
    }

    protected String getId() {
        return "org.eclipse.wst.jsdt.internal.ui.typehierarchy.QuickHierarchy";
    }

    protected Object getSelectedElement() {
        Object object = super.getSelectedElement();
        if (object instanceof IType && this.fFocus != null) {
            IType iType = (IType)object;
            try {
                return this.findMethod(this.fFocus, iType);
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
        }
        return object;
    }
}

