/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.viewsupport;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredJavaElementLabels;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredString;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.IRichLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.OwnerDrawSupport;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;

public class ColoredViewersManager
implements IPropertyChangeListener {
    public static final String QUALIFIER_COLOR_NAME = "org.eclipse.wst.jsdt.ui.ColoredLabels.qualifier";
    public static final String DECORATIONS_COLOR_NAME = "org.eclipse.wst.jsdt.ui.ColoredLabels.decorations";
    public static final String COUNTER_COLOR_NAME = "org.eclipse.wst.jsdt.ui.ColoredLabels.counter";
    public static final String INHERITED_COLOR_NAME = "org.eclipse.wst.jsdt.ui.ColoredLabels.inherited";
    private static ColoredViewersManager fgInstance = new ColoredViewersManager();
    private Map fManagedViewers = new HashMap();
    private ColorRegistry fColorRegisty = JFaceResources.getColorRegistry();

    public void installColoredLabels(StructuredViewer structuredViewer) {
        if (this.fManagedViewers.containsKey(structuredViewer)) {
            return;
        }
        if (this.fManagedViewers.isEmpty()) {
            PreferenceConstants.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
            this.fColorRegisty.addListener((IPropertyChangeListener)this);
        }
        this.fManagedViewers.put(structuredViewer, new ManagedViewer(structuredViewer));
    }

    public void uninstallColoredLabels(StructuredViewer structuredViewer) {
        ManagedViewer managedViewer = (ManagedViewer)this.fManagedViewers.remove(structuredViewer);
        if (managedViewer == null) {
            return;
        }
        if (this.fManagedViewers.isEmpty()) {
            PreferenceConstants.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
            this.fColorRegisty.removeListener((IPropertyChangeListener)this);
        }
    }

    public Color getColorForName(String string) {
        return this.fColorRegisty.get(string);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if (string.equals(QUALIFIER_COLOR_NAME) || string.equals(COUNTER_COLOR_NAME) || string.equals(DECORATIONS_COLOR_NAME) || string.equals("colored_labels_in_views")) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ColoredViewersManager.this.refreshAllViewers();
                }
            });
        }
    }

    protected final void refreshAllViewers() {
        Iterator iterator = this.fManagedViewers.values().iterator();
        while (iterator.hasNext()) {
            ManagedViewer managedViewer = (ManagedViewer)iterator.next();
            managedViewer.refresh();
        }
    }

    public static boolean showColoredLabels() {
        String string = PreferenceConstants.getPreference("colored_labels_in_views", null);
        return string != null && Boolean.valueOf(string) != false;
    }

    public static void install(StructuredViewer structuredViewer) {
        fgInstance.installColoredLabels(structuredViewer);
    }

    private class ManagedViewer
    implements DisposeListener {
        private static final String COLORED_LABEL_KEY = "coloredlabel";
        private StructuredViewer fViewer;
        private OwnerDrawSupport fOwnerDrawSupport;

        private ManagedViewer(StructuredViewer structuredViewer) {
            this.fViewer = structuredViewer;
            this.fOwnerDrawSupport = null;
            this.fViewer.getControl().addDisposeListener((DisposeListener)this);
            if (ColoredViewersManager.showColoredLabels()) {
                this.installOwnerDraw();
            }
        }

        public void widgetDisposed(DisposeEvent disposeEvent) {
            ColoredViewersManager.this.uninstallColoredLabels(this.fViewer);
        }

        public final void refresh() {
            Control control = this.fViewer.getControl();
            if (!control.isDisposed()) {
                if (ColoredViewersManager.showColoredLabels()) {
                    this.installOwnerDraw();
                } else {
                    this.uninstallOwnerDraw();
                }
            }
        }

        protected void installOwnerDraw() {
            if (this.fOwnerDrawSupport == null) {
                this.fOwnerDrawSupport = new OwnerDrawSupport(this, this.fViewer.getControl()){
                    final /* synthetic */ ManagedViewer this$1;
                    {
                        this.this$1 = managedViewer;
                    }

                    public ColoredString getColoredLabel(Item item) {
                        return ManagedViewer.access$0(this.this$1, item);
                    }

                    public Color getColor(String string, Display display) {
                        return ManagedViewer.access$2(this.this$1).getColorForName(string);
                    }
                };
            }
            this.refreshViewer();
        }

        protected void uninstallOwnerDraw() {
            if (this.fOwnerDrawSupport == null) {
                return;
            }
            this.fOwnerDrawSupport.dispose();
            this.fOwnerDrawSupport = null;
            this.refreshViewer();
        }

        private void refreshViewer() {
            Control control = this.fViewer.getControl();
            if (!control.isDisposed()) {
                if (control instanceof Tree) {
                    this.refresh((Item[])((Tree)control).getItems());
                } else if (control instanceof Table) {
                    this.refresh((Item[])((Table)control).getItems());
                }
            }
        }

        private void refresh(Item[] itemArray) {
            int n = 0;
            while (n < itemArray.length) {
                Item item = itemArray[n];
                item.setData(COLORED_LABEL_KEY, null);
                String string = item.getText();
                item.setText("");
                item.setText(string);
                if (item instanceof TreeItem) {
                    this.refresh((Item[])((TreeItem)item).getItems());
                }
                ++n;
            }
        }

        private ColoredString getColoredLabelForView(Item item) {
            ColoredString coloredString = (ColoredString)item.getData(COLORED_LABEL_KEY);
            String string = item.getText();
            if (coloredString != null && coloredString.getString().equals(string)) {
                return coloredString;
            }
            ColoredString coloredString2 = null;
            IBaseLabelProvider iBaseLabelProvider = this.fViewer.getLabelProvider();
            if (iBaseLabelProvider instanceof IRichLabelProvider) {
                coloredString2 = ((IRichLabelProvider)iBaseLabelProvider).getRichTextLabel(item.getData());
            }
            if (coloredString2 == null) {
                coloredString2 = new ColoredString(string);
            } else if (!coloredString2.getString().equals(string)) {
                coloredString2 = ColoredJavaElementLabels.decorateColoredString(coloredString2, string, ColoredJavaElementLabels.DECORATIONS_STYLE);
            }
            item.setData(COLORED_LABEL_KEY, (Object)coloredString2);
            return coloredString2;
        }

        static /* synthetic */ ColoredString access$0(ManagedViewer managedViewer, Item item) {
            return managedViewer.getColoredLabelForView(item);
        }

        static /* synthetic */ ColoredViewersManager access$2(ManagedViewer managedViewer) {
            return managedViewer.ColoredViewersManager.this;
        }
    }
}

