/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.viewsupport;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public final class ProjectTemplateStore {
    private static final String KEY = "org.eclipse.wst.jsdt.ui.text.custom_code_templates";
    private final TemplateStore fInstanceStore = JavaPlugin.getDefault().getCodeTemplateStore();
    private final TemplateStore fProjectStore;

    public ProjectTemplateStore(IProject iProject) {
        if (iProject == null) {
            this.fProjectStore = null;
        } else {
            final ScopedPreferenceStore scopedPreferenceStore = new ScopedPreferenceStore((IScopeContext)new ProjectScope(iProject), "org.eclipse.wst.jsdt.ui");
            this.fProjectStore = new TemplateStore((IPreferenceStore)scopedPreferenceStore, KEY){

                public void add(TemplatePersistenceData templatePersistenceData) {
                    this.internalAdd(templatePersistenceData);
                }

                public void save() throws IOException {
                    StringWriter stringWriter = new StringWriter();
                    TemplateReaderWriter templateReaderWriter = new TemplateReaderWriter();
                    templateReaderWriter.save(this.getTemplateData(false), (Writer)stringWriter);
                    scopedPreferenceStore.setValue(ProjectTemplateStore.KEY, stringWriter.toString());
                    scopedPreferenceStore.save();
                }
            };
        }
    }

    public static boolean hasProjectSpecificTempates(IProject iProject) {
        String string = new ProjectScope(iProject).getNode("org.eclipse.wst.jsdt.ui").get(KEY, null);
        if (string != null && string.trim().length() > 0) {
            StringReader stringReader = new StringReader(string);
            TemplateReaderWriter templateReaderWriter = new TemplateReaderWriter();
            try {
                TemplatePersistenceData[] templatePersistenceDataArray = templateReaderWriter.read((Reader)stringReader);
                return templatePersistenceDataArray.length > 0;
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    public TemplatePersistenceData[] getTemplateData() {
        if (this.fProjectStore != null) {
            return this.fProjectStore.getTemplateData(true);
        }
        return this.fInstanceStore.getTemplateData(true);
    }

    public Template findTemplateById(String string) {
        Template template = null;
        if (this.fProjectStore != null) {
            template = this.fProjectStore.findTemplateById(string);
        }
        if (template == null) {
            template = this.fInstanceStore.findTemplateById(string);
        }
        return template;
    }

    public void load() throws IOException {
        if (this.fProjectStore != null) {
            this.fProjectStore.load();
            HashSet<String> hashSet = new HashSet<String>();
            TemplatePersistenceData[] templatePersistenceDataArray = this.fProjectStore.getTemplateData(false);
            int n = 0;
            while (n < templatePersistenceDataArray.length) {
                hashSet.add(templatePersistenceDataArray[n].getId());
                ++n;
            }
            templatePersistenceDataArray = this.fInstanceStore.getTemplateData(false);
            n = 0;
            while (n < templatePersistenceDataArray.length) {
                TemplatePersistenceData templatePersistenceData = templatePersistenceDataArray[n];
                if (!hashSet.contains(templatePersistenceData.getId())) {
                    TemplatePersistenceData templatePersistenceData2 = new TemplatePersistenceData(new Template(templatePersistenceData.getTemplate()), templatePersistenceData.isEnabled(), templatePersistenceData.getId());
                    this.fProjectStore.add(templatePersistenceData2);
                    templatePersistenceData2.setDeleted(true);
                }
                ++n;
            }
        }
    }

    public boolean isProjectSpecific(String string) {
        if (string == null) {
            return false;
        }
        if (this.fProjectStore == null) {
            return false;
        }
        return this.fProjectStore.findTemplateById(string) != null;
    }

    public void setProjectSpecific(String string, boolean bl) {
        Assert.isNotNull((Object)this.fProjectStore);
        TemplatePersistenceData templatePersistenceData = this.fProjectStore.getTemplateData(string);
        if (templatePersistenceData == null) {
            return;
        }
        templatePersistenceData.setDeleted(!bl);
    }

    public void restoreDefaults() {
        if (this.fProjectStore == null) {
            this.fInstanceStore.restoreDefaults();
        } else {
            this.fProjectStore.restoreDefaults();
        }
    }

    public void save() throws IOException {
        if (this.fProjectStore == null) {
            this.fInstanceStore.save();
        } else {
            this.fProjectStore.save();
        }
    }

    public void revertChanges() throws IOException {
        if (this.fProjectStore == null) {
            this.fInstanceStore.load();
        }
    }
}

