/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.viewsupport;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJarEntryResource;

public class StorageLabelProvider
extends LabelProvider {
    private IEditorRegistry fEditorRegistry = null;
    private Map fJarImageMap = new HashMap(10);
    private Image fDefaultImage;

    private IEditorRegistry getEditorRegistry() {
        if (this.fEditorRegistry == null) {
            this.fEditorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        }
        return this.fEditorRegistry;
    }

    public Image getImage(Object object) {
        if (object instanceof IStorage) {
            return this.getImageForJarEntry((IStorage)object);
        }
        return super.getImage(object);
    }

    public String getText(Object object) {
        if (object instanceof IStorage) {
            return ((IStorage)object).getName();
        }
        return super.getText(object);
    }

    public void dispose() {
        if (this.fJarImageMap != null) {
            Iterator iterator = this.fJarImageMap.values().iterator();
            while (iterator.hasNext()) {
                Image image = (Image)iterator.next();
                image.dispose();
            }
            this.fJarImageMap = null;
        }
        this.fDefaultImage = null;
    }

    private Image getImageForJarEntry(IStorage iStorage) {
        IPath iPath;
        if (iStorage instanceof IJarEntryResource && !((IJarEntryResource)iStorage).isFile()) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        if (this.fJarImageMap == null) {
            return this.getDefaultImage();
        }
        if (iStorage == null || iStorage.getName() == null) {
            return this.getDefaultImage();
        }
        String string = iStorage.getName();
        Image image = (Image)this.fJarImageMap.get(string);
        if (image != null) {
            return image;
        }
        IFileEditorMapping[] iFileEditorMappingArray = this.getEditorRegistry().getFileEditorMappings();
        int n = 0;
        while (n < iFileEditorMappingArray.length) {
            if (iFileEditorMappingArray[n].getLabel().equals(string)) break;
            ++n;
        }
        String string2 = string;
        if (n == iFileEditorMappingArray.length) {
            iPath = iStorage.getFullPath();
            if (iPath == null) {
                return this.getDefaultImage();
            }
            string2 = iPath.getFileExtension();
            if (string2 == null) {
                return this.getDefaultImage();
            }
            image = (Image)this.fJarImageMap.get(string2);
            if (image != null) {
                return image;
            }
        }
        iPath = this.getEditorRegistry().getImageDescriptor(string);
        image = iPath.createImage();
        this.fJarImageMap.put(string2, image);
        return image;
    }

    private Image getDefaultImage() {
        if (this.fDefaultImage == null) {
            this.fDefaultImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        }
        return this.fDefaultImage;
    }
}

