/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.wizards.JavaProjectWizardFirstPage;
import org.eclipse.wst.jsdt.internal.ui.wizards.JavaProjectWizardSecondPage;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetConfigurationBlock;

public class JavaProjectWizard
extends NewElementWizard
implements IExecutableExtension {
    private JavaProjectWizardFirstPage fFirstPage;
    private JavaProjectWizardSecondPage fSecondPage;
    private IConfigurationElement fConfigElement;

    public JavaProjectWizard() {
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWJPRJ);
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(NewWizardMessages.JavaProjectWizard_title);
    }

    public void addPages() {
        super.addPages();
        this.fFirstPage = new JavaProjectWizardFirstPage();
        this.fFirstPage.setWorkingSets(this.getWorkingSets(this.getSelection()));
        this.addPage((IWizardPage)this.fFirstPage);
        this.fSecondPage = new JavaProjectWizardSecondPage(this.fFirstPage);
        this.addPage((IWizardPage)this.fSecondPage);
    }

    protected void finishPage(IProgressMonitor iProgressMonitor) throws InterruptedException, CoreException {
        this.fSecondPage.performFinish(iProgressMonitor);
    }

    public boolean performFinish() {
        boolean bl = super.performFinish();
        if (bl) {
            final IJavaElement iJavaElement = this.getCreatedElement();
            IWorkingSet[] iWorkingSetArray = this.fFirstPage.getWorkingSets();
            WorkingSetConfigurationBlock.addToWorkingSets((IAdaptable)iJavaElement, iWorkingSetArray);
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
            this.selectAndReveal((IResource)this.fSecondPage.getJavaProject().getProject());
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    PackageExplorerPart packageExplorerPart = JavaProjectWizard.this.getActivePackageExplorer();
                    if (packageExplorerPart != null) {
                        packageExplorerPart.tryToReveal(iJavaElement);
                    }
                }
            });
        }
        return bl;
    }

    protected void handleFinishException(Shell shell, InvocationTargetException invocationTargetException) {
        String string = NewWizardMessages.JavaProjectWizard_op_error_title;
        String string2 = NewWizardMessages.JavaProjectWizard_op_error_create_message;
        ExceptionHandler.handle(invocationTargetException, this.getShell(), string, string2);
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) {
        this.fConfigElement = iConfigurationElement;
    }

    public boolean performCancel() {
        this.fSecondPage.performCancel();
        return super.performCancel();
    }

    public IJavaElement getCreatedElement() {
        return JavaCore.create((IProject)this.fFirstPage.getProjectHandle());
    }

    private IWorkingSet[] getWorkingSets(IStructuredSelection iStructuredSelection) {
        IWorkingSet[] iWorkingSetArray = WorkingSetConfigurationBlock.getSelectedWorkingSet(iStructuredSelection);
        if (iWorkingSetArray != null && iWorkingSetArray.length > 0) {
            int n = 0;
            while (n < iWorkingSetArray.length) {
                if (!this.isValidWorkingSet(iWorkingSetArray[n])) {
                    return null;
                }
                ++n;
            }
            return iWorkingSetArray;
        }
        PackageExplorerPart packageExplorerPart = this.getActivePackageExplorer();
        if (packageExplorerPart == null) {
            return null;
        }
        if (packageExplorerPart.getRootMode() == 1) {
            IWorkingSet iWorkingSet = packageExplorerPart.getFilterWorkingSet();
            if (iWorkingSet == null) {
                return null;
            }
            if (!this.isValidWorkingSet(iWorkingSet)) {
                return null;
            }
            return new IWorkingSet[]{iWorkingSet};
        }
        if (packageExplorerPart.getRootMode() == 2) {
            Object object = packageExplorerPart.getViewPartInput();
            if (!(object instanceof IWorkingSet)) {
                return null;
            }
            IWorkingSet iWorkingSet = (IWorkingSet)object;
            if (!this.isValidWorkingSet(iWorkingSet)) {
                return null;
            }
            return new IWorkingSet[]{iWorkingSet};
        }
        return null;
    }

    private PackageExplorerPart getActivePackageExplorer() {
        PackageExplorerPart packageExplorerPart = PackageExplorerPart.getFromActivePerspective();
        if (packageExplorerPart == null) {
            return null;
        }
        IWorkbenchPage iWorkbenchPage = packageExplorerPart.getViewSite().getWorkbenchWindow().getActivePage();
        if (iWorkbenchPage == null) {
            return null;
        }
        if (iWorkbenchPage.getActivePart() != packageExplorerPart) {
            return null;
        }
        return packageExplorerPart;
    }

    private boolean isValidWorkingSet(IWorkingSet iWorkingSet) {
        String string = iWorkingSet.getId();
        if (!"org.eclipse.wst.jsdt.ui.JavaWorkingSetPage".equals(string) && !"org.eclipse.ui.resourceWorkingSetPage".equals(string)) {
            return false;
        }
        return !iWorkingSet.isAggregateWorkingSet();
    }
}

