/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.util.CoreUtility;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.wizards.ClassPathDetector;
import org.eclipse.wst.jsdt.internal.ui.wizards.JavaProjectWizardFirstPage;
import org.eclipse.wst.jsdt.internal.ui.wizards.JavaProjectWizardSecondPage;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;
import org.eclipse.wst.jsdt.ui.wizards.JavaCapabilityConfigurationPage;

public class JavaProjectWizardSecondPage
extends JavaCapabilityConfigurationPage {
    private static final String FILENAME_PROJECT = ".project";
    private final JavaProjectWizardFirstPage fFirstPage;
    private URI fCurrProjectLocation;
    private IProject fCurrProject;
    private boolean fKeepContent;
    private File fDotProjectBackup;
    private File fDotClasspathBackup;
    private Boolean fIsAutobuild;

    public JavaProjectWizardSecondPage(JavaProjectWizardFirstPage javaProjectWizardFirstPage) {
        this.fFirstPage = javaProjectWizardFirstPage;
        this.fCurrProjectLocation = null;
        this.fCurrProject = null;
        this.fKeepContent = false;
        this.fDotProjectBackup = null;
        this.fDotClasspathBackup = null;
        this.fIsAutobuild = null;
    }

    protected boolean useNewSourcePage() {
        return true;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            IStatus iStatus = this.changeToNewProject();
            if (iStatus != null && !iStatus.isOK()) {
                ErrorDialog.openError((Shell)this.getShell(), (String)NewWizardMessages.JavaProjectWizardSecondPage_error_title, null, (IStatus)iStatus);
            }
        } else {
            this.removeProject();
        }
        super.setVisible(bl);
        if (bl) {
            this.setFocus();
        }
    }

    private IStatus changeToNewProject() {
        this.fKeepContent = this.fFirstPage.getDetect();
        class UpdateRunnable
        implements IRunnableWithProgress {
            public IStatus infoStatus;
            final /* synthetic */ JavaProjectWizardSecondPage this$0;

            UpdateRunnable(JavaProjectWizardSecondPage javaProjectWizardSecondPage) {
                this.this$0 = javaProjectWizardSecondPage;
                this.infoStatus = Status.OK_STATUS;
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        if (JavaProjectWizardSecondPage.access$0(this.this$0) == null) {
                            JavaProjectWizardSecondPage.access$1(this.this$0, CoreUtility.enableAutoBuild(false));
                        }
                        this.infoStatus = this.this$0.updateProject(iProgressMonitor);
                    }
                    catch (CoreException coreException) {
                        throw new InvocationTargetException(coreException);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        throw new InterruptedException();
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                iProgressMonitor.done();
            }
        }
        UpdateRunnable updateRunnable = new UpdateRunnable(this);
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)updateRunnable));
            return updateRunnable.infoStatus;
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = NewWizardMessages.JavaProjectWizardSecondPage_error_title;
            String string2 = NewWizardMessages.JavaProjectWizardSecondPage_error_message;
            ExceptionHandler.handle(invocationTargetException, this.getShell(), string, string2);
        }
        catch (InterruptedException interruptedException) {}
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final IStatus updateProject(IProgressMonitor iProgressMonitor) throws CoreException, InterruptedException {
        IStatus iStatus = StatusInfo.OK_STATUS;
        this.fCurrProject = this.fFirstPage.getProjectHandle();
        this.fCurrProjectLocation = this.getProjectLocationURI();
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            IClasspathEntry[] iClasspathEntryArray;
            iProgressMonitor.beginTask(NewWizardMessages.JavaProjectWizardSecondPage_operation_initialize, 7);
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            URI uRI = this.fCurrProjectLocation;
            if (this.fCurrProjectLocation == null) {
                try {
                    iClasspathEntryArray = ResourcesPlugin.getWorkspace().getRoot().getLocationURI();
                    uRI = new URI(iClasspathEntryArray.getScheme(), null, Path.fromPortableString((String)iClasspathEntryArray.getPath()).append(this.fCurrProject.getName()).toString(), null);
                }
                catch (URISyntaxException uRISyntaxException) {
                    Assert.isTrue((boolean)false, (String)"Can't happen");
                }
            }
            this.rememberExistingFiles(uRI);
            try {
                JavaProjectWizardSecondPage.createProject(this.fCurrProject, this.fCurrProjectLocation, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
            }
            catch (CoreException coreException) {
                if (coreException.getStatus().getCode() != 567) throw coreException;
                iStatus = new StatusInfo(1, Messages.format(NewWizardMessages.JavaProjectWizardSecondPage_DeleteCorruptProjectFile_message, coreException.getLocalizedMessage()));
                this.deleteProjectFile(uRI);
                if (this.fCurrProject.exists()) {
                    this.fCurrProject.delete(true, null);
                }
                JavaProjectWizardSecondPage.createProject(this.fCurrProject, this.fCurrProjectLocation, null);
            }
            iClasspathEntryArray = null;
            if (this.fFirstPage.getDetect()) {
                if (!this.fCurrProject.getFile(".jsdtscope").exists()) {
                    ClassPathDetector classPathDetector = new ClassPathDetector(this.fCurrProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
                    iClasspathEntryArray = classPathDetector.getClasspath();
                    classPathDetector.getOutputLocation();
                } else {
                    iProgressMonitor.worked(2);
                }
            } else if (this.fFirstPage.isSrcBin()) {
                IFolder iFolder;
                IPreferenceStore iPreferenceStore = PreferenceConstants.getPreferenceStore();
                Path path = new Path(iPreferenceStore.getString("org.eclipse.wst.jsdt.ui.wizards.srcBinFoldersSrcName"));
                Path path2 = new Path(iPreferenceStore.getString("org.eclipse.wst.jsdt.ui.wizards.srcBinFoldersBinName"));
                if (path.segmentCount() > 0) {
                    iFolder = this.fCurrProject.getFolder((IPath)path);
                    CoreUtility.createFolder(iFolder, true, true, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                } else {
                    iProgressMonitor.worked(1);
                }
                if (path2.segmentCount() > 0 && !path2.equals((Object)path)) {
                    iFolder = this.fCurrProject.getFolder((IPath)path2);
                    CoreUtility.createDerivedFolder(iFolder, true, true, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                } else {
                    iProgressMonitor.worked(1);
                }
                iFolder = this.fCurrProject.getFullPath();
                ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>();
                arrayList.add(JavaCore.newSourceEntry((IPath)iFolder.append((IPath)path)));
                arrayList.addAll(Arrays.asList(this.getDefaultClasspathEntry()));
                iClasspathEntryArray = arrayList.toArray(new IClasspathEntry[arrayList.size()]);
                iFolder.append((IPath)path2);
            } else {
                IPath iPath = this.fCurrProject.getFullPath();
                ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>();
                arrayList.add(JavaCore.newSourceEntry((IPath)iPath));
                arrayList.addAll(Arrays.asList(this.getDefaultClasspathEntry()));
                iClasspathEntryArray = arrayList.toArray(new IClasspathEntry[arrayList.size()]);
                iProgressMonitor.worked(2);
            }
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.init(JavaCore.create((IProject)this.fCurrProject), iClasspathEntryArray, false);
            this.configureJavaProject((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 3));
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var10_16 = null;
        }
        iProgressMonitor.done();
        return iStatus;
    }

    private URI getProjectLocationURI() throws CoreException {
        if (this.fFirstPage.isInWorkspace()) {
            return null;
        }
        return URIUtil.toURI((IPath)this.fFirstPage.getLocationPath());
    }

    private IClasspathEntry[] getDefaultClasspathEntry() {
        IClasspathEntry[] iClasspathEntryArray = PreferenceConstants.getDefaultJRELibrary();
        String string = this.fFirstPage.getCompilerCompliance();
        Path path = new Path("org.eclipse.wst.jsdt.launching.JRE_CONTAINER");
        if (string == null || iClasspathEntryArray.length > 1 || !path.isPrefixOf(iClasspathEntryArray[0].getPath())) {
            return iClasspathEntryArray;
        }
        IPath iPath = this.fFirstPage.getJREContainerPath();
        if (iPath != null) {
            return new IClasspathEntry[]{JavaCore.newContainerEntry((IPath)iPath)};
        }
        return iClasspathEntryArray;
    }

    private void deleteProjectFile(URI uRI) throws CoreException {
        IFileStore iFileStore;
        IFileStore iFileStore2 = EFS.getStore((URI)uRI);
        if (iFileStore2.fetchInfo().exists() && (iFileStore = iFileStore2.getChild(FILENAME_PROJECT)).fetchInfo().exists()) {
            iFileStore.delete(0, null);
        }
    }

    private void rememberExistingFiles(URI uRI) throws CoreException {
        this.fDotProjectBackup = null;
        this.fDotClasspathBackup = null;
        IFileStore iFileStore = EFS.getStore((URI)uRI);
        if (iFileStore.fetchInfo().exists()) {
            IFileStore iFileStore2;
            IFileStore iFileStore3 = iFileStore.getChild(FILENAME_PROJECT);
            if (iFileStore3.fetchInfo().exists()) {
                this.fDotProjectBackup = this.createBackup(iFileStore3, "project-desc");
            }
            if ((iFileStore2 = iFileStore.getChild(".jsdtscope")).fetchInfo().exists()) {
                this.fDotClasspathBackup = this.createBackup(iFileStore2, "classpath-desc");
            }
        }
    }

    private void restoreExistingFiles(URI uRI, IProgressMonitor iProgressMonitor) throws CoreException {
        IFileStore iFileStore;
        int n = ((this.fDotProjectBackup != null ? 1 : 0) + (this.fDotClasspathBackup != null ? 1 : 0)) * 2;
        iProgressMonitor.beginTask("", n);
        try {
            iFileStore = EFS.getStore((URI)uRI).getChild(FILENAME_PROJECT);
            iFileStore.delete(0, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            if (this.fDotProjectBackup != null) {
                this.copyFile(this.fDotProjectBackup, iFileStore, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            }
        }
        catch (IOException iOException) {
            Status status = new Status(4, "org.eclipse.wst.jsdt.ui", 4, NewWizardMessages.JavaProjectWizardSecondPage_problem_restore_project, (Throwable)iOException);
            throw new CoreException((IStatus)status);
        }
        try {
            iFileStore = EFS.getStore((URI)uRI).getChild(".jsdtscope");
            iFileStore.delete(0, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            if (this.fDotClasspathBackup != null) {
                this.copyFile(this.fDotClasspathBackup, iFileStore, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            }
        }
        catch (IOException iOException) {
            Status status = new Status(4, "org.eclipse.wst.jsdt.ui", 4, NewWizardMessages.JavaProjectWizardSecondPage_problem_restore_classpath, (Throwable)iOException);
            throw new CoreException((IStatus)status);
        }
    }

    private File createBackup(IFileStore iFileStore, String string) throws CoreException {
        try {
            File file = File.createTempFile("eclipse-" + string, ".bak");
            this.copyFile(iFileStore, file);
            return file;
        }
        catch (IOException iOException) {
            Status status = new Status(4, "org.eclipse.wst.jsdt.ui", 4, Messages.format(NewWizardMessages.JavaProjectWizardSecondPage_problem_backup, string), (Throwable)iOException);
            throw new CoreException((IStatus)status);
        }
    }

    private void copyFile(IFileStore iFileStore, File file) throws IOException, CoreException {
        InputStream inputStream = iFileStore.openInputStream(0, null);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.copyFile(inputStream, fileOutputStream);
    }

    private void copyFile(File file, IFileStore iFileStore, IProgressMonitor iProgressMonitor) throws IOException, CoreException {
        FileInputStream fileInputStream = new FileInputStream(file);
        OutputStream outputStream = iFileStore.openOutputStream(0, iProgressMonitor);
        this.copyFile(fileInputStream, outputStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyFile(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            int n;
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                inputStream.close();
                Object var7_11 = null;
            }
            catch (Throwable throwable2) {
                Object var7_10 = null;
                outputStream.close();
                throw throwable2;
            }
            outputStream.close();
            throw throwable;
        }
        try {}
        catch (Throwable throwable) {
            Object var7_12 = null;
            outputStream.close();
            throw throwable;
        }
        inputStream.close();
        Object var7_13 = null;
        outputStream.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void performFinish(IProgressMonitor iProgressMonitor) throws CoreException, InterruptedException {
        try {
            String string;
            iProgressMonitor.beginTask(NewWizardMessages.JavaProjectWizardSecondPage_operation_create, 3);
            if (this.fCurrProject == null) {
                this.updateProject((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            }
            this.configureJavaProject((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
            if (!this.fKeepContent && (string = this.fFirstPage.getCompilerCompliance()) != null) {
                IJavaProject iJavaProject = JavaCore.create((IProject)this.fCurrProject);
                Map map = iJavaProject.getOptions(false);
                JavaModelUtil.setCompilanceOptions(map, string);
                JavaModelUtil.setDefaultClassfileOptions(map, string);
                iJavaProject.setOptions(map);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            iProgressMonitor.done();
            this.fCurrProject = null;
            if (this.fIsAutobuild == null) throw throwable;
            CoreUtility.enableAutoBuild(this.fIsAutobuild);
            this.fIsAutobuild = null;
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        iProgressMonitor.done();
        this.fCurrProject = null;
        if (this.fIsAutobuild == null) return;
        CoreUtility.enableAutoBuild(this.fIsAutobuild);
        this.fIsAutobuild = null;
    }

    private void removeProject() {
        if (this.fCurrProject == null || !this.fCurrProject.exists()) {
            return;
        }
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                JavaProjectWizardSecondPage.this.doRemoveProject(iProgressMonitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(iRunnableWithProgress));
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = NewWizardMessages.JavaProjectWizardSecondPage_error_remove_title;
            String string2 = NewWizardMessages.JavaProjectWizardSecondPage_error_remove_message;
            ExceptionHandler.handle(invocationTargetException, this.getShell(), string, string2);
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void doRemoveProject(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
        boolean bl;
        boolean bl2 = bl = this.fCurrProjectLocation == null;
        if (iProgressMonitor == null || bl) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask(NewWizardMessages.JavaProjectWizardSecondPage_operation_remove, 3);
        try {
            try {
                try {
                    URI uRI = this.fCurrProject.getLocationURI();
                    boolean bl3 = !this.fKeepContent && this.fCurrProject.isSynchronized(2);
                    this.fCurrProject.delete(bl3, false, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
                    this.restoreExistingFiles(uRI, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    CoreUtility.enableAutoBuild(this.fIsAutobuild);
                    this.fIsAutobuild = null;
                    throw throwable;
                }
                {
                    Object var5_8 = null;
                    CoreUtility.enableAutoBuild(this.fIsAutobuild);
                    this.fIsAutobuild = null;
                }
            }
            catch (CoreException coreException) {
                throw new InvocationTargetException(coreException);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            iProgressMonitor.done();
            this.fCurrProject = null;
            this.fKeepContent = false;
            throw throwable;
        }
        {
            Object var7_11 = null;
        }
        iProgressMonitor.done();
        this.fCurrProject = null;
        this.fKeepContent = false;
    }

    public void performCancel() {
        this.removeProject();
    }

    static /* synthetic */ Boolean access$0(JavaProjectWizardSecondPage javaProjectWizardSecondPage) {
        return javaProjectWizardSecondPage.fIsAutobuild;
    }

    static /* synthetic */ void access$1(JavaProjectWizardSecondPage javaProjectWizardSecondPage, Boolean bl) {
        javaProjectWizardSecondPage.fIsAutobuild = bl;
    }
}

