/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;

class NewJSFileWizardPage
extends WizardNewFileCreationPage {
    private IContentType fContentType;
    private List fValidExtensions = null;

    public NewJSFileWizardPage(String string, IStructuredSelection iStructuredSelection) {
        super(string, iStructuredSelection);
    }

    protected void initialPopulateContainerNameField() {
        super.initialPopulateContainerNameField();
        IPath iPath = this.getContainerFullPath();
        IProject iProject = this.getProjectFromPath(iPath);
        IPath iPath2 = this.getWebContentPath(iProject);
        if (iPath2 != null && !iPath2.isPrefixOf(iPath)) {
            this.setContainerFullPath(iPath2);
        }
    }

    protected boolean validatePage() {
        this.setMessage(null);
        this.setErrorMessage(null);
        if (!super.validatePage()) {
            return false;
        }
        String string = this.getFileName();
        IPath iPath = this.getContainerFullPath();
        if (iPath != null && !iPath.isEmpty() && string != null) {
            IPath iPath2;
            String string2;
            if (!this.extensionValidForContentType(string)) {
                this.setErrorMessage(NLS.bind((String)NewWizardMessages.Javascript_Error_Filename_Must_End_JS, (Object)this.getValidExtensions().toString()));
                return false;
            }
            if (string.lastIndexOf(46) == -1) {
                string2 = this.addDefaultExtension(string);
                iPath2 = iPath.append(string2);
                IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
                IStatus iStatus = iWorkspace.validatePath(iPath2.toString(), 2);
                if (!iStatus.isOK()) {
                    this.setErrorMessage(iStatus.getMessage());
                    return false;
                }
                if (iWorkspace.getRoot().getFolder(iPath2).exists() || iWorkspace.getRoot().getFile(iPath2).exists()) {
                    this.setErrorMessage(NewWizardMessages.Javascript_Resource_Group_Name_Exists);
                    return false;
                }
            }
            if ((string2 = this.getProjectFromPath(iPath)) != null && this.isWebProject((IProject)string2) && !(iPath2 = this.getWebContentPath((IProject)string2)).isPrefixOf(iPath)) {
                this.setMessage(NewWizardMessages.Javascript_Warning_Folder_Must_Be_Inside_Web_Content, 2);
            }
        }
        return true;
    }

    private IContentType getContentType() {
        if (this.fContentType == null) {
            this.fContentType = Platform.getContentTypeManager().getContentType("org.eclipse.wst.jsdt.core.jsSource");
        }
        return this.fContentType;
    }

    private List getValidExtensions() {
        if (this.fValidExtensions == null) {
            IContentType iContentType = this.getContentType();
            this.fValidExtensions = new ArrayList<String>(Arrays.asList(iContentType.getFileSpecs(8)));
        }
        return this.fValidExtensions;
    }

    private boolean extensionValidForContentType(String string) {
        boolean bl = false;
        IContentType iContentType = this.getContentType();
        if (string.lastIndexOf(46) != -1) {
            IContentType[] iContentTypeArray = Platform.getContentTypeManager().findContentTypesFor(string);
            int n = 0;
            while (n < iContentTypeArray.length && !bl) {
                bl = iContentTypeArray[n].isKindOf(iContentType);
                ++n;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    String addDefaultExtension(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(".");
        stringBuffer.append("js");
        return stringBuffer.toString();
    }

    private IProject getProjectFromPath(IPath iPath) {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IProject iProject = null;
        if (iPath != null) {
            iProject = iWorkspace.validatePath(iPath.toString(), 4).isOK() ? iWorkspace.getRoot().getProject(iPath.toString()) : iWorkspace.getRoot().getFile(iPath).getProject();
        }
        return iProject;
    }

    private boolean isWebProject(IProject iProject) {
        return true;
    }

    private IPath getWebContentPath(IProject iProject) {
        IPath iPath = iProject.getFullPath();
        if (iProject != null && this.isWebProject(iProject)) {
            iPath.append("/");
        }
        return iPath;
    }
}

