/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.jsdt.core.IAccessRule;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.AccessRuleEntryDialog;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.AccessRulesLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class AccessRulesDialog
extends StatusDialog {
    public static final int SWITCH_PAGE = 10;
    private final ListDialogField fAccessRulesList;
    private final SelectionButtonDialogField fCombineRulesCheckbox;
    private final CPListElement fCurrElement;
    private final IJavaProject fProject;
    private final boolean fParentCanSwitchPage;
    private static final int IDX_ADD = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_UP = 3;
    private static final int IDX_DOWN = 4;
    private static final int IDX_REMOVE = 6;

    public AccessRulesDialog(Shell shell, CPListElement cPListElement, IJavaProject iJavaProject, boolean bl) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fCurrElement = cPListElement;
        this.fProject = iJavaProject;
        this.setTitle(NewWizardMessages.AccessRulesDialog_title);
        this.fAccessRulesList = this.createListContents(cPListElement);
        this.fCombineRulesCheckbox = new SelectionButtonDialogField(32);
        this.fCombineRulesCheckbox.setLabelText(NewWizardMessages.AccessRulesDialog_combine_label);
        this.fCombineRulesCheckbox.setSelection(Boolean.TRUE.equals(cPListElement.getAttribute("combineaccessrules")));
        this.fParentCanSwitchPage = bl;
    }

    private ListDialogField createListContents(CPListElement cPListElement) {
        String string = NewWizardMessages.AccessRulesDialog_rules_label;
        String[] stringArray = new String[7];
        stringArray[0] = NewWizardMessages.AccessRulesDialog_rules_add;
        stringArray[1] = NewWizardMessages.AccessRulesDialog_rules_edit;
        stringArray[3] = NewWizardMessages.AccessRulesDialog_rules_up;
        stringArray[4] = NewWizardMessages.AccessRulesDialog_rules_down;
        stringArray[6] = NewWizardMessages.AccessRulesDialog_rules_remove;
        String[] stringArray2 = stringArray;
        TypeRestrictionAdapter typeRestrictionAdapter = new TypeRestrictionAdapter();
        AccessRulesLabelProvider accessRulesLabelProvider = new AccessRulesLabelProvider();
        ListDialogField listDialogField = new ListDialogField(typeRestrictionAdapter, stringArray2, (ILabelProvider)accessRulesLabelProvider);
        listDialogField.setDialogFieldListener(typeRestrictionAdapter);
        listDialogField.setLabelText(string);
        listDialogField.setRemoveButtonIndex(6);
        listDialogField.setUpButtonIndex(3);
        listDialogField.setDownButtonIndex(4);
        listDialogField.enableButton(1, false);
        IAccessRule[] iAccessRuleArray = (IAccessRule[])cPListElement.getAttribute("accessrules");
        ArrayList<IAccessRule> arrayList = new ArrayList<IAccessRule>(iAccessRuleArray.length);
        int n = 0;
        while (n < iAccessRuleArray.length) {
            arrayList.add(iAccessRuleArray[n]);
            ++n;
        }
        listDialogField.setElements(arrayList);
        listDialogField.selectFirstElement();
        return listDialogField;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Control createDialogArea(Composite composite) {
        GridLayout gridLayout;
        Composite composite2 = (Composite)super.createDialogArea(composite);
        int n = 0;
        GC gC = new GC((Drawable)composite2);
        try {
            int n2;
            n = gC.textExtent((String)AccessRulesLabelProvider.getResolutionLabel((int)0)).x;
            int n3 = gC.textExtent((String)AccessRulesLabelProvider.getResolutionLabel((int)2)).x;
            if (n3 > n) {
                n = n3;
            }
            if ((n2 = gC.textExtent((String)AccessRulesLabelProvider.getResolutionLabel((int)1)).x) > n) {
                n = n2;
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            gC.dispose();
            throw throwable;
        }
        {
            gridLayout = null;
        }
        gC.dispose();
        ColumnLayoutData[] columnLayoutDataArray = new ColumnLayoutData[]{new ColumnPixelData(n + 40), new ColumnWeightData(1)};
        this.fAccessRulesList.setTableColumns(new ListDialogField.ColumnsDescription(columnLayoutDataArray, null, false));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setFont(composite2.getFont());
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite3, 64);
        label.setText(this.getDescriptionString());
        GridData gridData = new GridData(4, 0x1000000, false, false, 2, 1);
        gridData.widthHint = this.convertWidthInCharsToPixels(70);
        label.setLayoutData((Object)gridData);
        this.fAccessRulesList.doFillIntoGrid(composite3, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fAccessRulesList.getLabelControl(null), 2);
        gridData = (GridData)this.fAccessRulesList.getListControl(null).getLayoutData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = -1;
        if (this.fCurrElement.getEntryKind() == 2) {
            this.fCombineRulesCheckbox.doFillIntoGrid(composite3, 2);
        }
        if (this.fProject != null) {
            String string = this.fProject.getOption("org.eclipse.wst.jsdt.core.compiler.problem.forbiddenReference", true);
            String string2 = this.fProject.getOption("org.eclipse.wst.jsdt.core.compiler.problem.discouragedReference", true);
            Object[] objectArray = new String[]{this.getLocalizedString(string2), this.getLocalizedString(string)};
            FormToolkit formToolkit = new FormToolkit(composite.getDisplay());
            formToolkit.setBackground(null);
            try {
                try {
                    FormText formText = formToolkit.createFormText(composite2, true);
                    formText.setFont(composite3.getFont());
                    if (this.fParentCanSwitchPage) {
                        formText.setText(Messages.format(NewWizardMessages.AccessRulesDialog_severity_info_with_link, objectArray), true, false);
                        formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                                AccessRulesDialog.this.doErrorWarningLinkPressed();
                            }
                        });
                    } else {
                        formText.setText(Messages.format(NewWizardMessages.AccessRulesDialog_severity_info_no_link, objectArray), true, false);
                    }
                    gridData = new GridData(4, 0x1000000, false, false, 2, 1);
                    gridData.widthHint = this.convertWidthInCharsToPixels(70);
                    formText.setLayoutData((Object)gridData);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    JavaPlugin.log(illegalArgumentException);
                }
            }
            catch (Throwable throwable) {
                Object var15_21 = null;
                formToolkit.dispose();
                throw throwable;
            }
            {
                Object var15_22 = null;
            }
            formToolkit.dispose();
        }
        AccessRulesDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    final void doErrorWarningLinkPressed() {
        if (this.fParentCanSwitchPage && MessageDialog.openQuestion((Shell)this.getShell(), (String)NewWizardMessages.AccessRulesDialog_switch_dialog_title, (String)NewWizardMessages.AccessRulesDialog_switch_dialog_message)) {
            this.setReturnCode(10);
            this.close();
        }
    }

    private String getLocalizedString(String string) {
        if ("error".equals(string)) {
            return NewWizardMessages.AccessRulesDialog_severity_error;
        }
        if ("warning".equals(string)) {
            return NewWizardMessages.AccessRulesDialog_severity_warning;
        }
        return NewWizardMessages.AccessRulesDialog_severity_ignore;
    }

    private String getDescriptionString() {
        String string;
        String string2 = this.fCurrElement.getPath().lastSegment();
        switch (this.fCurrElement.getEntryKind()) {
            case 5: {
                try {
                    string2 = JavaElementLabels.getContainerEntryLabel(this.fCurrElement.getPath(), this.fCurrElement.getJavaProject());
                }
                catch (JavaModelException javaModelException) {}
                string = NewWizardMessages.AccessRulesDialog_container_description;
                break;
            }
            case 2: {
                string = NewWizardMessages.AccessRulesDialog_project_description;
                break;
            }
            default: {
                string = NewWizardMessages.AccessRulesDialog_description;
            }
        }
        return Messages.format(string, string2);
    }

    protected void doCustomButtonPressed(ListDialogField listDialogField, int n) {
        if (n == 0) {
            this.addEntry(listDialogField);
        } else if (n == 1) {
            this.editEntry(listDialogField);
        }
    }

    protected void doDoubleClicked(ListDialogField listDialogField) {
        this.editEntry(listDialogField);
    }

    protected void doSelectionChanged(ListDialogField listDialogField) {
        List list = listDialogField.getSelectedElements();
        listDialogField.enableButton(1, this.canEdit(list));
    }

    private boolean canEdit(List list) {
        return list.size() == 1;
    }

    private void editEntry(ListDialogField listDialogField) {
        List list = listDialogField.getSelectedElements();
        if (list.size() != 1) {
            return;
        }
        IAccessRule iAccessRule = (IAccessRule)list.get(0);
        AccessRuleEntryDialog accessRuleEntryDialog = new AccessRuleEntryDialog(this.getShell(), iAccessRule, this.fCurrElement);
        if (accessRuleEntryDialog.open() == 0) {
            listDialogField.replaceElement(iAccessRule, accessRuleEntryDialog.getRule());
        }
    }

    private void addEntry(ListDialogField listDialogField) {
        AccessRuleEntryDialog accessRuleEntryDialog = new AccessRuleEntryDialog(this.getShell(), null, this.fCurrElement);
        if (accessRuleEntryDialog.open() == 0) {
            listDialogField.addElement(accessRuleEntryDialog.getRule());
        }
    }

    protected void doStatusLineUpdate() {
    }

    protected void checkIfPatternValid() {
    }

    public IAccessRule[] getAccessRules() {
        List list = this.fAccessRulesList.getElements();
        return list.toArray(new IAccessRule[list.size()]);
    }

    public boolean doCombineAccessRules() {
        return this.fCombineRulesCheckbox.isSelected();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.wst.jsdt.ui.access_rules_dialog_context");
    }

    public void performPageSwitch(IWorkbenchPreferenceContainer iWorkbenchPreferenceContainer) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("select_option_key", "org.eclipse.wst.jsdt.core.compiler.problem.forbiddenReference");
        hashMap.put("select_option_qualifier", "org.eclipse.wst.jsdt.core");
        iWorkbenchPreferenceContainer.openPage("org.eclipse.wst.jsdt.ui.propertyPages.ProblemSeveritiesPreferencePage", hashMap);
    }

    private class TypeRestrictionAdapter
    implements IListAdapter,
    IDialogFieldListener {
        private TypeRestrictionAdapter() {
        }

        public void customButtonPressed(ListDialogField listDialogField, int n) {
            AccessRulesDialog.this.doCustomButtonPressed(listDialogField, n);
        }

        public void selectionChanged(ListDialogField listDialogField) {
            AccessRulesDialog.this.doSelectionChanged(listDialogField);
        }

        public void doubleClicked(ListDialogField listDialogField) {
            AccessRulesDialog.this.doDoubleClicked(listDialogField);
        }

        public void dialogFieldChanged(DialogField dialogField) {
        }
    }
}

