/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public class ArchiveFileFilter
extends ViewerFilter {
    public static final String[] FILTER_EXTENSIONS = new String[]{"*.js"};
    private static final String[] fgArchiveExtensions = new String[]{"js"};
    private List fExcludes;
    private boolean fRecursive;

    public ArchiveFileFilter(IFile[] iFileArray, boolean bl) {
        this.fExcludes = iFileArray != null ? Arrays.asList(iFileArray) : null;
        this.fRecursive = bl;
    }

    public ArchiveFileFilter(List list, boolean bl) {
        this.fExcludes = list;
        this.fRecursive = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean select(Viewer viewer, Object object, Object object2) {
        if (object2 instanceof IFile) {
            if (this.fExcludes == null) return ArchiveFileFilter.isArchivePath(((IFile)object2).getFullPath());
            if (!this.fExcludes.contains(object2)) return ArchiveFileFilter.isArchivePath(((IFile)object2).getFullPath());
            return false;
        }
        if (!(object2 instanceof IContainer)) return false;
        if (!this.fRecursive) {
            return true;
        }
        if (object2 instanceof IProject && !((IProject)object2).isOpen()) {
            return false;
        }
        try {
            IResource[] iResourceArray = ((IContainer)object2).members();
            int n = 0;
            while (true) {
                if (n >= iResourceArray.length) {
                    return false;
                }
                if (this.select(viewer, object, iResourceArray[n])) {
                    return true;
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            JavaPlugin.log(coreException.getStatus());
        }
        return false;
    }

    public static boolean isArchivePath(IPath iPath) {
        String string = iPath.getFileExtension();
        if (string != null && string.length() != 0) {
            return ArchiveFileFilter.isArchiveFileExtension(string);
        }
        return false;
    }

    public static boolean isArchiveFileExtension(String string) {
        int n = 0;
        while (n < fgArchiveExtensions.length) {
            if (string.equalsIgnoreCase(fgArchiveExtensions[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

