/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.jsdt.core.ClasspathContainerInitializer;
import org.eclipse.wst.jsdt.core.IAccessRule;
import org.eclipse.wst.jsdt.core.IClasspathAttribute;
import org.eclipse.wst.jsdt.core.IClasspathContainer;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElementAttribute;

public class CPListElement {
    public static final String SOURCEATTACHMENT = "sourcepath";
    public static final String OUTPUT = "output";
    public static final String EXCLUSION = "exclusion";
    public static final String INCLUSION = "inclusion";
    public static final String SUPER_TYPE = "supertype";
    public static final String ACCESSRULES = "accessrules";
    public static final String COMBINE_ACCESSRULES = "combineaccessrules";
    public static final String JAVADOC = "javadoc_location";
    public static final String NATIVE_LIB_PATH = "org.eclipse.wst.jsdt.core.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY";
    private IJavaProject fProject;
    private int fEntryKind;
    private IPath fPath;
    private IPath fOrginalPath;
    private IResource fResource;
    private boolean fIsExported;
    private boolean fIsMissing;
    private Object fParentContainer;
    private IClasspathEntry fCachedEntry;
    private ArrayList fChildren;
    private IPath fLinkTarget;
    private IPath fOrginalLinkTarget;

    private CPListElement() {
    }

    public CPListElement(IJavaProject iJavaProject, int n, IPath iPath, IResource iResource) {
        this(null, iJavaProject, n, iPath, iResource);
    }

    public CPListElement(Object object, IJavaProject iJavaProject, int n, IPath iPath, IResource iResource) {
        this(object, iJavaProject, n, iPath, iResource, null);
    }

    public CPListElement(IJavaProject iJavaProject, int n) {
        this(null, iJavaProject, n, null, null);
    }

    public CPListElement(Object object, IJavaProject iJavaProject, int n, IPath iPath, IResource iResource, IPath iPath2) {
        this.fProject = iJavaProject;
        this.fEntryKind = n;
        this.fPath = iPath;
        this.fOrginalPath = iPath;
        this.fLinkTarget = iPath2;
        this.fOrginalLinkTarget = iPath2;
        this.fChildren = new ArrayList();
        this.fResource = iResource;
        this.fIsExported = false;
        this.fIsMissing = false;
        this.fCachedEntry = null;
        this.fParentContainer = object;
        ClasspathContainerInitializer classpathContainerInitializer = this.getContainerInitializer();
        boolean bl = true;
        if (classpathContainerInitializer != null) {
            bl = classpathContainerInitializer.allowAttachJsDoc();
        }
        switch (n) {
            case 3: {
                this.createAttributeElement(INCLUSION, new Path[0], true);
                this.createAttributeElement(EXCLUSION, new Path[0], true);
                break;
            }
            case 1: 
            case 4: {
                if (!bl) break;
                this.createAttributeElement(JAVADOC, null, false);
                break;
            }
            case 2: {
                this.createAttributeElement(COMBINE_ACCESSRULES, Boolean.FALSE, true);
                break;
            }
            case 5: {
                try {
                    IClasspathContainer iClasspathContainer = JavaCore.getClasspathContainer((IPath)this.fPath, (IJavaProject)this.fProject);
                    if (iClasspathContainer == null) break;
                    IClasspathEntry[] iClasspathEntryArray = iClasspathContainer.getClasspathEntries();
                    if (iClasspathEntryArray != null) {
                        int n2 = 0;
                        while (n2 < iClasspathEntryArray.length) {
                            IClasspathEntry iClasspathEntry = iClasspathEntryArray[n2];
                            if (iClasspathEntry != null) {
                                Object object2;
                                if (classpathContainerInitializer == null || (object2 = classpathContainerInitializer.getDescription(iClasspathEntry.getPath(), iJavaProject)) != null) {
                                    object2 = CPListElement.createFromExisting(this, iClasspathEntry, this.fProject);
                                    this.fChildren.add(object2);
                                }
                            } else {
                                JavaPlugin.logErrorMessage("Null entry in container '" + this.fPath + "'");
                            }
                            ++n2;
                        }
                        break;
                    }
                    JavaPlugin.logErrorMessage("container returns null as entries: '" + this.fPath + "'");
                    break;
                }
                catch (JavaModelException javaModelException) {}
            }
        }
    }

    public IClasspathEntry getClasspathEntry() {
        if (this.fCachedEntry == null) {
            this.fCachedEntry = this.newClasspathEntry();
        }
        return this.fCachedEntry;
    }

    private IClasspathAttribute[] getClasspathAttributes() {
        ArrayList<IClasspathAttribute> arrayList = new ArrayList<IClasspathAttribute>();
        int n = 0;
        while (n < this.fChildren.size()) {
            CPListElementAttribute cPListElementAttribute;
            Object e = this.fChildren.get(n);
            if (e instanceof CPListElementAttribute && !(cPListElementAttribute = (CPListElementAttribute)e).isBuiltIn() && cPListElementAttribute.getValue() != null) {
                arrayList.add(cPListElementAttribute.getClasspathAttribute());
            }
            ++n;
        }
        return arrayList.toArray(new IClasspathAttribute[arrayList.size()]);
    }

    private IClasspathEntry newClasspathEntry() {
        IClasspathAttribute[] iClasspathAttributeArray = this.getClasspathAttributes();
        switch (this.fEntryKind) {
            case 3: {
                IPath[] iPathArray = (IPath[])this.getAttribute(INCLUSION);
                IPath[] iPathArray2 = (IPath[])this.getAttribute(EXCLUSION);
                IPath iPath = (IPath)this.getAttribute(OUTPUT);
                return JavaCore.newSourceEntry((IPath)this.fPath, (IPath[])iPathArray, (IPath[])iPathArray2, (IPath)iPath, (IClasspathAttribute[])iClasspathAttributeArray);
            }
            case 1: {
                IPath iPath = (IPath)this.getAttribute(SOURCEATTACHMENT);
                IAccessRule[] iAccessRuleArray = (IAccessRule[])this.getAttribute(ACCESSRULES);
                return JavaCore.newLibraryEntry((IPath)this.fPath, (IPath)iPath, null, (IAccessRule[])iAccessRuleArray, (IClasspathAttribute[])iClasspathAttributeArray, (boolean)this.isExported());
            }
            case 2: {
                IAccessRule[] iAccessRuleArray = (IAccessRule[])this.getAttribute(ACCESSRULES);
                boolean bl = (Boolean)this.getAttribute(COMBINE_ACCESSRULES);
                return JavaCore.newProjectEntry((IPath)this.fPath, (IAccessRule[])iAccessRuleArray, (boolean)bl, (IClasspathAttribute[])iClasspathAttributeArray, (boolean)this.isExported());
            }
            case 5: {
                IAccessRule[] iAccessRuleArray = (IAccessRule[])this.getAttribute(ACCESSRULES);
                return JavaCore.newContainerEntry((IPath)this.fPath, (IAccessRule[])iAccessRuleArray, (IClasspathAttribute[])iClasspathAttributeArray, (boolean)this.isExported());
            }
            case 4: {
                IPath iPath = (IPath)this.getAttribute(SOURCEATTACHMENT);
                IAccessRule[] iAccessRuleArray = (IAccessRule[])this.getAttribute(ACCESSRULES);
                return JavaCore.newVariableEntry((IPath)this.fPath, (IPath)iPath, null, (IAccessRule[])iAccessRuleArray, (IClasspathAttribute[])iClasspathAttributeArray, (boolean)this.isExported());
            }
        }
        return null;
    }

    public IPath getPath() {
        return this.fPath;
    }

    public int getEntryKind() {
        return this.fEntryKind;
    }

    public IResource getResource() {
        return this.fResource;
    }

    public CPListElementAttribute setAttribute(String string, Object object) {
        CPListElementAttribute cPListElementAttribute = this.findAttributeElement(string);
        if (cPListElementAttribute == null) {
            return null;
        }
        if (string.equals(EXCLUSION) || string.equals(INCLUSION)) {
            Assert.isTrue((object != null || this.fEntryKind != 3 ? 1 : 0) != 0);
        }
        if (string.equals(ACCESSRULES)) {
            Assert.isTrue((object != null || this.fEntryKind == 3 ? 1 : 0) != 0);
        }
        if (string.equals(COMBINE_ACCESSRULES)) {
            Assert.isTrue((boolean)(object instanceof Boolean));
        }
        cPListElementAttribute.setValue(object);
        return cPListElementAttribute;
    }

    public boolean addToExclusions(IPath iPath) {
        String string = EXCLUSION;
        return this.addFilter(iPath, string);
    }

    public boolean addToInclusion(IPath iPath) {
        String string = INCLUSION;
        return this.addFilter(iPath, string);
    }

    public boolean removeFromExclusions(IPath iPath) {
        String string = EXCLUSION;
        return this.removeFilter(iPath, string);
    }

    public boolean removeFromInclusion(IPath iPath) {
        String string = INCLUSION;
        return this.removeFilter(iPath, string);
    }

    private boolean addFilter(IPath iPath, String string) {
        IPath[] iPathArray = (IPath[])this.getAttribute(string);
        if (iPathArray == null) {
            return false;
        }
        if (!JavaModelUtil.isExcludedPath(iPath, iPathArray)) {
            IPath iPath2 = iPath.removeFirstSegments(this.getPath().segmentCount()).addTrailingSeparator();
            IPath[] iPathArray2 = new IPath[iPathArray.length + 1];
            System.arraycopy(iPathArray, 0, iPathArray2, 0, iPathArray.length);
            iPathArray2[iPathArray.length] = iPath2;
            this.setAttribute(string, iPathArray2);
            return true;
        }
        return false;
    }

    private boolean removeFilter(IPath iPath, String string) {
        IPath[] iPathArray = (IPath[])this.getAttribute(string);
        if (iPathArray == null) {
            return false;
        }
        IPath iPath2 = iPath.removeFirstSegments(this.getPath().segmentCount()).addTrailingSeparator();
        if (JavaModelUtil.isExcludedPath(iPath2, iPathArray)) {
            ArrayList<IPath> arrayList = new ArrayList<IPath>(Arrays.asList(iPathArray));
            arrayList.remove(iPath2);
            IPath[] iPathArray2 = arrayList.toArray(new IPath[arrayList.size()]);
            this.setAttribute(string, iPathArray2);
            return true;
        }
        return false;
    }

    public CPListElementAttribute findAttributeElement(String string) {
        int n = 0;
        while (n < this.fChildren.size()) {
            CPListElementAttribute cPListElementAttribute;
            Object e = this.fChildren.get(n);
            if (e instanceof CPListElementAttribute && string.equals((cPListElementAttribute = (CPListElementAttribute)e).getKey())) {
                return cPListElementAttribute;
            }
            ++n;
        }
        return null;
    }

    public Object getAttribute(String string) {
        CPListElementAttribute cPListElementAttribute = this.findAttributeElement(string);
        if (cPListElementAttribute != null) {
            return cPListElementAttribute.getValue();
        }
        return null;
    }

    public CPListElementAttribute[] getAllAttributes() {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < this.fChildren.size()) {
            Object e = this.fChildren.get(n);
            if (e instanceof CPListElementAttribute) {
                arrayList.add(e);
            }
            ++n;
        }
        return arrayList.toArray(new CPListElementAttribute[arrayList.size()]);
    }

    private void createAttributeElement(String string, Object object, boolean bl) {
        this.fChildren.add(new CPListElementAttribute(this, string, object, bl));
    }

    private static boolean isFiltered(Object object, String[] stringArray) {
        if (object instanceof CPListElementAttribute) {
            CPListElementAttribute cPListElementAttribute = (CPListElementAttribute)object;
            String string = cPListElementAttribute.getKey();
            int n = 0;
            while (n < stringArray.length) {
                if (string.equals(stringArray[n])) {
                    return true;
                }
                ++n;
            }
            if (cPListElementAttribute.isNotSupported()) {
                return true;
            }
            if (!(cPListElementAttribute.isBuiltIn() || string.equals(JAVADOC) || string.equals(NATIVE_LIB_PATH))) {
                return !JavaPlugin.getDefault().getClasspathAttributeConfigurationDescriptors().containsKey(string);
            }
        }
        return false;
    }

    private Object[] getFilteredChildren(String[] stringArray) {
        int n = this.fChildren.size();
        ArrayList arrayList = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            Object e = this.fChildren.get(n2);
            if (!CPListElement.isFiltered(e, stringArray)) {
                arrayList.add(e);
            }
            ++n2;
        }
        return arrayList.toArray();
    }

    public Object[] getChildren(boolean bl) {
        if (bl && this.fEntryKind == 3) {
            return this.getFilteredChildren(new String[]{OUTPUT});
        }
        if (this.fEntryKind == 2) {
            return this.getFilteredChildren(new String[]{COMBINE_ACCESSRULES});
        }
        return this.getFilteredChildren(new String[0]);
    }

    public Object getParentContainer() {
        return this.fParentContainer;
    }

    protected void attributeChanged(String string) {
        this.fCachedEntry = null;
    }

    public ClasspathContainerInitializer getContainerInitializer() {
        if (this.fEntryKind == 5 && this.fProject != null) {
            ClasspathContainerInitializer classpathContainerInitializer = JavaCore.getClasspathContainerInitializer((String)this.fPath.segment(0));
            return classpathContainerInitializer;
        }
        if (this.fParentContainer != null && this.fParentContainer instanceof CPListElement) {
            return ((CPListElement)this.fParentContainer).getContainerInitializer();
        }
        return null;
    }

    private IStatus evaluateContainerChildStatus(CPListElementAttribute cPListElementAttribute) {
        if (this.fProject != null) {
            ClasspathContainerInitializer classpathContainerInitializer = JavaCore.getClasspathContainerInitializer((String)this.fPath.segment(0));
            if (classpathContainerInitializer != null && classpathContainerInitializer.canUpdateClasspathContainer(this.fPath, this.fProject)) {
                if (cPListElementAttribute.isBuiltIn()) {
                    if (SOURCEATTACHMENT.equals(cPListElementAttribute.getKey())) {
                        return classpathContainerInitializer.getSourceAttachmentStatus(this.fPath, this.fProject);
                    }
                    if (ACCESSRULES.equals(cPListElementAttribute.getKey())) {
                        return classpathContainerInitializer.getAccessRulesStatus(this.fPath, this.fProject);
                    }
                } else {
                    return classpathContainerInitializer.getAttributeStatus(this.fPath, this.fProject, cPListElementAttribute.getKey());
                }
            }
            return new Status(4, "org.eclipse.wst.jsdt.ui", 2, "", null);
        }
        return null;
    }

    private boolean canUpdateContainer() {
        if (this.fEntryKind == 5 && this.fProject != null) {
            ClasspathContainerInitializer classpathContainerInitializer = this.getContainerInitializer();
            return classpathContainerInitializer != null && classpathContainerInitializer.canUpdateClasspathContainer(this.fPath, this.fProject);
        }
        return false;
    }

    public boolean isInNonModifiableContainer() {
        if (this.fParentContainer != null && this.fParentContainer instanceof CPListElement) {
            return !((CPListElement)this.fParentContainer).canUpdateContainer();
        }
        return this.fParentContainer == null && !this.canUpdateContainer();
    }

    public IStatus getContainerChildStatus(CPListElementAttribute cPListElementAttribute) {
        if (this.fParentContainer instanceof CPListElement) {
            CPListElement cPListElement = (CPListElement)this.fParentContainer;
            if (cPListElement.getEntryKind() == 5) {
                return cPListElement.evaluateContainerChildStatus(cPListElementAttribute);
            }
            return ((CPListElement)this.fParentContainer).getContainerChildStatus(cPListElementAttribute);
        }
        return null;
    }

    public boolean isJRE() {
        IPath iPath = this.getPath();
        Path path = new Path("org.eclipse.wst.jsdt.launching.JRE_CONTAINER");
        return iPath != null && iPath.equals((Object)path);
    }

    public boolean isInContainer(String string) {
        if (this.fParentContainer instanceof CPListElement) {
            CPListElement cPListElement = (CPListElement)this.fParentContainer;
            return new Path(string).isPrefixOf(cPListElement.getPath());
        }
        return false;
    }

    public boolean isDeprecated() {
        if (this.fEntryKind != 4) {
            return false;
        }
        if (this.fPath.segmentCount() > 0) {
            return JavaCore.getClasspathVariableDeprecationMessage((String)this.fPath.segment(0)) != null;
        }
        return false;
    }

    public String getDeprecationMessage() {
        if (this.fEntryKind != 4) {
            return null;
        }
        if (this.fPath.segmentCount() > 0) {
            String string = this.fPath.segment(0);
            return BuildPathSupport.getDeprecationMessage(string);
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            CPListElement cPListElement = (CPListElement)object;
            return this.getClasspathEntry().equals(cPListElement.getClasspathEntry());
        }
        return false;
    }

    public int hashCode() {
        return this.fPath.hashCode() + this.fEntryKind;
    }

    public String toString() {
        return this.getClasspathEntry().toString();
    }

    public boolean isMissing() {
        return this.fIsMissing;
    }

    public void setIsMissing(boolean bl) {
        this.fIsMissing = bl;
    }

    public boolean isExported() {
        return this.fIsExported;
    }

    public void setExported(boolean bl) {
        if (bl != this.fIsExported) {
            this.fIsExported = bl;
            this.attributeChanged(null);
        }
    }

    public IJavaProject getJavaProject() {
        return this.fProject;
    }

    public static CPListElement createFromExisting(IClasspathEntry iClasspathEntry, IJavaProject iJavaProject) {
        return CPListElement.createFromExisting(null, iClasspathEntry, iJavaProject);
    }

    public static CPListElement createFromExisting(Object object, IClasspathEntry iClasspathEntry, IJavaProject iJavaProject) {
        Object object2;
        IPath iPath = iClasspathEntry.getPath();
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource iResource = null;
        boolean bl = false;
        IPath iPath2 = null;
        switch (iClasspathEntry.getEntryKind()) {
            case 5: {
                try {
                    bl = iJavaProject != null && JavaCore.getClasspathContainer((IPath)iPath, (IJavaProject)iJavaProject) == null;
                }
                catch (JavaModelException javaModelException) {
                    bl = true;
                }
                break;
            }
            case 4: {
                object2 = JavaCore.getResolvedVariablePath((IPath)iPath);
                bl = iWorkspaceRoot.findMember((IPath)object2) == null && !object2.toFile().isFile();
                break;
            }
            case 1: {
                iResource = iWorkspaceRoot.findMember(iPath);
                if (iResource == null) {
                    if (!ArchiveFileFilter.isArchivePath(iPath) && iWorkspaceRoot.getWorkspace().validatePath(iPath.toString(), 2).isOK() && iWorkspaceRoot.getProject(iPath.segment(0)).exists()) {
                        iResource = iWorkspaceRoot.getFolder(iPath);
                    }
                    bl = !iPath.toFile().isFile();
                    break;
                }
                if (!iResource.isLinked()) break;
                iPath2 = iResource.getLocation();
                break;
            }
            case 3: {
                iPath = iPath.removeTrailingSeparator();
                iResource = iWorkspaceRoot.findMember(iPath);
                if (iResource == null) {
                    if (iWorkspaceRoot.getWorkspace().validatePath(iPath.toString(), 2).isOK()) {
                        iResource = iWorkspaceRoot.getFolder(iPath);
                    }
                    bl = true;
                    break;
                }
                if (!iResource.isLinked()) break;
                iPath2 = iResource.getLocation();
                break;
            }
            case 2: {
                iResource = iWorkspaceRoot.findMember(iPath);
                bl = iResource == null;
            }
        }
        object2 = new CPListElement(object, iJavaProject, iClasspathEntry.getEntryKind(), iPath, iResource, iPath2);
        ((CPListElement)object2).setExported(iClasspathEntry.isExported());
        ((CPListElement)object2).setAttribute(SOURCEATTACHMENT, iClasspathEntry.getSourceAttachmentPath());
        ((CPListElement)object2).setAttribute(OUTPUT, iClasspathEntry.getOutputLocation());
        ((CPListElement)object2).setAttribute(EXCLUSION, iClasspathEntry.getExclusionPatterns());
        ((CPListElement)object2).setAttribute(INCLUSION, iClasspathEntry.getInclusionPatterns());
        ((CPListElement)object2).setAttribute(ACCESSRULES, iClasspathEntry.getAccessRules());
        ((CPListElement)object2).setAttribute(COMBINE_ACCESSRULES, new Boolean(iClasspathEntry.combineAccessRules()));
        IClasspathAttribute[] iClasspathAttributeArray = iClasspathEntry.getExtraAttributes();
        int n = 0;
        while (n < iClasspathAttributeArray.length) {
            IClasspathAttribute iClasspathAttribute = iClasspathAttributeArray[n];
            CPListElementAttribute cPListElementAttribute = ((CPListElement)object2).findAttributeElement(iClasspathAttribute.getName());
            if (cPListElementAttribute == null) {
                super.createAttributeElement(iClasspathAttribute.getName(), iClasspathAttribute.getValue(), false);
            } else {
                cPListElementAttribute.setValue(iClasspathAttribute.getValue());
            }
            ++n;
        }
        if (iJavaProject != null && iJavaProject.exists()) {
            ((CPListElement)object2).setIsMissing(bl);
        }
        return object2;
    }

    public static StringBuffer appendEncodePath(IPath iPath, StringBuffer stringBuffer) {
        if (iPath != null) {
            String string = iPath.toString();
            stringBuffer.append('[').append(string.length()).append(']').append(string);
        } else {
            stringBuffer.append('[').append(']');
        }
        return stringBuffer;
    }

    public static StringBuffer appendEncodedString(String string, StringBuffer stringBuffer) {
        if (string != null) {
            stringBuffer.append('[').append(string.length()).append(']').append(string);
        } else {
            stringBuffer.append('[').append(']');
        }
        return stringBuffer;
    }

    public static StringBuffer appendEncodedFilter(IPath[] iPathArray, StringBuffer stringBuffer) {
        if (iPathArray != null) {
            stringBuffer.append('[').append(iPathArray.length).append(']');
            int n = 0;
            while (n < iPathArray.length) {
                CPListElement.appendEncodePath(iPathArray[n], stringBuffer).append(';');
                ++n;
            }
        } else {
            stringBuffer.append('[').append(']');
        }
        return stringBuffer;
    }

    public static StringBuffer appendEncodedAccessRules(IAccessRule[] iAccessRuleArray, StringBuffer stringBuffer) {
        if (iAccessRuleArray != null) {
            stringBuffer.append('[').append(iAccessRuleArray.length).append(']');
            int n = 0;
            while (n < iAccessRuleArray.length) {
                CPListElement.appendEncodePath(iAccessRuleArray[n].getPattern(), stringBuffer).append(';');
                stringBuffer.append(iAccessRuleArray[n].getKind()).append(';');
                ++n;
            }
        } else {
            stringBuffer.append('[').append(']');
        }
        return stringBuffer;
    }

    public StringBuffer appendEncodedSettings(StringBuffer stringBuffer) {
        stringBuffer.append(this.fEntryKind).append(';');
        if (this.getLinkTarget() == null) {
            CPListElement.appendEncodePath(this.fPath, stringBuffer).append(';');
        } else {
            CPListElement.appendEncodePath(this.fPath, stringBuffer).append('-').append('>');
            CPListElement.appendEncodePath(this.getLinkTarget(), stringBuffer).append(';');
        }
        stringBuffer.append((Object)this.fIsExported).append(';');
        int n = 0;
        while (n < this.fChildren.size()) {
            Object e = this.fChildren.get(n);
            if (e instanceof CPListElementAttribute) {
                CPListElementAttribute cPListElementAttribute = (CPListElementAttribute)e;
                if (cPListElementAttribute.isBuiltIn()) {
                    String string = cPListElementAttribute.getKey();
                    if (OUTPUT.equals(string) || SOURCEATTACHMENT.equals(string)) {
                        CPListElement.appendEncodePath((IPath)cPListElementAttribute.getValue(), stringBuffer).append(';');
                    } else if (EXCLUSION.equals(string) || INCLUSION.equals(string)) {
                        CPListElement.appendEncodedFilter((IPath[])cPListElementAttribute.getValue(), stringBuffer).append(';');
                    } else if (ACCESSRULES.equals(string)) {
                        CPListElement.appendEncodedAccessRules((IAccessRule[])cPListElementAttribute.getValue(), stringBuffer).append(';');
                    } else if (COMBINE_ACCESSRULES.equals(string)) {
                        stringBuffer.append((Boolean)cPListElementAttribute.getValue()).append(';');
                    }
                } else {
                    CPListElement.appendEncodedString((String)cPListElementAttribute.getValue(), stringBuffer);
                }
            }
            ++n;
        }
        return stringBuffer;
    }

    public IPath getLinkTarget() {
        return this.fLinkTarget;
    }

    public void setPath(IPath iPath) {
        this.fCachedEntry = null;
        this.fPath = iPath;
    }

    public void setLinkTarget(IPath iPath) {
        this.fCachedEntry = null;
        this.fLinkTarget = iPath;
    }

    public static void insert(CPListElement cPListElement, List list) {
        int n = list.size();
        CPListElement[] cPListElementArray = list.toArray(new CPListElement[n]);
        int n2 = 0;
        while (n2 < n && cPListElementArray[n2].getEntryKind() != cPListElement.getEntryKind()) {
            ++n2;
        }
        if (n2 < n) {
            ++n2;
            while (n2 < n && cPListElementArray[n2].getEntryKind() == cPListElement.getEntryKind()) {
                ++n2;
            }
            list.add(n2, cPListElement);
            return;
        }
        switch (cPListElement.getEntryKind()) {
            case 3: {
                list.add(0, cPListElement);
                break;
            }
            default: {
                list.add(cPListElement);
            }
        }
    }

    public static IClasspathEntry[] convertToClasspathEntries(List list) {
        IClasspathEntry[] iClasspathEntryArray = new IClasspathEntry[list.size()];
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CPListElement cPListElement = (CPListElement)iterator.next();
            iClasspathEntryArray[n] = cPListElement.getClasspathEntry();
            ++n;
        }
        return iClasspathEntryArray;
    }

    public static CPListElement[] createFromExisting(IJavaProject iJavaProject) throws JavaModelException {
        IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
        CPListElement[] cPListElementArray = new CPListElement[iClasspathEntryArray.length];
        int n = 0;
        while (n < iClasspathEntryArray.length) {
            cPListElementArray[n] = CPListElement.createFromExisting(iClasspathEntryArray[n], iJavaProject);
            ++n;
        }
        return cPListElementArray;
    }

    public static boolean isProjectSourceFolder(CPListElement[] cPListElementArray, IJavaProject iJavaProject) {
        IPath iPath = iJavaProject.getProject().getFullPath();
        int n = 0;
        while (n < cPListElementArray.length) {
            IClasspathEntry iClasspathEntry = cPListElementArray[n].getClasspathEntry();
            if (iClasspathEntry.getEntryKind() == 3 && iPath.equals((Object)iClasspathEntry.getPath())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public IPath getOrginalPath() {
        return this.fOrginalPath;
    }

    public IPath getOrginalLinkTarget() {
        return this.fOrginalLinkTarget;
    }

    public CPListElement copy() {
        CPListElement cPListElement = new CPListElement();
        cPListElement.fProject = this.fProject;
        cPListElement.fEntryKind = this.fEntryKind;
        cPListElement.fPath = this.fPath;
        cPListElement.fOrginalPath = this.fOrginalPath;
        cPListElement.fResource = this.fResource;
        cPListElement.fIsExported = this.fIsExported;
        cPListElement.fIsMissing = this.fIsMissing;
        cPListElement.fParentContainer = this.fParentContainer;
        cPListElement.fCachedEntry = null;
        cPListElement.fChildren = new ArrayList(this.fChildren.size());
        Iterator iterator = this.fChildren.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof CPListElement) {
                cPListElement.fChildren.add(((CPListElement)e).copy());
                continue;
            }
            cPListElement.fChildren.add(((CPListElementAttribute)e).copy());
        }
        cPListElement.fLinkTarget = this.fLinkTarget;
        cPListElement.fOrginalLinkTarget = this.fOrginalLinkTarget;
        return cPListElement;
    }

    public void setAttributesFromExisting(CPListElement cPListElement) {
        Assert.isTrue((cPListElement.getEntryKind() == this.getEntryKind() ? 1 : 0) != 0);
        CPListElementAttribute[] cPListElementAttributeArray = cPListElement.getAllAttributes();
        int n = 0;
        while (n < cPListElementAttributeArray.length) {
            CPListElementAttribute cPListElementAttribute = cPListElementAttributeArray[n];
            CPListElementAttribute cPListElementAttribute2 = this.findAttributeElement(cPListElementAttribute.getKey());
            if (cPListElementAttribute2 == null) {
                this.createAttributeElement(cPListElementAttribute.getKey(), cPListElementAttribute.getValue(), false);
            } else {
                cPListElementAttribute2.setValue(cPListElementAttribute.getValue());
            }
            ++n;
        }
    }
}

