/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringDialogField;

public class NewSourceFolderDialog
extends StatusDialog {
    private SelectionButtonDialogField fUseProjectButton;
    private SelectionButtonDialogField fUseFolderButton;
    private StringDialogField fContainerDialogField;
    private StatusInfo fContainerFieldStatus;
    private IContainer fFolder;
    private List fExistingFolders;
    private IProject fCurrProject;

    public NewSourceFolderDialog(Shell shell, String string, IProject iProject, List list, CPListElement cPListElement) {
        super(shell);
        this.setTitle(string);
        this.fContainerFieldStatus = new StatusInfo();
        SourceContainerAdapter sourceContainerAdapter = new SourceContainerAdapter();
        this.fUseProjectButton = new SelectionButtonDialogField(16);
        this.fUseProjectButton.setLabelText(NewWizardMessages.NewSourceFolderDialog_useproject_button);
        this.fUseProjectButton.setDialogFieldListener(sourceContainerAdapter);
        this.fUseFolderButton = new SelectionButtonDialogField(16);
        this.fUseFolderButton.setLabelText(NewWizardMessages.NewSourceFolderDialog_usefolder_button);
        this.fUseFolderButton.setDialogFieldListener(sourceContainerAdapter);
        this.fContainerDialogField = new StringDialogField();
        this.fContainerDialogField.setDialogFieldListener(sourceContainerAdapter);
        this.fContainerDialogField.setLabelText(NewWizardMessages.NewSourceFolderDialog_sourcefolder_label);
        this.fUseFolderButton.attachDialogField(this.fContainerDialogField);
        this.fFolder = null;
        this.fExistingFolders = list;
        this.fCurrProject = iProject;
        boolean bl = true;
        if (cPListElement == null) {
            this.fContainerDialogField.setText("");
        } else {
            IPath iPath = cPListElement.getPath().removeFirstSegments(1);
            this.fContainerDialogField.setText(iPath.toString());
            bl = !iPath.isEmpty();
        }
        this.fUseFolderButton.setSelection(bl);
        this.fUseProjectButton.setSelection(!bl);
    }

    public void setMessage(String string) {
        this.fContainerDialogField.setLabelText(string);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 1;
        composite3.setLayout((Layout)gridLayout);
        int n = this.convertWidthInCharsToPixels(50);
        GridData gridData = new GridData(768);
        gridData.widthHint = n;
        if (this.fExistingFolders.contains(this.fCurrProject)) {
            this.fContainerDialogField.doFillIntoGrid(composite3, 2);
        } else {
            int n2;
            this.fUseProjectButton.doFillIntoGrid(composite3, 1);
            this.fUseFolderButton.doFillIntoGrid(composite3, 1);
            this.fContainerDialogField.getTextControl(composite3);
            gridData.horizontalIndent = n2 = this.convertWidthInCharsToPixels(3);
        }
        Text text = this.fContainerDialogField.getTextControl(null);
        text.setLayoutData((Object)gridData);
        TextFieldNavigationHandler.install(text);
        this.fContainerDialogField.postSetFocusOnDialogField(composite.getDisplay());
        NewSourceFolderDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    protected void doStatusLineUpdate() {
        this.checkIfPathValid();
        this.updateStatus(this.fContainerFieldStatus);
    }

    protected void checkIfPathValid() {
        this.fFolder = null;
        IProject iProject = null;
        if (this.fUseFolderButton.isSelected()) {
            String string = this.fContainerDialogField.getText();
            if (string.length() == 0) {
                this.fContainerFieldStatus.setError(NewWizardMessages.NewSourceFolderDialog_error_enterpath);
                return;
            }
            IPath iPath = this.fCurrProject.getFullPath().append(string);
            IWorkspace iWorkspace = this.fCurrProject.getWorkspace();
            IStatus iStatus = iWorkspace.validatePath(iPath.toString(), 2);
            if (!iStatus.isOK()) {
                this.fContainerFieldStatus.setError(Messages.format(NewWizardMessages.NewSourceFolderDialog_error_invalidpath, iStatus.getMessage()));
                return;
            }
            iProject = this.fCurrProject.getFolder(string);
        } else {
            iProject = this.fCurrProject;
        }
        if (this.isExisting((IContainer)iProject)) {
            this.fContainerFieldStatus.setError(NewWizardMessages.NewSourceFolderDialog_error_pathexists);
            return;
        }
        this.fContainerFieldStatus.setOK();
        this.fFolder = iProject;
    }

    private boolean isExisting(IContainer iContainer) {
        return this.fExistingFolders.contains(iContainer);
    }

    public IContainer getSourceFolder() {
        return this.fFolder;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.wst.jsdt.ui.new_container_dialog_context");
    }

    private class SourceContainerAdapter
    implements IDialogFieldListener {
        private SourceContainerAdapter() {
        }

        public void dialogFieldChanged(DialogField dialogField) {
            NewSourceFolderDialog.this.doStatusLineUpdate();
        }
    }
}

