/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.jsdt.core.IAccessRule;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.AccessRulesDialog;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElementSorter;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.wst.jsdt.ui.JavaElementComparator;

public class ProjectsWorkbookPage
extends BuildPathBasePage {
    private final int IDX_ADDPROJECT = 0;
    private final int IDX_EDIT = 2;
    private final int IDX_REMOVE = 3;
    private ListDialogField fClassPathList;
    private IJavaProject fCurrJProject;
    private TreeListDialogField fProjectsList;
    private Control fSWTControl;
    private final IWorkbenchPreferenceContainer fPageContainer;

    public ProjectsWorkbookPage(ListDialogField listDialogField, IWorkbenchPreferenceContainer iWorkbenchPreferenceContainer) {
        this.fClassPathList = listDialogField;
        this.fPageContainer = iWorkbenchPreferenceContainer;
        this.fSWTControl = null;
        String[] stringArray = new String[4];
        stringArray[0] = NewWizardMessages.ProjectsWorkbookPage_projects_add_button;
        stringArray[2] = NewWizardMessages.ProjectsWorkbookPage_projects_edit_button;
        stringArray[3] = NewWizardMessages.ProjectsWorkbookPage_projects_remove_button;
        String[] stringArray2 = stringArray;
        ProjectsAdapter projectsAdapter = new ProjectsAdapter();
        this.fProjectsList = new TreeListDialogField(projectsAdapter, stringArray2, (ILabelProvider)new CPListLabelProvider());
        this.fProjectsList.setDialogFieldListener(projectsAdapter);
        this.fProjectsList.setLabelText(NewWizardMessages.ProjectsWorkbookPage_projects_label);
        this.fProjectsList.enableButton(3, false);
        this.fProjectsList.enableButton(2, false);
        this.fProjectsList.setViewerComparator(new CPListElementSorter());
    }

    public void init(final IJavaProject iJavaProject) {
        this.fCurrJProject = iJavaProject;
        if (Display.getCurrent() != null) {
            this.updateProjectsList(iJavaProject);
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ProjectsWorkbookPage.this.updateProjectsList(iJavaProject);
                }
            });
        }
    }

    private void updateProjectsList(IJavaProject iJavaProject) {
        List list = this.fClassPathList.getElements();
        ArrayList<CPListElement> arrayList = new ArrayList<CPListElement>(list.size());
        int n = list.size() - 1;
        while (n >= 0) {
            CPListElement cPListElement = (CPListElement)list.get(n);
            if (this.isEntryKind(cPListElement.getEntryKind())) {
                arrayList.add(cPListElement);
            }
            --n;
        }
        this.fProjectsList.setElements(arrayList);
    }

    public Control getControl(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        LayoutUtil.doDefaultLayout(composite2, new DialogField[]{this.fProjectsList}, true, -1, -1);
        LayoutUtil.setHorizontalGrabbing(this.fProjectsList.getTreeControl(null));
        int n = pixelConverter.convertWidthInCharsToPixels(24);
        this.fProjectsList.setButtonsMinWidth(n);
        this.fSWTControl = composite2;
        return composite2;
    }

    private void updateClasspathList() {
        List list = this.fProjectsList.getElements();
        boolean bl = false;
        List list2 = this.fClassPathList.getElements();
        int n = list2.size() - 1;
        while (n >= 0) {
            CPListElement cPListElement = (CPListElement)list2.get(n);
            if (this.isEntryKind(cPListElement.getEntryKind()) && !list.remove(cPListElement)) {
                list2.remove(n);
                bl = true;
            }
            --n;
        }
        n = 0;
        while (n < list.size()) {
            list2.add(list.get(n));
            ++n;
        }
        if (bl || list.size() > 0) {
            this.fClassPathList.setElements(list2);
        }
    }

    public List getSelection() {
        return this.fProjectsList.getSelectedElements();
    }

    public void setSelection(List list, boolean bl) {
        this.fProjectsList.selectElements((ISelection)new StructuredSelection(list));
        if (bl) {
            int n = 0;
            while (n < list.size()) {
                this.fProjectsList.expandElement(list.get(n), 1);
                ++n;
            }
        }
    }

    public boolean isEntryKind(int n) {
        return n == 2;
    }

    private void projectPageCustomButtonPressed(DialogField dialogField, int n) {
        Object[] objectArray = null;
        switch (n) {
            case 0: {
                objectArray = this.openProjectDialog(null);
                break;
            }
            case 2: {
                this.editEntry();
                return;
            }
            case 3: {
                this.removeEntry();
                return;
            }
        }
        if (objectArray != null) {
            int n2 = objectArray.length;
            List list = this.fProjectsList.getElements();
            ArrayList<CPListElement> arrayList = new ArrayList<CPListElement>(n2);
            int n3 = 0;
            while (n3 < n2) {
                CPListElement cPListElement = objectArray[n3];
                if (!list.contains(cPListElement) && !arrayList.contains(cPListElement)) {
                    arrayList.add(cPListElement);
                }
                ++n3;
            }
            this.fProjectsList.addElements(arrayList);
            if (n == 0) {
                this.fProjectsList.refresh();
            }
            this.fProjectsList.postSetSelection((ISelection)new StructuredSelection(objectArray));
        }
    }

    private void removeEntry() {
        List list = this.fProjectsList.getSelectedElements();
        int n = list.size() - 1;
        while (n >= 0) {
            Object e = list.get(n);
            if (e instanceof CPListElementAttribute) {
                CPListElementAttribute cPListElementAttribute = (CPListElementAttribute)e;
                if (cPListElementAttribute.isBuiltIn()) {
                    String string = cPListElementAttribute.getKey();
                    IAccessRule[] iAccessRuleArray = null;
                    if (string.equals("accessrules")) {
                        iAccessRuleArray = new IAccessRule[]{};
                    }
                    cPListElementAttribute.getParent().setAttribute(string, iAccessRuleArray);
                } else {
                    this.removeCustomAttribute(cPListElementAttribute);
                }
                list.remove(n);
            }
            --n;
        }
        if (list.isEmpty()) {
            this.fProjectsList.refresh();
            this.fClassPathList.dialogFieldChanged();
        } else {
            this.fProjectsList.removeElements(list);
        }
    }

    private boolean canRemove(List list) {
        if (list.size() == 0) {
            return false;
        }
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            if (e instanceof CPListElementAttribute) {
                CPListElementAttribute cPListElementAttribute = (CPListElementAttribute)e;
                if (cPListElementAttribute.isNonModifiable()) {
                    return false;
                }
                if (cPListElementAttribute.isBuiltIn() ? ("accessrules".equals(cPListElementAttribute.getKey()) ? ((IAccessRule[])cPListElementAttribute.getValue()).length == 0 : cPListElementAttribute.getValue() == null) : !this.canRemoveCustomAttribute(cPListElementAttribute)) {
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    private boolean canEdit(List list) {
        if (list.size() != 1) {
            return false;
        }
        Object e = list.get(0);
        if (e instanceof CPListElement) {
            return false;
        }
        if (e instanceof CPListElementAttribute) {
            CPListElementAttribute cPListElementAttribute = (CPListElementAttribute)e;
            if (cPListElementAttribute.isNonModifiable()) {
                return false;
            }
            if (!cPListElementAttribute.isBuiltIn()) {
                return this.canEditCustomAttribute(cPListElementAttribute);
            }
            return true;
        }
        return false;
    }

    private void editEntry() {
        List list = this.fProjectsList.getSelectedElements();
        if (list.size() != 1) {
            return;
        }
        Object e = list.get(0);
        if (this.fProjectsList.getIndexOfElement(e) != -1) {
            this.editElementEntry((CPListElement)e);
        } else if (e instanceof CPListElementAttribute) {
            this.editAttributeEntry((CPListElementAttribute)e);
        }
    }

    private void editAttributeEntry(CPListElementAttribute cPListElementAttribute) {
        String string = cPListElementAttribute.getKey();
        if (string.equals("accessrules")) {
            this.showAccessRestrictionDialog(cPListElementAttribute.getParent());
        } else if (this.editCustomAttribute(this.getShell(), cPListElementAttribute)) {
            this.fProjectsList.refresh();
            this.fClassPathList.dialogFieldChanged();
        }
    }

    private void showAccessRestrictionDialog(CPListElement cPListElement) {
        AccessRulesDialog accessRulesDialog = new AccessRulesDialog(this.getShell(), cPListElement, this.fCurrJProject, this.fPageContainer != null);
        int n = accessRulesDialog.open();
        if (n == 0 || n == 10) {
            cPListElement.setAttribute("accessrules", accessRulesDialog.getAccessRules());
            cPListElement.setAttribute("combineaccessrules", new Boolean(accessRulesDialog.doCombineAccessRules()));
            this.fProjectsList.refresh();
            this.fClassPathList.dialogFieldChanged();
            if (n == 10) {
                accessRulesDialog.performPageSwitch(this.fPageContainer);
            }
        }
    }

    private void editElementEntry(CPListElement cPListElement) {
        CPListElement[] cPListElementArray = this.openProjectDialog(cPListElement);
        if (cPListElementArray != null && cPListElementArray.length > 0) {
            CPListElement cPListElement2 = cPListElementArray[0];
            cPListElement2.setExported(cPListElement.isExported());
            this.fProjectsList.replaceElement(cPListElement, cPListElement2);
        }
    }

    private Shell getShell() {
        if (this.fSWTControl != null) {
            return this.fSWTControl.getShell();
        }
        return JavaPlugin.getActiveWorkbenchShell();
    }

    private CPListElement[] openProjectDialog(CPListElement cPListElement) {
        try {
            Object[] objectArray;
            CPListElement cPListElement2;
            ArrayList<IJavaProject> arrayList = new ArrayList<IJavaProject>();
            arrayList.addAll(Arrays.asList(this.fCurrJProject.getJavaModel().getJavaProjects()));
            arrayList.remove(this.fCurrJProject);
            List list = this.fProjectsList.getElements();
            int n = 0;
            while (n < list.size()) {
                cPListElement2 = (CPListElement)list.get(0);
                objectArray = (Object[])JavaCore.create((IResource)cPListElement2.getResource());
                arrayList.remove(objectArray);
                ++n;
            }
            Object[] objectArray2 = arrayList.toArray();
            new JavaElementComparator().sort(null, objectArray2);
            cPListElement2 = new ListSelectionDialog(this.getShell(), Arrays.asList(objectArray2), (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new JavaUILabelProvider(), NewWizardMessages.ProjectsWorkbookPage_chooseProjects_message);
            cPListElement2.setTitle(NewWizardMessages.ProjectsWorkbookPage_chooseProjects_title);
            cPListElement2.setHelpAvailable(false);
            if (cPListElement2.open() == 0) {
                objectArray = cPListElement2.getResult();
                CPListElement[] cPListElementArray = new CPListElement[objectArray.length];
                int n2 = 0;
                while (n2 < objectArray.length) {
                    IJavaProject iJavaProject = (IJavaProject)objectArray[n2];
                    cPListElementArray[n2] = new CPListElement(this.fCurrJProject, 2, iJavaProject.getPath(), iJavaProject.getResource());
                    ++n2;
                }
                return cPListElementArray;
            }
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        return null;
    }

    protected void projectPageDoubleClicked(TreeListDialogField treeListDialogField) {
        List list = this.fProjectsList.getSelectedElements();
        if (this.canEdit(list)) {
            this.editEntry();
        }
    }

    protected void projectPageKeyPressed(TreeListDialogField treeListDialogField, KeyEvent keyEvent) {
        List list;
        if (treeListDialogField == this.fProjectsList && keyEvent.character == '\u007f' && keyEvent.stateMask == 0 && this.canRemove(list = treeListDialogField.getSelectedElements())) {
            this.removeEntry();
        }
    }

    private void projectPageDialogFieldChanged(DialogField dialogField) {
        if (this.fCurrJProject != null) {
            this.updateClasspathList();
        }
    }

    private void projectPageSelectionChanged(DialogField dialogField) {
        List list = this.fProjectsList.getSelectedElements();
        this.fProjectsList.enableButton(2, this.canEdit(list));
        this.fProjectsList.enableButton(3, this.canRemove(list));
        boolean bl = this.containsOnlyTopLevelEntries(list);
        this.fProjectsList.enableButton(0, bl);
    }

    public void setFocus() {
        this.fProjectsList.setFocus();
    }

    private class ProjectsAdapter
    implements IDialogFieldListener,
    ITreeListAdapter {
        private final Object[] EMPTY_ARR = new Object[0];

        private ProjectsAdapter() {
        }

        public void customButtonPressed(TreeListDialogField treeListDialogField, int n) {
            ProjectsWorkbookPage.this.projectPageCustomButtonPressed(treeListDialogField, n);
        }

        public void selectionChanged(TreeListDialogField treeListDialogField) {
            ProjectsWorkbookPage.this.projectPageSelectionChanged(treeListDialogField);
        }

        public void doubleClicked(TreeListDialogField treeListDialogField) {
            ProjectsWorkbookPage.this.projectPageDoubleClicked(treeListDialogField);
        }

        public void keyPressed(TreeListDialogField treeListDialogField, KeyEvent keyEvent) {
            ProjectsWorkbookPage.this.projectPageKeyPressed(treeListDialogField, keyEvent);
        }

        public Object[] getChildren(TreeListDialogField treeListDialogField, Object object) {
            if (object instanceof CPListElement) {
                return ((CPListElement)object).getChildren(false);
            }
            return this.EMPTY_ARR;
        }

        public Object getParent(TreeListDialogField treeListDialogField, Object object) {
            if (object instanceof CPListElementAttribute) {
                return ((CPListElementAttribute)object).getParent();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField treeListDialogField, Object object) {
            return this.getChildren(treeListDialogField, object).length > 0;
        }

        public void dialogFieldChanged(DialogField dialogField) {
            ProjectsWorkbookPage.this.projectPageDialogFieldChanged(dialogField);
        }
    }
}

