/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaModelStatus;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.ExclusionInclusionEntryDialog;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.wst.jsdt.ui.wizards.NewElementWizardPage;

public class SetFilterWizardPage
extends NewElementWizardPage {
    private static final String PAGE_NAME = "SetFilterWizardPage";
    private ListDialogField fInclusionPatternList;
    private ListDialogField fExclusionPatternList;
    private CPListElement fCurrElement;
    private IProject fCurrProject;
    private IContainer fCurrSourceFolder;
    private static final int IDX_ADD = 0;
    private static final int IDX_ADD_MULTIPLE = 1;
    private static final int IDX_EDIT = 2;
    private static final int IDX_REMOVE = 4;
    private final ArrayList fExistingEntries;
    private final IPath fOutputLocation;

    public SetFilterWizardPage(CPListElement cPListElement, ArrayList arrayList, IPath iPath) {
        super(PAGE_NAME);
        this.fExistingEntries = arrayList;
        this.fOutputLocation = iPath;
        this.setTitle(NewWizardMessages.ExclusionInclusionDialog_title);
        this.setDescription(NewWizardMessages.ExclusionInclusionDialog_description2);
        this.fCurrElement = cPListElement;
        this.fCurrProject = cPListElement.getJavaProject().getProject();
        IWorkspaceRoot iWorkspaceRoot = this.fCurrProject.getWorkspace().getRoot();
        IResource iResource = iWorkspaceRoot.findMember(cPListElement.getPath());
        if (iResource instanceof IContainer) {
            this.fCurrSourceFolder = (IContainer)iResource;
        }
        String string = NewWizardMessages.ExclusionInclusionDialog_exclusion_pattern_label;
        ImageDescriptor imageDescriptor = JavaPluginImages.DESC_OBJS_EXCLUSION_FILTER_ATTRIB;
        String[] stringArray = new String[5];
        stringArray[0] = NewWizardMessages.ExclusionInclusionDialog_exclusion_pattern_add;
        stringArray[1] = NewWizardMessages.ExclusionInclusionDialog_exclusion_pattern_add_multiple;
        stringArray[2] = NewWizardMessages.ExclusionInclusionDialog_exclusion_pattern_edit;
        stringArray[4] = NewWizardMessages.ExclusionInclusionDialog_exclusion_pattern_remove;
        String[] stringArray2 = stringArray;
        String string2 = NewWizardMessages.ExclusionInclusionDialog_inclusion_pattern_label;
        ImageDescriptor imageDescriptor2 = JavaPluginImages.DESC_OBJS_INCLUSION_FILTER_ATTRIB;
        String[] stringArray3 = new String[5];
        stringArray3[0] = NewWizardMessages.ExclusionInclusionDialog_inclusion_pattern_add;
        stringArray3[1] = NewWizardMessages.ExclusionInclusionDialog_inclusion_pattern_add_multiple;
        stringArray3[2] = NewWizardMessages.ExclusionInclusionDialog_inclusion_pattern_edit;
        stringArray3[4] = NewWizardMessages.ExclusionInclusionDialog_inclusion_pattern_remove;
        String[] stringArray4 = stringArray3;
        this.fExclusionPatternList = this.createListContents(cPListElement, "exclusion", string, imageDescriptor, stringArray2);
        this.fInclusionPatternList = this.createListContents(cPListElement, "inclusion", string2, imageDescriptor2, stringArray4);
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        this.fInclusionPatternList.doFillIntoGrid(composite2, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fInclusionPatternList.getLabelControl(null), 2);
        LayoutUtil.setHorizontalGrabbing(this.fInclusionPatternList.getListControl(null));
        this.fExclusionPatternList.doFillIntoGrid(composite2, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fExclusionPatternList.getLabelControl(null), 2);
        LayoutUtil.setHorizontalGrabbing(this.fExclusionPatternList.getListControl(null));
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.wst.jsdt.ui.edit_inclusion_exlusion_filter_wizard_page_context");
    }

    private ListDialogField createListContents(CPListElement cPListElement, String string, String string2, ImageDescriptor imageDescriptor, String[] stringArray) {
        ExclusionPatternAdapter exclusionPatternAdapter = new ExclusionPatternAdapter();
        ListDialogField listDialogField = new ListDialogField(exclusionPatternAdapter, stringArray, (ILabelProvider)new ExclusionInclusionLabelProvider(imageDescriptor));
        listDialogField.setDialogFieldListener(exclusionPatternAdapter);
        listDialogField.setLabelText(string2);
        listDialogField.enableButton(2, false);
        IPath[] iPathArray = (IPath[])cPListElement.getAttribute(string);
        ArrayList<String> arrayList = new ArrayList<String>(iPathArray.length);
        int n = 0;
        while (n < iPathArray.length) {
            String string3 = iPathArray[n].toString();
            if (string3.length() > 0) {
                arrayList.add(string3);
            }
            ++n;
        }
        listDialogField.setElements(arrayList);
        listDialogField.selectFirstElement();
        listDialogField.enableButton(1, this.fCurrSourceFolder != null);
        listDialogField.setViewerComparator(new ViewerComparator());
        return listDialogField;
    }

    protected void doCustomButtonPressed(ListDialogField listDialogField, int n) {
        if (n == 0) {
            this.addEntry(listDialogField);
        } else if (n == 2) {
            this.editEntry(listDialogField);
        } else if (n == 1) {
            this.addMultipleEntries(listDialogField);
        } else if (n == 4) {
            listDialogField.removeElements(listDialogField.getSelectedElements());
        }
        this.updateStatus();
    }

    private void updateStatus() {
        IJavaModelStatus iJavaModelStatus = JavaConventions.validateClasspath((IJavaProject)this.fCurrElement.getJavaProject(), (IClasspathEntry[])CPListElement.convertToClasspathEntries(this.fExistingEntries), (IPath)this.fOutputLocation);
        if (!iJavaModelStatus.isOK()) {
            StatusInfo statusInfo = new StatusInfo();
            statusInfo.setError(iJavaModelStatus.getMessage());
            this.updateStatus(statusInfo);
        } else {
            StatusInfo statusInfo = new StatusInfo();
            statusInfo.setOK();
            this.updateStatus(statusInfo);
        }
    }

    protected void doDoubleClicked(ListDialogField listDialogField) {
        this.editEntry(listDialogField);
        this.updateStatus();
    }

    protected void doSelectionChanged(ListDialogField listDialogField) {
        List list = listDialogField.getSelectedElements();
        listDialogField.enableButton(2, this.canEdit(list));
    }

    private boolean canEdit(List list) {
        return list.size() == 1;
    }

    private void editEntry(ListDialogField listDialogField) {
        List list = listDialogField.getSelectedElements();
        if (list.size() != 1) {
            return;
        }
        List list2 = listDialogField.getElements();
        String string = (String)list.get(0);
        ExclusionInclusionEntryDialog exclusionInclusionEntryDialog = new ExclusionInclusionEntryDialog(this.getShell(), this.isExclusion(listDialogField), string, list2, this.fCurrElement);
        if (exclusionInclusionEntryDialog.open() == 0) {
            listDialogField.replaceElement(string, exclusionInclusionEntryDialog.getExclusionPattern());
        }
    }

    private boolean isExclusion(ListDialogField listDialogField) {
        return listDialogField == this.fExclusionPatternList;
    }

    private void addEntry(ListDialogField listDialogField) {
        List list = listDialogField.getElements();
        ExclusionInclusionEntryDialog exclusionInclusionEntryDialog = new ExclusionInclusionEntryDialog(this.getShell(), this.isExclusion(listDialogField), null, list, this.fCurrElement);
        if (exclusionInclusionEntryDialog.open() == 0) {
            listDialogField.addElement(exclusionInclusionEntryDialog.getExclusionPattern());
        }
    }

    protected void doStatusLineUpdate() {
    }

    protected void checkIfPatternValid() {
    }

    private IPath[] getPattern(ListDialogField listDialogField) {
        Object[] objectArray = listDialogField.getElements().toArray();
        Arrays.sort(objectArray);
        IPath[] iPathArray = new IPath[objectArray.length];
        int n = 0;
        while (n < iPathArray.length) {
            iPathArray[n] = new Path((String)objectArray[n]);
            ++n;
        }
        return iPathArray;
    }

    public IPath[] getExclusionPattern() {
        return this.getPattern(this.fExclusionPatternList);
    }

    public IPath[] getInclusionPattern() {
        return this.getPattern(this.fInclusionPatternList);
    }

    protected void configureShell(Shell shell) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.wst.jsdt.ui.exclusion_pattern_dialog_context");
    }

    private void addMultipleEntries(ListDialogField listDialogField) {
        String string;
        String string2;
        if (this.isExclusion(listDialogField)) {
            string2 = NewWizardMessages.ExclusionInclusionDialog_ChooseExclusionPattern_title;
            string = NewWizardMessages.ExclusionInclusionDialog_ChooseExclusionPattern_description;
        } else {
            string2 = NewWizardMessages.ExclusionInclusionDialog_ChooseInclusionPattern_title;
            string = NewWizardMessages.ExclusionInclusionDialog_ChooseInclusionPattern_description;
        }
        IPath[] iPathArray = ExclusionInclusionEntryDialog.chooseExclusionPattern(this.getShell(), this.fCurrSourceFolder, string2, string, null, true);
        if (iPathArray != null) {
            int n = 0;
            while (n < iPathArray.length) {
                listDialogField.addElement(iPathArray[n].toString());
                ++n;
            }
        }
    }

    private static class ExclusionInclusionLabelProvider
    extends LabelProvider {
        private Image fElementImage;

        public ExclusionInclusionLabelProvider(ImageDescriptor imageDescriptor) {
            ImageDescriptorRegistry imageDescriptorRegistry = JavaPlugin.getImageDescriptorRegistry();
            this.fElementImage = imageDescriptorRegistry.get(imageDescriptor);
        }

        public Image getImage(Object object) {
            return this.fElementImage;
        }

        public String getText(Object object) {
            return (String)object;
        }
    }

    private class ExclusionPatternAdapter
    implements IListAdapter,
    IDialogFieldListener {
        private ExclusionPatternAdapter() {
        }

        public void customButtonPressed(ListDialogField listDialogField, int n) {
            SetFilterWizardPage.this.doCustomButtonPressed(listDialogField, n);
        }

        public void selectionChanged(ListDialogField listDialogField) {
            SetFilterWizardPage.this.doSelectionChanged(listDialogField);
        }

        public void doubleClicked(ListDialogField listDialogField) {
            SetFilterWizardPage.this.doDoubleClicked(listDialogField);
        }

        public void dialogFieldChanged(DialogField dialogField) {
        }
    }
}

