/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaModel;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.util.CoreUtility;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPVariableElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPVariableElementLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.VariableCreationDialog;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ListDialogField;

public class VariableBlock {
    private ListDialogField fVariablesList;
    private Control fControl;
    private CLabel fWarning;
    private boolean fHasChanges;
    private List fSelectedElements = new ArrayList(0);
    private boolean fAskToBuild;
    private final boolean fEditOnDoubleclick;

    public VariableBlock(boolean bl, String string) {
        this.fEditOnDoubleclick = bl;
        this.fAskToBuild = true;
        String[] stringArray = new String[]{NewWizardMessages.VariableBlock_vars_add_button, NewWizardMessages.VariableBlock_vars_edit_button, NewWizardMessages.VariableBlock_vars_remove_button};
        VariablesAdapter variablesAdapter = new VariablesAdapter();
        CPVariableElementLabelProvider cPVariableElementLabelProvider = new CPVariableElementLabelProvider(bl);
        this.fVariablesList = new ListDialogField(variablesAdapter, stringArray, (ILabelProvider)cPVariableElementLabelProvider);
        this.fVariablesList.setDialogFieldListener(variablesAdapter);
        this.fVariablesList.setLabelText(NewWizardMessages.VariableBlock_vars_label);
        this.fVariablesList.setRemoveButtonIndex(2);
        this.fVariablesList.enableButton(1, false);
        this.fVariablesList.setViewerComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object object, Object object2) {
                if (object instanceof CPVariableElement && object2 instanceof CPVariableElement) {
                    return this.getComparator().compare(((CPVariableElement)object).getName(), ((CPVariableElement)object2).getName());
                }
                return super.compare(viewer, object, object2);
            }
        });
        this.refresh(string);
    }

    public boolean hasChanges() {
        return this.fHasChanges;
    }

    public void setChanges(boolean bl) {
        this.fHasChanges = bl;
    }

    public Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        LayoutUtil.doDefaultLayout(composite2, new DialogField[]{this.fVariablesList}, true, 0, 0);
        LayoutUtil.setHorizontalGrabbing(this.fVariablesList.getListControl(null));
        this.fWarning = new CLabel(composite2, 0);
        this.fWarning.setLayoutData((Object)new GridData(4, 128, true, false, this.fVariablesList.getNumberOfControls() - 1, 1));
        this.fControl = composite2;
        this.updateDeprecationWarning();
        return composite2;
    }

    public void addDoubleClickListener(IDoubleClickListener iDoubleClickListener) {
        this.fVariablesList.getTableViewer().addDoubleClickListener(iDoubleClickListener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fVariablesList.getTableViewer().addSelectionChangedListener(iSelectionChangedListener);
    }

    private Shell getShell() {
        if (this.fControl != null) {
            return this.fControl.getShell();
        }
        return JavaPlugin.getActiveWorkbenchShell();
    }

    private boolean containsReadOnly(List list) {
        int n = list.size() - 1;
        while (n >= 0) {
            if (((CPVariableElement)list.get(n)).isReadOnly()) {
                return true;
            }
            --n;
        }
        return false;
    }

    private boolean canEdit(List list, boolean bl) {
        return list.size() == 1 && !bl;
    }

    private void doSelectionChanged(DialogField dialogField) {
        List list = this.fVariablesList.getSelectedElements();
        boolean bl = this.containsReadOnly(list);
        this.fVariablesList.enableButton(1, this.canEdit(list, bl));
        this.fVariablesList.enableButton(2, !bl);
        this.fSelectedElements = list;
        this.updateDeprecationWarning();
    }

    private void updateDeprecationWarning() {
        if (this.fWarning == null || this.fWarning.isDisposed()) {
            return;
        }
        Iterator iterator = this.fSelectedElements.iterator();
        while (iterator.hasNext()) {
            CPVariableElement cPVariableElement = (CPVariableElement)iterator.next();
            String string = cPVariableElement.getDeprecationMessage();
            if (string == null) continue;
            this.fWarning.setText(string);
            this.fWarning.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
            return;
        }
        this.fWarning.setText(null);
        this.fWarning.setImage(null);
    }

    private void editEntries(CPVariableElement cPVariableElement) {
        List list = this.fVariablesList.getElements();
        VariableCreationDialog variableCreationDialog = new VariableCreationDialog(this.getShell(), cPVariableElement, list);
        if (variableCreationDialog.open() != 0) {
            return;
        }
        CPVariableElement cPVariableElement2 = variableCreationDialog.getClasspathElement();
        if (cPVariableElement == null) {
            this.fVariablesList.addElement(cPVariableElement2);
            cPVariableElement = cPVariableElement2;
            this.fHasChanges = true;
        } else {
            boolean bl;
            boolean bl2 = bl = !cPVariableElement.getName().equals(cPVariableElement2.getName()) || !cPVariableElement.getPath().equals((Object)cPVariableElement2.getPath());
            if (bl) {
                this.fHasChanges = true;
                cPVariableElement.setName(cPVariableElement2.getName());
                cPVariableElement.setPath(cPVariableElement2.getPath());
                this.fVariablesList.refresh();
            }
        }
        this.fVariablesList.selectElements((ISelection)new StructuredSelection((Object)cPVariableElement));
    }

    public List getSelectedElements() {
        return this.fSelectedElements;
    }

    public boolean performOk() {
        Object object;
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(JavaCore.getClasspathVariableNames()));
        List list = this.fVariablesList.getElements();
        int n = list.size() - 1;
        while (n >= 0) {
            CPVariableElement cPVariableElement = (CPVariableElement)list.get(n);
            if (cPVariableElement.isReadOnly()) {
                list.remove(cPVariableElement);
            } else {
                object2 = cPVariableElement.getPath();
                object = JavaCore.getClasspathVariable((String)cPVariableElement.getName());
                if (object != null && object.equals(object2)) {
                    list.remove(cPVariableElement);
                } else {
                    arrayList2.add(cPVariableElement.getName());
                }
            }
            arrayList.remove(cPVariableElement.getName());
            --n;
        }
        n = list.size() + arrayList.size();
        if (n > 0) {
            boolean bl = false;
            if (this.fAskToBuild && this.doesChangeRequireFullBuild(arrayList, arrayList2)) {
                object2 = NewWizardMessages.VariableBlock_needsbuild_title;
                object = NewWizardMessages.VariableBlock_needsbuild_message;
                MessageDialog messageDialog = new MessageDialog(this.getShell(), (String)object2, null, (String)object, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
                int n2 = messageDialog.open();
                if (n2 != 0 && n2 != 1) {
                    return false;
                }
                bl = n2 == 0;
            }
            object2 = new VariableBlockRunnable(arrayList, list);
            object = new ProgressMonitorDialog(this.getShell());
            try {
                object.run(true, true, (IRunnableWithProgress)object2);
            }
            catch (InvocationTargetException invocationTargetException) {
                ExceptionHandler.handle(new InvocationTargetException(new NullPointerException()), this.getShell(), NewWizardMessages.VariableBlock_variableSettingError_titel, NewWizardMessages.VariableBlock_variableSettingError_message);
                return false;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            if (bl) {
                CoreUtility.getBuildJob(null).schedule();
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doesChangeRequireFullBuild(List list, List list2) {
        try {
            IJavaModel iJavaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            IJavaProject[] iJavaProjectArray = iJavaModel.getJavaProjects();
            int n = 0;
            block2: while (true) {
                if (n >= iJavaProjectArray.length) {
                    return false;
                }
                IClasspathEntry[] iClasspathEntryArray = iJavaProjectArray[n].getRawClasspath();
                int n2 = 0;
                while (true) {
                    if (n2 >= iClasspathEntryArray.length) {
                        ++n;
                        continue block2;
                    }
                    IClasspathEntry iClasspathEntry = iClasspathEntryArray[n2];
                    if (iClasspathEntry.getEntryKind() == 4) {
                        String string = iClasspathEntry.getPath().segment(0);
                        if (list.contains(string)) return true;
                        if (list2.contains(string)) {
                            return true;
                        }
                    }
                    ++n2;
                }
                break;
            }
        }
        catch (JavaModelException javaModelException) {
            return true;
        }
    }

    public void setAskToBuild(boolean bl) {
        this.fAskToBuild = bl;
    }

    public void refresh(String string) {
        CPVariableElement cPVariableElement = null;
        String[] stringArray = JavaCore.getClasspathVariableNames();
        ArrayList<CPVariableElement> arrayList = new ArrayList<CPVariableElement>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            IPath iPath = JavaCore.getClasspathVariable((String)string2);
            if (iPath != null) {
                CPVariableElement cPVariableElement2 = new CPVariableElement(string2, iPath);
                arrayList.add(cPVariableElement2);
                if (string2.equals(string)) {
                    cPVariableElement = cPVariableElement2;
                }
            } else {
                JavaPlugin.logErrorMessage("VariableBlock: Classpath variable with null value: " + string2);
            }
            ++n;
        }
        this.fVariablesList.setElements(arrayList);
        if (cPVariableElement != null) {
            StructuredSelection structuredSelection = new StructuredSelection(cPVariableElement);
            this.fVariablesList.selectElements((ISelection)structuredSelection);
        } else {
            this.fVariablesList.selectFirstElement();
        }
        this.fHasChanges = false;
    }

    public void setSelection(String string) {
        int n = 0;
        while (n < this.fVariablesList.getSize()) {
            CPVariableElement cPVariableElement = (CPVariableElement)this.fVariablesList.getElement(n);
            if (cPVariableElement.getName().equals(string)) {
                this.fVariablesList.selectElements((ISelection)new StructuredSelection((Object)cPVariableElement));
                return;
            }
            ++n;
        }
    }

    private class VariableBlockRunnable
    implements IRunnableWithProgress {
        private List fToRemove;
        private List fToChange;

        public VariableBlockRunnable(List list, List list2) {
            this.fToRemove = list;
            this.fToChange = list2;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
            iProgressMonitor.beginTask(NewWizardMessages.VariableBlock_operation_desc, 1);
            try {
                try {
                    this.setVariables(iProgressMonitor);
                }
                catch (CoreException coreException) {
                    throw new InvocationTargetException(coreException);
                }
                catch (OperationCanceledException operationCanceledException) {
                    throw new InterruptedException();
                }
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                iProgressMonitor.done();
                throw throwable;
            }
            {
                Object var3_5 = null;
            }
            iProgressMonitor.done();
        }

        public void setVariables(IProgressMonitor iProgressMonitor) throws JavaModelException, CoreException {
            int n = this.fToChange.size() + this.fToRemove.size();
            String[] stringArray = new String[n];
            IPath[] iPathArray = new IPath[n];
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.fToChange.size()) {
                CPVariableElement cPVariableElement = (CPVariableElement)this.fToChange.get(n3);
                stringArray[n2] = cPVariableElement.getName();
                iPathArray[n2] = cPVariableElement.getPath();
                ++n2;
                ++n3;
            }
            n3 = 0;
            while (n3 < this.fToRemove.size()) {
                stringArray[n2] = (String)this.fToRemove.get(n3);
                iPathArray[n2] = null;
                ++n2;
                ++n3;
            }
            JavaCore.setClasspathVariables((String[])stringArray, (IPath[])iPathArray, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        }
    }

    private class VariablesAdapter
    implements IDialogFieldListener,
    IListAdapter {
        private VariablesAdapter() {
        }

        public void customButtonPressed(ListDialogField listDialogField, int n) {
            switch (n) {
                case 0: {
                    VariableBlock.this.editEntries(null);
                    break;
                }
                case 1: {
                    List list = listDialogField.getSelectedElements();
                    VariableBlock.this.editEntries((CPVariableElement)list.get(0));
                }
            }
        }

        public void selectionChanged(ListDialogField listDialogField) {
            VariableBlock.this.doSelectionChanged(listDialogField);
        }

        public void doubleClicked(ListDialogField listDialogField) {
            List list;
            if (VariableBlock.this.fEditOnDoubleclick && VariableBlock.this.canEdit(list = listDialogField.getSelectedElements(), VariableBlock.this.containsReadOnly(list))) {
                VariableBlock.this.editEntries((CPVariableElement)list.get(0));
            }
        }

        public void dialogFieldChanged(DialogField dialogField) {
        }
    }
}

