/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.wst.jsdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.BuildpathModifierAction;

public class AddSelectedLibraryToBuildpathAction
extends BuildpathModifierAction {
    private final IRunnableContext fContext;

    public AddSelectedLibraryToBuildpathAction(IWorkbenchSite iWorkbenchSite) {
        this(iWorkbenchSite, null, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
    }

    public AddSelectedLibraryToBuildpathAction(IRunnableContext iRunnableContext, ISetSelectionTarget iSetSelectionTarget) {
        this(null, iSetSelectionTarget, iRunnableContext);
    }

    private AddSelectedLibraryToBuildpathAction(IWorkbenchSite iWorkbenchSite, ISetSelectionTarget iSetSelectionTarget, IRunnableContext iRunnableContext) {
        super(iWorkbenchSite, iSetSelectionTarget, 15);
        this.fContext = iRunnableContext;
        this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddSelLibToCP_label);
        this.setImageDescriptor(JavaPluginImages.DESC_OBJS_EXTJAR);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddSelLibToCP_tooltip);
    }

    public String getDetailedDescription() {
        if (!this.isEnabled()) {
            return null;
        }
        IFile iFile = (IFile)this.getSelectedElements().get(0);
        IJavaProject iJavaProject = JavaCore.create((IProject)iFile.getProject());
        try {
            if (ClasspathModifier.isArchive(iFile, iJavaProject)) {
                String string = ClasspathModifier.escapeSpecialChars(iFile.getName());
                return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_ArchiveToBuildpath, string);
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
        return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_toBuildpath;
    }

    public void run() {
        try {
            final IFile[] iFileArray = this.getSelectedElements().toArray(new IFile[this.getSelectedElements().size()]);
            IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IJavaProject iJavaProject = JavaCore.create((IProject)iFileArray[0].getProject());
                        List list = AddSelectedLibraryToBuildpathAction.this.addLibraryEntries(iFileArray, iJavaProject, iProgressMonitor);
                        AddSelectedLibraryToBuildpathAction.this.selectAndReveal((ISelection)new StructuredSelection(list));
                    }
                    catch (CoreException coreException) {
                        throw new InvocationTargetException(coreException);
                    }
                }
            };
            this.fContext.run(false, false, iRunnableWithProgress);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof CoreException) {
                this.showExceptionDialog((CoreException)invocationTargetException.getCause(), NewWizardMessages.AddSelectedLibraryToBuildpathAction_ErrorTitle);
            } else {
                JavaPlugin.log(invocationTargetException);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    private List addLibraryEntries(IFile[] iFileArray, IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws CoreException {
        ArrayList<IPackageFragmentRoot> arrayList;
        ArrayList<CPListElement> arrayList2 = new ArrayList<CPListElement>();
        try {
            Object object;
            iProgressMonitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_AddToBuildpath, 4);
            int n = 0;
            while (n < iFileArray.length) {
                object = iFileArray[n];
                arrayList2.add(new CPListElement(iJavaProject, 1, object.getFullPath(), (IResource)object));
                ++n;
            }
            iProgressMonitor.worked(1);
            List list = ClasspathModifier.getExistingEntries(iJavaProject);
            ClasspathModifier.setNewEntry(list, arrayList2, iJavaProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            ClasspathModifier.commitClassPath(list, iJavaProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            object = new BuildpathDelta(this.getToolTipText());
            ((BuildpathDelta)object).setNewEntries(list.toArray(new CPListElement[list.size()]));
            this.informListeners((BuildpathDelta)object);
            ArrayList<IPackageFragmentRoot> arrayList3 = new ArrayList<IPackageFragmentRoot>(arrayList2.size());
            int n2 = 0;
            while (n2 < iFileArray.length) {
                IFile iFile = iFileArray[n2];
                IPackageFragmentRoot iPackageFragmentRoot = iJavaProject.getPackageFragmentRoot((IResource)iFile);
                if (iPackageFragmentRoot != null) {
                    arrayList3.add(iPackageFragmentRoot);
                }
                ++n2;
            }
            iProgressMonitor.worked(1);
            arrayList = arrayList3;
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean canHandle(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() == 0) {
            return false;
        }
        try {
            IJavaProject iJavaProject;
            IFile iFile;
            Iterator iterator = iStructuredSelection.iterator();
            do {
                if (!iterator.hasNext()) {
                    return true;
                }
                Object e = iterator.next();
                if (!(e instanceof IFile)) return false;
                iFile = (IFile)e;
                iJavaProject = JavaCore.create((IProject)iFile.getProject());
                if (iJavaProject != null) continue;
                return false;
            } while (ClasspathModifier.isArchive(iFile, iJavaProject));
            return false;
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

