/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.AddSourceFolderWizard;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.BuildpathModifierAction;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;

public class CreateSourceFolderAction
extends BuildpathModifierAction {
    public CreateSourceFolderAction(IWorkbenchSite iWorkbenchSite) {
        this(iWorkbenchSite, null, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
    }

    public CreateSourceFolderAction(IRunnableContext iRunnableContext, ISetSelectionTarget iSetSelectionTarget) {
        this(null, iSetSelectionTarget, iRunnableContext);
    }

    private CreateSourceFolderAction(IWorkbenchSite iWorkbenchSite, ISetSelectionTarget iSetSelectionTarget, IRunnableContext iRunnableContext) {
        super(iWorkbenchSite, iSetSelectionTarget, 12);
        this.setText(ActionMessages.OpenNewSourceFolderWizardAction_text2);
        this.setDescription(ActionMessages.OpenNewSourceFolderWizardAction_description);
        this.setToolTipText(ActionMessages.OpenNewSourceFolderWizardAction_tooltip);
        this.setImageDescriptor(JavaPluginImages.DESC_TOOL_NEWPACKROOT);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.open_sourcefolder_wizard_action");
    }

    public String getDetailedDescription() {
        return NewWizardMessages.PackageExplorerActionGroup_FormText_createNewSourceFolder;
    }

    public void run() {
        Shell shell = this.getShell();
        try {
            IJavaProject iJavaProject = (IJavaProject)this.getSelectedElements().get(0);
            CPListElement cPListElement = new CPListElement(iJavaProject, 3);
            CPListElement[] cPListElementArray = CPListElement.createFromExisting(iJavaProject);
            boolean bl = CPListElement.isProjectSourceFolder(cPListElementArray, iJavaProject);
            AddSourceFolderWizard addSourceFolderWizard = new AddSourceFolderWizard(cPListElementArray, cPListElement, this.getOutputLocation(iJavaProject), false, false, false, bl, bl);
            addSourceFolderWizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)iJavaProject));
            WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)addSourceFolderWizard);
            PixelConverter pixelConverter = new PixelConverter(JFaceResources.getDialogFont());
            wizardDialog.setMinimumPageSize(pixelConverter.convertWidthInCharsToPixels(70), pixelConverter.convertHeightInCharsToPixels(20));
            wizardDialog.create();
            int n = wizardDialog.open();
            if (n == 0) {
                BuildpathDelta buildpathDelta = new BuildpathDelta(this.getToolTipText());
                ArrayList arrayList = addSourceFolderWizard.getExistingEntries();
                buildpathDelta.setNewEntries(arrayList.toArray(new CPListElement[arrayList.size()]));
                IResource iResource = addSourceFolderWizard.getCreatedElement().getCorrespondingResource();
                buildpathDelta.addCreatedResource(iResource);
                buildpathDelta.setDefaultOutputLocation(addSourceFolderWizard.getOutputLocation());
                this.informListeners(buildpathDelta);
                this.selectAndReveal((ISelection)new StructuredSelection((Object)addSourceFolderWizard.getCreatedElement()));
            }
            this.notifyResult(n == 0);
        }
        catch (CoreException coreException) {
            String string = NewWizardMessages.AbstractOpenWizardAction_createerror_title;
            String string2 = NewWizardMessages.AbstractOpenWizardAction_createerror_message;
            ExceptionHandler.handle(coreException, shell, string, string2);
        }
    }

    private IPath getOutputLocation(IJavaProject iJavaProject) {
        try {
            return iJavaProject.getOutputLocation();
        }
        catch (CoreException coreException) {
            IProject iProject = iJavaProject.getProject();
            IPath iPath = iProject.getFullPath();
            return iPath.append(PreferenceConstants.getPreferenceStore().getString("org.eclipse.wst.jsdt.ui.wizards.srcBinFoldersBinName"));
        }
    }

    protected boolean canHandle(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() != 1) {
            return false;
        }
        return iStructuredSelection.getFirstElement() instanceof IJavaProject;
    }
}

