/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.wst.jsdt.internal.ui.workingsets.SimpleWorkingSetSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetConfigurationDialog;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public final class ConfigureWorkingSetAssignementAction
extends SelectionDispatchAction {
    private static final String[] VALID_WORKING_SET_IDS = new String[]{"org.eclipse.wst.jsdt.ui.JavaWorkingSetPage", "org.eclipse.ui.resourceWorkingSetPage"};
    private WorkingSetModel fWorkingSetModel;
    private final IWorkbenchSite fSite;

    public ConfigureWorkingSetAssignementAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.fSite = iWorkbenchSite;
        this.setText(WorkingSetMessages.ConfigureWorkingSetAssignementAction_WorkingSets_actionLabel);
        this.setEnabled(false);
    }

    public void setWorkingSetModel(WorkingSetModel workingSetModel) {
        this.fWorkingSetModel = workingSetModel;
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(this.canEnable(iStructuredSelection));
    }

    private boolean canEnable(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.isEmpty()) {
            return false;
        }
        List list = iStructuredSelection.toList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof IResource || e instanceof IJavaElement) continue;
            return false;
        }
        return true;
    }

    private IAdaptable[] getSelectedElements(IStructuredSelection iStructuredSelection) {
        ArrayList arrayList = new ArrayList();
        List list = iStructuredSelection.toList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof IResource) && !(e instanceof IJavaElement)) continue;
            arrayList.add(e);
        }
        return arrayList.toArray(new IAdaptable[arrayList.size()]);
    }

    public void run(IStructuredSelection iStructuredSelection) {
        IAdaptable[] iAdaptableArray = this.getSelectedElements(iStructuredSelection);
        GrayedCheckedModel grayedCheckedModel = ConfigureWorkingSetAssignementAction.createGrayedCheckedModel(iAdaptableArray, this.getAllWorkingSets());
        WorkingSetModelAwareSelectionDialog workingSetModelAwareSelectionDialog = new WorkingSetModelAwareSelectionDialog(this.fSite.getShell(), grayedCheckedModel, iAdaptableArray);
        if (iAdaptableArray.length == 1) {
            IAdaptable iAdaptable = iAdaptableArray[0];
            String string = iAdaptable instanceof IResource ? ((IResource)iAdaptable).getName() : JavaElementLabels.getElementLabel((IJavaElement)iAdaptable, JavaElementLabels.ALL_DEFAULT);
            workingSetModelAwareSelectionDialog.setMessage(Messages.format(WorkingSetMessages.ConfigureWorkingSetAssignementAction_DialogMessage_specific, string));
        } else {
            workingSetModelAwareSelectionDialog.setMessage(Messages.format(WorkingSetMessages.ConfigureWorkingSetAssignementAction_DialogMessage_multi, new Integer(iAdaptableArray.length)));
        }
        if (workingSetModelAwareSelectionDialog.open() == 0) {
            this.updateWorkingSets(workingSetModelAwareSelectionDialog.getSelection(), workingSetModelAwareSelectionDialog.getGrayed(), iAdaptableArray);
            this.selectAndReveal(iAdaptableArray);
        }
    }

    private static GrayedCheckedModel createGrayedCheckedModel(IAdaptable[] iAdaptableArray, IWorkingSet[] iWorkingSetArray) {
        GrayedCheckedModelElement[] grayedCheckedModelElementArray = new GrayedCheckedModelElement[iWorkingSetArray.length];
        int n = 0;
        while (n < iWorkingSetArray.length) {
            IWorkingSet iWorkingSet = iWorkingSetArray[n];
            int n2 = 0;
            int n3 = 0;
            while (n3 < iAdaptableArray.length) {
                IAdaptable iAdaptable = ConfigureWorkingSetAssignementAction.adapt(iWorkingSet, iAdaptableArray[n3]);
                if (iAdaptable != null && ConfigureWorkingSetAssignementAction.contains(iWorkingSet, iAdaptable)) {
                    ++n2;
                }
                ++n3;
            }
            grayedCheckedModelElementArray[n] = new GrayedCheckedModelElement(iWorkingSet, n2, iAdaptableArray.length);
            ++n;
        }
        return new GrayedCheckedModel(grayedCheckedModelElementArray);
    }

    private void updateWorkingSets(IWorkingSet[] iWorkingSetArray, IWorkingSet[] iWorkingSetArray2, IAdaptable[] iAdaptableArray) {
        IAdaptable iAdaptable;
        int n;
        IWorkingSet iWorkingSet;
        HashSet<IWorkingSet> hashSet = new HashSet<IWorkingSet>(Arrays.asList(iWorkingSetArray));
        HashSet<IWorkingSet> hashSet2 = new HashSet<IWorkingSet>(Arrays.asList(iWorkingSetArray2));
        IWorkingSet[] iWorkingSetArray3 = this.getAllWorkingSets();
        int n2 = 0;
        while (n2 < iWorkingSetArray3.length) {
            iWorkingSet = iWorkingSetArray3[n2];
            if (ConfigureWorkingSetAssignementAction.isValidWorkingSet(iWorkingSet) && !hashSet.contains(iWorkingSet) && !hashSet2.contains(iWorkingSet)) {
                n = 0;
                while (n < iAdaptableArray.length) {
                    iAdaptable = ConfigureWorkingSetAssignementAction.adapt(iWorkingSet, iAdaptableArray[n]);
                    if (iAdaptable != null && ConfigureWorkingSetAssignementAction.contains(iWorkingSet, iAdaptable)) {
                        ConfigureWorkingSetAssignementAction.remove(iWorkingSet, iAdaptable);
                    }
                    ++n;
                }
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < iWorkingSetArray.length) {
            iWorkingSet = iWorkingSetArray[n2];
            if (ConfigureWorkingSetAssignementAction.isValidWorkingSet(iWorkingSet) && !hashSet2.contains(iWorkingSet)) {
                n = 0;
                while (n < iAdaptableArray.length) {
                    iAdaptable = ConfigureWorkingSetAssignementAction.adapt(iWorkingSet, iAdaptableArray[n]);
                    if (iAdaptable != null && !ConfigureWorkingSetAssignementAction.contains(iWorkingSet, iAdaptable)) {
                        ConfigureWorkingSetAssignementAction.add(iWorkingSet, iAdaptable);
                    }
                    ++n;
                }
            }
            ++n2;
        }
    }

    private IWorkingSet[] getAllWorkingSets() {
        if (this.fWorkingSetModel != null) {
            return this.fWorkingSetModel.getAllWorkingSets();
        }
        return PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
    }

    private static boolean isValidWorkingSet(IWorkingSet iWorkingSet) {
        if (iWorkingSet.isAggregateWorkingSet() || !iWorkingSet.isSelfUpdating()) {
            return false;
        }
        if (!iWorkingSet.isVisible()) {
            return false;
        }
        if (!iWorkingSet.isEditable()) {
            return false;
        }
        int n = 0;
        while (n < VALID_WORKING_SET_IDS.length) {
            if (VALID_WORKING_SET_IDS[n].equals(iWorkingSet.getId())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static IAdaptable adapt(IWorkingSet iWorkingSet, IAdaptable iAdaptable) {
        IAdaptable[] iAdaptableArray = iWorkingSet.adaptElements(new IAdaptable[]{iAdaptable});
        if (iAdaptableArray.length != 1) {
            return null;
        }
        return iAdaptableArray[0];
    }

    private static boolean contains(IWorkingSet iWorkingSet, IAdaptable iAdaptable) {
        IAdaptable[] iAdaptableArray = iWorkingSet.getElements();
        int n = 0;
        while (n < iAdaptableArray.length) {
            if (iAdaptableArray[n].equals(iAdaptable)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static void remove(IWorkingSet iWorkingSet, IAdaptable iAdaptable) {
        HashSet<IAdaptable> hashSet = new HashSet<IAdaptable>(Arrays.asList(iWorkingSet.getElements()));
        hashSet.remove(iAdaptable);
        iWorkingSet.setElements(hashSet.toArray(new IAdaptable[hashSet.size()]));
    }

    private static void add(IWorkingSet iWorkingSet, IAdaptable iAdaptable) {
        IAdaptable[] iAdaptableArray = iWorkingSet.getElements();
        IAdaptable[] iAdaptableArray2 = new IAdaptable[iAdaptableArray.length + 1];
        System.arraycopy(iAdaptableArray, 0, iAdaptableArray2, 0, iAdaptableArray.length);
        iAdaptableArray2[iAdaptableArray.length] = iAdaptable;
        iWorkingSet.setElements(iAdaptableArray2);
    }

    private void selectAndReveal(IAdaptable[] iAdaptableArray) {
        PackageExplorerPart packageExplorerPart = this.getActivePackageExplorer();
        if (packageExplorerPart != null) {
            packageExplorerPart.selectReveal((ISelection)new StructuredSelection((Object[])iAdaptableArray));
        }
    }

    private PackageExplorerPart getActivePackageExplorer() {
        IWorkbenchPart iWorkbenchPart;
        IWorkbenchPage iWorkbenchPage = JavaPlugin.getActivePage();
        if (iWorkbenchPage != null && (iWorkbenchPart = iWorkbenchPage.getActivePart()) instanceof PackageExplorerPart) {
            return (PackageExplorerPart)iWorkbenchPart;
        }
        return null;
    }

    static /* synthetic */ boolean access$4(IWorkingSet iWorkingSet) {
        return ConfigureWorkingSetAssignementAction.isValidWorkingSet(iWorkingSet);
    }

    private static final class GrayedCheckedModel {
        private GrayedCheckedModelElement[] fElements;
        private final Hashtable fLookup;

        public GrayedCheckedModel(GrayedCheckedModelElement[] grayedCheckedModelElementArray) {
            this.fElements = grayedCheckedModelElementArray;
            this.fLookup = new Hashtable();
            int n = 0;
            while (n < grayedCheckedModelElementArray.length) {
                this.fLookup.put(grayedCheckedModelElementArray[n].getWorkingSet(), grayedCheckedModelElementArray[n]);
                ++n;
            }
        }

        public void addElement(GrayedCheckedModelElement grayedCheckedModelElement) {
            ArrayList<GrayedCheckedModelElement> arrayList = new ArrayList<GrayedCheckedModelElement>(Arrays.asList(this.fElements));
            arrayList.add(grayedCheckedModelElement);
            this.fElements = arrayList.toArray(new GrayedCheckedModelElement[arrayList.size()]);
            this.fLookup.put(grayedCheckedModelElement.getWorkingSet(), grayedCheckedModelElement);
        }

        public IWorkingSet[] getAll() {
            IWorkingSet[] iWorkingSetArray = new IWorkingSet[this.fElements.length];
            int n = 0;
            while (n < this.fElements.length) {
                iWorkingSetArray[n] = this.fElements[n].getWorkingSet();
                ++n;
            }
            return iWorkingSetArray;
        }

        public GrayedCheckedModelElement getModelElement(IWorkingSet iWorkingSet) {
            return (GrayedCheckedModelElement)this.fLookup.get(iWorkingSet);
        }

        public IWorkingSet[] getChecked() {
            ArrayList<IWorkingSet> arrayList = new ArrayList<IWorkingSet>();
            int n = 0;
            while (n < this.fElements.length) {
                if (this.fElements[n].isChecked()) {
                    arrayList.add(this.fElements[n].getWorkingSet());
                }
                ++n;
            }
            return arrayList.toArray(new IWorkingSet[arrayList.size()]);
        }

        public IWorkingSet[] getGrayed() {
            ArrayList<IWorkingSet> arrayList = new ArrayList<IWorkingSet>();
            int n = 0;
            while (n < this.fElements.length) {
                if (this.fElements[n].isGrayed()) {
                    arrayList.add(this.fElements[n].getWorkingSet());
                }
                ++n;
            }
            return arrayList.toArray(new IWorkingSet[arrayList.size()]);
        }

        public void selectAll() {
            int n = 0;
            while (n < this.fElements.length) {
                this.fElements[n].select();
                ++n;
            }
        }

        public void deselectAll() {
            int n = 0;
            while (n < this.fElements.length) {
                this.fElements[n].deselect();
                ++n;
            }
        }
    }

    private static final class GrayedCheckedModelElement {
        private final IWorkingSet fWorkingSet;
        private final int fElementCount;
        private int fCheckCount;

        public GrayedCheckedModelElement(IWorkingSet iWorkingSet, int n, int n2) {
            this.fWorkingSet = iWorkingSet;
            this.fCheckCount = n;
            this.fElementCount = n2;
        }

        public IWorkingSet getWorkingSet() {
            return this.fWorkingSet;
        }

        public int getCheckCount() {
            return this.fCheckCount;
        }

        public boolean isGrayed() {
            return this.isChecked() && this.fCheckCount < this.fElementCount;
        }

        public boolean isChecked() {
            return this.fCheckCount > 0;
        }

        public void deselect() {
            this.fCheckCount = 0;
        }

        public void select() {
            this.fCheckCount = this.fElementCount;
        }
    }

    private final class WorkingSetModelAwareSelectionDialog
    extends SimpleWorkingSetSelectionDialog {
        private CheckboxTableViewer fTableViewer;
        private boolean fShowVisibleOnly;
        private GrayedCheckedModel fModel;
        private final IAdaptable[] fElements;

        private WorkingSetModelAwareSelectionDialog(Shell shell, GrayedCheckedModel grayedCheckedModel, IAdaptable[] iAdaptableArray) {
            super(shell, VALID_WORKING_SET_IDS, grayedCheckedModel.getChecked());
            this.setTitle(WorkingSetMessages.ConfigureWorkingSetAssignementAction_WorkingSetAssignments_title);
            this.fModel = grayedCheckedModel;
            this.fShowVisibleOnly = true;
            this.fElements = iAdaptableArray;
        }

        public IWorkingSet[] getGrayed() {
            return this.fModel.getGrayed();
        }

        public IWorkingSet[] getSelection() {
            return this.fModel.getChecked();
        }

        protected CheckboxTableViewer createTableViewer(Composite composite) {
            this.fTableViewer = super.createTableViewer(composite);
            this.fTableViewer.setGrayedElements((Object[])this.fModel.getGrayed());
            this.fTableViewer.addCheckStateListener(new ICheckStateListener(this){
                final /* synthetic */ WorkingSetModelAwareSelectionDialog this$1;
                {
                    this.this$1 = workingSetModelAwareSelectionDialog;
                }

                public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                    IWorkingSet iWorkingSet = (IWorkingSet)checkStateChangedEvent.getElement();
                    WorkingSetModelAwareSelectionDialog.access$0(this.this$1).setGrayed((Object)iWorkingSet, false);
                    GrayedCheckedModelElement grayedCheckedModelElement = WorkingSetModelAwareSelectionDialog.access$1(this.this$1).getModelElement(iWorkingSet);
                    if (checkStateChangedEvent.getChecked()) {
                        grayedCheckedModelElement.select();
                    } else {
                        grayedCheckedModelElement.deselect();
                    }
                    WorkingSetModelAwareSelectionDialog.access$0(this.this$1).update((Object)iWorkingSet, null);
                }
            });
            this.createShowVisibleOnly(composite);
            return this.fTableViewer;
        }

        protected void selectAll() {
            super.selectAll();
            this.fModel.selectAll();
            this.fTableViewer.setGrayedElements(new Object[0]);
            this.fTableViewer.refresh();
        }

        protected void deselectAll() {
            super.deselectAll();
            this.fModel.deselectAll();
            this.fTableViewer.setGrayedElements(new Object[0]);
            this.fTableViewer.refresh();
        }

        protected void addNewWorkingSet(IWorkingSet iWorkingSet) {
            if (ConfigureWorkingSetAssignementAction.this.fWorkingSetModel != null) {
                IWorkingSet[] iWorkingSetArray = ConfigureWorkingSetAssignementAction.this.fWorkingSetModel.getActiveWorkingSets();
                IWorkingSet[] iWorkingSetArray2 = new IWorkingSet[iWorkingSetArray.length + 1];
                iWorkingSetArray2[0] = iWorkingSet;
                System.arraycopy(iWorkingSetArray, 0, iWorkingSetArray2, 1, iWorkingSetArray.length);
                ConfigureWorkingSetAssignementAction.this.fWorkingSetModel.setActiveWorkingSets(iWorkingSetArray2);
            }
            int n = 0;
            int n2 = 0;
            while (n2 < this.fElements.length) {
                IAdaptable iAdaptable = ConfigureWorkingSetAssignementAction.adapt(iWorkingSet, this.fElements[n2]);
                if (iAdaptable != null && ConfigureWorkingSetAssignementAction.contains(iWorkingSet, iAdaptable)) {
                    ++n;
                }
                ++n2;
            }
            this.fModel.addElement(new GrayedCheckedModelElement(iWorkingSet, n, this.fElements.length));
            this.fTableViewer.setInput((Object)this.fModel.getAll());
            this.fTableViewer.refresh();
            this.fTableViewer.setCheckedElements((Object[])this.fModel.getChecked());
            this.fTableViewer.setGrayedElements((Object[])this.fModel.getGrayed());
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)iWorkingSet));
        }

        protected ViewerFilter createTableFilter() {
            ViewerFilter viewerFilter = super.createTableFilter();
            return new ViewerFilter(this, viewerFilter){
                final /* synthetic */ WorkingSetModelAwareSelectionDialog this$1;
                private final /* synthetic */ ViewerFilter val$superFilter;
                {
                    this.this$1 = workingSetModelAwareSelectionDialog;
                    this.val$superFilter = viewerFilter;
                }

                public boolean select(Viewer viewer, Object object, Object object2) {
                    if (!this.val$superFilter.select(viewer, object, object2)) {
                        return false;
                    }
                    IWorkingSet iWorkingSet = (IWorkingSet)object2;
                    if (!ConfigureWorkingSetAssignementAction.access$4(iWorkingSet)) {
                        return false;
                    }
                    if (ConfigureWorkingSetAssignementAction.access$1(WorkingSetModelAwareSelectionDialog.access$7(this.this$1)) == null) {
                        return true;
                    }
                    if (WorkingSetModelAwareSelectionDialog.access$2(this.this$1)) {
                        return ConfigureWorkingSetAssignementAction.access$1(WorkingSetModelAwareSelectionDialog.access$7(this.this$1)).isActiveWorkingSet(iWorkingSet);
                    }
                    return true;
                }
            };
        }

        protected ViewerSorter createTableSorter() {
            ViewerSorter viewerSorter = super.createTableSorter();
            return new ViewerSorter(this, viewerSorter){
                final /* synthetic */ WorkingSetModelAwareSelectionDialog this$1;
                private final /* synthetic */ ViewerSorter val$superSorter;
                {
                    this.this$1 = workingSetModelAwareSelectionDialog;
                    this.val$superSorter = viewerSorter;
                }

                public int compare(Viewer viewer, Object object, Object object2) {
                    if (ConfigureWorkingSetAssignementAction.access$1(WorkingSetModelAwareSelectionDialog.access$7(this.this$1)) == null) {
                        return this.val$superSorter.compare(viewer, object, object2);
                    }
                    IWorkingSet[] iWorkingSetArray = ConfigureWorkingSetAssignementAction.access$1(WorkingSetModelAwareSelectionDialog.access$7(this.this$1)).getActiveWorkingSets();
                    int n = 0;
                    while (n < iWorkingSetArray.length) {
                        IWorkingSet iWorkingSet = iWorkingSetArray[n];
                        if (iWorkingSet == object) {
                            return -1;
                        }
                        if (iWorkingSet == object2) {
                            return 1;
                        }
                        ++n;
                    }
                    return this.val$superSorter.compare(viewer, object, object2);
                }
            };
        }

        protected LabelProvider createTableLabelProvider() {
            LabelProvider labelProvider = super.createTableLabelProvider();
            return new LabelProvider(this, labelProvider){
                final /* synthetic */ WorkingSetModelAwareSelectionDialog this$1;
                private final /* synthetic */ LabelProvider val$superLabelProvider;
                {
                    this.this$1 = workingSetModelAwareSelectionDialog;
                    this.val$superLabelProvider = labelProvider;
                }

                public String getText(Object object) {
                    String string = this.val$superLabelProvider.getText(object);
                    if (string == null) {
                        return null;
                    }
                    GrayedCheckedModelElement grayedCheckedModelElement = WorkingSetModelAwareSelectionDialog.access$1(this.this$1).getModelElement((IWorkingSet)object);
                    if (!grayedCheckedModelElement.isGrayed()) {
                        return string;
                    }
                    return String.valueOf(string) + Messages.format(WorkingSetMessages.ConfigureWorkingSetAssignementAction_XofY_label, new Object[]{new Integer(grayedCheckedModelElement.getCheckCount()), new Integer(WorkingSetModelAwareSelectionDialog.access$3(this.this$1).length)});
                }
            };
        }

        private void createShowVisibleOnly(Composite composite) {
            if (ConfigureWorkingSetAssignementAction.this.fWorkingSetModel == null) {
                return;
            }
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayoutData((Object)new GridData(4, 128, true, false));
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            composite2.setLayout((Layout)gridLayout);
            Button button = new Button(composite2, 32);
            button.setSelection(this.fShowVisibleOnly);
            button.setLayoutData((Object)new GridData(16384, 4, false, true));
            button.addSelectionListener((SelectionListener)new SelectionAdapter(this, button){
                final /* synthetic */ WorkingSetModelAwareSelectionDialog this$1;
                private final /* synthetic */ Button val$showVisibleOnly;
                {
                    this.this$1 = workingSetModelAwareSelectionDialog;
                    this.val$showVisibleOnly = button;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    WorkingSetModelAwareSelectionDialog.access$4(this.this$1, this.val$showVisibleOnly.getSelection());
                    WorkingSetModelAwareSelectionDialog.access$0(this.this$1).refresh();
                    WorkingSetModelAwareSelectionDialog.access$0(this.this$1).setCheckedElements((Object[])WorkingSetModelAwareSelectionDialog.access$1(this.this$1).getChecked());
                    WorkingSetModelAwareSelectionDialog.access$0(this.this$1).setGrayedElements((Object[])WorkingSetModelAwareSelectionDialog.access$1(this.this$1).getGrayed());
                }
            });
            Link link = new Link(composite2, 0);
            link.setText(WorkingSetMessages.ConfigureWorkingSetAssignementAction_OnlyShowVisible_link);
            link.setLayoutData((Object)new GridData(4, 4, true, true));
            link.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ WorkingSetModelAwareSelectionDialog this$1;
                {
                    this.this$1 = workingSetModelAwareSelectionDialog;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ArrayList<IWorkingSet> arrayList = new ArrayList<IWorkingSet>(Arrays.asList(ConfigureWorkingSetAssignementAction.access$1(WorkingSetModelAwareSelectionDialog.access$7(this.this$1)).getAllWorkingSets()));
                    IWorkingSet[] iWorkingSetArray = ConfigureWorkingSetAssignementAction.access$1(WorkingSetModelAwareSelectionDialog.access$7(this.this$1)).getActiveWorkingSets();
                    WorkingSetConfigurationDialog workingSetConfigurationDialog = new WorkingSetConfigurationDialog(this.this$1.getShell(), arrayList.toArray(new IWorkingSet[arrayList.size()]), iWorkingSetArray);
                    workingSetConfigurationDialog.setSelection(iWorkingSetArray);
                    if (workingSetConfigurationDialog.open() == 0) {
                        IWorkingSet[] iWorkingSetArray2 = workingSetConfigurationDialog.getSelection();
                        ConfigureWorkingSetAssignementAction.access$1(WorkingSetModelAwareSelectionDialog.access$7(this.this$1)).setActiveWorkingSets(iWorkingSetArray2);
                    }
                    WorkingSetModelAwareSelectionDialog.access$5(this.this$1);
                }
            });
        }

        private void recalculateCheckedState() {
            this.fModel = ConfigureWorkingSetAssignementAction.createGrayedCheckedModel(this.fElements, ConfigureWorkingSetAssignementAction.this.getAllWorkingSets());
            this.fTableViewer.setInput((Object)this.fModel.getAll());
            this.fTableViewer.refresh();
            this.fTableViewer.setCheckedElements((Object[])this.fModel.getChecked());
            this.fTableViewer.setGrayedElements((Object[])this.fModel.getGrayed());
        }

        static /* synthetic */ CheckboxTableViewer access$0(WorkingSetModelAwareSelectionDialog workingSetModelAwareSelectionDialog) {
            return workingSetModelAwareSelectionDialog.fTableViewer;
        }

        static /* synthetic */ GrayedCheckedModel access$1(WorkingSetModelAwareSelectionDialog workingSetModelAwareSelectionDialog) {
            return workingSetModelAwareSelectionDialog.fModel;
        }

        static /* synthetic */ boolean access$2(WorkingSetModelAwareSelectionDialog workingSetModelAwareSelectionDialog) {
            return workingSetModelAwareSelectionDialog.fShowVisibleOnly;
        }

        static /* synthetic */ IAdaptable[] access$3(WorkingSetModelAwareSelectionDialog workingSetModelAwareSelectionDialog) {
            return workingSetModelAwareSelectionDialog.fElements;
        }

        static /* synthetic */ void access$4(WorkingSetModelAwareSelectionDialog workingSetModelAwareSelectionDialog, boolean bl) {
            workingSetModelAwareSelectionDialog.fShowVisibleOnly = bl;
        }

        static /* synthetic */ void access$5(WorkingSetModelAwareSelectionDialog workingSetModelAwareSelectionDialog) {
            workingSetModelAwareSelectionDialog.recalculateCheckedState();
        }

        static /* synthetic */ ConfigureWorkingSetAssignementAction access$7(WorkingSetModelAwareSelectionDialog workingSetModelAwareSelectionDialog) {
            return workingSetModelAwareSelectionDialog.ConfigureWorkingSetAssignementAction.this;
        }
    }
}

