/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.wst.jsdt.internal.ui.search.WorkingSetComparator;
import org.eclipse.wst.jsdt.internal.ui.workingsets.ClearWorkingSetAction;
import org.eclipse.wst.jsdt.internal.ui.workingsets.EditWorkingSetAction;
import org.eclipse.wst.jsdt.internal.ui.workingsets.IWorkingSetActionGroup;
import org.eclipse.wst.jsdt.internal.ui.workingsets.SelectWorkingSetAction;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetFilter;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetMenuContributionItem;

public class WorkingSetFilterActionGroup
extends ActionGroup
implements IWorkingSetActionGroup {
    private static final String TAG_WORKING_SET_NAME = "workingSetName";
    private static final String TAG_IS_WINDOW_WORKING_SET = "isWindowWorkingSet";
    private static final String LRU_GROUP = "workingSet_lru_group";
    private final WorkingSetFilter fWorkingSetFilter;
    private IWorkingSet fWorkingSet = null;
    private final ClearWorkingSetAction fClearWorkingSetAction;
    private final SelectWorkingSetAction fSelectWorkingSetAction;
    private final EditWorkingSetAction fEditWorkingSetAction;
    private IPropertyChangeListener fWorkingSetListener;
    private IPropertyChangeListener fChangeListener;
    private int fLRUMenuCount;
    private IMenuManager fMenuManager;
    private IMenuListener fMenuListener;
    private List fContributions = new ArrayList();
    private final IWorkbenchPage fWorkbenchPage;
    private boolean fAllowWindowWorkingSetByDefault;

    public WorkingSetFilterActionGroup(IWorkbenchPartSite iWorkbenchPartSite, IPropertyChangeListener iPropertyChangeListener) {
        Assert.isNotNull((Object)iWorkbenchPartSite);
        Assert.isNotNull((Object)iPropertyChangeListener);
        this.fChangeListener = iPropertyChangeListener;
        this.fWorkbenchPage = iWorkbenchPartSite.getPage();
        this.fAllowWindowWorkingSetByDefault = true;
        this.fClearWorkingSetAction = new ClearWorkingSetAction(this);
        this.fSelectWorkingSetAction = new SelectWorkingSetAction(this, iWorkbenchPartSite);
        this.fEditWorkingSetAction = new EditWorkingSetAction(this, iWorkbenchPartSite);
        this.fWorkingSetListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WorkingSetFilterActionGroup.this.doPropertyChange(propertyChangeEvent);
            }
        };
        this.fWorkingSetFilter = new WorkingSetFilter();
        IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        iWorkingSetManager.addPropertyChangeListener(this.fWorkingSetListener);
        if (this.useWindowWorkingSetByDefault()) {
            this.setWorkingSet(iWorkbenchPartSite.getPage().getAggregateWorkingSet(), false);
        }
    }

    public WorkingSetFilterActionGroup(Shell shell, IWorkbenchPage iWorkbenchPage, IPropertyChangeListener iPropertyChangeListener) {
        Assert.isNotNull((Object)shell);
        Assert.isNotNull((Object)iPropertyChangeListener);
        this.fWorkbenchPage = iWorkbenchPage;
        this.fAllowWindowWorkingSetByDefault = false;
        this.fChangeListener = iPropertyChangeListener;
        this.fClearWorkingSetAction = new ClearWorkingSetAction(this);
        this.fSelectWorkingSetAction = new SelectWorkingSetAction(this, shell);
        this.fEditWorkingSetAction = new EditWorkingSetAction(this, shell);
        this.fWorkingSetListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WorkingSetFilterActionGroup.this.doPropertyChange(propertyChangeEvent);
            }
        };
        this.fWorkingSetFilter = new WorkingSetFilter();
        IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        iWorkingSetManager.addPropertyChangeListener(this.fWorkingSetListener);
        this.setWorkingSet(null, false);
    }

    public boolean isFiltered(Object object, Object object2) {
        if (this.fWorkingSetFilter == null) {
            return false;
        }
        return !this.fWorkingSetFilter.select(null, object, object2);
    }

    public IWorkingSet getWorkingSet() {
        return this.fWorkingSet;
    }

    public void setWorkingSet(IWorkingSet iWorkingSet, boolean bl) {
        this.fClearWorkingSetAction.setEnabled(iWorkingSet != null);
        this.fEditWorkingSetAction.setEnabled(iWorkingSet != null && !iWorkingSet.isAggregateWorkingSet());
        this.fWorkingSet = iWorkingSet;
        this.fWorkingSetFilter.setWorkingSet(iWorkingSet);
        if (bl) {
            this.fChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "workingSetContentChange", null, (Object)iWorkingSet));
        }
    }

    public void saveState(IMemento iMemento) {
        String string = "";
        boolean bl = false;
        if (this.fWorkingSet != null) {
            if (this.fWorkingSet.isAggregateWorkingSet()) {
                bl = true;
            } else {
                string = this.fWorkingSet.getName();
            }
        }
        iMemento.putString(TAG_IS_WINDOW_WORKING_SET, Boolean.toString(bl));
        iMemento.putString(TAG_WORKING_SET_NAME, string);
    }

    public void restoreState(IMemento iMemento) {
        boolean bl = iMemento.getString(TAG_IS_WINDOW_WORKING_SET) != null ? Boolean.valueOf(iMemento.getString(TAG_IS_WINDOW_WORKING_SET)).booleanValue() : this.useWindowWorkingSetByDefault();
        String string = iMemento.getString(TAG_WORKING_SET_NAME);
        boolean bl2 = string != null && string.length() > 0;
        IWorkingSet iWorkingSet = null;
        if (bl2) {
            iWorkingSet = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(string);
        } else if (bl && this.fWorkbenchPage != null) {
            iWorkingSet = this.fWorkbenchPage.getAggregateWorkingSet();
        }
        this.setWorkingSet(iWorkingSet, false);
    }

    private boolean useWindowWorkingSetByDefault() {
        return this.fAllowWindowWorkingSetByDefault && PlatformUI.getPreferenceStore().getBoolean("USE_WINDOW_WORKING_SET_BY_DEFAULT");
    }

    public void fillActionBars(IActionBars iActionBars) {
        this.fillToolBar(iActionBars.getToolBarManager());
        this.fillViewMenu(iActionBars.getMenuManager());
    }

    private void fillToolBar(IToolBarManager iToolBarManager) {
    }

    public void fillViewMenu(IMenuManager iMenuManager) {
        if (iMenuManager.find("working_set_action_group") == null) {
            iMenuManager.add((IContributionItem)new Separator("working_set_action_group"));
        }
        this.add(iMenuManager, (IAction)this.fSelectWorkingSetAction);
        this.add(iMenuManager, (IAction)this.fClearWorkingSetAction);
        this.add(iMenuManager, (IAction)this.fEditWorkingSetAction);
        this.add(iMenuManager, (IContributionItem)new Separator());
        this.add(iMenuManager, (IContributionItem)new Separator(LRU_GROUP));
        this.fMenuManager = iMenuManager;
        this.fMenuListener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                WorkingSetFilterActionGroup.this.removePreviousLRUWorkingSetActions(iMenuManager);
                WorkingSetFilterActionGroup.this.addLRUWorkingSetActions(iMenuManager);
            }
        };
        this.fMenuManager.addMenuListener(this.fMenuListener);
    }

    private void add(IMenuManager iMenuManager, IAction iAction) {
        ActionContributionItem actionContributionItem = new ActionContributionItem(iAction);
        iMenuManager.appendToGroup("working_set_action_group", (IContributionItem)actionContributionItem);
        this.fContributions.add(actionContributionItem);
    }

    private void add(IMenuManager iMenuManager, IContributionItem iContributionItem) {
        iMenuManager.appendToGroup("working_set_action_group", iContributionItem);
        this.fContributions.add(iContributionItem);
    }

    private void removePreviousLRUWorkingSetActions(IMenuManager iMenuManager) {
        int n = 1;
        while (n < this.fLRUMenuCount) {
            String string = WorkingSetMenuContributionItem.getId(n);
            IContributionItem iContributionItem = iMenuManager.remove(string);
            if (iContributionItem != null) {
                iContributionItem.dispose();
                this.fContributions.remove(iContributionItem);
            }
            ++n;
        }
    }

    private void addLRUWorkingSetActions(IMenuManager iMenuManager) {
        IWorkingSet[] iWorkingSetArray = PlatformUI.getWorkbench().getWorkingSetManager().getRecentWorkingSets();
        Arrays.sort(iWorkingSetArray, new WorkingSetComparator());
        int n = 1;
        if (this.fWorkbenchPage != null) {
            this.addLRUWorkingSetAction(iMenuManager, n++, this.fWorkbenchPage.getAggregateWorkingSet());
        }
        int n2 = 0;
        while (n2 < iWorkingSetArray.length) {
            if (!iWorkingSetArray[n2].isAggregateWorkingSet()) {
                this.addLRUWorkingSetAction(iMenuManager, n++, iWorkingSetArray[n2]);
            }
            ++n2;
        }
        this.fLRUMenuCount = n;
    }

    private void addLRUWorkingSetAction(IMenuManager iMenuManager, int n, IWorkingSet iWorkingSet) {
        WorkingSetMenuContributionItem workingSetMenuContributionItem = new WorkingSetMenuContributionItem(n, this, iWorkingSet);
        iMenuManager.insertBefore(LRU_GROUP, (IContributionItem)workingSetMenuContributionItem);
        this.fContributions.add(workingSetMenuContributionItem);
    }

    public void cleanViewMenu(IMenuManager iMenuManager) {
        Iterator iterator = this.fContributions.iterator();
        while (iterator.hasNext()) {
            IContributionItem iContributionItem = iMenuManager.remove((IContributionItem)iterator.next());
            if (iContributionItem == null) continue;
            iContributionItem.dispose();
        }
        this.fContributions.clear();
        this.fMenuManager.removeMenuListener(this.fMenuListener);
        this.fMenuListener = null;
    }

    public void dispose() {
        if (this.fMenuManager != null && this.fMenuListener != null) {
            this.fMenuManager.removeMenuListener(this.fMenuListener);
        }
        if (this.fWorkingSetListener != null) {
            PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener(this.fWorkingSetListener);
            this.fWorkingSetListener = null;
        }
        this.fChangeListener = null;
        super.dispose();
    }

    public ViewerFilter getWorkingSetFilter() {
        return this.fWorkingSetFilter;
    }

    private void doPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        IWorkingSet iWorkingSet;
        String string = propertyChangeEvent.getProperty();
        if ("workingSetNameChange".equals(string)) {
            this.fChangeListener.propertyChange(propertyChangeEvent);
        } else if ("workingSetContentChange".equals(string) && (iWorkingSet = (IWorkingSet)propertyChangeEvent.getNewValue()).equals(this.fWorkingSet)) {
            if (this.fWorkingSetFilter != null) {
                this.fWorkingSetFilter.notifyWorkingSetContentChange();
            }
            this.fChangeListener.propertyChange(propertyChangeEvent);
        }
    }
}

