/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.launching;

import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.jsdt.launching.ExecutionArguments;
import org.eclipse.wst.jsdt.launching.IVMInstall;
import org.eclipse.wst.jsdt.launching.IVMInstall2;
import org.eclipse.wst.jsdt.launching.IVMInstall3;
import org.eclipse.wst.jsdt.launching.IVMInstallType;
import org.eclipse.wst.jsdt.launching.IVMRunner;
import org.eclipse.wst.jsdt.launching.JavaRuntime;
import org.eclipse.wst.jsdt.launching.LaunchingMessages;
import org.eclipse.wst.jsdt.launching.LibraryLocation;
import org.eclipse.wst.jsdt.launching.PropertyChangeEvent;

public abstract class AbstractVMInstall
implements IVMInstall,
IVMInstall2,
IVMInstall3 {
    private IVMInstallType fType;
    private String fId;
    private String fName;
    private File fInstallLocation;
    private LibraryLocation[] fSystemLibraryDescriptions;
    private URL fJavadocLocation;
    private String fVMArgs;
    private static final String PREF_VM_INSTALL_SYSTEM_PROPERTY = "PREF_VM_INSTALL_SYSTEM_PROPERTY";
    private boolean fNotify = true;

    public AbstractVMInstall(IVMInstallType iVMInstallType, String string) {
        if (iVMInstallType == null) {
            throw new IllegalArgumentException(LaunchingMessages.vmInstall_assert_typeNotNull);
        }
        if (string == null) {
            throw new IllegalArgumentException(LaunchingMessages.vmInstall_assert_idNotNull);
        }
        this.fType = iVMInstallType;
        this.fId = string;
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String string) {
        if (!string.equals(this.fName)) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "org.eclipse.wst.jsdt.core.PROPERTY_NAME", this.fName, string);
            this.fName = string;
            if (this.fNotify) {
                JavaRuntime.fireVMChanged(propertyChangeEvent);
            }
        }
    }

    public File getInstallLocation() {
        return this.fInstallLocation;
    }

    public void setInstallLocation(File file) {
        if (!file.equals(this.fInstallLocation)) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "org.eclipse.wst.jsdt.core.PROPERTY_INSTALL_LOCATION", this.fInstallLocation, file);
            this.fInstallLocation = file;
            if (this.fNotify) {
                JavaRuntime.fireVMChanged(propertyChangeEvent);
            }
        }
    }

    public IVMInstallType getVMInstallType() {
        return this.fType;
    }

    public IVMRunner getVMRunner(String string) {
        return null;
    }

    public LibraryLocation[] getLibraryLocations() {
        return this.fSystemLibraryDescriptions;
    }

    public void setLibraryLocations(LibraryLocation[] libraryLocationArray) {
        LibraryLocation[] libraryLocationArray2;
        if (libraryLocationArray == this.fSystemLibraryDescriptions) {
            return;
        }
        LibraryLocation[] libraryLocationArray3 = libraryLocationArray;
        if (libraryLocationArray3 == null) {
            libraryLocationArray3 = this.getVMInstallType().getDefaultLibraryLocations(this.getInstallLocation());
        }
        if ((libraryLocationArray2 = this.fSystemLibraryDescriptions) == null) {
            libraryLocationArray2 = this.getVMInstallType().getDefaultLibraryLocations(this.getInstallLocation());
        }
        if (libraryLocationArray3.length == libraryLocationArray2.length) {
            int n = 0;
            boolean bl = true;
            while (n < libraryLocationArray3.length && bl) {
                bl = libraryLocationArray3[n].equals(libraryLocationArray2[n]);
                ++n;
            }
            if (bl) {
                return;
            }
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "org.eclipse.wst.jsdt.core.PROPERTY_LIBRARY_LOCATIONS", libraryLocationArray2, libraryLocationArray3);
        this.fSystemLibraryDescriptions = libraryLocationArray;
        if (this.fNotify) {
            JavaRuntime.fireVMChanged(propertyChangeEvent);
        }
    }

    public URL getJavadocLocation() {
        return this.fJavadocLocation;
    }

    public void setJavadocLocation(URL uRL) {
        if (uRL == this.fJavadocLocation) {
            return;
        }
        if (uRL != null && this.fJavadocLocation != null && uRL.equals(this.fJavadocLocation)) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "org.eclipse.wst.jsdt.core.PROPERTY_JAVADOC_LOCATION", this.fJavadocLocation, uRL);
        this.fJavadocLocation = uRL;
        if (this.fNotify) {
            JavaRuntime.fireVMChanged(propertyChangeEvent);
        }
    }

    protected void setNotify(boolean bl) {
        this.fNotify = bl;
    }

    public boolean equals(Object object) {
        if (object instanceof IVMInstall) {
            IVMInstall iVMInstall = (IVMInstall)object;
            return this.getVMInstallType().equals(iVMInstall.getVMInstallType()) && this.getId().equals(iVMInstall.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getVMInstallType().hashCode() + this.getId().hashCode();
    }

    public String[] getVMArguments() {
        String string = this.getVMArgs();
        if (string == null) {
            return null;
        }
        ExecutionArguments executionArguments = new ExecutionArguments(string, "");
        return executionArguments.getVMArgumentsArray();
    }

    public void setVMArguments(String[] stringArray) {
        if (stringArray == null) {
            this.setVMArgs(null);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                stringBuffer.append(string);
                stringBuffer.append(" ");
                ++n;
            }
            this.setVMArgs(stringBuffer.toString().trim());
        }
    }

    public String getVMArgs() {
        return this.fVMArgs;
    }

    public void setVMArgs(String string) {
        if (this.fVMArgs == null ? string == null : this.fVMArgs.equals(string)) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "org.eclipse.wst.jsdt.core.PROPERTY_VM_ARGUMENTS", this.fVMArgs, string);
        this.fVMArgs = string;
        if (this.fNotify) {
            JavaRuntime.fireVMChanged(propertyChangeEvent);
        }
    }

    public String getJavaVersion() {
        return null;
    }

    private String getSystemPropertyKey(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(PREF_VM_INSTALL_SYSTEM_PROPERTY);
        stringBuffer.append(".");
        stringBuffer.append(this.getVMInstallType().getId());
        stringBuffer.append(".");
        stringBuffer.append(this.getId());
        stringBuffer.append(".");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    protected void abort(String string, Throwable throwable, int n) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.core", n, string, throwable));
    }
}

