/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.AddBookmarkAction;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.AddTaskAction;
import org.eclipse.wst.jsdt.internal.ui.actions.AllCleanUpsAction;
import org.eclipse.wst.jsdt.internal.ui.actions.FindBrokenNLSKeysAction;
import org.eclipse.wst.jsdt.internal.ui.actions.JDTQuickMenuAction;
import org.eclipse.wst.jsdt.internal.ui.actions.MultiSortMembersAction;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.ui.actions.AddDelegateMethodsAction;
import org.eclipse.wst.jsdt.ui.actions.AddGetterSetterAction;
import org.eclipse.wst.jsdt.ui.actions.AddJavaDocStubAction;
import org.eclipse.wst.jsdt.ui.actions.ExternalizeStringsAction;
import org.eclipse.wst.jsdt.ui.actions.FormatAllAction;
import org.eclipse.wst.jsdt.ui.actions.GenerateNewConstructorUsingFieldsAction;
import org.eclipse.wst.jsdt.ui.actions.OverrideMethodsAction;

public class GenerateActionGroup
extends ActionGroup {
    public static final String MENU_ID = "org.eclipse.wst.jsdt.ui.source.menu";
    public static final String GROUP_IMPORT = "importGroup";
    public static final String GROUP_GENERATE = "generateGroup";
    public static final String GROUP_CODE = "codeGroup";
    private static final String GROUP_EXTERNALIZE = "externalizeGroup";
    private static final String GROUP_COMMENT = "commentGroup";
    private static final String GROUP_EDIT = "editGroup";
    private CompilationUnitEditor fEditor;
    private IWorkbenchSite fSite;
    private String fGroupName = "group.reorganize";
    private List fRegisteredSelectionListeners;
    private OverrideMethodsAction fOverrideMethods;
    private AddGetterSetterAction fAddGetterSetter;
    private AddDelegateMethodsAction fAddDelegateMethods;
    private GenerateNewConstructorUsingFieldsAction fGenerateConstructorUsingFields;
    private AddJavaDocStubAction fAddJavaDocStub;
    private AddBookmarkAction fAddBookmark;
    private AddTaskAction fAddTaskAction;
    private ExternalizeStringsAction fExternalizeStrings;
    private AllCleanUpsAction fCleanUp;
    private FindBrokenNLSKeysAction fFindNLSProblems;
    private MultiSortMembersAction fSortMembers;
    private FormatAllAction fFormatAll;
    private static final String QUICK_MENU_ID = "org.eclipse.wst.jsdt.ui.edit.text.java.source.quickMenu";
    private JDTQuickMenuAction fQuickAccessAction;
    private IHandlerActivation fQuickAccessHandlerActivation;
    private IHandlerService fHandlerService;
    static /* synthetic */ Class class$0;

    public GenerateActionGroup(CompilationUnitEditor compilationUnitEditor, String string) {
        this.fSite = compilationUnitEditor.getSite();
        this.fEditor = compilationUnitEditor;
        this.fGroupName = string;
        this.fSortMembers = new MultiSortMembersAction(compilationUnitEditor);
        this.fSortMembers.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.sort.members");
        compilationUnitEditor.setAction("SortMembers", (IAction)this.fSortMembers);
        this.fAddJavaDocStub = new AddJavaDocStubAction(compilationUnitEditor);
        this.fAddJavaDocStub.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.add.javadoc.comment");
        compilationUnitEditor.setAction("AddJavadocComment", (IAction)this.fAddJavaDocStub);
        this.fCleanUp = new AllCleanUpsAction(compilationUnitEditor);
        this.fCleanUp.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.clean.up");
        compilationUnitEditor.setAction("CleanUp", (IAction)this.fCleanUp);
        this.installQuickAccessAction();
    }

    public GenerateActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite());
    }

    public GenerateActionGroup(IViewPart iViewPart) {
        this((IWorkbenchSite)iViewPart.getSite());
    }

    private GenerateActionGroup(IWorkbenchSite iWorkbenchSite) {
        this.fSite = iWorkbenchSite;
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        ISelection iSelection = iSelectionProvider.getSelection();
        this.fAddJavaDocStub = new AddJavaDocStubAction(iWorkbenchSite);
        this.fAddJavaDocStub.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.add.javadoc.comment");
        this.fAddBookmark = new AddBookmarkAction(iWorkbenchSite.getShell());
        this.fAddBookmark.setActionDefinitionId("org.eclipse.ui.edit.addBookmark");
        this.fAddTaskAction = new AddTaskAction(iWorkbenchSite);
        this.fAddTaskAction.setActionDefinitionId("org.eclipse.ui.edit.addTask");
        this.fSortMembers = new MultiSortMembersAction(iWorkbenchSite);
        this.fSortMembers.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.sort.members");
        this.fFormatAll = new FormatAllAction(iWorkbenchSite);
        this.fFormatAll.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.format");
        this.fCleanUp = new AllCleanUpsAction(iWorkbenchSite);
        this.fCleanUp.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.clean.up");
        this.fAddJavaDocStub.update(iSelection);
        this.fCleanUp.update(iSelection);
        this.fAddTaskAction.update(iSelection);
        this.fSortMembers.update(iSelection);
        this.fFormatAll.update(iSelection);
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            this.fAddBookmark.selectionChanged(iStructuredSelection);
        } else {
            this.fAddBookmark.setEnabled(false);
        }
        this.registerSelectionListener(iSelectionProvider, this.fAddJavaDocStub);
        this.registerSelectionListener(iSelectionProvider, (ISelectionChangedListener)this.fAddBookmark);
        this.registerSelectionListener(iSelectionProvider, this.fFormatAll);
        this.registerSelectionListener(iSelectionProvider, this.fSortMembers);
        this.registerSelectionListener(iSelectionProvider, this.fAddTaskAction);
        this.registerSelectionListener(iSelectionProvider, this.fCleanUp);
        this.installQuickAccessAction();
    }

    private void installQuickAccessAction() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fHandlerService = (IHandlerService)this.fSite.getService((Class)clazz);
        if (this.fHandlerService != null) {
            this.fQuickAccessAction = new SourceQuickAccessAction(this.fEditor);
            this.fQuickAccessHandlerActivation = this.fHandlerService.activateHandler(this.fQuickAccessAction.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.fQuickAccessAction));
        }
    }

    private void registerSelectionListener(ISelectionProvider iSelectionProvider, ISelectionChangedListener iSelectionChangedListener) {
        if (this.fRegisteredSelectionListeners == null) {
            this.fRegisteredSelectionListeners = new ArrayList(20);
        }
        iSelectionProvider.addSelectionChangedListener(iSelectionChangedListener);
        this.fRegisteredSelectionListeners.add(iSelectionChangedListener);
    }

    public void editorStateChanged() {
        Assert.isTrue((boolean)this.isEditorOwner());
    }

    public void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        this.setGlobalActionHandlers(iActionBars);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        super.fillContextMenu(iMenuManager);
        String string = ActionMessages.SourceMenu_label;
        if (this.fQuickAccessAction != null) {
            string = this.fQuickAccessAction.addShortcut(string);
        }
        MenuManager menuManager = new MenuManager(string, MENU_ID);
        int n = 0;
        n = this.isEditorOwner() ? this.fillEditorSubMenu((IMenuManager)menuManager) : this.fillViewSubMenu((IMenuManager)menuManager);
        if (n > 0) {
            iMenuManager.appendToGroup(this.fGroupName, (IContributionItem)menuManager);
        }
    }

    private void fillQuickMenu(IMenuManager iMenuManager) {
        if (this.isEditorOwner()) {
            this.fillEditorSubMenu(iMenuManager);
        } else {
            this.fillViewSubMenu(iMenuManager);
        }
    }

    private int fillEditorSubMenu(IMenuManager iMenuManager) {
        int n = 0;
        iMenuManager.add((IContributionItem)new Separator(GROUP_COMMENT));
        n += this.addEditorAction(iMenuManager, "ToggleComment");
        n += this.addEditorAction(iMenuManager, "AddBlockComment");
        n += this.addEditorAction(iMenuManager, "RemoveBlockComment");
        n += this.addAction(iMenuManager, (IAction)this.fAddJavaDocStub);
        iMenuManager.add((IContributionItem)new Separator(GROUP_EDIT));
        n += this.addEditorAction(iMenuManager, "Indent");
        n += this.addEditorAction(iMenuManager, "Format");
        iMenuManager.add((IContributionItem)new Separator(GROUP_IMPORT));
        n += this.addAction(iMenuManager, (IAction)this.fSortMembers);
        iMenuManager.add((IContributionItem)new Separator(GROUP_CODE));
        iMenuManager.add((IContributionItem)new Separator(GROUP_EXTERNALIZE));
        return n += this.addAction(iMenuManager, (IAction)this.fCleanUp);
    }

    private int fillViewSubMenu(IMenuManager iMenuManager) {
        int n = 0;
        iMenuManager.add((IContributionItem)new Separator(GROUP_COMMENT));
        n += this.addAction(iMenuManager, (IAction)this.fAddJavaDocStub);
        iMenuManager.add((IContributionItem)new Separator(GROUP_EDIT));
        n += this.addAction(iMenuManager, (IAction)this.fFormatAll);
        iMenuManager.add((IContributionItem)new Separator(GROUP_IMPORT));
        n += this.addAction(iMenuManager, (IAction)this.fSortMembers);
        iMenuManager.add((IContributionItem)new Separator(GROUP_CODE));
        iMenuManager.add((IContributionItem)new Separator(GROUP_EXTERNALIZE));
        return n += this.addAction(iMenuManager, (IAction)this.fCleanUp);
    }

    public void dispose() {
        if (this.fRegisteredSelectionListeners != null) {
            ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
            Iterator iterator = this.fRegisteredSelectionListeners.iterator();
            while (iterator.hasNext()) {
                ISelectionChangedListener iSelectionChangedListener = (ISelectionChangedListener)iterator.next();
                iSelectionProvider.removeSelectionChangedListener(iSelectionChangedListener);
            }
        }
        if (this.fQuickAccessHandlerActivation != null && this.fHandlerService != null) {
            this.fHandlerService.deactivateHandler(this.fQuickAccessHandlerActivation);
        }
        this.fEditor = null;
        this.fCleanUp.dispose();
        super.dispose();
    }

    private void setGlobalActionHandlers(IActionBars iActionBars) {
        iActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.OverrideMethods", (IAction)this.fOverrideMethods);
        iActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.GenerateGetterSetter", (IAction)this.fAddGetterSetter);
        iActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.GenerateDelegateMethods", (IAction)this.fAddDelegateMethods);
        iActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.GenerateConstructorUsingFields", (IAction)this.fGenerateConstructorUsingFields);
        iActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.AddJavaDocComment", (IAction)this.fAddJavaDocStub);
        iActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.ExternalizeStrings", (IAction)this.fExternalizeStrings);
        iActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.CleanUp", (IAction)this.fCleanUp);
        iActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.FindNLSProblems", (IAction)this.fFindNLSProblems);
        iActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.SortMembers", (IAction)this.fSortMembers);
        if (!this.isEditorOwner()) {
            iActionBars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), (IAction)this.fAddBookmark);
            iActionBars.setGlobalActionHandler(IDEActionFactory.ADD_TASK.getId(), (IAction)this.fAddTaskAction);
            iActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.Format", (IAction)this.fFormatAll);
        }
    }

    private int addAction(IMenuManager iMenuManager, IAction iAction) {
        if (iAction != null && iAction.isEnabled()) {
            iMenuManager.add(iAction);
            return 1;
        }
        return 0;
    }

    private int addEditorAction(IMenuManager iMenuManager, String string) {
        if (this.fEditor == null) {
            return 0;
        }
        IAction iAction = this.fEditor.getAction(string);
        if (iAction == null) {
            return 0;
        }
        if (iAction instanceof IUpdate) {
            ((IUpdate)iAction).update();
        }
        if (iAction.isEnabled()) {
            iMenuManager.add(iAction);
            return 1;
        }
        return 0;
    }

    private boolean isEditorOwner() {
        return this.fEditor != null;
    }

    private class SourceQuickAccessAction
    extends JDTQuickMenuAction {
        public SourceQuickAccessAction(CompilationUnitEditor compilationUnitEditor) {
            super(compilationUnitEditor, GenerateActionGroup.QUICK_MENU_ID);
        }

        protected void fillMenu(IMenuManager iMenuManager) {
            GenerateActionGroup.this.fillQuickMenu(iMenuManager);
        }
    }
}

