/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.Page;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;
import org.eclipse.wst.jsdt.ui.actions.DeclarationsSearchGroup;
import org.eclipse.wst.jsdt.ui.actions.OccurrencesSearchGroup;
import org.eclipse.wst.jsdt.ui.actions.ReadReferencesSearchGroup;
import org.eclipse.wst.jsdt.ui.actions.ReferencesSearchGroup;
import org.eclipse.wst.jsdt.ui.actions.WriteReferencesSearchGroup;

public class JavaSearchActionGroup
extends ActionGroup {
    private JavaEditor fEditor;
    private ReferencesSearchGroup fReferencesGroup;
    private ReadReferencesSearchGroup fReadAccessGroup;
    private WriteReferencesSearchGroup fWriteAccessGroup;
    private DeclarationsSearchGroup fDeclarationsGroup;
    private OccurrencesSearchGroup fOccurrencesGroup;

    public JavaSearchActionGroup(IViewPart iViewPart) {
        this((IWorkbenchSite)iViewPart.getViewSite());
    }

    public JavaSearchActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite());
    }

    public JavaSearchActionGroup(JavaEditor javaEditor) {
        Assert.isNotNull((Object)javaEditor);
        this.fEditor = javaEditor;
        this.fReferencesGroup = new ReferencesSearchGroup(this.fEditor);
        this.fReadAccessGroup = new ReadReferencesSearchGroup(this.fEditor);
        this.fWriteAccessGroup = new WriteReferencesSearchGroup(this.fEditor);
        this.fDeclarationsGroup = new DeclarationsSearchGroup(this.fEditor);
        this.fOccurrencesGroup = new OccurrencesSearchGroup(this.fEditor);
    }

    private JavaSearchActionGroup(IWorkbenchSite iWorkbenchSite) {
        this.fReferencesGroup = new ReferencesSearchGroup(iWorkbenchSite);
        this.fReadAccessGroup = new ReadReferencesSearchGroup(iWorkbenchSite);
        this.fWriteAccessGroup = new WriteReferencesSearchGroup(iWorkbenchSite);
        this.fDeclarationsGroup = new DeclarationsSearchGroup(iWorkbenchSite);
        this.fOccurrencesGroup = new OccurrencesSearchGroup(iWorkbenchSite);
    }

    public void setContext(ActionContext actionContext) {
        this.fReferencesGroup.setContext(actionContext);
        this.fDeclarationsGroup.setContext(actionContext);
        this.fReadAccessGroup.setContext(actionContext);
        this.fWriteAccessGroup.setContext(actionContext);
        this.fOccurrencesGroup.setContext(actionContext);
    }

    public void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        this.fReferencesGroup.fillActionBars(iActionBars);
        this.fDeclarationsGroup.fillActionBars(iActionBars);
        this.fReadAccessGroup.fillActionBars(iActionBars);
        this.fWriteAccessGroup.fillActionBars(iActionBars);
        this.fOccurrencesGroup.fillActionBars(iActionBars);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        super.fillContextMenu(iMenuManager);
        if (PreferenceConstants.getPreferenceStore().getBoolean("Search.usereducemenu")) {
            this.fReferencesGroup.fillContextMenu(iMenuManager);
            this.fDeclarationsGroup.fillContextMenu(iMenuManager);
            if (this.fEditor == null) {
                this.fReadAccessGroup.fillContextMenu(iMenuManager);
                this.fWriteAccessGroup.fillContextMenu(iMenuManager);
            }
        } else {
            IMenuManager iMenuManager2 = iMenuManager;
            MenuManager menuManager = null;
            if (this.fEditor != null) {
                String string = SearchMessages.group_search;
                menuManager = new MenuManager(string, "group.find");
                menuManager.add((IContributionItem)new GroupMarker("group.find"));
                iMenuManager2 = menuManager;
            }
            this.fReferencesGroup.fillContextMenu(iMenuManager2);
            this.fDeclarationsGroup.fillContextMenu(iMenuManager2);
            this.fReadAccessGroup.fillContextMenu(iMenuManager2);
            this.fWriteAccessGroup.fillContextMenu(iMenuManager2);
            if (menuManager != null) {
                this.fOccurrencesGroup.fillContextMenu(iMenuManager2);
                menuManager.add((IContributionItem)new Separator());
            }
            if (menuManager != null && menuManager.getItems().length > 2) {
                iMenuManager.appendToGroup("group.find", (IContributionItem)menuManager);
            }
        }
    }

    public void dispose() {
        this.fReferencesGroup.dispose();
        this.fDeclarationsGroup.dispose();
        this.fReadAccessGroup.dispose();
        this.fWriteAccessGroup.dispose();
        this.fOccurrencesGroup.dispose();
        super.dispose();
    }
}

