/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.OpenBrowserUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class OpenExternalJavadocAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public OpenExternalJavadocAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(ActionMessages.OpenExternalJavadocAction_label);
        this.setDescription(ActionMessages.OpenExternalJavadocAction_description);
        this.setToolTipText(ActionMessages.OpenExternalJavadocAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.open_external_javadoc_action");
    }

    public OpenExternalJavadocAction(IWorkbenchSite iWorkbenchSite, ISelectionProvider iSelectionProvider) {
        this(iWorkbenchSite);
        this.setSpecialSelectionProvider(iSelectionProvider);
    }

    public OpenExternalJavadocAction(JavaEditor javaEditor) {
        this((IWorkbenchSite)javaEditor.getEditorSite());
        this.fEditor = javaEditor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(ITextSelection iTextSelection) {
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(this.checkEnabled(iStructuredSelection));
    }

    private boolean checkEnabled(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() != 1) {
            return false;
        }
        return iStructuredSelection.getFirstElement() instanceof IJavaElement;
    }

    public void run(ITextSelection iTextSelection) {
        IJavaElement iJavaElement = SelectionConverter.getInput(this.fEditor);
        if (!ActionUtil.isProcessable(this.getShell(), iJavaElement)) {
            return;
        }
        try {
            IJavaElement[] iJavaElementArray = SelectionConverter.codeResolveOrInputForked(this.fEditor);
            if (iJavaElementArray == null || iJavaElementArray.length == 0) {
                return;
            }
            IJavaElement iJavaElement2 = iJavaElementArray[0];
            if (iJavaElementArray.length > 1) {
                iJavaElement2 = SelectionConverter.selectJavaElement(iJavaElementArray, this.getShell(), this.getDialogTitle(), ActionMessages.OpenExternalJavadocAction_select_element);
            }
            if (iJavaElement2 != null) {
                this.run(iJavaElement2);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionHandler.handle(invocationTargetException, this.getShell(), this.getDialogTitle(), ActionMessages.OpenExternalJavadocAction_code_resolve_failed);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void run(IStructuredSelection iStructuredSelection) {
        if (!this.checkEnabled(iStructuredSelection)) {
            return;
        }
        IJavaElement iJavaElement = (IJavaElement)iStructuredSelection.getFirstElement();
        if (!ActionUtil.isProcessable(this.getShell(), iJavaElement)) {
            return;
        }
        this.run(iJavaElement);
    }

    public void run(IJavaElement iJavaElement) {
        if (iJavaElement == null) {
            return;
        }
        Shell shell = this.getShell();
        try {
            String string = JavaElementLabels.getElementLabel(iJavaElement, JavaElementLabels.ALL_DEFAULT);
            URL uRL = JavaUI.getJavadocBaseLocation(iJavaElement);
            if (uRL == null) {
                IPackageFragmentRoot iPackageFragmentRoot = JavaModelUtil.getPackageFragmentRoot(iJavaElement);
                if (iPackageFragmentRoot != null && iPackageFragmentRoot.getKind() == 2) {
                    String string2 = ActionMessages.OpenExternalJavadocAction_libraries_no_location;
                    OpenExternalJavadocAction.showMessage(shell, Messages.format(string2, new String[]{string, iPackageFragmentRoot.getElementName()}), false);
                } else {
                    IJavaProject iJavaProject = iJavaElement.getJavaProject();
                    String string3 = ActionMessages.OpenExternalJavadocAction_source_no_location;
                    OpenExternalJavadocAction.showMessage(shell, Messages.format(string3, new String[]{string, iJavaProject.getElementName()}), false);
                }
                return;
            }
            URL uRL2 = JavaUI.getJavadocLocation(iJavaElement, true);
            if (uRL2 != null) {
                OpenBrowserUtil.open(uRL2, shell.getDisplay(), OpenExternalJavadocAction.getTitle());
            }
        }
        catch (CoreException coreException) {
            JavaPlugin.log(coreException);
            OpenExternalJavadocAction.showMessage(shell, ActionMessages.OpenExternalJavadocAction_opening_failed, true);
        }
    }

    private static void showMessage(final Shell shell, final String string, final boolean bl) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (bl) {
                    MessageDialog.openError((Shell)shell, (String)OpenExternalJavadocAction.getTitle(), (String)string);
                } else {
                    MessageDialog.openInformation((Shell)shell, (String)OpenExternalJavadocAction.getTitle(), (String)string);
                }
            }
        });
    }

    private static String getTitle() {
        return ActionMessages.OpenExternalJavadocAction_dialog_title;
    }

    protected String getDialogTitle() {
        return OpenExternalJavadocAction.getTitle();
    }
}

