/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.part.Page;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.OpenCallHierarchyAction;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.ui.actions.OpenExternalJavadocAction;
import org.eclipse.wst.jsdt.ui.actions.OpenSuperImplementationAction;
import org.eclipse.wst.jsdt.ui.actions.OpenTypeHierarchyAction;

public class OpenViewActionGroup
extends ActionGroup {
    private boolean fEditorIsOwner;
    private boolean fIsTypeHiararchyViewerOwner;
    private boolean fIsCallHiararchyViewerOwner;
    private ISelectionProvider fSelectionProvider;
    private OpenSuperImplementationAction fOpenSuperImplementation;
    private OpenExternalJavadocAction fOpenExternalJavadoc;
    private OpenTypeHierarchyAction fOpenTypeHierarchy;
    private OpenCallHierarchyAction fOpenCallHierarchy;
    private PropertyDialogAction fOpenPropertiesDialog;
    private boolean fShowOpenPropertiesAction = true;
    private boolean fShowShowInMenu = true;
    static /* synthetic */ Class class$0;

    public OpenViewActionGroup(Page page) {
        this.createSiteActions((IWorkbenchSite)page.getSite(), null);
    }

    public OpenViewActionGroup(Page page, ISelectionProvider iSelectionProvider) {
        this.createSiteActions((IWorkbenchSite)page.getSite(), iSelectionProvider);
    }

    public OpenViewActionGroup(IViewPart iViewPart) {
        this(iViewPart, null);
    }

    public OpenViewActionGroup(IViewPart iViewPart, ISelectionProvider iSelectionProvider) {
        this.createSiteActions((IWorkbenchSite)iViewPart.getSite(), iSelectionProvider);
        String string = iViewPart.getClass().getName();
        this.fIsTypeHiararchyViewerOwner = "org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyViewPart".equals(string);
        this.fIsCallHiararchyViewerOwner = "org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyViewPart".equals(string);
    }

    public OpenViewActionGroup(IWorkbenchSite iWorkbenchSite, ISelectionProvider iSelectionProvider) {
        this.createSiteActions(iWorkbenchSite, iSelectionProvider);
    }

    public OpenViewActionGroup(JavaEditor javaEditor) {
        this.fEditorIsOwner = true;
        this.fShowShowInMenu = false;
        this.fOpenSuperImplementation = new OpenSuperImplementationAction(javaEditor);
        this.fOpenSuperImplementation.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.open.super.implementation");
        javaEditor.setAction("OpenSuperImplementation", (IAction)this.fOpenSuperImplementation);
        this.fOpenExternalJavadoc = new OpenExternalJavadocAction(javaEditor);
        this.fOpenExternalJavadoc.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.open.external.javadoc");
        javaEditor.setAction("OpenExternalJavadoc", (IAction)this.fOpenExternalJavadoc);
        this.fOpenTypeHierarchy = new OpenTypeHierarchyAction(javaEditor);
        this.fOpenTypeHierarchy.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.open.type.hierarchy");
        javaEditor.setAction("OpenTypeHierarchy", (IAction)this.fOpenTypeHierarchy);
        this.fOpenCallHierarchy = new OpenCallHierarchyAction(javaEditor);
        this.fOpenCallHierarchy.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.open.call.hierarchy");
        javaEditor.setAction("OpenCallHierarchy", (IAction)this.fOpenCallHierarchy);
        this.initialize(javaEditor.getEditorSite().getSelectionProvider());
    }

    public void containsOpenPropertiesAction(boolean bl) {
        this.fShowOpenPropertiesAction = bl;
    }

    public void containsShowInMenu(boolean bl) {
        this.fShowShowInMenu = bl;
    }

    private void createSiteActions(IWorkbenchSite iWorkbenchSite, ISelectionProvider iSelectionProvider) {
        this.fOpenSuperImplementation = new OpenSuperImplementationAction(iWorkbenchSite);
        this.fOpenSuperImplementation.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.open.super.implementation");
        this.fOpenSuperImplementation.setSpecialSelectionProvider(iSelectionProvider);
        this.fOpenExternalJavadoc = new OpenExternalJavadocAction(iWorkbenchSite);
        this.fOpenExternalJavadoc.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.open.external.javadoc");
        this.fOpenExternalJavadoc.setSpecialSelectionProvider(iSelectionProvider);
        this.fOpenTypeHierarchy = new OpenTypeHierarchyAction(iWorkbenchSite);
        this.fOpenTypeHierarchy.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.open.type.hierarchy");
        this.fOpenTypeHierarchy.setSpecialSelectionProvider(iSelectionProvider);
        this.fOpenCallHierarchy = new OpenCallHierarchyAction(iWorkbenchSite);
        this.fOpenCallHierarchy.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.open.call.hierarchy");
        this.fOpenCallHierarchy.setSpecialSelectionProvider(iSelectionProvider);
        ISelectionProvider iSelectionProvider2 = iSelectionProvider != null ? iSelectionProvider : iWorkbenchSite.getSelectionProvider();
        this.fOpenPropertiesDialog = new PropertyDialogAction((IShellProvider)iWorkbenchSite, iSelectionProvider2);
        this.fOpenPropertiesDialog.setActionDefinitionId("org.eclipse.ui.file.properties");
        this.initialize(iSelectionProvider2);
    }

    private void initialize(ISelectionProvider iSelectionProvider) {
        this.fSelectionProvider = iSelectionProvider;
        ISelection iSelection = iSelectionProvider.getSelection();
        this.fOpenSuperImplementation.update(iSelection);
        this.fOpenExternalJavadoc.update(iSelection);
        this.fOpenTypeHierarchy.update(iSelection);
        this.fOpenCallHierarchy.update(iSelection);
        if (!this.fEditorIsOwner) {
            if (this.fShowOpenPropertiesAction) {
                if (iSelection instanceof IStructuredSelection) {
                    this.fOpenPropertiesDialog.selectionChanged((IStructuredSelection)iSelection);
                } else {
                    this.fOpenPropertiesDialog.selectionChanged(iSelection);
                }
            }
            iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.fOpenSuperImplementation);
            iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.fOpenExternalJavadoc);
            iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.fOpenTypeHierarchy);
            iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.fOpenCallHierarchy);
        }
    }

    public void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        this.setGlobalActionHandlers(iActionBars);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        IStructuredSelection iStructuredSelection;
        super.fillContextMenu(iMenuManager);
        if (!this.fIsTypeHiararchyViewerOwner) {
            this.appendToGroup(iMenuManager, (IAction)this.fOpenTypeHierarchy);
        }
        if (!this.fIsCallHiararchyViewerOwner) {
            this.appendToGroup(iMenuManager, (IAction)this.fOpenCallHierarchy);
        }
        if (this.fShowShowInMenu) {
            iStructuredSelection = new MenuManager(this.getShowInMenuLabel());
            IWorkbenchWindow iWorkbenchWindow = this.fOpenSuperImplementation.getSite().getWorkbenchWindow();
            iStructuredSelection.add(ContributionItemFactory.VIEWS_SHOW_IN.create(iWorkbenchWindow));
            iMenuManager.appendToGroup("group.open", (IContributionItem)iStructuredSelection);
        }
        iStructuredSelection = this.getStructuredSelection();
        if (this.fShowOpenPropertiesAction && iStructuredSelection != null) {
            iMenuManager.appendToGroup("group.properties", (IAction)this.fOpenPropertiesDialog);
        }
    }

    private String getShowInMenuLabel() {
        IBindingService iBindingService;
        String string = null;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.keys.IBindingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iBindingService = (IBindingService)iWorkbench.getAdapter((Class)clazz)) != null) {
            string = iBindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.navigate.showInQuickMenu");
        }
        if (string == null) {
            string = "";
        }
        return String.valueOf(ActionMessages.OpenViewActionGroup_showInAction_label) + '\t' + string;
    }

    public void dispose() {
        this.fSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fOpenSuperImplementation);
        this.fSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fOpenExternalJavadoc);
        this.fSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fOpenTypeHierarchy);
        this.fSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fOpenCallHierarchy);
        super.dispose();
    }

    private void setGlobalActionHandlers(IActionBars iActionBars) {
        iActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.OpenSuperImplementation", (IAction)this.fOpenSuperImplementation);
        iActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.OpenExternalJavaDoc", (IAction)this.fOpenExternalJavadoc);
        iActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.OpenTypeHierarchy", (IAction)this.fOpenTypeHierarchy);
        iActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.OpenCallHierarchy", (IAction)this.fOpenCallHierarchy);
        if (!this.fEditorIsOwner && this.fShowOpenPropertiesAction) {
            iActionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.fOpenPropertiesDialog);
        }
    }

    private void appendToGroup(IMenuManager iMenuManager, IAction iAction) {
        if (iAction.isEnabled()) {
            iMenuManager.appendToGroup("group.open", iAction);
        }
    }

    private IStructuredSelection getStructuredSelection() {
        ISelection iSelection = this.getContext().getSelection();
        if (iSelection instanceof IStructuredSelection) {
            return (IStructuredSelection)iSelection;
        }
        return null;
    }
}

